/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralselling.model.CountryCode;
import software.amazon.awssdk.services.partnercentralselling.model.Industry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EngagementCustomer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EngagementCustomer> {
    private static final SdkField<String> COMPANY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompanyName").getter(EngagementCustomer.getter(EngagementCustomer::companyName)).setter(EngagementCustomer.setter(Builder::companyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompanyName").build()}).build();
    private static final SdkField<String> COUNTRY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CountryCode").getter(EngagementCustomer.getter(EngagementCustomer::countryCodeAsString)).setter(EngagementCustomer.setter(Builder::countryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountryCode").build()}).build();
    private static final SdkField<String> INDUSTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Industry").getter(EngagementCustomer.getter(EngagementCustomer::industryAsString)).setter(EngagementCustomer.setter(Builder::industry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Industry").build()}).build();
    private static final SdkField<String> WEBSITE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebsiteUrl").getter(EngagementCustomer.getter(EngagementCustomer::websiteUrl)).setter(EngagementCustomer.setter(Builder::websiteUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebsiteUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPANY_NAME_FIELD, COUNTRY_CODE_FIELD, INDUSTRY_FIELD, WEBSITE_URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EngagementCustomer.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String companyName;
    private final String countryCode;
    private final String industry;
    private final String websiteUrl;

    private EngagementCustomer(BuilderImpl builder) {
        this.companyName = builder.companyName;
        this.countryCode = builder.countryCode;
        this.industry = builder.industry;
        this.websiteUrl = builder.websiteUrl;
    }

    public final String companyName() {
        return this.companyName;
    }

    public final CountryCode countryCode() {
        return CountryCode.fromValue(this.countryCode);
    }

    public final String countryCodeAsString() {
        return this.countryCode;
    }

    public final Industry industry() {
        return Industry.fromValue(this.industry);
    }

    public final String industryAsString() {
        return this.industry;
    }

    public final String websiteUrl() {
        return this.websiteUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.companyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.countryCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.industryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.websiteUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngagementCustomer)) {
            return false;
        }
        EngagementCustomer other = (EngagementCustomer)obj;
        return Objects.equals(this.companyName(), other.companyName()) && Objects.equals(this.countryCodeAsString(), other.countryCodeAsString()) && Objects.equals(this.industryAsString(), other.industryAsString()) && Objects.equals(this.websiteUrl(), other.websiteUrl());
    }

    public final String toString() {
        return ToString.builder((String)"EngagementCustomer").add("CompanyName", (Object)this.companyName()).add("CountryCode", (Object)(this.countryCodeAsString() == null ? null : "*** Sensitive Data Redacted ***")).add("Industry", (Object)this.industryAsString()).add("WebsiteUrl", (Object)(this.websiteUrl() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CompanyName": {
                return Optional.ofNullable(clazz.cast(this.companyName()));
            }
            case "CountryCode": {
                return Optional.ofNullable(clazz.cast(this.countryCodeAsString()));
            }
            case "Industry": {
                return Optional.ofNullable(clazz.cast(this.industryAsString()));
            }
            case "WebsiteUrl": {
                return Optional.ofNullable(clazz.cast(this.websiteUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("CompanyName", COMPANY_NAME_FIELD);
        map.put("CountryCode", COUNTRY_CODE_FIELD);
        map.put("Industry", INDUSTRY_FIELD);
        map.put("WebsiteUrl", WEBSITE_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EngagementCustomer, T> g) {
        return obj -> g.apply((EngagementCustomer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String companyName;
        private String countryCode;
        private String industry;
        private String websiteUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(EngagementCustomer model) {
            this.companyName(model.companyName);
            this.countryCode(model.countryCode);
            this.industry(model.industry);
            this.websiteUrl(model.websiteUrl);
        }

        public final String getCompanyName() {
            return this.companyName;
        }

        public final void setCompanyName(String companyName) {
            this.companyName = companyName;
        }

        @Override
        public final Builder companyName(String companyName) {
            this.companyName = companyName;
            return this;
        }

        public final String getCountryCode() {
            return this.countryCode;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        @Override
        public final Builder countryCode(CountryCode countryCode) {
            this.countryCode(countryCode == null ? null : countryCode.toString());
            return this;
        }

        public final String getIndustry() {
            return this.industry;
        }

        public final void setIndustry(String industry) {
            this.industry = industry;
        }

        @Override
        public final Builder industry(String industry) {
            this.industry = industry;
            return this;
        }

        @Override
        public final Builder industry(Industry industry) {
            this.industry(industry == null ? null : industry.toString());
            return this;
        }

        public final String getWebsiteUrl() {
            return this.websiteUrl;
        }

        public final void setWebsiteUrl(String websiteUrl) {
            this.websiteUrl = websiteUrl;
        }

        @Override
        public final Builder websiteUrl(String websiteUrl) {
            this.websiteUrl = websiteUrl;
            return this;
        }

        public EngagementCustomer build() {
            return new EngagementCustomer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EngagementCustomer> {
        public Builder companyName(String var1);

        public Builder countryCode(String var1);

        public Builder countryCode(CountryCode var1);

        public Builder industry(String var1);

        public Builder industry(Industry var1);

        public Builder websiteUrl(String var1);
    }
}

