/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralselling.model.AwsAccountListCopier;
import software.amazon.awssdk.services.partnercentralselling.model.EngagementIdentifiersCopier;
import software.amazon.awssdk.services.partnercentralselling.model.EngagementSort;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEngagementsRequest
extends PartnerCentralSellingRequest
implements ToCopyableBuilder<Builder, ListEngagementsRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(ListEngagementsRequest.getter(ListEngagementsRequest::catalog)).setter(ListEngagementsRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<List<String>> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CreatedBy").getter(ListEngagementsRequest.getter(ListEngagementsRequest::createdBy)).setter(ListEngagementsRequest.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ENGAGEMENT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EngagementIdentifier").getter(ListEngagementsRequest.getter(ListEngagementsRequest::engagementIdentifier)).setter(ListEngagementsRequest.setter(Builder::engagementIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementIdentifier").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUDE_CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludeCreatedBy").getter(ListEngagementsRequest.getter(ListEngagementsRequest::excludeCreatedBy)).setter(ListEngagementsRequest.setter(Builder::excludeCreatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeCreatedBy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListEngagementsRequest.getter(ListEngagementsRequest::maxResults)).setter(ListEngagementsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEngagementsRequest.getter(ListEngagementsRequest::nextToken)).setter(ListEngagementsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<EngagementSort> SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sort").getter(ListEngagementsRequest.getter(ListEngagementsRequest::sort)).setter(ListEngagementsRequest.setter(Builder::sort)).constructor(EngagementSort::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sort").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, CREATED_BY_FIELD, ENGAGEMENT_IDENTIFIER_FIELD, EXCLUDE_CREATED_BY_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEngagementsRequest.memberNameToFieldInitializer();
    private final String catalog;
    private final List<String> createdBy;
    private final List<String> engagementIdentifier;
    private final List<String> excludeCreatedBy;
    private final Integer maxResults;
    private final String nextToken;
    private final EngagementSort sort;

    private ListEngagementsRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.createdBy = builder.createdBy;
        this.engagementIdentifier = builder.engagementIdentifier;
        this.excludeCreatedBy = builder.excludeCreatedBy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sort = builder.sort;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final boolean hasCreatedBy() {
        return this.createdBy != null && !(this.createdBy instanceof SdkAutoConstructList);
    }

    public final List<String> createdBy() {
        return this.createdBy;
    }

    public final boolean hasEngagementIdentifier() {
        return this.engagementIdentifier != null && !(this.engagementIdentifier instanceof SdkAutoConstructList);
    }

    public final List<String> engagementIdentifier() {
        return this.engagementIdentifier;
    }

    public final boolean hasExcludeCreatedBy() {
        return this.excludeCreatedBy != null && !(this.excludeCreatedBy instanceof SdkAutoConstructList);
    }

    public final List<String> excludeCreatedBy() {
        return this.excludeCreatedBy;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final EngagementSort sort() {
        return this.sort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCreatedBy() ? this.createdBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEngagementIdentifier() ? this.engagementIdentifier() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludeCreatedBy() ? this.excludeCreatedBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sort());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEngagementsRequest)) {
            return false;
        }
        ListEngagementsRequest other = (ListEngagementsRequest)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && this.hasCreatedBy() == other.hasCreatedBy() && Objects.equals(this.createdBy(), other.createdBy()) && this.hasEngagementIdentifier() == other.hasEngagementIdentifier() && Objects.equals(this.engagementIdentifier(), other.engagementIdentifier()) && this.hasExcludeCreatedBy() == other.hasExcludeCreatedBy() && Objects.equals(this.excludeCreatedBy(), other.excludeCreatedBy()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.sort(), other.sort());
    }

    public final String toString() {
        return ToString.builder((String)"ListEngagementsRequest").add("Catalog", (Object)this.catalog()).add("CreatedBy", (Object)(this.createdBy() == null ? null : "*** Sensitive Data Redacted ***")).add("EngagementIdentifier", this.hasEngagementIdentifier() ? this.engagementIdentifier() : null).add("ExcludeCreatedBy", (Object)(this.excludeCreatedBy() == null ? null : "*** Sensitive Data Redacted ***")).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("Sort", (Object)this.sort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "EngagementIdentifier": {
                return Optional.ofNullable(clazz.cast(this.engagementIdentifier()));
            }
            case "ExcludeCreatedBy": {
                return Optional.ofNullable(clazz.cast(this.excludeCreatedBy()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Sort": {
                return Optional.ofNullable(clazz.cast(this.sort()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("EngagementIdentifier", ENGAGEMENT_IDENTIFIER_FIELD);
        map.put("ExcludeCreatedBy", EXCLUDE_CREATED_BY_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Sort", SORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEngagementsRequest, T> g) {
        return obj -> g.apply((ListEngagementsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralSellingRequest.BuilderImpl
    implements Builder {
        private String catalog;
        private List<String> createdBy = DefaultSdkAutoConstructList.getInstance();
        private List<String> engagementIdentifier = DefaultSdkAutoConstructList.getInstance();
        private List<String> excludeCreatedBy = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;
        private EngagementSort sort;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEngagementsRequest model) {
            super(model);
            this.catalog(model.catalog);
            this.createdBy(model.createdBy);
            this.engagementIdentifier(model.engagementIdentifier);
            this.excludeCreatedBy(model.excludeCreatedBy);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.sort(model.sort);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final Collection<String> getCreatedBy() {
            if (this.createdBy instanceof SdkAutoConstructList) {
                return null;
            }
            return this.createdBy;
        }

        public final void setCreatedBy(Collection<String> createdBy) {
            this.createdBy = AwsAccountListCopier.copy(createdBy);
        }

        @Override
        public final Builder createdBy(Collection<String> createdBy) {
            this.createdBy = AwsAccountListCopier.copy(createdBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createdBy(String ... createdBy) {
            this.createdBy(Arrays.asList(createdBy));
            return this;
        }

        public final Collection<String> getEngagementIdentifier() {
            if (this.engagementIdentifier instanceof SdkAutoConstructList) {
                return null;
            }
            return this.engagementIdentifier;
        }

        public final void setEngagementIdentifier(Collection<String> engagementIdentifier) {
            this.engagementIdentifier = EngagementIdentifiersCopier.copy(engagementIdentifier);
        }

        @Override
        public final Builder engagementIdentifier(Collection<String> engagementIdentifier) {
            this.engagementIdentifier = EngagementIdentifiersCopier.copy(engagementIdentifier);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engagementIdentifier(String ... engagementIdentifier) {
            this.engagementIdentifier(Arrays.asList(engagementIdentifier));
            return this;
        }

        public final Collection<String> getExcludeCreatedBy() {
            if (this.excludeCreatedBy instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludeCreatedBy;
        }

        public final void setExcludeCreatedBy(Collection<String> excludeCreatedBy) {
            this.excludeCreatedBy = AwsAccountListCopier.copy(excludeCreatedBy);
        }

        @Override
        public final Builder excludeCreatedBy(Collection<String> excludeCreatedBy) {
            this.excludeCreatedBy = AwsAccountListCopier.copy(excludeCreatedBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeCreatedBy(String ... excludeCreatedBy) {
            this.excludeCreatedBy(Arrays.asList(excludeCreatedBy));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final EngagementSort.Builder getSort() {
            return this.sort != null ? this.sort.toBuilder() : null;
        }

        public final void setSort(EngagementSort.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(EngagementSort sort) {
            this.sort = sort;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEngagementsRequest build() {
            return new ListEngagementsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PartnerCentralSellingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEngagementsRequest> {
        public Builder catalog(String var1);

        public Builder createdBy(Collection<String> var1);

        public Builder createdBy(String ... var1);

        public Builder engagementIdentifier(Collection<String> var1);

        public Builder engagementIdentifier(String ... var1);

        public Builder excludeCreatedBy(Collection<String> var1);

        public Builder excludeCreatedBy(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder sort(EngagementSort var1);

        default public Builder sort(Consumer<EngagementSort.Builder> sort) {
            return this.sort((EngagementSort)((EngagementSort.Builder)EngagementSort.builder().applyMutation(sort)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

