/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralselling.model.Contact;
import software.amazon.awssdk.services.partnercentralselling.model.Customer;
import software.amazon.awssdk.services.partnercentralselling.model.LifeCycle;
import software.amazon.awssdk.services.partnercentralselling.model.Marketing;
import software.amazon.awssdk.services.partnercentralselling.model.NationalSecurity;
import software.amazon.awssdk.services.partnercentralselling.model.OpportunityType;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingResponse;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerOpportunityTeamMembersListCopier;
import software.amazon.awssdk.services.partnercentralselling.model.PrimaryNeedFromAws;
import software.amazon.awssdk.services.partnercentralselling.model.PrimaryNeedsFromAwsCopier;
import software.amazon.awssdk.services.partnercentralselling.model.Project;
import software.amazon.awssdk.services.partnercentralselling.model.RelatedEntityIdentifiers;
import software.amazon.awssdk.services.partnercentralselling.model.SoftwareRevenue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetOpportunityResponse
extends PartnerCentralSellingResponse
implements ToCopyableBuilder<Builder, GetOpportunityResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetOpportunityResponse.getter(GetOpportunityResponse::arn)).setter(GetOpportunityResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(GetOpportunityResponse.getter(GetOpportunityResponse::catalog)).setter(GetOpportunityResponse.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedDate").getter(GetOpportunityResponse.getter(GetOpportunityResponse::createdDate)).setter(GetOpportunityResponse.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Customer> CUSTOMER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Customer").getter(GetOpportunityResponse.getter(GetOpportunityResponse::customer)).setter(GetOpportunityResponse.setter(Builder::customer)).constructor(Customer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Customer").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(GetOpportunityResponse.getter(GetOpportunityResponse::id)).setter(GetOpportunityResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedDate").getter(GetOpportunityResponse.getter(GetOpportunityResponse::lastModifiedDate)).setter(GetOpportunityResponse.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<LifeCycle> LIFE_CYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LifeCycle").getter(GetOpportunityResponse.getter(GetOpportunityResponse::lifeCycle)).setter(GetOpportunityResponse.setter(Builder::lifeCycle)).constructor(LifeCycle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycle").build()}).build();
    private static final SdkField<Marketing> MARKETING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Marketing").getter(GetOpportunityResponse.getter(GetOpportunityResponse::marketing)).setter(GetOpportunityResponse.setter(Builder::marketing)).constructor(Marketing::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marketing").build()}).build();
    private static final SdkField<String> NATIONAL_SECURITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NationalSecurity").getter(GetOpportunityResponse.getter(GetOpportunityResponse::nationalSecurityAsString)).setter(GetOpportunityResponse.setter(Builder::nationalSecurity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NationalSecurity").build()}).build();
    private static final SdkField<List<Contact>> OPPORTUNITY_TEAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OpportunityTeam").getter(GetOpportunityResponse.getter(GetOpportunityResponse::opportunityTeam)).setter(GetOpportunityResponse.setter(Builder::opportunityTeam)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpportunityTeam").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Contact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OPPORTUNITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OpportunityType").getter(GetOpportunityResponse.getter(GetOpportunityResponse::opportunityTypeAsString)).setter(GetOpportunityResponse.setter(Builder::opportunityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpportunityType").build()}).build();
    private static final SdkField<String> PARTNER_OPPORTUNITY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PartnerOpportunityIdentifier").getter(GetOpportunityResponse.getter(GetOpportunityResponse::partnerOpportunityIdentifier)).setter(GetOpportunityResponse.setter(Builder::partnerOpportunityIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerOpportunityIdentifier").build()}).build();
    private static final SdkField<List<String>> PRIMARY_NEEDS_FROM_AWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrimaryNeedsFromAws").getter(GetOpportunityResponse.getter(GetOpportunityResponse::primaryNeedsFromAwsAsStrings)).setter(GetOpportunityResponse.setter(Builder::primaryNeedsFromAwsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryNeedsFromAws").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Project> PROJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Project").getter(GetOpportunityResponse.getter(GetOpportunityResponse::project)).setter(GetOpportunityResponse.setter(Builder::project)).constructor(Project::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Project").build()}).build();
    private static final SdkField<RelatedEntityIdentifiers> RELATED_ENTITY_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RelatedEntityIdentifiers").getter(GetOpportunityResponse.getter(GetOpportunityResponse::relatedEntityIdentifiers)).setter(GetOpportunityResponse.setter(Builder::relatedEntityIdentifiers)).constructor(RelatedEntityIdentifiers::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedEntityIdentifiers").build()}).build();
    private static final SdkField<SoftwareRevenue> SOFTWARE_REVENUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SoftwareRevenue").getter(GetOpportunityResponse.getter(GetOpportunityResponse::softwareRevenue)).setter(GetOpportunityResponse.setter(Builder::softwareRevenue)).constructor(SoftwareRevenue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareRevenue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CATALOG_FIELD, CREATED_DATE_FIELD, CUSTOMER_FIELD, ID_FIELD, LAST_MODIFIED_DATE_FIELD, LIFE_CYCLE_FIELD, MARKETING_FIELD, NATIONAL_SECURITY_FIELD, OPPORTUNITY_TEAM_FIELD, OPPORTUNITY_TYPE_FIELD, PARTNER_OPPORTUNITY_IDENTIFIER_FIELD, PRIMARY_NEEDS_FROM_AWS_FIELD, PROJECT_FIELD, RELATED_ENTITY_IDENTIFIERS_FIELD, SOFTWARE_REVENUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetOpportunityResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String catalog;
    private final Instant createdDate;
    private final Customer customer;
    private final String id;
    private final Instant lastModifiedDate;
    private final LifeCycle lifeCycle;
    private final Marketing marketing;
    private final String nationalSecurity;
    private final List<Contact> opportunityTeam;
    private final String opportunityType;
    private final String partnerOpportunityIdentifier;
    private final List<String> primaryNeedsFromAws;
    private final Project project;
    private final RelatedEntityIdentifiers relatedEntityIdentifiers;
    private final SoftwareRevenue softwareRevenue;

    private GetOpportunityResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.catalog = builder.catalog;
        this.createdDate = builder.createdDate;
        this.customer = builder.customer;
        this.id = builder.id;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.lifeCycle = builder.lifeCycle;
        this.marketing = builder.marketing;
        this.nationalSecurity = builder.nationalSecurity;
        this.opportunityTeam = builder.opportunityTeam;
        this.opportunityType = builder.opportunityType;
        this.partnerOpportunityIdentifier = builder.partnerOpportunityIdentifier;
        this.primaryNeedsFromAws = builder.primaryNeedsFromAws;
        this.project = builder.project;
        this.relatedEntityIdentifiers = builder.relatedEntityIdentifiers;
        this.softwareRevenue = builder.softwareRevenue;
    }

    public final String arn() {
        return this.arn;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public final Customer customer() {
        return this.customer;
    }

    public final String id() {
        return this.id;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final LifeCycle lifeCycle() {
        return this.lifeCycle;
    }

    public final Marketing marketing() {
        return this.marketing;
    }

    public final NationalSecurity nationalSecurity() {
        return NationalSecurity.fromValue(this.nationalSecurity);
    }

    public final String nationalSecurityAsString() {
        return this.nationalSecurity;
    }

    public final boolean hasOpportunityTeam() {
        return this.opportunityTeam != null && !(this.opportunityTeam instanceof SdkAutoConstructList);
    }

    public final List<Contact> opportunityTeam() {
        return this.opportunityTeam;
    }

    public final OpportunityType opportunityType() {
        return OpportunityType.fromValue(this.opportunityType);
    }

    public final String opportunityTypeAsString() {
        return this.opportunityType;
    }

    public final String partnerOpportunityIdentifier() {
        return this.partnerOpportunityIdentifier;
    }

    public final List<PrimaryNeedFromAws> primaryNeedsFromAws() {
        return PrimaryNeedsFromAwsCopier.copyStringToEnum(this.primaryNeedsFromAws);
    }

    public final boolean hasPrimaryNeedsFromAws() {
        return this.primaryNeedsFromAws != null && !(this.primaryNeedsFromAws instanceof SdkAutoConstructList);
    }

    public final List<String> primaryNeedsFromAwsAsStrings() {
        return this.primaryNeedsFromAws;
    }

    public final Project project() {
        return this.project;
    }

    public final RelatedEntityIdentifiers relatedEntityIdentifiers() {
        return this.relatedEntityIdentifiers;
    }

    public final SoftwareRevenue softwareRevenue() {
        return this.softwareRevenue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.customer());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifeCycle());
        hashCode = 31 * hashCode + Objects.hashCode(this.marketing());
        hashCode = 31 * hashCode + Objects.hashCode(this.nationalSecurityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOpportunityTeam() ? this.opportunityTeam() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.opportunityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.partnerOpportunityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrimaryNeedsFromAws() ? this.primaryNeedsFromAwsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.project());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedEntityIdentifiers());
        hashCode = 31 * hashCode + Objects.hashCode(this.softwareRevenue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOpportunityResponse)) {
            return false;
        }
        GetOpportunityResponse other = (GetOpportunityResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.customer(), other.customer()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.lifeCycle(), other.lifeCycle()) && Objects.equals(this.marketing(), other.marketing()) && Objects.equals(this.nationalSecurityAsString(), other.nationalSecurityAsString()) && this.hasOpportunityTeam() == other.hasOpportunityTeam() && Objects.equals(this.opportunityTeam(), other.opportunityTeam()) && Objects.equals(this.opportunityTypeAsString(), other.opportunityTypeAsString()) && Objects.equals(this.partnerOpportunityIdentifier(), other.partnerOpportunityIdentifier()) && this.hasPrimaryNeedsFromAws() == other.hasPrimaryNeedsFromAws() && Objects.equals(this.primaryNeedsFromAwsAsStrings(), other.primaryNeedsFromAwsAsStrings()) && Objects.equals(this.project(), other.project()) && Objects.equals(this.relatedEntityIdentifiers(), other.relatedEntityIdentifiers()) && Objects.equals(this.softwareRevenue(), other.softwareRevenue());
    }

    public final String toString() {
        return ToString.builder((String)"GetOpportunityResponse").add("Arn", (Object)this.arn()).add("Catalog", (Object)this.catalog()).add("CreatedDate", (Object)this.createdDate()).add("Customer", (Object)this.customer()).add("Id", (Object)this.id()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("LifeCycle", (Object)this.lifeCycle()).add("Marketing", (Object)this.marketing()).add("NationalSecurity", (Object)this.nationalSecurityAsString()).add("OpportunityTeam", this.hasOpportunityTeam() ? this.opportunityTeam() : null).add("OpportunityType", (Object)this.opportunityTypeAsString()).add("PartnerOpportunityIdentifier", (Object)this.partnerOpportunityIdentifier()).add("PrimaryNeedsFromAws", this.hasPrimaryNeedsFromAws() ? this.primaryNeedsFromAwsAsStrings() : null).add("Project", (Object)this.project()).add("RelatedEntityIdentifiers", (Object)this.relatedEntityIdentifiers()).add("SoftwareRevenue", (Object)this.softwareRevenue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "Customer": {
                return Optional.ofNullable(clazz.cast(this.customer()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "LifeCycle": {
                return Optional.ofNullable(clazz.cast(this.lifeCycle()));
            }
            case "Marketing": {
                return Optional.ofNullable(clazz.cast(this.marketing()));
            }
            case "NationalSecurity": {
                return Optional.ofNullable(clazz.cast(this.nationalSecurityAsString()));
            }
            case "OpportunityTeam": {
                return Optional.ofNullable(clazz.cast(this.opportunityTeam()));
            }
            case "OpportunityType": {
                return Optional.ofNullable(clazz.cast(this.opportunityTypeAsString()));
            }
            case "PartnerOpportunityIdentifier": {
                return Optional.ofNullable(clazz.cast(this.partnerOpportunityIdentifier()));
            }
            case "PrimaryNeedsFromAws": {
                return Optional.ofNullable(clazz.cast(this.primaryNeedsFromAwsAsStrings()));
            }
            case "Project": {
                return Optional.ofNullable(clazz.cast(this.project()));
            }
            case "RelatedEntityIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.relatedEntityIdentifiers()));
            }
            case "SoftwareRevenue": {
                return Optional.ofNullable(clazz.cast(this.softwareRevenue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("Catalog", CATALOG_FIELD);
        map.put("CreatedDate", CREATED_DATE_FIELD);
        map.put("Customer", CUSTOMER_FIELD);
        map.put("Id", ID_FIELD);
        map.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        map.put("LifeCycle", LIFE_CYCLE_FIELD);
        map.put("Marketing", MARKETING_FIELD);
        map.put("NationalSecurity", NATIONAL_SECURITY_FIELD);
        map.put("OpportunityTeam", OPPORTUNITY_TEAM_FIELD);
        map.put("OpportunityType", OPPORTUNITY_TYPE_FIELD);
        map.put("PartnerOpportunityIdentifier", PARTNER_OPPORTUNITY_IDENTIFIER_FIELD);
        map.put("PrimaryNeedsFromAws", PRIMARY_NEEDS_FROM_AWS_FIELD);
        map.put("Project", PROJECT_FIELD);
        map.put("RelatedEntityIdentifiers", RELATED_ENTITY_IDENTIFIERS_FIELD);
        map.put("SoftwareRevenue", SOFTWARE_REVENUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOpportunityResponse, T> g) {
        return obj -> g.apply((GetOpportunityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralSellingResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String catalog;
        private Instant createdDate;
        private Customer customer;
        private String id;
        private Instant lastModifiedDate;
        private LifeCycle lifeCycle;
        private Marketing marketing;
        private String nationalSecurity;
        private List<Contact> opportunityTeam = DefaultSdkAutoConstructList.getInstance();
        private String opportunityType;
        private String partnerOpportunityIdentifier;
        private List<String> primaryNeedsFromAws = DefaultSdkAutoConstructList.getInstance();
        private Project project;
        private RelatedEntityIdentifiers relatedEntityIdentifiers;
        private SoftwareRevenue softwareRevenue;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOpportunityResponse model) {
            super(model);
            this.arn(model.arn);
            this.catalog(model.catalog);
            this.createdDate(model.createdDate);
            this.customer(model.customer);
            this.id(model.id);
            this.lastModifiedDate(model.lastModifiedDate);
            this.lifeCycle(model.lifeCycle);
            this.marketing(model.marketing);
            this.nationalSecurity(model.nationalSecurity);
            this.opportunityTeam(model.opportunityTeam);
            this.opportunityType(model.opportunityType);
            this.partnerOpportunityIdentifier(model.partnerOpportunityIdentifier);
            this.primaryNeedsFromAwsWithStrings(model.primaryNeedsFromAws);
            this.project(model.project);
            this.relatedEntityIdentifiers(model.relatedEntityIdentifiers);
            this.softwareRevenue(model.softwareRevenue);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Customer.Builder getCustomer() {
            return this.customer != null ? this.customer.toBuilder() : null;
        }

        public final void setCustomer(Customer.BuilderImpl customer) {
            this.customer = customer != null ? customer.build() : null;
        }

        @Override
        public final Builder customer(Customer customer) {
            this.customer = customer;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final LifeCycle.Builder getLifeCycle() {
            return this.lifeCycle != null ? this.lifeCycle.toBuilder() : null;
        }

        public final void setLifeCycle(LifeCycle.BuilderImpl lifeCycle) {
            this.lifeCycle = lifeCycle != null ? lifeCycle.build() : null;
        }

        @Override
        public final Builder lifeCycle(LifeCycle lifeCycle) {
            this.lifeCycle = lifeCycle;
            return this;
        }

        public final Marketing.Builder getMarketing() {
            return this.marketing != null ? this.marketing.toBuilder() : null;
        }

        public final void setMarketing(Marketing.BuilderImpl marketing) {
            this.marketing = marketing != null ? marketing.build() : null;
        }

        @Override
        public final Builder marketing(Marketing marketing) {
            this.marketing = marketing;
            return this;
        }

        public final String getNationalSecurity() {
            return this.nationalSecurity;
        }

        public final void setNationalSecurity(String nationalSecurity) {
            this.nationalSecurity = nationalSecurity;
        }

        @Override
        public final Builder nationalSecurity(String nationalSecurity) {
            this.nationalSecurity = nationalSecurity;
            return this;
        }

        @Override
        public final Builder nationalSecurity(NationalSecurity nationalSecurity) {
            this.nationalSecurity(nationalSecurity == null ? null : nationalSecurity.toString());
            return this;
        }

        public final List<Contact.Builder> getOpportunityTeam() {
            List<Contact.Builder> result = PartnerOpportunityTeamMembersListCopier.copyToBuilder(this.opportunityTeam);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOpportunityTeam(Collection<Contact.BuilderImpl> opportunityTeam) {
            this.opportunityTeam = PartnerOpportunityTeamMembersListCopier.copyFromBuilder(opportunityTeam);
        }

        @Override
        public final Builder opportunityTeam(Collection<Contact> opportunityTeam) {
            this.opportunityTeam = PartnerOpportunityTeamMembersListCopier.copy(opportunityTeam);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder opportunityTeam(Contact ... opportunityTeam) {
            this.opportunityTeam(Arrays.asList(opportunityTeam));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder opportunityTeam(Consumer<Contact.Builder> ... opportunityTeam) {
            this.opportunityTeam(Stream.of(opportunityTeam).map(c -> (Contact)((Contact.Builder)Contact.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOpportunityType() {
            return this.opportunityType;
        }

        public final void setOpportunityType(String opportunityType) {
            this.opportunityType = opportunityType;
        }

        @Override
        public final Builder opportunityType(String opportunityType) {
            this.opportunityType = opportunityType;
            return this;
        }

        @Override
        public final Builder opportunityType(OpportunityType opportunityType) {
            this.opportunityType(opportunityType == null ? null : opportunityType.toString());
            return this;
        }

        public final String getPartnerOpportunityIdentifier() {
            return this.partnerOpportunityIdentifier;
        }

        public final void setPartnerOpportunityIdentifier(String partnerOpportunityIdentifier) {
            this.partnerOpportunityIdentifier = partnerOpportunityIdentifier;
        }

        @Override
        public final Builder partnerOpportunityIdentifier(String partnerOpportunityIdentifier) {
            this.partnerOpportunityIdentifier = partnerOpportunityIdentifier;
            return this;
        }

        public final Collection<String> getPrimaryNeedsFromAws() {
            if (this.primaryNeedsFromAws instanceof SdkAutoConstructList) {
                return null;
            }
            return this.primaryNeedsFromAws;
        }

        public final void setPrimaryNeedsFromAws(Collection<String> primaryNeedsFromAws) {
            this.primaryNeedsFromAws = PrimaryNeedsFromAwsCopier.copy(primaryNeedsFromAws);
        }

        @Override
        public final Builder primaryNeedsFromAwsWithStrings(Collection<String> primaryNeedsFromAws) {
            this.primaryNeedsFromAws = PrimaryNeedsFromAwsCopier.copy(primaryNeedsFromAws);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryNeedsFromAwsWithStrings(String ... primaryNeedsFromAws) {
            this.primaryNeedsFromAwsWithStrings(Arrays.asList(primaryNeedsFromAws));
            return this;
        }

        @Override
        public final Builder primaryNeedsFromAws(Collection<PrimaryNeedFromAws> primaryNeedsFromAws) {
            this.primaryNeedsFromAws = PrimaryNeedsFromAwsCopier.copyEnumToString(primaryNeedsFromAws);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryNeedsFromAws(PrimaryNeedFromAws ... primaryNeedsFromAws) {
            this.primaryNeedsFromAws(Arrays.asList(primaryNeedsFromAws));
            return this;
        }

        public final Project.Builder getProject() {
            return this.project != null ? this.project.toBuilder() : null;
        }

        public final void setProject(Project.BuilderImpl project) {
            this.project = project != null ? project.build() : null;
        }

        @Override
        public final Builder project(Project project) {
            this.project = project;
            return this;
        }

        public final RelatedEntityIdentifiers.Builder getRelatedEntityIdentifiers() {
            return this.relatedEntityIdentifiers != null ? this.relatedEntityIdentifiers.toBuilder() : null;
        }

        public final void setRelatedEntityIdentifiers(RelatedEntityIdentifiers.BuilderImpl relatedEntityIdentifiers) {
            this.relatedEntityIdentifiers = relatedEntityIdentifiers != null ? relatedEntityIdentifiers.build() : null;
        }

        @Override
        public final Builder relatedEntityIdentifiers(RelatedEntityIdentifiers relatedEntityIdentifiers) {
            this.relatedEntityIdentifiers = relatedEntityIdentifiers;
            return this;
        }

        public final SoftwareRevenue.Builder getSoftwareRevenue() {
            return this.softwareRevenue != null ? this.softwareRevenue.toBuilder() : null;
        }

        public final void setSoftwareRevenue(SoftwareRevenue.BuilderImpl softwareRevenue) {
            this.softwareRevenue = softwareRevenue != null ? softwareRevenue.build() : null;
        }

        @Override
        public final Builder softwareRevenue(SoftwareRevenue softwareRevenue) {
            this.softwareRevenue = softwareRevenue;
            return this;
        }

        @Override
        public GetOpportunityResponse build() {
            return new GetOpportunityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PartnerCentralSellingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetOpportunityResponse> {
        public Builder arn(String var1);

        public Builder catalog(String var1);

        public Builder createdDate(Instant var1);

        public Builder customer(Customer var1);

        default public Builder customer(Consumer<Customer.Builder> customer) {
            return this.customer((Customer)((Customer.Builder)Customer.builder().applyMutation(customer)).build());
        }

        public Builder id(String var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder lifeCycle(LifeCycle var1);

        default public Builder lifeCycle(Consumer<LifeCycle.Builder> lifeCycle) {
            return this.lifeCycle((LifeCycle)((LifeCycle.Builder)LifeCycle.builder().applyMutation(lifeCycle)).build());
        }

        public Builder marketing(Marketing var1);

        default public Builder marketing(Consumer<Marketing.Builder> marketing) {
            return this.marketing((Marketing)((Marketing.Builder)Marketing.builder().applyMutation(marketing)).build());
        }

        public Builder nationalSecurity(String var1);

        public Builder nationalSecurity(NationalSecurity var1);

        public Builder opportunityTeam(Collection<Contact> var1);

        public Builder opportunityTeam(Contact ... var1);

        public Builder opportunityTeam(Consumer<Contact.Builder> ... var1);

        public Builder opportunityType(String var1);

        public Builder opportunityType(OpportunityType var1);

        public Builder partnerOpportunityIdentifier(String var1);

        public Builder primaryNeedsFromAwsWithStrings(Collection<String> var1);

        public Builder primaryNeedsFromAwsWithStrings(String ... var1);

        public Builder primaryNeedsFromAws(Collection<PrimaryNeedFromAws> var1);

        public Builder primaryNeedsFromAws(PrimaryNeedFromAws ... var1);

        public Builder project(Project var1);

        default public Builder project(Consumer<Project.Builder> project) {
            return this.project((Project)((Project.Builder)Project.builder().applyMutation(project)).build());
        }

        public Builder relatedEntityIdentifiers(RelatedEntityIdentifiers var1);

        default public Builder relatedEntityIdentifiers(Consumer<RelatedEntityIdentifiers.Builder> relatedEntityIdentifiers) {
            return this.relatedEntityIdentifiers((RelatedEntityIdentifiers)((RelatedEntityIdentifiers.Builder)RelatedEntityIdentifiers.builder().applyMutation(relatedEntityIdentifiers)).build());
        }

        public Builder softwareRevenue(SoftwareRevenue var1);

        default public Builder softwareRevenue(Consumer<SoftwareRevenue.Builder> softwareRevenue) {
            return this.softwareRevenue((SoftwareRevenue)((SoftwareRevenue.Builder)SoftwareRevenue.builder().applyMutation(softwareRevenue)).build());
        }
    }
}

