/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateResourceSnapshotJobRequest
extends PartnerCentralSellingRequest
implements ToCopyableBuilder<Builder, CreateResourceSnapshotJobRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(CreateResourceSnapshotJobRequest.getter(CreateResourceSnapshotJobRequest::catalog)).setter(CreateResourceSnapshotJobRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateResourceSnapshotJobRequest.getter(CreateResourceSnapshotJobRequest::clientToken)).setter(CreateResourceSnapshotJobRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ENGAGEMENT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngagementIdentifier").getter(CreateResourceSnapshotJobRequest.getter(CreateResourceSnapshotJobRequest::engagementIdentifier)).setter(CreateResourceSnapshotJobRequest.setter(Builder::engagementIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementIdentifier").build()}).build();
    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceIdentifier").getter(CreateResourceSnapshotJobRequest.getter(CreateResourceSnapshotJobRequest::resourceIdentifier)).setter(CreateResourceSnapshotJobRequest.setter(Builder::resourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifier").build()}).build();
    private static final SdkField<String> RESOURCE_SNAPSHOT_TEMPLATE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceSnapshotTemplateIdentifier").getter(CreateResourceSnapshotJobRequest.getter(CreateResourceSnapshotJobRequest::resourceSnapshotTemplateIdentifier)).setter(CreateResourceSnapshotJobRequest.setter(Builder::resourceSnapshotTemplateIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSnapshotTemplateIdentifier").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(CreateResourceSnapshotJobRequest.getter(CreateResourceSnapshotJobRequest::resourceTypeAsString)).setter(CreateResourceSnapshotJobRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, CLIENT_TOKEN_FIELD, ENGAGEMENT_IDENTIFIER_FIELD, RESOURCE_IDENTIFIER_FIELD, RESOURCE_SNAPSHOT_TEMPLATE_IDENTIFIER_FIELD, RESOURCE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateResourceSnapshotJobRequest.memberNameToFieldInitializer();
    private final String catalog;
    private final String clientToken;
    private final String engagementIdentifier;
    private final String resourceIdentifier;
    private final String resourceSnapshotTemplateIdentifier;
    private final String resourceType;

    private CreateResourceSnapshotJobRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.clientToken = builder.clientToken;
        this.engagementIdentifier = builder.engagementIdentifier;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.resourceSnapshotTemplateIdentifier = builder.resourceSnapshotTemplateIdentifier;
        this.resourceType = builder.resourceType;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String engagementIdentifier() {
        return this.engagementIdentifier;
    }

    public final String resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public final String resourceSnapshotTemplateIdentifier() {
        return this.resourceSnapshotTemplateIdentifier;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.engagementIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSnapshotTemplateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceSnapshotJobRequest)) {
            return false;
        }
        CreateResourceSnapshotJobRequest other = (CreateResourceSnapshotJobRequest)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.engagementIdentifier(), other.engagementIdentifier()) && Objects.equals(this.resourceIdentifier(), other.resourceIdentifier()) && Objects.equals(this.resourceSnapshotTemplateIdentifier(), other.resourceSnapshotTemplateIdentifier()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateResourceSnapshotJobRequest").add("Catalog", (Object)this.catalog()).add("ClientToken", (Object)this.clientToken()).add("EngagementIdentifier", (Object)this.engagementIdentifier()).add("ResourceIdentifier", (Object)this.resourceIdentifier()).add("ResourceSnapshotTemplateIdentifier", (Object)this.resourceSnapshotTemplateIdentifier()).add("ResourceType", (Object)this.resourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "EngagementIdentifier": {
                return Optional.ofNullable(clazz.cast(this.engagementIdentifier()));
            }
            case "ResourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
            case "ResourceSnapshotTemplateIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceSnapshotTemplateIdentifier()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("EngagementIdentifier", ENGAGEMENT_IDENTIFIER_FIELD);
        map.put("ResourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
        map.put("ResourceSnapshotTemplateIdentifier", RESOURCE_SNAPSHOT_TEMPLATE_IDENTIFIER_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateResourceSnapshotJobRequest, T> g) {
        return obj -> g.apply((CreateResourceSnapshotJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralSellingRequest.BuilderImpl
    implements Builder {
        private String catalog;
        private String clientToken;
        private String engagementIdentifier;
        private String resourceIdentifier;
        private String resourceSnapshotTemplateIdentifier;
        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceSnapshotJobRequest model) {
            super(model);
            this.catalog(model.catalog);
            this.clientToken(model.clientToken);
            this.engagementIdentifier(model.engagementIdentifier);
            this.resourceIdentifier(model.resourceIdentifier);
            this.resourceSnapshotTemplateIdentifier(model.resourceSnapshotTemplateIdentifier);
            this.resourceType(model.resourceType);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getEngagementIdentifier() {
            return this.engagementIdentifier;
        }

        public final void setEngagementIdentifier(String engagementIdentifier) {
            this.engagementIdentifier = engagementIdentifier;
        }

        @Override
        public final Builder engagementIdentifier(String engagementIdentifier) {
            this.engagementIdentifier = engagementIdentifier;
            return this;
        }

        public final String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final String getResourceSnapshotTemplateIdentifier() {
            return this.resourceSnapshotTemplateIdentifier;
        }

        public final void setResourceSnapshotTemplateIdentifier(String resourceSnapshotTemplateIdentifier) {
            this.resourceSnapshotTemplateIdentifier = resourceSnapshotTemplateIdentifier;
        }

        @Override
        public final Builder resourceSnapshotTemplateIdentifier(String resourceSnapshotTemplateIdentifier) {
            this.resourceSnapshotTemplateIdentifier = resourceSnapshotTemplateIdentifier;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResourceSnapshotJobRequest build() {
            return new CreateResourceSnapshotJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PartnerCentralSellingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateResourceSnapshotJobRequest> {
        public Builder catalog(String var1);

        public Builder clientToken(String var1);

        public Builder engagementIdentifier(String var1);

        public Builder resourceIdentifier(String var1);

        public Builder resourceSnapshotTemplateIdentifier(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

