/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingResponse;
import software.amazon.awssdk.services.partnercentralselling.model.SolutionBase;
import software.amazon.awssdk.services.partnercentralselling.model.SolutionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSolutionsResponse
extends PartnerCentralSellingResponse
implements ToCopyableBuilder<Builder, ListSolutionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSolutionsResponse.getter(ListSolutionsResponse::nextToken)).setter(ListSolutionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<SolutionBase>> SOLUTION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SolutionSummaries").getter(ListSolutionsResponse.getter(ListSolutionsResponse::solutionSummaries)).setter(ListSolutionsResponse.setter(Builder::solutionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolutionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SolutionBase::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SOLUTION_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSolutionsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<SolutionBase> solutionSummaries;

    private ListSolutionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.solutionSummaries = builder.solutionSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSolutionSummaries() {
        return this.solutionSummaries != null && !(this.solutionSummaries instanceof SdkAutoConstructList);
    }

    public final List<SolutionBase> solutionSummaries() {
        return this.solutionSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSolutionSummaries() ? this.solutionSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSolutionsResponse)) {
            return false;
        }
        ListSolutionsResponse other = (ListSolutionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSolutionSummaries() == other.hasSolutionSummaries() && Objects.equals(this.solutionSummaries(), other.solutionSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListSolutionsResponse").add("NextToken", (Object)this.nextToken()).add("SolutionSummaries", this.hasSolutionSummaries() ? this.solutionSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "SolutionSummaries": {
                return Optional.ofNullable(clazz.cast(this.solutionSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("SolutionSummaries", SOLUTION_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSolutionsResponse, T> g) {
        return obj -> g.apply((ListSolutionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralSellingResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SolutionBase> solutionSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSolutionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.solutionSummaries(model.solutionSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SolutionBase.Builder> getSolutionSummaries() {
            List<SolutionBase.Builder> result = SolutionListCopier.copyToBuilder(this.solutionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSolutionSummaries(Collection<SolutionBase.BuilderImpl> solutionSummaries) {
            this.solutionSummaries = SolutionListCopier.copyFromBuilder(solutionSummaries);
        }

        @Override
        public final Builder solutionSummaries(Collection<SolutionBase> solutionSummaries) {
            this.solutionSummaries = SolutionListCopier.copy(solutionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder solutionSummaries(SolutionBase ... solutionSummaries) {
            this.solutionSummaries(Arrays.asList(solutionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder solutionSummaries(Consumer<SolutionBase.Builder> ... solutionSummaries) {
            this.solutionSummaries(Stream.of(solutionSummaries).map(c -> (SolutionBase)((SolutionBase.Builder)SolutionBase.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSolutionsResponse build() {
            return new ListSolutionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PartnerCentralSellingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSolutionsResponse> {
        public Builder nextToken(String var1);

        public Builder solutionSummaries(Collection<SolutionBase> var1);

        public Builder solutionSummaries(SolutionBase ... var1);

        public Builder solutionSummaries(Consumer<SolutionBase.Builder> ... var1);
    }
}

