/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementByAcceptingInvitationTaskSummariesCopier;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementByAcceptingInvitationTaskSummary;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEngagementByAcceptingInvitationTasksResponse
extends PartnerCentralSellingResponse
implements ToCopyableBuilder<Builder, ListEngagementByAcceptingInvitationTasksResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEngagementByAcceptingInvitationTasksResponse.getter(ListEngagementByAcceptingInvitationTasksResponse::nextToken)).setter(ListEngagementByAcceptingInvitationTasksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ListEngagementByAcceptingInvitationTaskSummary>> TASK_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TaskSummaries").getter(ListEngagementByAcceptingInvitationTasksResponse.getter(ListEngagementByAcceptingInvitationTasksResponse::taskSummaries)).setter(ListEngagementByAcceptingInvitationTasksResponse.setter(Builder::taskSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListEngagementByAcceptingInvitationTaskSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TASK_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("TaskSummaries", TASK_SUMMARIES_FIELD);
        }
    });
    private final String nextToken;
    private final List<ListEngagementByAcceptingInvitationTaskSummary> taskSummaries;

    private ListEngagementByAcceptingInvitationTasksResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.taskSummaries = builder.taskSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasTaskSummaries() {
        return this.taskSummaries != null && !(this.taskSummaries instanceof SdkAutoConstructList);
    }

    public final List<ListEngagementByAcceptingInvitationTaskSummary> taskSummaries() {
        return this.taskSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaskSummaries() ? this.taskSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEngagementByAcceptingInvitationTasksResponse)) {
            return false;
        }
        ListEngagementByAcceptingInvitationTasksResponse other = (ListEngagementByAcceptingInvitationTasksResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasTaskSummaries() == other.hasTaskSummaries() && Objects.equals(this.taskSummaries(), other.taskSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListEngagementByAcceptingInvitationTasksResponse").add("NextToken", (Object)this.nextToken()).add("TaskSummaries", this.hasTaskSummaries() ? this.taskSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "TaskSummaries": {
                return Optional.ofNullable(clazz.cast(this.taskSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListEngagementByAcceptingInvitationTasksResponse, T> g) {
        return obj -> g.apply((ListEngagementByAcceptingInvitationTasksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralSellingResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ListEngagementByAcceptingInvitationTaskSummary> taskSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEngagementByAcceptingInvitationTasksResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.taskSummaries(model.taskSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ListEngagementByAcceptingInvitationTaskSummary.Builder> getTaskSummaries() {
            List<ListEngagementByAcceptingInvitationTaskSummary.Builder> result = ListEngagementByAcceptingInvitationTaskSummariesCopier.copyToBuilder(this.taskSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaskSummaries(Collection<ListEngagementByAcceptingInvitationTaskSummary.BuilderImpl> taskSummaries) {
            this.taskSummaries = ListEngagementByAcceptingInvitationTaskSummariesCopier.copyFromBuilder(taskSummaries);
        }

        @Override
        public final Builder taskSummaries(Collection<ListEngagementByAcceptingInvitationTaskSummary> taskSummaries) {
            this.taskSummaries = ListEngagementByAcceptingInvitationTaskSummariesCopier.copy(taskSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskSummaries(ListEngagementByAcceptingInvitationTaskSummary ... taskSummaries) {
            this.taskSummaries(Arrays.asList(taskSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskSummaries(Consumer<ListEngagementByAcceptingInvitationTaskSummary.Builder> ... taskSummaries) {
            this.taskSummaries(Stream.of(taskSummaries).map(c -> (ListEngagementByAcceptingInvitationTaskSummary)((ListEngagementByAcceptingInvitationTaskSummary.Builder)ListEngagementByAcceptingInvitationTaskSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListEngagementByAcceptingInvitationTasksResponse build() {
            return new ListEngagementByAcceptingInvitationTasksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PartnerCentralSellingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEngagementByAcceptingInvitationTasksResponse> {
        public Builder nextToken(String var1);

        public Builder taskSummaries(Collection<ListEngagementByAcceptingInvitationTaskSummary> var1);

        public Builder taskSummaries(ListEngagementByAcceptingInvitationTaskSummary ... var1);

        public Builder taskSummaries(Consumer<ListEngagementByAcceptingInvitationTaskSummary.Builder> ... var1);
    }
}

