/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralselling.model.ResourceSnapshotJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceSnapshotJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceSnapshotJobSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ResourceSnapshotJobSummary.getter(ResourceSnapshotJobSummary::arn)).setter(ResourceSnapshotJobSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> ENGAGEMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngagementId").getter(ResourceSnapshotJobSummary.getter(ResourceSnapshotJobSummary::engagementId)).setter(ResourceSnapshotJobSummary.setter(Builder::engagementId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ResourceSnapshotJobSummary.getter(ResourceSnapshotJobSummary::id)).setter(ResourceSnapshotJobSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ResourceSnapshotJobSummary.getter(ResourceSnapshotJobSummary::statusAsString)).setter(ResourceSnapshotJobSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ENGAGEMENT_ID_FIELD, ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Arn", ARN_FIELD);
            this.put("EngagementId", ENGAGEMENT_ID_FIELD);
            this.put("Id", ID_FIELD);
            this.put("Status", STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String engagementId;
    private final String id;
    private final String status;

    private ResourceSnapshotJobSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.engagementId = builder.engagementId;
        this.id = builder.id;
        this.status = builder.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final String engagementId() {
        return this.engagementId;
    }

    public final String id() {
        return this.id;
    }

    public final ResourceSnapshotJobStatus status() {
        return ResourceSnapshotJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.engagementId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceSnapshotJobSummary)) {
            return false;
        }
        ResourceSnapshotJobSummary other = (ResourceSnapshotJobSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.engagementId(), other.engagementId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceSnapshotJobSummary").add("Arn", (Object)this.arn()).add("EngagementId", (Object)this.engagementId()).add("Id", (Object)this.id()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "EngagementId": {
                return Optional.ofNullable(clazz.cast(this.engagementId()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResourceSnapshotJobSummary, T> g) {
        return obj -> g.apply((ResourceSnapshotJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String engagementId;
        private String id;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceSnapshotJobSummary model) {
            this.arn(model.arn);
            this.engagementId(model.engagementId);
            this.id(model.id);
            this.status(model.status);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getEngagementId() {
            return this.engagementId;
        }

        public final void setEngagementId(String engagementId) {
            this.engagementId = engagementId;
        }

        @Override
        public final Builder engagementId(String engagementId) {
            this.engagementId = engagementId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceSnapshotJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public ResourceSnapshotJobSummary build() {
            return new ResourceSnapshotJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceSnapshotJobSummary> {
        public Builder arn(String var1);

        public Builder engagementId(String var1);

        public Builder id(String var1);

        public Builder status(String var1);

        public Builder status(ResourceSnapshotJobStatus var1);
    }
}

