/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralselling.model.DeliveryModel;
import software.amazon.awssdk.services.partnercentralselling.model.DeliveryModelsCopier;
import software.amazon.awssdk.services.partnercentralselling.model.ExpectedCustomerSpend;
import software.amazon.awssdk.services.partnercentralselling.model.ExpectedCustomerSpendListCopier;
import software.amazon.awssdk.services.partnercentralselling.model.SalesActivitiesCopier;
import software.amazon.awssdk.services.partnercentralselling.model.SalesActivity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProjectView
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProjectView> {
    private static final SdkField<String> CUSTOMER_USE_CASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerUseCase").getter(ProjectView.getter(ProjectView::customerUseCase)).setter(ProjectView.setter(Builder::customerUseCase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerUseCase").build()}).build();
    private static final SdkField<List<String>> DELIVERY_MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeliveryModels").getter(ProjectView.getter(ProjectView::deliveryModelsAsStrings)).setter(ProjectView.setter(Builder::deliveryModelsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryModels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ExpectedCustomerSpend>> EXPECTED_CUSTOMER_SPEND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExpectedCustomerSpend").getter(ProjectView.getter(ProjectView::expectedCustomerSpend)).setter(ProjectView.setter(Builder::expectedCustomerSpend)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedCustomerSpend").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExpectedCustomerSpend::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OTHER_SOLUTION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OtherSolutionDescription").getter(ProjectView.getter(ProjectView::otherSolutionDescription)).setter(ProjectView.setter(Builder::otherSolutionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherSolutionDescription").build()}).build();
    private static final SdkField<List<String>> SALES_ACTIVITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SalesActivities").getter(ProjectView.getter(ProjectView::salesActivitiesAsStrings)).setter(ProjectView.setter(Builder::salesActivitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SalesActivities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_USE_CASE_FIELD, DELIVERY_MODELS_FIELD, EXPECTED_CUSTOMER_SPEND_FIELD, OTHER_SOLUTION_DESCRIPTION_FIELD, SALES_ACTIVITIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CustomerUseCase", CUSTOMER_USE_CASE_FIELD);
            this.put("DeliveryModels", DELIVERY_MODELS_FIELD);
            this.put("ExpectedCustomerSpend", EXPECTED_CUSTOMER_SPEND_FIELD);
            this.put("OtherSolutionDescription", OTHER_SOLUTION_DESCRIPTION_FIELD);
            this.put("SalesActivities", SALES_ACTIVITIES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String customerUseCase;
    private final List<String> deliveryModels;
    private final List<ExpectedCustomerSpend> expectedCustomerSpend;
    private final String otherSolutionDescription;
    private final List<String> salesActivities;

    private ProjectView(BuilderImpl builder) {
        this.customerUseCase = builder.customerUseCase;
        this.deliveryModels = builder.deliveryModels;
        this.expectedCustomerSpend = builder.expectedCustomerSpend;
        this.otherSolutionDescription = builder.otherSolutionDescription;
        this.salesActivities = builder.salesActivities;
    }

    public final String customerUseCase() {
        return this.customerUseCase;
    }

    public final List<DeliveryModel> deliveryModels() {
        return DeliveryModelsCopier.copyStringToEnum(this.deliveryModels);
    }

    public final boolean hasDeliveryModels() {
        return this.deliveryModels != null && !(this.deliveryModels instanceof SdkAutoConstructList);
    }

    public final List<String> deliveryModelsAsStrings() {
        return this.deliveryModels;
    }

    public final boolean hasExpectedCustomerSpend() {
        return this.expectedCustomerSpend != null && !(this.expectedCustomerSpend instanceof SdkAutoConstructList);
    }

    public final List<ExpectedCustomerSpend> expectedCustomerSpend() {
        return this.expectedCustomerSpend;
    }

    public final String otherSolutionDescription() {
        return this.otherSolutionDescription;
    }

    public final List<SalesActivity> salesActivities() {
        return SalesActivitiesCopier.copyStringToEnum(this.salesActivities);
    }

    public final boolean hasSalesActivities() {
        return this.salesActivities != null && !(this.salesActivities instanceof SdkAutoConstructList);
    }

    public final List<String> salesActivitiesAsStrings() {
        return this.salesActivities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customerUseCase());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeliveryModels() ? this.deliveryModelsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExpectedCustomerSpend() ? this.expectedCustomerSpend() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.otherSolutionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSalesActivities() ? this.salesActivitiesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectView)) {
            return false;
        }
        ProjectView other = (ProjectView)obj;
        return Objects.equals(this.customerUseCase(), other.customerUseCase()) && this.hasDeliveryModels() == other.hasDeliveryModels() && Objects.equals(this.deliveryModelsAsStrings(), other.deliveryModelsAsStrings()) && this.hasExpectedCustomerSpend() == other.hasExpectedCustomerSpend() && Objects.equals(this.expectedCustomerSpend(), other.expectedCustomerSpend()) && Objects.equals(this.otherSolutionDescription(), other.otherSolutionDescription()) && this.hasSalesActivities() == other.hasSalesActivities() && Objects.equals(this.salesActivitiesAsStrings(), other.salesActivitiesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ProjectView").add("CustomerUseCase", (Object)this.customerUseCase()).add("DeliveryModels", this.hasDeliveryModels() ? this.deliveryModelsAsStrings() : null).add("ExpectedCustomerSpend", this.hasExpectedCustomerSpend() ? this.expectedCustomerSpend() : null).add("OtherSolutionDescription", (Object)(this.otherSolutionDescription() == null ? null : "*** Sensitive Data Redacted ***")).add("SalesActivities", this.hasSalesActivities() ? this.salesActivitiesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomerUseCase": {
                return Optional.ofNullable(clazz.cast(this.customerUseCase()));
            }
            case "DeliveryModels": {
                return Optional.ofNullable(clazz.cast(this.deliveryModelsAsStrings()));
            }
            case "ExpectedCustomerSpend": {
                return Optional.ofNullable(clazz.cast(this.expectedCustomerSpend()));
            }
            case "OtherSolutionDescription": {
                return Optional.ofNullable(clazz.cast(this.otherSolutionDescription()));
            }
            case "SalesActivities": {
                return Optional.ofNullable(clazz.cast(this.salesActivitiesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ProjectView, T> g) {
        return obj -> g.apply((ProjectView)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String customerUseCase;
        private List<String> deliveryModels = DefaultSdkAutoConstructList.getInstance();
        private List<ExpectedCustomerSpend> expectedCustomerSpend = DefaultSdkAutoConstructList.getInstance();
        private String otherSolutionDescription;
        private List<String> salesActivities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectView model) {
            this.customerUseCase(model.customerUseCase);
            this.deliveryModelsWithStrings(model.deliveryModels);
            this.expectedCustomerSpend(model.expectedCustomerSpend);
            this.otherSolutionDescription(model.otherSolutionDescription);
            this.salesActivitiesWithStrings(model.salesActivities);
        }

        public final String getCustomerUseCase() {
            return this.customerUseCase;
        }

        public final void setCustomerUseCase(String customerUseCase) {
            this.customerUseCase = customerUseCase;
        }

        @Override
        public final Builder customerUseCase(String customerUseCase) {
            this.customerUseCase = customerUseCase;
            return this;
        }

        public final Collection<String> getDeliveryModels() {
            if (this.deliveryModels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deliveryModels;
        }

        public final void setDeliveryModels(Collection<String> deliveryModels) {
            this.deliveryModels = DeliveryModelsCopier.copy(deliveryModels);
        }

        @Override
        public final Builder deliveryModelsWithStrings(Collection<String> deliveryModels) {
            this.deliveryModels = DeliveryModelsCopier.copy(deliveryModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryModelsWithStrings(String ... deliveryModels) {
            this.deliveryModelsWithStrings(Arrays.asList(deliveryModels));
            return this;
        }

        @Override
        public final Builder deliveryModels(Collection<DeliveryModel> deliveryModels) {
            this.deliveryModels = DeliveryModelsCopier.copyEnumToString(deliveryModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryModels(DeliveryModel ... deliveryModels) {
            this.deliveryModels(Arrays.asList(deliveryModels));
            return this;
        }

        public final List<ExpectedCustomerSpend.Builder> getExpectedCustomerSpend() {
            List<ExpectedCustomerSpend.Builder> result = ExpectedCustomerSpendListCopier.copyToBuilder(this.expectedCustomerSpend);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExpectedCustomerSpend(Collection<ExpectedCustomerSpend.BuilderImpl> expectedCustomerSpend) {
            this.expectedCustomerSpend = ExpectedCustomerSpendListCopier.copyFromBuilder(expectedCustomerSpend);
        }

        @Override
        public final Builder expectedCustomerSpend(Collection<ExpectedCustomerSpend> expectedCustomerSpend) {
            this.expectedCustomerSpend = ExpectedCustomerSpendListCopier.copy(expectedCustomerSpend);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expectedCustomerSpend(ExpectedCustomerSpend ... expectedCustomerSpend) {
            this.expectedCustomerSpend(Arrays.asList(expectedCustomerSpend));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expectedCustomerSpend(Consumer<ExpectedCustomerSpend.Builder> ... expectedCustomerSpend) {
            this.expectedCustomerSpend(Stream.of(expectedCustomerSpend).map(c -> (ExpectedCustomerSpend)((ExpectedCustomerSpend.Builder)ExpectedCustomerSpend.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOtherSolutionDescription() {
            return this.otherSolutionDescription;
        }

        public final void setOtherSolutionDescription(String otherSolutionDescription) {
            this.otherSolutionDescription = otherSolutionDescription;
        }

        @Override
        public final Builder otherSolutionDescription(String otherSolutionDescription) {
            this.otherSolutionDescription = otherSolutionDescription;
            return this;
        }

        public final Collection<String> getSalesActivities() {
            if (this.salesActivities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.salesActivities;
        }

        public final void setSalesActivities(Collection<String> salesActivities) {
            this.salesActivities = SalesActivitiesCopier.copy(salesActivities);
        }

        @Override
        public final Builder salesActivitiesWithStrings(Collection<String> salesActivities) {
            this.salesActivities = SalesActivitiesCopier.copy(salesActivities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder salesActivitiesWithStrings(String ... salesActivities) {
            this.salesActivitiesWithStrings(Arrays.asList(salesActivities));
            return this;
        }

        @Override
        public final Builder salesActivities(Collection<SalesActivity> salesActivities) {
            this.salesActivities = SalesActivitiesCopier.copyEnumToString(salesActivities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder salesActivities(SalesActivity ... salesActivities) {
            this.salesActivities(Arrays.asList(salesActivities));
            return this;
        }

        public ProjectView build() {
            return new ProjectView(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProjectView> {
        public Builder customerUseCase(String var1);

        public Builder deliveryModelsWithStrings(Collection<String> var1);

        public Builder deliveryModelsWithStrings(String ... var1);

        public Builder deliveryModels(Collection<DeliveryModel> var1);

        public Builder deliveryModels(DeliveryModel ... var1);

        public Builder expectedCustomerSpend(Collection<ExpectedCustomerSpend> var1);

        public Builder expectedCustomerSpend(ExpectedCustomerSpend ... var1);

        public Builder expectedCustomerSpend(Consumer<ExpectedCustomerSpend.Builder> ... var1);

        public Builder otherSolutionDescription(String var1);

        public Builder salesActivitiesWithStrings(Collection<String> var1);

        public Builder salesActivitiesWithStrings(String ... var1);

        public Builder salesActivities(Collection<SalesActivity> var1);

        public Builder salesActivities(SalesActivity ... var1);
    }
}

