/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralselling.model.AwsFundingUsed;
import software.amazon.awssdk.services.partnercentralselling.model.Channel;
import software.amazon.awssdk.services.partnercentralselling.model.ChannelsCopier;
import software.amazon.awssdk.services.partnercentralselling.model.MarketingSource;
import software.amazon.awssdk.services.partnercentralselling.model.UseCasesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Marketing
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Marketing> {
    private static final SdkField<String> AWS_FUNDING_USED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsFundingUsed").getter(Marketing.getter(Marketing::awsFundingUsedAsString)).setter(Marketing.setter(Builder::awsFundingUsed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsFundingUsed").build()}).build();
    private static final SdkField<String> CAMPAIGN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CampaignName").getter(Marketing.getter(Marketing::campaignName)).setter(Marketing.setter(Builder::campaignName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CampaignName").build()}).build();
    private static final SdkField<List<String>> CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Channels").getter(Marketing.getter(Marketing::channelsAsStrings)).setter(Marketing.setter(Builder::channelsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(Marketing.getter(Marketing::sourceAsString)).setter(Marketing.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<List<String>> USE_CASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UseCases").getter(Marketing.getter(Marketing::useCases)).setter(Marketing.setter(Builder::useCases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseCases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_FUNDING_USED_FIELD, CAMPAIGN_NAME_FIELD, CHANNELS_FIELD, SOURCE_FIELD, USE_CASES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AwsFundingUsed", AWS_FUNDING_USED_FIELD);
            this.put("CampaignName", CAMPAIGN_NAME_FIELD);
            this.put("Channels", CHANNELS_FIELD);
            this.put("Source", SOURCE_FIELD);
            this.put("UseCases", USE_CASES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String awsFundingUsed;
    private final String campaignName;
    private final List<String> channels;
    private final String source;
    private final List<String> useCases;

    private Marketing(BuilderImpl builder) {
        this.awsFundingUsed = builder.awsFundingUsed;
        this.campaignName = builder.campaignName;
        this.channels = builder.channels;
        this.source = builder.source;
        this.useCases = builder.useCases;
    }

    public final AwsFundingUsed awsFundingUsed() {
        return AwsFundingUsed.fromValue(this.awsFundingUsed);
    }

    public final String awsFundingUsedAsString() {
        return this.awsFundingUsed;
    }

    public final String campaignName() {
        return this.campaignName;
    }

    public final List<Channel> channels() {
        return ChannelsCopier.copyStringToEnum(this.channels);
    }

    public final boolean hasChannels() {
        return this.channels != null && !(this.channels instanceof SdkAutoConstructList);
    }

    public final List<String> channelsAsStrings() {
        return this.channels;
    }

    public final MarketingSource source() {
        return MarketingSource.fromValue(this.source);
    }

    public final String sourceAsString() {
        return this.source;
    }

    public final boolean hasUseCases() {
        return this.useCases != null && !(this.useCases instanceof SdkAutoConstructList);
    }

    public final List<String> useCases() {
        return this.useCases;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsFundingUsedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.campaignName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannels() ? this.channelsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUseCases() ? this.useCases() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Marketing)) {
            return false;
        }
        Marketing other = (Marketing)obj;
        return Objects.equals(this.awsFundingUsedAsString(), other.awsFundingUsedAsString()) && Objects.equals(this.campaignName(), other.campaignName()) && this.hasChannels() == other.hasChannels() && Objects.equals(this.channelsAsStrings(), other.channelsAsStrings()) && Objects.equals(this.sourceAsString(), other.sourceAsString()) && this.hasUseCases() == other.hasUseCases() && Objects.equals(this.useCases(), other.useCases());
    }

    public final String toString() {
        return ToString.builder((String)"Marketing").add("AwsFundingUsed", (Object)this.awsFundingUsedAsString()).add("CampaignName", (Object)this.campaignName()).add("Channels", this.hasChannels() ? this.channelsAsStrings() : null).add("Source", (Object)this.sourceAsString()).add("UseCases", this.hasUseCases() ? this.useCases() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsFundingUsed": {
                return Optional.ofNullable(clazz.cast(this.awsFundingUsedAsString()));
            }
            case "CampaignName": {
                return Optional.ofNullable(clazz.cast(this.campaignName()));
            }
            case "Channels": {
                return Optional.ofNullable(clazz.cast(this.channelsAsStrings()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.sourceAsString()));
            }
            case "UseCases": {
                return Optional.ofNullable(clazz.cast(this.useCases()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Marketing, T> g) {
        return obj -> g.apply((Marketing)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String awsFundingUsed;
        private String campaignName;
        private List<String> channels = DefaultSdkAutoConstructList.getInstance();
        private String source;
        private List<String> useCases = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Marketing model) {
            this.awsFundingUsed(model.awsFundingUsed);
            this.campaignName(model.campaignName);
            this.channelsWithStrings(model.channels);
            this.source(model.source);
            this.useCases(model.useCases);
        }

        public final String getAwsFundingUsed() {
            return this.awsFundingUsed;
        }

        public final void setAwsFundingUsed(String awsFundingUsed) {
            this.awsFundingUsed = awsFundingUsed;
        }

        @Override
        public final Builder awsFundingUsed(String awsFundingUsed) {
            this.awsFundingUsed = awsFundingUsed;
            return this;
        }

        @Override
        public final Builder awsFundingUsed(AwsFundingUsed awsFundingUsed) {
            this.awsFundingUsed(awsFundingUsed == null ? null : awsFundingUsed.toString());
            return this;
        }

        public final String getCampaignName() {
            return this.campaignName;
        }

        public final void setCampaignName(String campaignName) {
            this.campaignName = campaignName;
        }

        @Override
        public final Builder campaignName(String campaignName) {
            this.campaignName = campaignName;
            return this;
        }

        public final Collection<String> getChannels() {
            if (this.channels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.channels;
        }

        public final void setChannels(Collection<String> channels) {
            this.channels = ChannelsCopier.copy(channels);
        }

        @Override
        public final Builder channelsWithStrings(Collection<String> channels) {
            this.channels = ChannelsCopier.copy(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelsWithStrings(String ... channels) {
            this.channelsWithStrings(Arrays.asList(channels));
            return this;
        }

        @Override
        public final Builder channels(Collection<Channel> channels) {
            this.channels = ChannelsCopier.copyEnumToString(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(Channel ... channels) {
            this.channels(Arrays.asList(channels));
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(MarketingSource source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public final Collection<String> getUseCases() {
            if (this.useCases instanceof SdkAutoConstructList) {
                return null;
            }
            return this.useCases;
        }

        public final void setUseCases(Collection<String> useCases) {
            this.useCases = UseCasesCopier.copy(useCases);
        }

        @Override
        public final Builder useCases(Collection<String> useCases) {
            this.useCases = UseCasesCopier.copy(useCases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder useCases(String ... useCases) {
            this.useCases(Arrays.asList(useCases));
            return this;
        }

        public Marketing build() {
            return new Marketing(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Marketing> {
        public Builder awsFundingUsed(String var1);

        public Builder awsFundingUsed(AwsFundingUsed var1);

        public Builder campaignName(String var1);

        public Builder channelsWithStrings(Collection<String> var1);

        public Builder channelsWithStrings(String ... var1);

        public Builder channels(Collection<Channel> var1);

        public Builder channels(Channel ... var1);

        public Builder source(String var1);

        public Builder source(MarketingSource var1);

        public Builder useCases(Collection<String> var1);

        public Builder useCases(String ... var1);
    }
}

