/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralselling.model.CustomerSummary;
import software.amazon.awssdk.services.partnercentralselling.model.LifeCycleSummary;
import software.amazon.awssdk.services.partnercentralselling.model.OpportunityType;
import software.amazon.awssdk.services.partnercentralselling.model.ProjectSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpportunitySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpportunitySummary> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(OpportunitySummary.getter(OpportunitySummary::catalog)).setter(OpportunitySummary.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedDate").getter(OpportunitySummary.getter(OpportunitySummary::createdDate)).setter(OpportunitySummary.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<CustomerSummary> CUSTOMER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Customer").getter(OpportunitySummary.getter(OpportunitySummary::customer)).setter(OpportunitySummary.setter(Builder::customer)).constructor(CustomerSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Customer").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(OpportunitySummary.getter(OpportunitySummary::id)).setter(OpportunitySummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedDate").getter(OpportunitySummary.getter(OpportunitySummary::lastModifiedDate)).setter(OpportunitySummary.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<LifeCycleSummary> LIFE_CYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LifeCycle").getter(OpportunitySummary.getter(OpportunitySummary::lifeCycle)).setter(OpportunitySummary.setter(Builder::lifeCycle)).constructor(LifeCycleSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycle").build()}).build();
    private static final SdkField<String> OPPORTUNITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OpportunityType").getter(OpportunitySummary.getter(OpportunitySummary::opportunityTypeAsString)).setter(OpportunitySummary.setter(Builder::opportunityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpportunityType").build()}).build();
    private static final SdkField<String> PARTNER_OPPORTUNITY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PartnerOpportunityIdentifier").getter(OpportunitySummary.getter(OpportunitySummary::partnerOpportunityIdentifier)).setter(OpportunitySummary.setter(Builder::partnerOpportunityIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerOpportunityIdentifier").build()}).build();
    private static final SdkField<ProjectSummary> PROJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Project").getter(OpportunitySummary.getter(OpportunitySummary::project)).setter(OpportunitySummary.setter(Builder::project)).constructor(ProjectSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Project").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, CREATED_DATE_FIELD, CUSTOMER_FIELD, ID_FIELD, LAST_MODIFIED_DATE_FIELD, LIFE_CYCLE_FIELD, OPPORTUNITY_TYPE_FIELD, PARTNER_OPPORTUNITY_IDENTIFIER_FIELD, PROJECT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Catalog", CATALOG_FIELD);
            this.put("CreatedDate", CREATED_DATE_FIELD);
            this.put("Customer", CUSTOMER_FIELD);
            this.put("Id", ID_FIELD);
            this.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
            this.put("LifeCycle", LIFE_CYCLE_FIELD);
            this.put("OpportunityType", OPPORTUNITY_TYPE_FIELD);
            this.put("PartnerOpportunityIdentifier", PARTNER_OPPORTUNITY_IDENTIFIER_FIELD);
            this.put("Project", PROJECT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String catalog;
    private final Instant createdDate;
    private final CustomerSummary customer;
    private final String id;
    private final Instant lastModifiedDate;
    private final LifeCycleSummary lifeCycle;
    private final String opportunityType;
    private final String partnerOpportunityIdentifier;
    private final ProjectSummary project;

    private OpportunitySummary(BuilderImpl builder) {
        this.catalog = builder.catalog;
        this.createdDate = builder.createdDate;
        this.customer = builder.customer;
        this.id = builder.id;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.lifeCycle = builder.lifeCycle;
        this.opportunityType = builder.opportunityType;
        this.partnerOpportunityIdentifier = builder.partnerOpportunityIdentifier;
        this.project = builder.project;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public final CustomerSummary customer() {
        return this.customer;
    }

    public final String id() {
        return this.id;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final LifeCycleSummary lifeCycle() {
        return this.lifeCycle;
    }

    public final OpportunityType opportunityType() {
        return OpportunityType.fromValue(this.opportunityType);
    }

    public final String opportunityTypeAsString() {
        return this.opportunityType;
    }

    public final String partnerOpportunityIdentifier() {
        return this.partnerOpportunityIdentifier;
    }

    public final ProjectSummary project() {
        return this.project;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.customer());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifeCycle());
        hashCode = 31 * hashCode + Objects.hashCode(this.opportunityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.partnerOpportunityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.project());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpportunitySummary)) {
            return false;
        }
        OpportunitySummary other = (OpportunitySummary)obj;
        return Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.customer(), other.customer()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.lifeCycle(), other.lifeCycle()) && Objects.equals(this.opportunityTypeAsString(), other.opportunityTypeAsString()) && Objects.equals(this.partnerOpportunityIdentifier(), other.partnerOpportunityIdentifier()) && Objects.equals(this.project(), other.project());
    }

    public final String toString() {
        return ToString.builder((String)"OpportunitySummary").add("Catalog", (Object)this.catalog()).add("CreatedDate", (Object)this.createdDate()).add("Customer", (Object)this.customer()).add("Id", (Object)this.id()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("LifeCycle", (Object)this.lifeCycle()).add("OpportunityType", (Object)this.opportunityTypeAsString()).add("PartnerOpportunityIdentifier", (Object)this.partnerOpportunityIdentifier()).add("Project", (Object)this.project()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "Customer": {
                return Optional.ofNullable(clazz.cast(this.customer()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "LifeCycle": {
                return Optional.ofNullable(clazz.cast(this.lifeCycle()));
            }
            case "OpportunityType": {
                return Optional.ofNullable(clazz.cast(this.opportunityTypeAsString()));
            }
            case "PartnerOpportunityIdentifier": {
                return Optional.ofNullable(clazz.cast(this.partnerOpportunityIdentifier()));
            }
            case "Project": {
                return Optional.ofNullable(clazz.cast(this.project()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OpportunitySummary, T> g) {
        return obj -> g.apply((OpportunitySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String catalog;
        private Instant createdDate;
        private CustomerSummary customer;
        private String id;
        private Instant lastModifiedDate;
        private LifeCycleSummary lifeCycle;
        private String opportunityType;
        private String partnerOpportunityIdentifier;
        private ProjectSummary project;

        private BuilderImpl() {
        }

        private BuilderImpl(OpportunitySummary model) {
            this.catalog(model.catalog);
            this.createdDate(model.createdDate);
            this.customer(model.customer);
            this.id(model.id);
            this.lastModifiedDate(model.lastModifiedDate);
            this.lifeCycle(model.lifeCycle);
            this.opportunityType(model.opportunityType);
            this.partnerOpportunityIdentifier(model.partnerOpportunityIdentifier);
            this.project(model.project);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final CustomerSummary.Builder getCustomer() {
            return this.customer != null ? this.customer.toBuilder() : null;
        }

        public final void setCustomer(CustomerSummary.BuilderImpl customer) {
            this.customer = customer != null ? customer.build() : null;
        }

        @Override
        public final Builder customer(CustomerSummary customer) {
            this.customer = customer;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final LifeCycleSummary.Builder getLifeCycle() {
            return this.lifeCycle != null ? this.lifeCycle.toBuilder() : null;
        }

        public final void setLifeCycle(LifeCycleSummary.BuilderImpl lifeCycle) {
            this.lifeCycle = lifeCycle != null ? lifeCycle.build() : null;
        }

        @Override
        public final Builder lifeCycle(LifeCycleSummary lifeCycle) {
            this.lifeCycle = lifeCycle;
            return this;
        }

        public final String getOpportunityType() {
            return this.opportunityType;
        }

        public final void setOpportunityType(String opportunityType) {
            this.opportunityType = opportunityType;
        }

        @Override
        public final Builder opportunityType(String opportunityType) {
            this.opportunityType = opportunityType;
            return this;
        }

        @Override
        public final Builder opportunityType(OpportunityType opportunityType) {
            this.opportunityType(opportunityType == null ? null : opportunityType.toString());
            return this;
        }

        public final String getPartnerOpportunityIdentifier() {
            return this.partnerOpportunityIdentifier;
        }

        public final void setPartnerOpportunityIdentifier(String partnerOpportunityIdentifier) {
            this.partnerOpportunityIdentifier = partnerOpportunityIdentifier;
        }

        @Override
        public final Builder partnerOpportunityIdentifier(String partnerOpportunityIdentifier) {
            this.partnerOpportunityIdentifier = partnerOpportunityIdentifier;
            return this;
        }

        public final ProjectSummary.Builder getProject() {
            return this.project != null ? this.project.toBuilder() : null;
        }

        public final void setProject(ProjectSummary.BuilderImpl project) {
            this.project = project != null ? project.build() : null;
        }

        @Override
        public final Builder project(ProjectSummary project) {
            this.project = project;
            return this;
        }

        public OpportunitySummary build() {
            return new OpportunitySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpportunitySummary> {
        public Builder catalog(String var1);

        public Builder createdDate(Instant var1);

        public Builder customer(CustomerSummary var1);

        default public Builder customer(Consumer<CustomerSummary.Builder> customer) {
            return this.customer((CustomerSummary)((CustomerSummary.Builder)CustomerSummary.builder().applyMutation(customer)).build());
        }

        public Builder id(String var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder lifeCycle(LifeCycleSummary var1);

        default public Builder lifeCycle(Consumer<LifeCycleSummary.Builder> lifeCycle) {
            return this.lifeCycle((LifeCycleSummary)((LifeCycleSummary.Builder)LifeCycleSummary.builder().applyMutation(lifeCycle)).build());
        }

        public Builder opportunityType(String var1);

        public Builder opportunityType(OpportunityType var1);

        public Builder partnerOpportunityIdentifier(String var1);

        public Builder project(ProjectSummary var1);

        default public Builder project(Consumer<ProjectSummary.Builder> project) {
            return this.project((ProjectSummary)((ProjectSummary.Builder)ProjectSummary.builder().applyMutation(project)).build());
        }
    }
}

