/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ReasonCode;
import software.amazon.awssdk.services.partnercentralselling.model.TaskStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartEngagementFromOpportunityTaskResponse
extends PartnerCentralSellingResponse
implements ToCopyableBuilder<Builder, StartEngagementFromOpportunityTaskResponse> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(StartEngagementFromOpportunityTaskResponse.getter(StartEngagementFromOpportunityTaskResponse::message)).setter(StartEngagementFromOpportunityTaskResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> OPPORTUNITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OpportunityId").getter(StartEngagementFromOpportunityTaskResponse.getter(StartEngagementFromOpportunityTaskResponse::opportunityId)).setter(StartEngagementFromOpportunityTaskResponse.setter(Builder::opportunityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpportunityId").build()}).build();
    private static final SdkField<String> REASON_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReasonCode").getter(StartEngagementFromOpportunityTaskResponse.getter(StartEngagementFromOpportunityTaskResponse::reasonCodeAsString)).setter(StartEngagementFromOpportunityTaskResponse.setter(Builder::reasonCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReasonCode").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(StartEngagementFromOpportunityTaskResponse.getter(StartEngagementFromOpportunityTaskResponse::startTime)).setter(StartEngagementFromOpportunityTaskResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskArn").getter(StartEngagementFromOpportunityTaskResponse.getter(StartEngagementFromOpportunityTaskResponse::taskArn)).setter(StartEngagementFromOpportunityTaskResponse.setter(Builder::taskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskArn").build()}).build();
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskId").getter(StartEngagementFromOpportunityTaskResponse.getter(StartEngagementFromOpportunityTaskResponse::taskId)).setter(StartEngagementFromOpportunityTaskResponse.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskId").build()}).build();
    private static final SdkField<String> TASK_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskStatus").getter(StartEngagementFromOpportunityTaskResponse.getter(StartEngagementFromOpportunityTaskResponse::taskStatusAsString)).setter(StartEngagementFromOpportunityTaskResponse.setter(Builder::taskStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD, OPPORTUNITY_ID_FIELD, REASON_CODE_FIELD, START_TIME_FIELD, TASK_ARN_FIELD, TASK_ID_FIELD, TASK_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Message", MESSAGE_FIELD);
            this.put("OpportunityId", OPPORTUNITY_ID_FIELD);
            this.put("ReasonCode", REASON_CODE_FIELD);
            this.put("StartTime", START_TIME_FIELD);
            this.put("TaskArn", TASK_ARN_FIELD);
            this.put("TaskId", TASK_ID_FIELD);
            this.put("TaskStatus", TASK_STATUS_FIELD);
        }
    });
    private final String message;
    private final String opportunityId;
    private final String reasonCode;
    private final Instant startTime;
    private final String taskArn;
    private final String taskId;
    private final String taskStatus;

    private StartEngagementFromOpportunityTaskResponse(BuilderImpl builder) {
        super(builder);
        this.message = builder.message;
        this.opportunityId = builder.opportunityId;
        this.reasonCode = builder.reasonCode;
        this.startTime = builder.startTime;
        this.taskArn = builder.taskArn;
        this.taskId = builder.taskId;
        this.taskStatus = builder.taskStatus;
    }

    public final String message() {
        return this.message;
    }

    public final String opportunityId() {
        return this.opportunityId;
    }

    public final ReasonCode reasonCode() {
        return ReasonCode.fromValue(this.reasonCode);
    }

    public final String reasonCodeAsString() {
        return this.reasonCode;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final String taskArn() {
        return this.taskArn;
    }

    public final String taskId() {
        return this.taskId;
    }

    public final TaskStatus taskStatus() {
        return TaskStatus.fromValue(this.taskStatus);
    }

    public final String taskStatusAsString() {
        return this.taskStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.opportunityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reasonCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartEngagementFromOpportunityTaskResponse)) {
            return false;
        }
        StartEngagementFromOpportunityTaskResponse other = (StartEngagementFromOpportunityTaskResponse)((Object)obj);
        return Objects.equals(this.message(), other.message()) && Objects.equals(this.opportunityId(), other.opportunityId()) && Objects.equals(this.reasonCodeAsString(), other.reasonCodeAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.taskArn(), other.taskArn()) && Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.taskStatusAsString(), other.taskStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StartEngagementFromOpportunityTaskResponse").add("Message", (Object)this.message()).add("OpportunityId", (Object)this.opportunityId()).add("ReasonCode", (Object)this.reasonCodeAsString()).add("StartTime", (Object)this.startTime()).add("TaskArn", (Object)this.taskArn()).add("TaskId", (Object)this.taskId()).add("TaskStatus", (Object)this.taskStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "OpportunityId": {
                return Optional.ofNullable(clazz.cast(this.opportunityId()));
            }
            case "ReasonCode": {
                return Optional.ofNullable(clazz.cast(this.reasonCodeAsString()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "TaskArn": {
                return Optional.ofNullable(clazz.cast(this.taskArn()));
            }
            case "TaskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "TaskStatus": {
                return Optional.ofNullable(clazz.cast(this.taskStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartEngagementFromOpportunityTaskResponse, T> g) {
        return obj -> g.apply((StartEngagementFromOpportunityTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralSellingResponse.BuilderImpl
    implements Builder {
        private String message;
        private String opportunityId;
        private String reasonCode;
        private Instant startTime;
        private String taskArn;
        private String taskId;
        private String taskStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(StartEngagementFromOpportunityTaskResponse model) {
            super(model);
            this.message(model.message);
            this.opportunityId(model.opportunityId);
            this.reasonCode(model.reasonCode);
            this.startTime(model.startTime);
            this.taskArn(model.taskArn);
            this.taskId(model.taskId);
            this.taskStatus(model.taskStatus);
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getOpportunityId() {
            return this.opportunityId;
        }

        public final void setOpportunityId(String opportunityId) {
            this.opportunityId = opportunityId;
        }

        @Override
        public final Builder opportunityId(String opportunityId) {
            this.opportunityId = opportunityId;
            return this;
        }

        public final String getReasonCode() {
            return this.reasonCode;
        }

        public final void setReasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
        }

        @Override
        public final Builder reasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
            return this;
        }

        @Override
        public final Builder reasonCode(ReasonCode reasonCode) {
            this.reasonCode(reasonCode == null ? null : reasonCode.toString());
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getTaskStatus() {
            return this.taskStatus;
        }

        public final void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        @Override
        public final Builder taskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
            return this;
        }

        @Override
        public final Builder taskStatus(TaskStatus taskStatus) {
            this.taskStatus(taskStatus == null ? null : taskStatus.toString());
            return this;
        }

        @Override
        public StartEngagementFromOpportunityTaskResponse build() {
            return new StartEngagementFromOpportunityTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PartnerCentralSellingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartEngagementFromOpportunityTaskResponse> {
        public Builder message(String var1);

        public Builder opportunityId(String var1);

        public Builder reasonCode(String var1);

        public Builder reasonCode(ReasonCode var1);

        public Builder startTime(Instant var1);

        public Builder taskArn(String var1);

        public Builder taskId(String var1);

        public Builder taskStatus(String var1);

        public Builder taskStatus(TaskStatus var1);
    }
}

