/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralselling.model.OpportunitySummariesCopier;
import software.amazon.awssdk.services.partnercentralselling.model.OpportunitySummary;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOpportunitiesResponse
extends PartnerCentralSellingResponse
implements ToCopyableBuilder<Builder, ListOpportunitiesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListOpportunitiesResponse.getter(ListOpportunitiesResponse::nextToken)).setter(ListOpportunitiesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<OpportunitySummary>> OPPORTUNITY_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OpportunitySummaries").getter(ListOpportunitiesResponse.getter(ListOpportunitiesResponse::opportunitySummaries)).setter(ListOpportunitiesResponse.setter(Builder::opportunitySummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpportunitySummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpportunitySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, OPPORTUNITY_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("OpportunitySummaries", OPPORTUNITY_SUMMARIES_FIELD);
        }
    });
    private final String nextToken;
    private final List<OpportunitySummary> opportunitySummaries;

    private ListOpportunitiesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.opportunitySummaries = builder.opportunitySummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasOpportunitySummaries() {
        return this.opportunitySummaries != null && !(this.opportunitySummaries instanceof SdkAutoConstructList);
    }

    public final List<OpportunitySummary> opportunitySummaries() {
        return this.opportunitySummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOpportunitySummaries() ? this.opportunitySummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOpportunitiesResponse)) {
            return false;
        }
        ListOpportunitiesResponse other = (ListOpportunitiesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasOpportunitySummaries() == other.hasOpportunitySummaries() && Objects.equals(this.opportunitySummaries(), other.opportunitySummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListOpportunitiesResponse").add("NextToken", (Object)this.nextToken()).add("OpportunitySummaries", this.hasOpportunitySummaries() ? this.opportunitySummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "OpportunitySummaries": {
                return Optional.ofNullable(clazz.cast(this.opportunitySummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListOpportunitiesResponse, T> g) {
        return obj -> g.apply((ListOpportunitiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralSellingResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<OpportunitySummary> opportunitySummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListOpportunitiesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.opportunitySummaries(model.opportunitySummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<OpportunitySummary.Builder> getOpportunitySummaries() {
            List<OpportunitySummary.Builder> result = OpportunitySummariesCopier.copyToBuilder(this.opportunitySummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOpportunitySummaries(Collection<OpportunitySummary.BuilderImpl> opportunitySummaries) {
            this.opportunitySummaries = OpportunitySummariesCopier.copyFromBuilder(opportunitySummaries);
        }

        @Override
        public final Builder opportunitySummaries(Collection<OpportunitySummary> opportunitySummaries) {
            this.opportunitySummaries = OpportunitySummariesCopier.copy(opportunitySummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder opportunitySummaries(OpportunitySummary ... opportunitySummaries) {
            this.opportunitySummaries(Arrays.asList(opportunitySummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder opportunitySummaries(Consumer<OpportunitySummary.Builder> ... opportunitySummaries) {
            this.opportunitySummaries(Stream.of(opportunitySummaries).map(c -> (OpportunitySummary)((OpportunitySummary.Builder)OpportunitySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListOpportunitiesResponse build() {
            return new ListOpportunitiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PartnerCentralSellingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOpportunitiesResponse> {
        public Builder nextToken(String var1);

        public Builder opportunitySummaries(Collection<OpportunitySummary> var1);

        public Builder opportunitySummaries(OpportunitySummary ... var1);

        public Builder opportunitySummaries(Consumer<OpportunitySummary.Builder> ... var1);
    }
}

