/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ReasonCode {
    INVITATION_ACCESS_DENIED("InvitationAccessDenied"),
    ENGAGEMENT_ACCESS_DENIED("EngagementAccessDenied"),
    OPPORTUNITY_ACCESS_DENIED("OpportunityAccessDenied"),
    RESOURCE_SNAPSHOT_JOB_ACCESS_DENIED("ResourceSnapshotJobAccessDenied"),
    ENGAGEMENT_VALIDATION_FAILED("EngagementValidationFailed"),
    OPPORTUNITY_SUBMISSION_FAILED("OpportunitySubmissionFailed"),
    ENGAGEMENT_INVITATION_CONFLICT("EngagementInvitationConflict"),
    INTERNAL_ERROR("InternalError"),
    OPPORTUNITY_VALIDATION_FAILED("OpportunityValidationFailed"),
    OPPORTUNITY_CONFLICT("OpportunityConflict"),
    RESOURCE_SNAPSHOT_ACCESS_DENIED("ResourceSnapshotAccessDenied"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ReasonCode> VALUE_MAP;
    private final String value;

    private ReasonCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReasonCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReasonCode> knownValues() {
        EnumSet<ReasonCode> knownValues = EnumSet.allOf(ReasonCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ReasonCode.class, ReasonCode::toString);
    }
}

