/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralselling.model.Address;
import software.amazon.awssdk.services.partnercentralselling.model.Industry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Account
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Account> {
    private static final SdkField<Address> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Address").getter(Account.getter(Account::address)).setter(Account.setter(Builder::address)).constructor(Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(Account.getter(Account::awsAccountId)).setter(Account.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> COMPANY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompanyName").getter(Account.getter(Account::companyName)).setter(Account.setter(Builder::companyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompanyName").build()}).build();
    private static final SdkField<String> DUNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Duns").getter(Account.getter(Account::duns)).setter(Account.setter(Builder::duns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duns").build()}).build();
    private static final SdkField<String> INDUSTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Industry").getter(Account.getter(Account::industryAsString)).setter(Account.setter(Builder::industry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Industry").build()}).build();
    private static final SdkField<String> OTHER_INDUSTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OtherIndustry").getter(Account.getter(Account::otherIndustry)).setter(Account.setter(Builder::otherIndustry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherIndustry").build()}).build();
    private static final SdkField<String> WEBSITE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebsiteUrl").getter(Account.getter(Account::websiteUrl)).setter(Account.setter(Builder::websiteUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebsiteUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_FIELD, AWS_ACCOUNT_ID_FIELD, COMPANY_NAME_FIELD, DUNS_FIELD, INDUSTRY_FIELD, OTHER_INDUSTRY_FIELD, WEBSITE_URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Address", ADDRESS_FIELD);
            this.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
            this.put("CompanyName", COMPANY_NAME_FIELD);
            this.put("Duns", DUNS_FIELD);
            this.put("Industry", INDUSTRY_FIELD);
            this.put("OtherIndustry", OTHER_INDUSTRY_FIELD);
            this.put("WebsiteUrl", WEBSITE_URL_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Address address;
    private final String awsAccountId;
    private final String companyName;
    private final String duns;
    private final String industry;
    private final String otherIndustry;
    private final String websiteUrl;

    private Account(BuilderImpl builder) {
        this.address = builder.address;
        this.awsAccountId = builder.awsAccountId;
        this.companyName = builder.companyName;
        this.duns = builder.duns;
        this.industry = builder.industry;
        this.otherIndustry = builder.otherIndustry;
        this.websiteUrl = builder.websiteUrl;
    }

    public final Address address() {
        return this.address;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String companyName() {
        return this.companyName;
    }

    public final String duns() {
        return this.duns;
    }

    public final Industry industry() {
        return Industry.fromValue(this.industry);
    }

    public final String industryAsString() {
        return this.industry;
    }

    public final String otherIndustry() {
        return this.otherIndustry;
    }

    public final String websiteUrl() {
        return this.websiteUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.companyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.duns());
        hashCode = 31 * hashCode + Objects.hashCode(this.industryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.otherIndustry());
        hashCode = 31 * hashCode + Objects.hashCode(this.websiteUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Account)) {
            return false;
        }
        Account other = (Account)obj;
        return Objects.equals(this.address(), other.address()) && Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.companyName(), other.companyName()) && Objects.equals(this.duns(), other.duns()) && Objects.equals(this.industryAsString(), other.industryAsString()) && Objects.equals(this.otherIndustry(), other.otherIndustry()) && Objects.equals(this.websiteUrl(), other.websiteUrl());
    }

    public final String toString() {
        return ToString.builder((String)"Account").add("Address", (Object)this.address()).add("AwsAccountId", (Object)(this.awsAccountId() == null ? null : "*** Sensitive Data Redacted ***")).add("CompanyName", (Object)(this.companyName() == null ? null : "*** Sensitive Data Redacted ***")).add("Duns", (Object)(this.duns() == null ? null : "*** Sensitive Data Redacted ***")).add("Industry", (Object)this.industryAsString()).add("OtherIndustry", (Object)this.otherIndustry()).add("WebsiteUrl", (Object)(this.websiteUrl() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "CompanyName": {
                return Optional.ofNullable(clazz.cast(this.companyName()));
            }
            case "Duns": {
                return Optional.ofNullable(clazz.cast(this.duns()));
            }
            case "Industry": {
                return Optional.ofNullable(clazz.cast(this.industryAsString()));
            }
            case "OtherIndustry": {
                return Optional.ofNullable(clazz.cast(this.otherIndustry()));
            }
            case "WebsiteUrl": {
                return Optional.ofNullable(clazz.cast(this.websiteUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Account, T> g) {
        return obj -> g.apply((Account)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Address address;
        private String awsAccountId;
        private String companyName;
        private String duns;
        private String industry;
        private String otherIndustry;
        private String websiteUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(Account model) {
            this.address(model.address);
            this.awsAccountId(model.awsAccountId);
            this.companyName(model.companyName);
            this.duns(model.duns);
            this.industry(model.industry);
            this.otherIndustry(model.otherIndustry);
            this.websiteUrl(model.websiteUrl);
        }

        public final Address.Builder getAddress() {
            return this.address != null ? this.address.toBuilder() : null;
        }

        public final void setAddress(Address.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(Address address) {
            this.address = address;
            return this;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getCompanyName() {
            return this.companyName;
        }

        public final void setCompanyName(String companyName) {
            this.companyName = companyName;
        }

        @Override
        public final Builder companyName(String companyName) {
            this.companyName = companyName;
            return this;
        }

        public final String getDuns() {
            return this.duns;
        }

        public final void setDuns(String duns) {
            this.duns = duns;
        }

        @Override
        public final Builder duns(String duns) {
            this.duns = duns;
            return this;
        }

        public final String getIndustry() {
            return this.industry;
        }

        public final void setIndustry(String industry) {
            this.industry = industry;
        }

        @Override
        public final Builder industry(String industry) {
            this.industry = industry;
            return this;
        }

        @Override
        public final Builder industry(Industry industry) {
            this.industry(industry == null ? null : industry.toString());
            return this;
        }

        public final String getOtherIndustry() {
            return this.otherIndustry;
        }

        public final void setOtherIndustry(String otherIndustry) {
            this.otherIndustry = otherIndustry;
        }

        @Override
        public final Builder otherIndustry(String otherIndustry) {
            this.otherIndustry = otherIndustry;
            return this;
        }

        public final String getWebsiteUrl() {
            return this.websiteUrl;
        }

        public final void setWebsiteUrl(String websiteUrl) {
            this.websiteUrl = websiteUrl;
        }

        @Override
        public final Builder websiteUrl(String websiteUrl) {
            this.websiteUrl = websiteUrl;
            return this;
        }

        public Account build() {
            return new Account(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Account> {
        public Builder address(Address var1);

        default public Builder address(Consumer<Address.Builder> address) {
            return this.address((Address)((Address.Builder)Address.builder().applyMutation(address)).build());
        }

        public Builder awsAccountId(String var1);

        public Builder companyName(String var1);

        public Builder duns(String var1);

        public Builder industry(String var1);

        public Builder industry(Industry var1);

        public Builder otherIndustry(String var1);

        public Builder websiteUrl(String var1);
    }
}

