/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralchannel.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralchannel.model.Program;
import software.amazon.awssdk.services.partnercentralchannel.model.ProgramListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProgramManagementAccountTypeFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProgramManagementAccountTypeFilters> {
    private static final SdkField<List<String>> PROGRAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("programs").getter(ProgramManagementAccountTypeFilters.getter(ProgramManagementAccountTypeFilters::programsAsStrings)).setter(ProgramManagementAccountTypeFilters.setter(Builder::programsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRAMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProgramManagementAccountTypeFilters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> programs;

    private ProgramManagementAccountTypeFilters(BuilderImpl builder) {
        this.programs = builder.programs;
    }

    public final List<Program> programs() {
        return ProgramListCopier.copyStringToEnum(this.programs);
    }

    public final boolean hasPrograms() {
        return this.programs != null && !(this.programs instanceof SdkAutoConstructList);
    }

    public final List<String> programsAsStrings() {
        return this.programs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrograms() ? this.programsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProgramManagementAccountTypeFilters)) {
            return false;
        }
        ProgramManagementAccountTypeFilters other = (ProgramManagementAccountTypeFilters)obj;
        return this.hasPrograms() == other.hasPrograms() && Objects.equals(this.programsAsStrings(), other.programsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ProgramManagementAccountTypeFilters").add("Programs", this.hasPrograms() ? this.programsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "programs": {
                return Optional.ofNullable(clazz.cast(this.programsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("programs", PROGRAMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProgramManagementAccountTypeFilters, T> g) {
        return obj -> g.apply((ProgramManagementAccountTypeFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> programs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProgramManagementAccountTypeFilters model) {
            this.programsWithStrings(model.programs);
        }

        public final Collection<String> getPrograms() {
            if (this.programs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.programs;
        }

        public final void setPrograms(Collection<String> programs) {
            this.programs = ProgramListCopier.copy(programs);
        }

        @Override
        public final Builder programsWithStrings(Collection<String> programs) {
            this.programs = ProgramListCopier.copy(programs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder programsWithStrings(String ... programs) {
            this.programsWithStrings(Arrays.asList(programs));
            return this;
        }

        @Override
        public final Builder programs(Collection<Program> programs) {
            this.programs = ProgramListCopier.copyEnumToString(programs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder programs(Program ... programs) {
            this.programs(Arrays.asList(programs));
            return this;
        }

        public ProgramManagementAccountTypeFilters build() {
            return new ProgramManagementAccountTypeFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProgramManagementAccountTypeFilters> {
        public Builder programsWithStrings(Collection<String> var1);

        public Builder programsWithStrings(String ... var1);

        public Builder programs(Collection<Program> var1);

        public Builder programs(Program ... var1);
    }
}

