/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralchannel.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralchannel.PartnerCentralChannelAsyncClient;
import software.amazon.awssdk.services.partnercentralchannel.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralchannel.model.ListProgramManagementAccountsRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.ListProgramManagementAccountsResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.ProgramManagementAccountSummary;

public class ListProgramManagementAccountsPublisher
implements SdkPublisher<ListProgramManagementAccountsResponse> {
    private final PartnerCentralChannelAsyncClient client;
    private final ListProgramManagementAccountsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProgramManagementAccountsPublisher(PartnerCentralChannelAsyncClient client, ListProgramManagementAccountsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProgramManagementAccountsPublisher(PartnerCentralChannelAsyncClient client, ListProgramManagementAccountsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProgramManagementAccountsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProgramManagementAccountsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProgramManagementAccountSummary> items() {
        Function<ListProgramManagementAccountsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListProgramManagementAccountsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListProgramManagementAccountsResponseFetcher
    implements AsyncPageFetcher<ListProgramManagementAccountsResponse> {
        private ListProgramManagementAccountsResponseFetcher() {
        }

        public boolean hasNextPage(ListProgramManagementAccountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProgramManagementAccountsResponse> nextPage(ListProgramManagementAccountsResponse previousPage) {
            if (previousPage == null) {
                return ListProgramManagementAccountsPublisher.this.client.listProgramManagementAccounts(ListProgramManagementAccountsPublisher.this.firstRequest);
            }
            return ListProgramManagementAccountsPublisher.this.client.listProgramManagementAccounts((ListProgramManagementAccountsRequest)((Object)ListProgramManagementAccountsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

