/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralchannel.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralchannel.PartnerCentralChannelClient;
import software.amazon.awssdk.services.partnercentralchannel.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralchannel.model.ChannelHandshakeSummary;
import software.amazon.awssdk.services.partnercentralchannel.model.ListChannelHandshakesRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.ListChannelHandshakesResponse;

public class ListChannelHandshakesIterable
implements SdkIterable<ListChannelHandshakesResponse> {
    private final PartnerCentralChannelClient client;
    private final ListChannelHandshakesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListChannelHandshakesIterable(PartnerCentralChannelClient client, ListChannelHandshakesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListChannelHandshakesResponseFetcher();
    }

    public Iterator<ListChannelHandshakesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ChannelHandshakeSummary> items() {
        Function<ListChannelHandshakesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListChannelHandshakesResponseFetcher
    implements SyncPageFetcher<ListChannelHandshakesResponse> {
        private ListChannelHandshakesResponseFetcher() {
        }

        public boolean hasNextPage(ListChannelHandshakesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListChannelHandshakesResponse nextPage(ListChannelHandshakesResponse previousPage) {
            if (previousPage == null) {
                return ListChannelHandshakesIterable.this.client.listChannelHandshakes(ListChannelHandshakesIterable.this.firstRequest);
            }
            return ListChannelHandshakesIterable.this.client.listChannelHandshakes((ListChannelHandshakesRequest)((Object)ListChannelHandshakesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

