/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralchannel.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralchannel.model.Program;
import software.amazon.awssdk.services.partnercentralchannel.model.ProgramManagementAccountStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProgramManagementAccountSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProgramManagementAccountSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ProgramManagementAccountSummary.getter(ProgramManagementAccountSummary::id)).setter(ProgramManagementAccountSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revision").getter(ProgramManagementAccountSummary.getter(ProgramManagementAccountSummary::revision)).setter(ProgramManagementAccountSummary.setter(Builder::revision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()}).build();
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("catalog").getter(ProgramManagementAccountSummary.getter(ProgramManagementAccountSummary::catalog)).setter(ProgramManagementAccountSummary.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalog").build()}).build();
    private static final SdkField<String> PROGRAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("program").getter(ProgramManagementAccountSummary.getter(ProgramManagementAccountSummary::programAsString)).setter(ProgramManagementAccountSummary.setter(Builder::program)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("program").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(ProgramManagementAccountSummary.getter(ProgramManagementAccountSummary::displayName)).setter(ProgramManagementAccountSummary.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(ProgramManagementAccountSummary.getter(ProgramManagementAccountSummary::accountId)).setter(ProgramManagementAccountSummary.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ProgramManagementAccountSummary.getter(ProgramManagementAccountSummary::arn)).setter(ProgramManagementAccountSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ProgramManagementAccountSummary.getter(ProgramManagementAccountSummary::createdAt)).setter(ProgramManagementAccountSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(ProgramManagementAccountSummary.getter(ProgramManagementAccountSummary::updatedAt)).setter(ProgramManagementAccountSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startDate").getter(ProgramManagementAccountSummary.getter(ProgramManagementAccountSummary::startDate)).setter(ProgramManagementAccountSummary.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ProgramManagementAccountSummary.getter(ProgramManagementAccountSummary::statusAsString)).setter(ProgramManagementAccountSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, REVISION_FIELD, CATALOG_FIELD, PROGRAM_FIELD, DISPLAY_NAME_FIELD, ACCOUNT_ID_FIELD, ARN_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, START_DATE_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProgramManagementAccountSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String revision;
    private final String catalog;
    private final String program;
    private final String displayName;
    private final String accountId;
    private final String arn;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final Instant startDate;
    private final String status;

    private ProgramManagementAccountSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.revision = builder.revision;
        this.catalog = builder.catalog;
        this.program = builder.program;
        this.displayName = builder.displayName;
        this.accountId = builder.accountId;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.startDate = builder.startDate;
        this.status = builder.status;
    }

    public final String id() {
        return this.id;
    }

    public final String revision() {
        return this.revision;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final Program program() {
        return Program.fromValue(this.program);
    }

    public final String programAsString() {
        return this.program;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final Instant startDate() {
        return this.startDate;
    }

    public final ProgramManagementAccountStatus status() {
        return ProgramManagementAccountStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.programAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProgramManagementAccountSummary)) {
            return false;
        }
        ProgramManagementAccountSummary other = (ProgramManagementAccountSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.revision(), other.revision()) && Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.programAsString(), other.programAsString()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ProgramManagementAccountSummary").add("Id", (Object)this.id()).add("Revision", (Object)this.revision()).add("Catalog", (Object)this.catalog()).add("Program", (Object)this.programAsString()).add("DisplayName", (Object)this.displayName()).add("AccountId", (Object)this.accountId()).add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("StartDate", (Object)this.startDate()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
            case "catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "program": {
                return Optional.ofNullable(clazz.cast(this.programAsString()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "startDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("revision", REVISION_FIELD);
        map.put("catalog", CATALOG_FIELD);
        map.put("program", PROGRAM_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("startDate", START_DATE_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProgramManagementAccountSummary, T> g) {
        return obj -> g.apply((ProgramManagementAccountSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String revision;
        private String catalog;
        private String program;
        private String displayName;
        private String accountId;
        private String arn;
        private Instant createdAt;
        private Instant updatedAt;
        private Instant startDate;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ProgramManagementAccountSummary model) {
            this.id(model.id);
            this.revision(model.revision);
            this.catalog(model.catalog);
            this.program(model.program);
            this.displayName(model.displayName);
            this.accountId(model.accountId);
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.startDate(model.startDate);
            this.status(model.status);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getRevision() {
            return this.revision;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getProgram() {
            return this.program;
        }

        public final void setProgram(String program) {
            this.program = program;
        }

        @Override
        public final Builder program(String program) {
            this.program = program;
            return this;
        }

        @Override
        public final Builder program(Program program) {
            this.program(program == null ? null : program.toString());
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProgramManagementAccountStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public ProgramManagementAccountSummary build() {
            return new ProgramManagementAccountSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProgramManagementAccountSummary> {
        public Builder id(String var1);

        public Builder revision(String var1);

        public Builder catalog(String var1);

        public Builder program(String var1);

        public Builder program(Program var1);

        public Builder displayName(String var1);

        public Builder accountId(String var1);

        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder startDate(Instant var1);

        public Builder status(String var1);

        public Builder status(ProgramManagementAccountStatus var1);
    }
}

