/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralchannel.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralchannel.PartnerCentralChannelClient;
import software.amazon.awssdk.services.partnercentralchannel.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralchannel.model.ListRelationshipsRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.ListRelationshipsResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.RelationshipSummary;

public class ListRelationshipsIterable
implements SdkIterable<ListRelationshipsResponse> {
    private final PartnerCentralChannelClient client;
    private final ListRelationshipsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRelationshipsIterable(PartnerCentralChannelClient client, ListRelationshipsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRelationshipsResponseFetcher();
    }

    public Iterator<ListRelationshipsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RelationshipSummary> items() {
        Function<ListRelationshipsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRelationshipsResponseFetcher
    implements SyncPageFetcher<ListRelationshipsResponse> {
        private ListRelationshipsResponseFetcher() {
        }

        public boolean hasNextPage(ListRelationshipsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRelationshipsResponse nextPage(ListRelationshipsResponse previousPage) {
            if (previousPage == null) {
                return ListRelationshipsIterable.this.client.listRelationships(ListRelationshipsIterable.this.firstRequest);
            }
            return ListRelationshipsIterable.this.client.listRelationships((ListRelationshipsRequest)((Object)ListRelationshipsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

