/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralchannel.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRelationshipResponse extends PartnerCentralChannelResponse implements
        ToCopyableBuilder<UpdateRelationshipResponse.Builder, UpdateRelationshipResponse> {
    private static final SdkField<UpdateRelationshipDetail> RELATIONSHIP_DETAIL_FIELD = SdkField
            .<UpdateRelationshipDetail> builder(MarshallingType.SDK_POJO).memberName("relationshipDetail")
            .getter(getter(UpdateRelationshipResponse::relationshipDetail)).setter(setter(Builder::relationshipDetail))
            .constructor(UpdateRelationshipDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationshipDetail").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATIONSHIP_DETAIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final UpdateRelationshipDetail relationshipDetail;

    private UpdateRelationshipResponse(BuilderImpl builder) {
        super(builder);
        this.relationshipDetail = builder.relationshipDetail;
    }

    /**
     * <p>
     * Details of the updated relationship.
     * </p>
     * 
     * @return Details of the updated relationship.
     */
    public final UpdateRelationshipDetail relationshipDetail() {
        return relationshipDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(relationshipDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRelationshipResponse)) {
            return false;
        }
        UpdateRelationshipResponse other = (UpdateRelationshipResponse) obj;
        return Objects.equals(relationshipDetail(), other.relationshipDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRelationshipResponse").add("RelationshipDetail", relationshipDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "relationshipDetail":
            return Optional.ofNullable(clazz.cast(relationshipDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("relationshipDetail", RELATIONSHIP_DETAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRelationshipResponse, T> g) {
        return obj -> g.apply((UpdateRelationshipResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PartnerCentralChannelResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateRelationshipResponse> {
        /**
         * <p>
         * Details of the updated relationship.
         * </p>
         * 
         * @param relationshipDetail
         *        Details of the updated relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationshipDetail(UpdateRelationshipDetail relationshipDetail);

        /**
         * <p>
         * Details of the updated relationship.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateRelationshipDetail.Builder}
         * avoiding the need to create one manually via {@link UpdateRelationshipDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateRelationshipDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #relationshipDetail(UpdateRelationshipDetail)}.
         * 
         * @param relationshipDetail
         *        a consumer that will call methods on {@link UpdateRelationshipDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relationshipDetail(UpdateRelationshipDetail)
         */
        default Builder relationshipDetail(Consumer<UpdateRelationshipDetail.Builder> relationshipDetail) {
            return relationshipDetail(UpdateRelationshipDetail.builder().applyMutation(relationshipDetail).build());
        }
    }

    static final class BuilderImpl extends PartnerCentralChannelResponse.BuilderImpl implements Builder {
        private UpdateRelationshipDetail relationshipDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRelationshipResponse model) {
            super(model);
            relationshipDetail(model.relationshipDetail);
        }

        public final UpdateRelationshipDetail.Builder getRelationshipDetail() {
            return relationshipDetail != null ? relationshipDetail.toBuilder() : null;
        }

        public final void setRelationshipDetail(UpdateRelationshipDetail.BuilderImpl relationshipDetail) {
            this.relationshipDetail = relationshipDetail != null ? relationshipDetail.build() : null;
        }

        @Override
        public final Builder relationshipDetail(UpdateRelationshipDetail relationshipDetail) {
            this.relationshipDetail = relationshipDetail;
            return this;
        }

        @Override
        public UpdateRelationshipResponse build() {
            return new UpdateRelationshipResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
