/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralchannel.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for different types of support plans.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SupportPlan implements SdkPojo, Serializable, ToCopyableBuilder<SupportPlan.Builder, SupportPlan> {
    private static final SdkField<ResoldBusiness> RESOLD_BUSINESS_FIELD = SdkField
            .<ResoldBusiness> builder(MarshallingType.SDK_POJO).memberName("resoldBusiness")
            .getter(getter(SupportPlan::resoldBusiness)).setter(setter(Builder::resoldBusiness))
            .constructor(ResoldBusiness::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resoldBusiness").build()).build();

    private static final SdkField<ResoldEnterprise> RESOLD_ENTERPRISE_FIELD = SdkField
            .<ResoldEnterprise> builder(MarshallingType.SDK_POJO).memberName("resoldEnterprise")
            .getter(getter(SupportPlan::resoldEnterprise)).setter(setter(Builder::resoldEnterprise))
            .constructor(ResoldEnterprise::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resoldEnterprise").build()).build();

    private static final SdkField<PartnerLedSupport> PARTNER_LED_SUPPORT_FIELD = SdkField
            .<PartnerLedSupport> builder(MarshallingType.SDK_POJO).memberName("partnerLedSupport")
            .getter(getter(SupportPlan::partnerLedSupport)).setter(setter(Builder::partnerLedSupport))
            .constructor(PartnerLedSupport::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partnerLedSupport").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOLD_BUSINESS_FIELD,
            RESOLD_ENTERPRISE_FIELD, PARTNER_LED_SUPPORT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ResoldBusiness resoldBusiness;

    private final ResoldEnterprise resoldEnterprise;

    private final PartnerLedSupport partnerLedSupport;

    private final Type type;

    private SupportPlan(BuilderImpl builder) {
        this.resoldBusiness = builder.resoldBusiness;
        this.resoldEnterprise = builder.resoldEnterprise;
        this.partnerLedSupport = builder.partnerLedSupport;
        this.type = builder.type;
    }

    /**
     * <p>
     * Configuration for resold business support plans.
     * </p>
     * 
     * @return Configuration for resold business support plans.
     */
    public final ResoldBusiness resoldBusiness() {
        return resoldBusiness;
    }

    /**
     * <p>
     * Configuration for resold enterprise support plans.
     * </p>
     * 
     * @return Configuration for resold enterprise support plans.
     */
    public final ResoldEnterprise resoldEnterprise() {
        return resoldEnterprise;
    }

    /**
     * <p>
     * Configuration for partner-led support plans.
     * </p>
     * 
     * @return Configuration for partner-led support plans.
     */
    public final PartnerLedSupport partnerLedSupport() {
        return partnerLedSupport;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resoldBusiness());
        hashCode = 31 * hashCode + Objects.hashCode(resoldEnterprise());
        hashCode = 31 * hashCode + Objects.hashCode(partnerLedSupport());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SupportPlan)) {
            return false;
        }
        SupportPlan other = (SupportPlan) obj;
        return Objects.equals(resoldBusiness(), other.resoldBusiness())
                && Objects.equals(resoldEnterprise(), other.resoldEnterprise())
                && Objects.equals(partnerLedSupport(), other.partnerLedSupport());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SupportPlan").add("ResoldBusiness", resoldBusiness())
                .add("ResoldEnterprise", resoldEnterprise()).add("PartnerLedSupport", partnerLedSupport()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resoldBusiness":
            return Optional.ofNullable(clazz.cast(resoldBusiness()));
        case "resoldEnterprise":
            return Optional.ofNullable(clazz.cast(resoldEnterprise()));
        case "partnerLedSupport":
            return Optional.ofNullable(clazz.cast(partnerLedSupport()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #resoldBusiness()} initialized to the given value.
     *
     * <p>
     * Configuration for resold business support plans.
     * </p>
     * 
     * @param resoldBusiness
     *        Configuration for resold business support plans.
     */
    public static SupportPlan fromResoldBusiness(ResoldBusiness resoldBusiness) {
        return builder().resoldBusiness(resoldBusiness).build();
    }

    /**
     * Create an instance of this class with {@link #resoldBusiness()} initialized to the given value.
     *
     * <p>
     * Configuration for resold business support plans.
     * </p>
     * 
     * @param resoldBusiness
     *        Configuration for resold business support plans.
     */
    public static SupportPlan fromResoldBusiness(Consumer<ResoldBusiness.Builder> resoldBusiness) {
        ResoldBusiness.Builder builder = ResoldBusiness.builder();
        resoldBusiness.accept(builder);
        return fromResoldBusiness(builder.build());
    }

    /**
     * Create an instance of this class with {@link #resoldEnterprise()} initialized to the given value.
     *
     * <p>
     * Configuration for resold enterprise support plans.
     * </p>
     * 
     * @param resoldEnterprise
     *        Configuration for resold enterprise support plans.
     */
    public static SupportPlan fromResoldEnterprise(ResoldEnterprise resoldEnterprise) {
        return builder().resoldEnterprise(resoldEnterprise).build();
    }

    /**
     * Create an instance of this class with {@link #resoldEnterprise()} initialized to the given value.
     *
     * <p>
     * Configuration for resold enterprise support plans.
     * </p>
     * 
     * @param resoldEnterprise
     *        Configuration for resold enterprise support plans.
     */
    public static SupportPlan fromResoldEnterprise(Consumer<ResoldEnterprise.Builder> resoldEnterprise) {
        ResoldEnterprise.Builder builder = ResoldEnterprise.builder();
        resoldEnterprise.accept(builder);
        return fromResoldEnterprise(builder.build());
    }

    /**
     * Create an instance of this class with {@link #partnerLedSupport()} initialized to the given value.
     *
     * <p>
     * Configuration for partner-led support plans.
     * </p>
     * 
     * @param partnerLedSupport
     *        Configuration for partner-led support plans.
     */
    public static SupportPlan fromPartnerLedSupport(PartnerLedSupport partnerLedSupport) {
        return builder().partnerLedSupport(partnerLedSupport).build();
    }

    /**
     * Create an instance of this class with {@link #partnerLedSupport()} initialized to the given value.
     *
     * <p>
     * Configuration for partner-led support plans.
     * </p>
     * 
     * @param partnerLedSupport
     *        Configuration for partner-led support plans.
     */
    public static SupportPlan fromPartnerLedSupport(Consumer<PartnerLedSupport.Builder> partnerLedSupport) {
        PartnerLedSupport.Builder builder = PartnerLedSupport.builder();
        partnerLedSupport.accept(builder);
        return fromPartnerLedSupport(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resoldBusiness", RESOLD_BUSINESS_FIELD);
        map.put("resoldEnterprise", RESOLD_ENTERPRISE_FIELD);
        map.put("partnerLedSupport", PARTNER_LED_SUPPORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SupportPlan, T> g) {
        return obj -> g.apply((SupportPlan) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SupportPlan> {
        /**
         * <p>
         * Configuration for resold business support plans.
         * </p>
         * 
         * @param resoldBusiness
         *        Configuration for resold business support plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resoldBusiness(ResoldBusiness resoldBusiness);

        /**
         * <p>
         * Configuration for resold business support plans.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResoldBusiness.Builder} avoiding the need
         * to create one manually via {@link ResoldBusiness#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResoldBusiness.Builder#build()} is called immediately and its
         * result is passed to {@link #resoldBusiness(ResoldBusiness)}.
         * 
         * @param resoldBusiness
         *        a consumer that will call methods on {@link ResoldBusiness.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resoldBusiness(ResoldBusiness)
         */
        default Builder resoldBusiness(Consumer<ResoldBusiness.Builder> resoldBusiness) {
            return resoldBusiness(ResoldBusiness.builder().applyMutation(resoldBusiness).build());
        }

        /**
         * <p>
         * Configuration for resold enterprise support plans.
         * </p>
         * 
         * @param resoldEnterprise
         *        Configuration for resold enterprise support plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resoldEnterprise(ResoldEnterprise resoldEnterprise);

        /**
         * <p>
         * Configuration for resold enterprise support plans.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResoldEnterprise.Builder} avoiding the
         * need to create one manually via {@link ResoldEnterprise#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResoldEnterprise.Builder#build()} is called immediately and its
         * result is passed to {@link #resoldEnterprise(ResoldEnterprise)}.
         * 
         * @param resoldEnterprise
         *        a consumer that will call methods on {@link ResoldEnterprise.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resoldEnterprise(ResoldEnterprise)
         */
        default Builder resoldEnterprise(Consumer<ResoldEnterprise.Builder> resoldEnterprise) {
            return resoldEnterprise(ResoldEnterprise.builder().applyMutation(resoldEnterprise).build());
        }

        /**
         * <p>
         * Configuration for partner-led support plans.
         * </p>
         * 
         * @param partnerLedSupport
         *        Configuration for partner-led support plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partnerLedSupport(PartnerLedSupport partnerLedSupport);

        /**
         * <p>
         * Configuration for partner-led support plans.
         * </p>
         * This is a convenience method that creates an instance of the {@link PartnerLedSupport.Builder} avoiding the
         * need to create one manually via {@link PartnerLedSupport#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PartnerLedSupport.Builder#build()} is called immediately and its
         * result is passed to {@link #partnerLedSupport(PartnerLedSupport)}.
         * 
         * @param partnerLedSupport
         *        a consumer that will call methods on {@link PartnerLedSupport.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partnerLedSupport(PartnerLedSupport)
         */
        default Builder partnerLedSupport(Consumer<PartnerLedSupport.Builder> partnerLedSupport) {
            return partnerLedSupport(PartnerLedSupport.builder().applyMutation(partnerLedSupport).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ResoldBusiness resoldBusiness;

        private ResoldEnterprise resoldEnterprise;

        private PartnerLedSupport partnerLedSupport;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SupportPlan model) {
            resoldBusiness(model.resoldBusiness);
            resoldEnterprise(model.resoldEnterprise);
            partnerLedSupport(model.partnerLedSupport);
        }

        public final ResoldBusiness.Builder getResoldBusiness() {
            return resoldBusiness != null ? resoldBusiness.toBuilder() : null;
        }

        public final void setResoldBusiness(ResoldBusiness.BuilderImpl resoldBusiness) {
            Object oldValue = this.resoldBusiness;
            this.resoldBusiness = resoldBusiness != null ? resoldBusiness.build() : null;
            handleUnionValueChange(Type.RESOLD_BUSINESS, oldValue, this.resoldBusiness);
        }

        @Override
        public final Builder resoldBusiness(ResoldBusiness resoldBusiness) {
            Object oldValue = this.resoldBusiness;
            this.resoldBusiness = resoldBusiness;
            handleUnionValueChange(Type.RESOLD_BUSINESS, oldValue, this.resoldBusiness);
            return this;
        }

        public final ResoldEnterprise.Builder getResoldEnterprise() {
            return resoldEnterprise != null ? resoldEnterprise.toBuilder() : null;
        }

        public final void setResoldEnterprise(ResoldEnterprise.BuilderImpl resoldEnterprise) {
            Object oldValue = this.resoldEnterprise;
            this.resoldEnterprise = resoldEnterprise != null ? resoldEnterprise.build() : null;
            handleUnionValueChange(Type.RESOLD_ENTERPRISE, oldValue, this.resoldEnterprise);
        }

        @Override
        public final Builder resoldEnterprise(ResoldEnterprise resoldEnterprise) {
            Object oldValue = this.resoldEnterprise;
            this.resoldEnterprise = resoldEnterprise;
            handleUnionValueChange(Type.RESOLD_ENTERPRISE, oldValue, this.resoldEnterprise);
            return this;
        }

        public final PartnerLedSupport.Builder getPartnerLedSupport() {
            return partnerLedSupport != null ? partnerLedSupport.toBuilder() : null;
        }

        public final void setPartnerLedSupport(PartnerLedSupport.BuilderImpl partnerLedSupport) {
            Object oldValue = this.partnerLedSupport;
            this.partnerLedSupport = partnerLedSupport != null ? partnerLedSupport.build() : null;
            handleUnionValueChange(Type.PARTNER_LED_SUPPORT, oldValue, this.partnerLedSupport);
        }

        @Override
        public final Builder partnerLedSupport(PartnerLedSupport partnerLedSupport) {
            Object oldValue = this.partnerLedSupport;
            this.partnerLedSupport = partnerLedSupport;
            handleUnionValueChange(Type.PARTNER_LED_SUPPORT, oldValue, this.partnerLedSupport);
            return this;
        }

        @Override
        public SupportPlan build() {
            return new SupportPlan(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see SupportPlan#type()
     */
    public enum Type {
        RESOLD_BUSINESS,

        RESOLD_ENTERPRISE,

        PARTNER_LED_SUPPORT,

        UNKNOWN_TO_SDK_VERSION
    }
}
