/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralchannel.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about a partner relationship.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RelationshipDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<RelationshipDetail.Builder, RelationshipDetail> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(RelationshipDetail::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(RelationshipDetail::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revision").getter(getter(RelationshipDetail::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()).build();

    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("catalog")
            .getter(getter(RelationshipDetail::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalog").build()).build();

    private static final SdkField<String> ASSOCIATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associationType").getter(getter(RelationshipDetail::associationTypeAsString))
            .setter(setter(Builder::associationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationType").build()).build();

    private static final SdkField<String> PROGRAM_MANAGEMENT_ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("programManagementAccountId")
            .getter(getter(RelationshipDetail::programManagementAccountId))
            .setter(setter(Builder::programManagementAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programManagementAccountId").build())
            .build();

    private static final SdkField<String> ASSOCIATED_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associatedAccountId").getter(getter(RelationshipDetail::associatedAccountId))
            .setter(setter(Builder::associatedAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedAccountId").build())
            .build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(RelationshipDetail::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> RESALE_ACCOUNT_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resaleAccountModel").getter(getter(RelationshipDetail::resaleAccountModelAsString))
            .setter(setter(Builder::resaleAccountModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resaleAccountModel").build())
            .build();

    private static final SdkField<String> SECTOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sector")
            .getter(getter(RelationshipDetail::sectorAsString)).setter(setter(Builder::sector))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sector").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(RelationshipDetail::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(RelationshipDetail::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> START_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startDate")
            .getter(getter(RelationshipDetail::startDate))
            .setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            REVISION_FIELD, CATALOG_FIELD, ASSOCIATION_TYPE_FIELD, PROGRAM_MANAGEMENT_ACCOUNT_ID_FIELD,
            ASSOCIATED_ACCOUNT_ID_FIELD, DISPLAY_NAME_FIELD, RESALE_ACCOUNT_MODEL_FIELD, SECTOR_FIELD, CREATED_AT_FIELD,
            UPDATED_AT_FIELD, START_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String id;

    private final String revision;

    private final String catalog;

    private final String associationType;

    private final String programManagementAccountId;

    private final String associatedAccountId;

    private final String displayName;

    private final String resaleAccountModel;

    private final String sector;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final Instant startDate;

    private RelationshipDetail(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.revision = builder.revision;
        this.catalog = builder.catalog;
        this.associationType = builder.associationType;
        this.programManagementAccountId = builder.programManagementAccountId;
        this.associatedAccountId = builder.associatedAccountId;
        this.displayName = builder.displayName;
        this.resaleAccountModel = builder.resaleAccountModel;
        this.sector = builder.sector;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.startDate = builder.startDate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the relationship.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the relationship.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The unique identifier of the relationship.
     * </p>
     * 
     * @return The unique identifier of the relationship.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The current revision number of the relationship.
     * </p>
     * 
     * @return The current revision number of the relationship.
     */
    public final String revision() {
        return revision;
    }

    /**
     * <p>
     * The catalog identifier associated with the relationship.
     * </p>
     * 
     * @return The catalog identifier associated with the relationship.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * The type of association for the relationship.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationType}
     * will return {@link AssociationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #associationTypeAsString}.
     * </p>
     * 
     * @return The type of association for the relationship.
     * @see AssociationType
     */
    public final AssociationType associationType() {
        return AssociationType.fromValue(associationType);
    }

    /**
     * <p>
     * The type of association for the relationship.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationType}
     * will return {@link AssociationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #associationTypeAsString}.
     * </p>
     * 
     * @return The type of association for the relationship.
     * @see AssociationType
     */
    public final String associationTypeAsString() {
        return associationType;
    }

    /**
     * <p>
     * The identifier of the program management account.
     * </p>
     * 
     * @return The identifier of the program management account.
     */
    public final String programManagementAccountId() {
        return programManagementAccountId;
    }

    /**
     * <p>
     * The AWS account ID associated in this relationship.
     * </p>
     * 
     * @return The AWS account ID associated in this relationship.
     */
    public final String associatedAccountId() {
        return associatedAccountId;
    }

    /**
     * <p>
     * The display name of the relationship.
     * </p>
     * 
     * @return The display name of the relationship.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The resale account model for the relationship.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resaleAccountModel} will return {@link ResaleAccountModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #resaleAccountModelAsString}.
     * </p>
     * 
     * @return The resale account model for the relationship.
     * @see ResaleAccountModel
     */
    public final ResaleAccountModel resaleAccountModel() {
        return ResaleAccountModel.fromValue(resaleAccountModel);
    }

    /**
     * <p>
     * The resale account model for the relationship.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resaleAccountModel} will return {@link ResaleAccountModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #resaleAccountModelAsString}.
     * </p>
     * 
     * @return The resale account model for the relationship.
     * @see ResaleAccountModel
     */
    public final String resaleAccountModelAsString() {
        return resaleAccountModel;
    }

    /**
     * <p>
     * The business sector for the relationship.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sector} will
     * return {@link Sector#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sectorAsString}.
     * </p>
     * 
     * @return The business sector for the relationship.
     * @see Sector
     */
    public final Sector sector() {
        return Sector.fromValue(sector);
    }

    /**
     * <p>
     * The business sector for the relationship.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sector} will
     * return {@link Sector#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sectorAsString}.
     * </p>
     * 
     * @return The business sector for the relationship.
     * @see Sector
     */
    public final String sectorAsString() {
        return sector;
    }

    /**
     * <p>
     * The timestamp when the relationship was created.
     * </p>
     * 
     * @return The timestamp when the relationship was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the relationship was last updated.
     * </p>
     * 
     * @return The timestamp when the relationship was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The start date of the relationship.
     * </p>
     * 
     * @return The start date of the relationship.
     */
    public final Instant startDate() {
        return startDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(associationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(programManagementAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(associatedAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(resaleAccountModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sectorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelationshipDetail)) {
            return false;
        }
        RelationshipDetail other = (RelationshipDetail) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id())
                && Objects.equals(revision(), other.revision()) && Objects.equals(catalog(), other.catalog())
                && Objects.equals(associationTypeAsString(), other.associationTypeAsString())
                && Objects.equals(programManagementAccountId(), other.programManagementAccountId())
                && Objects.equals(associatedAccountId(), other.associatedAccountId())
                && Objects.equals(displayName(), other.displayName())
                && Objects.equals(resaleAccountModelAsString(), other.resaleAccountModelAsString())
                && Objects.equals(sectorAsString(), other.sectorAsString()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(startDate(), other.startDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RelationshipDetail").add("Arn", arn()).add("Id", id()).add("Revision", revision())
                .add("Catalog", catalog()).add("AssociationType", associationTypeAsString())
                .add("ProgramManagementAccountId", programManagementAccountId())
                .add("AssociatedAccountId", associatedAccountId()).add("DisplayName", displayName())
                .add("ResaleAccountModel", resaleAccountModelAsString()).add("Sector", sectorAsString())
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).add("StartDate", startDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "revision":
            return Optional.ofNullable(clazz.cast(revision()));
        case "catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "associationType":
            return Optional.ofNullable(clazz.cast(associationTypeAsString()));
        case "programManagementAccountId":
            return Optional.ofNullable(clazz.cast(programManagementAccountId()));
        case "associatedAccountId":
            return Optional.ofNullable(clazz.cast(associatedAccountId()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "resaleAccountModel":
            return Optional.ofNullable(clazz.cast(resaleAccountModelAsString()));
        case "sector":
            return Optional.ofNullable(clazz.cast(sectorAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "startDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("revision", REVISION_FIELD);
        map.put("catalog", CATALOG_FIELD);
        map.put("associationType", ASSOCIATION_TYPE_FIELD);
        map.put("programManagementAccountId", PROGRAM_MANAGEMENT_ACCOUNT_ID_FIELD);
        map.put("associatedAccountId", ASSOCIATED_ACCOUNT_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("resaleAccountModel", RESALE_ACCOUNT_MODEL_FIELD);
        map.put("sector", SECTOR_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("startDate", START_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RelationshipDetail, T> g) {
        return obj -> g.apply((RelationshipDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RelationshipDetail> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the relationship.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The unique identifier of the relationship.
         * </p>
         * 
         * @param id
         *        The unique identifier of the relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The current revision number of the relationship.
         * </p>
         * 
         * @param revision
         *        The current revision number of the relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(String revision);

        /**
         * <p>
         * The catalog identifier associated with the relationship.
         * </p>
         * 
         * @param catalog
         *        The catalog identifier associated with the relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * The type of association for the relationship.
         * </p>
         * 
         * @param associationType
         *        The type of association for the relationship.
         * @see AssociationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationType
         */
        Builder associationType(String associationType);

        /**
         * <p>
         * The type of association for the relationship.
         * </p>
         * 
         * @param associationType
         *        The type of association for the relationship.
         * @see AssociationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationType
         */
        Builder associationType(AssociationType associationType);

        /**
         * <p>
         * The identifier of the program management account.
         * </p>
         * 
         * @param programManagementAccountId
         *        The identifier of the program management account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programManagementAccountId(String programManagementAccountId);

        /**
         * <p>
         * The AWS account ID associated in this relationship.
         * </p>
         * 
         * @param associatedAccountId
         *        The AWS account ID associated in this relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedAccountId(String associatedAccountId);

        /**
         * <p>
         * The display name of the relationship.
         * </p>
         * 
         * @param displayName
         *        The display name of the relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The resale account model for the relationship.
         * </p>
         * 
         * @param resaleAccountModel
         *        The resale account model for the relationship.
         * @see ResaleAccountModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResaleAccountModel
         */
        Builder resaleAccountModel(String resaleAccountModel);

        /**
         * <p>
         * The resale account model for the relationship.
         * </p>
         * 
         * @param resaleAccountModel
         *        The resale account model for the relationship.
         * @see ResaleAccountModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResaleAccountModel
         */
        Builder resaleAccountModel(ResaleAccountModel resaleAccountModel);

        /**
         * <p>
         * The business sector for the relationship.
         * </p>
         * 
         * @param sector
         *        The business sector for the relationship.
         * @see Sector
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Sector
         */
        Builder sector(String sector);

        /**
         * <p>
         * The business sector for the relationship.
         * </p>
         * 
         * @param sector
         *        The business sector for the relationship.
         * @see Sector
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Sector
         */
        Builder sector(Sector sector);

        /**
         * <p>
         * The timestamp when the relationship was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the relationship was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the relationship was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the relationship was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The start date of the relationship.
         * </p>
         * 
         * @param startDate
         *        The start date of the relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String revision;

        private String catalog;

        private String associationType;

        private String programManagementAccountId;

        private String associatedAccountId;

        private String displayName;

        private String resaleAccountModel;

        private String sector;

        private Instant createdAt;

        private Instant updatedAt;

        private Instant startDate;

        private BuilderImpl() {
        }

        private BuilderImpl(RelationshipDetail model) {
            arn(model.arn);
            id(model.id);
            revision(model.revision);
            catalog(model.catalog);
            associationType(model.associationType);
            programManagementAccountId(model.programManagementAccountId);
            associatedAccountId(model.associatedAccountId);
            displayName(model.displayName);
            resaleAccountModel(model.resaleAccountModel);
            sector(model.sector);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            startDate(model.startDate);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getRevision() {
            return revision;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getAssociationType() {
            return associationType;
        }

        public final void setAssociationType(String associationType) {
            this.associationType = associationType;
        }

        @Override
        public final Builder associationType(String associationType) {
            this.associationType = associationType;
            return this;
        }

        @Override
        public final Builder associationType(AssociationType associationType) {
            this.associationType(associationType == null ? null : associationType.toString());
            return this;
        }

        public final String getProgramManagementAccountId() {
            return programManagementAccountId;
        }

        public final void setProgramManagementAccountId(String programManagementAccountId) {
            this.programManagementAccountId = programManagementAccountId;
        }

        @Override
        public final Builder programManagementAccountId(String programManagementAccountId) {
            this.programManagementAccountId = programManagementAccountId;
            return this;
        }

        public final String getAssociatedAccountId() {
            return associatedAccountId;
        }

        public final void setAssociatedAccountId(String associatedAccountId) {
            this.associatedAccountId = associatedAccountId;
        }

        @Override
        public final Builder associatedAccountId(String associatedAccountId) {
            this.associatedAccountId = associatedAccountId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getResaleAccountModel() {
            return resaleAccountModel;
        }

        public final void setResaleAccountModel(String resaleAccountModel) {
            this.resaleAccountModel = resaleAccountModel;
        }

        @Override
        public final Builder resaleAccountModel(String resaleAccountModel) {
            this.resaleAccountModel = resaleAccountModel;
            return this;
        }

        @Override
        public final Builder resaleAccountModel(ResaleAccountModel resaleAccountModel) {
            this.resaleAccountModel(resaleAccountModel == null ? null : resaleAccountModel.toString());
            return this;
        }

        public final String getSector() {
            return sector;
        }

        public final void setSector(String sector) {
            this.sector = sector;
        }

        @Override
        public final Builder sector(String sector) {
            this.sector = sector;
            return this;
        }

        @Override
        public final Builder sector(Sector sector) {
            this.sector(sector == null ? null : sector.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Instant getStartDate() {
            return startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        @Override
        public RelationshipDetail build() {
            return new RelationshipDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
