/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralchannel.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Type-specific filters for program management accounts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProgramManagementAccountTypeFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<ProgramManagementAccountTypeFilters.Builder, ProgramManagementAccountTypeFilters> {
    private static final SdkField<List<String>> PROGRAMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("programs")
            .getter(getter(ProgramManagementAccountTypeFilters::programsAsStrings))
            .setter(setter(Builder::programsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRAMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> programs;

    private ProgramManagementAccountTypeFilters(BuilderImpl builder) {
        this.programs = builder.programs;
    }

    /**
     * <p>
     * Filter by program types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrograms} method.
     * </p>
     * 
     * @return Filter by program types.
     */
    public final List<Program> programs() {
        return ProgramListCopier.copyStringToEnum(programs);
    }

    /**
     * For responses, this returns true if the service returned a value for the Programs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPrograms() {
        return programs != null && !(programs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter by program types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrograms} method.
     * </p>
     * 
     * @return Filter by program types.
     */
    public final List<String> programsAsStrings() {
        return programs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPrograms() ? programsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProgramManagementAccountTypeFilters)) {
            return false;
        }
        ProgramManagementAccountTypeFilters other = (ProgramManagementAccountTypeFilters) obj;
        return hasPrograms() == other.hasPrograms() && Objects.equals(programsAsStrings(), other.programsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProgramManagementAccountTypeFilters")
                .add("Programs", hasPrograms() ? programsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "programs":
            return Optional.ofNullable(clazz.cast(programsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("programs", PROGRAMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProgramManagementAccountTypeFilters, T> g) {
        return obj -> g.apply((ProgramManagementAccountTypeFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProgramManagementAccountTypeFilters> {
        /**
         * <p>
         * Filter by program types.
         * </p>
         * 
         * @param programs
         *        Filter by program types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programsWithStrings(Collection<String> programs);

        /**
         * <p>
         * Filter by program types.
         * </p>
         * 
         * @param programs
         *        Filter by program types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programsWithStrings(String... programs);

        /**
         * <p>
         * Filter by program types.
         * </p>
         * 
         * @param programs
         *        Filter by program types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programs(Collection<Program> programs);

        /**
         * <p>
         * Filter by program types.
         * </p>
         * 
         * @param programs
         *        Filter by program types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programs(Program... programs);
    }

    static final class BuilderImpl implements Builder {
        private List<String> programs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProgramManagementAccountTypeFilters model) {
            programsWithStrings(model.programs);
        }

        public final Collection<String> getPrograms() {
            if (programs instanceof SdkAutoConstructList) {
                return null;
            }
            return programs;
        }

        public final void setPrograms(Collection<String> programs) {
            this.programs = ProgramListCopier.copy(programs);
        }

        @Override
        public final Builder programsWithStrings(Collection<String> programs) {
            this.programs = ProgramListCopier.copy(programs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder programsWithStrings(String... programs) {
            programsWithStrings(Arrays.asList(programs));
            return this;
        }

        @Override
        public final Builder programs(Collection<Program> programs) {
            this.programs = ProgramListCopier.copyEnumToString(programs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder programs(Program... programs) {
            programs(Arrays.asList(programs));
            return this;
        }

        @Override
        public ProgramManagementAccountTypeFilters build() {
            return new ProgramManagementAccountTypeFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
