/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralchannel.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListChannelHandshakesRequest extends PartnerCentralChannelRequest implements
        ToCopyableBuilder<ListChannelHandshakesRequest.Builder, ListChannelHandshakesRequest> {
    private static final SdkField<String> HANDSHAKE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("handshakeType").getter(getter(ListChannelHandshakesRequest::handshakeTypeAsString))
            .setter(setter(Builder::handshakeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("handshakeType").build()).build();

    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("catalog")
            .getter(getter(ListChannelHandshakesRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalog").build()).build();

    private static final SdkField<String> PARTICIPANT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("participantType").getter(getter(ListChannelHandshakesRequest::participantTypeAsString))
            .setter(setter(Builder::participantType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participantType").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListChannelHandshakesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<List<String>> STATUSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("statuses")
            .getter(getter(ListChannelHandshakesRequest::statusesAsStrings))
            .setter(setter(Builder::statusesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ASSOCIATED_RESOURCE_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("associatedResourceIdentifiers")
            .getter(getter(ListChannelHandshakesRequest::associatedResourceIdentifiers))
            .setter(setter(Builder::associatedResourceIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedResourceIdentifiers")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ListChannelHandshakesTypeFilters> HANDSHAKE_TYPE_FILTERS_FIELD = SdkField
            .<ListChannelHandshakesTypeFilters> builder(MarshallingType.SDK_POJO).memberName("handshakeTypeFilters")
            .getter(getter(ListChannelHandshakesRequest::handshakeTypeFilters)).setter(setter(Builder::handshakeTypeFilters))
            .constructor(ListChannelHandshakesTypeFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("handshakeTypeFilters").build())
            .build();

    private static final SdkField<ListChannelHandshakesTypeSort> HANDSHAKE_TYPE_SORT_FIELD = SdkField
            .<ListChannelHandshakesTypeSort> builder(MarshallingType.SDK_POJO).memberName("handshakeTypeSort")
            .getter(getter(ListChannelHandshakesRequest::handshakeTypeSort)).setter(setter(Builder::handshakeTypeSort))
            .constructor(ListChannelHandshakesTypeSort::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("handshakeTypeSort").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListChannelHandshakesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HANDSHAKE_TYPE_FIELD,
            CATALOG_FIELD, PARTICIPANT_TYPE_FIELD, MAX_RESULTS_FIELD, STATUSES_FIELD, ASSOCIATED_RESOURCE_IDENTIFIERS_FIELD,
            HANDSHAKE_TYPE_FILTERS_FIELD, HANDSHAKE_TYPE_SORT_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String handshakeType;

    private final String catalog;

    private final String participantType;

    private final Integer maxResults;

    private final List<String> statuses;

    private final List<String> associatedResourceIdentifiers;

    private final ListChannelHandshakesTypeFilters handshakeTypeFilters;

    private final ListChannelHandshakesTypeSort handshakeTypeSort;

    private final String nextToken;

    private ListChannelHandshakesRequest(BuilderImpl builder) {
        super(builder);
        this.handshakeType = builder.handshakeType;
        this.catalog = builder.catalog;
        this.participantType = builder.participantType;
        this.maxResults = builder.maxResults;
        this.statuses = builder.statuses;
        this.associatedResourceIdentifiers = builder.associatedResourceIdentifiers;
        this.handshakeTypeFilters = builder.handshakeTypeFilters;
        this.handshakeTypeSort = builder.handshakeTypeSort;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Filter results by handshake type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #handshakeType}
     * will return {@link HandshakeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #handshakeTypeAsString}.
     * </p>
     * 
     * @return Filter results by handshake type.
     * @see HandshakeType
     */
    public final HandshakeType handshakeType() {
        return HandshakeType.fromValue(handshakeType);
    }

    /**
     * <p>
     * Filter results by handshake type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #handshakeType}
     * will return {@link HandshakeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #handshakeTypeAsString}.
     * </p>
     * 
     * @return Filter results by handshake type.
     * @see HandshakeType
     */
    public final String handshakeTypeAsString() {
        return handshakeType;
    }

    /**
     * <p>
     * The catalog identifier to filter handshakes.
     * </p>
     * 
     * @return The catalog identifier to filter handshakes.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * Filter by participant type (sender or receiver).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantType}
     * will return {@link ParticipantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #participantTypeAsString}.
     * </p>
     * 
     * @return Filter by participant type (sender or receiver).
     * @see ParticipantType
     */
    public final ParticipantType participantType() {
        return ParticipantType.fromValue(participantType);
    }

    /**
     * <p>
     * Filter by participant type (sender or receiver).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantType}
     * will return {@link ParticipantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #participantTypeAsString}.
     * </p>
     * 
     * @return Filter by participant type (sender or receiver).
     * @see ParticipantType
     */
    public final String participantTypeAsString() {
        return participantType;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call.
     * </p>
     * 
     * @return The maximum number of results to return in a single call.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Filter results by handshake status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatuses} method.
     * </p>
     * 
     * @return Filter results by handshake status.
     */
    public final List<HandshakeStatus> statuses() {
        return HandshakeStatusListCopier.copyStringToEnum(statuses);
    }

    /**
     * For responses, this returns true if the service returned a value for the Statuses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatuses() {
        return statuses != null && !(statuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter results by handshake status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatuses} method.
     * </p>
     * 
     * @return Filter results by handshake status.
     */
    public final List<String> statusesAsStrings() {
        return statuses;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedResourceIdentifiers property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssociatedResourceIdentifiers() {
        return associatedResourceIdentifiers != null && !(associatedResourceIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter by associated resource identifiers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedResourceIdentifiers} method.
     * </p>
     * 
     * @return Filter by associated resource identifiers.
     */
    public final List<String> associatedResourceIdentifiers() {
        return associatedResourceIdentifiers;
    }

    /**
     * <p>
     * Type-specific filters for handshakes.
     * </p>
     * 
     * @return Type-specific filters for handshakes.
     */
    public final ListChannelHandshakesTypeFilters handshakeTypeFilters() {
        return handshakeTypeFilters;
    }

    /**
     * <p>
     * Type-specific sorting options for handshakes.
     * </p>
     * 
     * @return Type-specific sorting options for handshakes.
     */
    public final ListChannelHandshakesTypeSort handshakeTypeSort() {
        return handshakeTypeSort;
    }

    /**
     * <p>
     * Token for retrieving the next page of results.
     * </p>
     * 
     * @return Token for retrieving the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(handshakeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(participantTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatuses() ? statusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedResourceIdentifiers() ? associatedResourceIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(handshakeTypeFilters());
        hashCode = 31 * hashCode + Objects.hashCode(handshakeTypeSort());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChannelHandshakesRequest)) {
            return false;
        }
        ListChannelHandshakesRequest other = (ListChannelHandshakesRequest) obj;
        return Objects.equals(handshakeTypeAsString(), other.handshakeTypeAsString())
                && Objects.equals(catalog(), other.catalog())
                && Objects.equals(participantTypeAsString(), other.participantTypeAsString())
                && Objects.equals(maxResults(), other.maxResults()) && hasStatuses() == other.hasStatuses()
                && Objects.equals(statusesAsStrings(), other.statusesAsStrings())
                && hasAssociatedResourceIdentifiers() == other.hasAssociatedResourceIdentifiers()
                && Objects.equals(associatedResourceIdentifiers(), other.associatedResourceIdentifiers())
                && Objects.equals(handshakeTypeFilters(), other.handshakeTypeFilters())
                && Objects.equals(handshakeTypeSort(), other.handshakeTypeSort())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListChannelHandshakesRequest")
                .add("HandshakeType", handshakeTypeAsString())
                .add("Catalog", catalog())
                .add("ParticipantType", participantTypeAsString())
                .add("MaxResults", maxResults())
                .add("Statuses", hasStatuses() ? statusesAsStrings() : null)
                .add("AssociatedResourceIdentifiers", hasAssociatedResourceIdentifiers() ? associatedResourceIdentifiers() : null)
                .add("HandshakeTypeFilters", handshakeTypeFilters()).add("HandshakeTypeSort", handshakeTypeSort())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "handshakeType":
            return Optional.ofNullable(clazz.cast(handshakeTypeAsString()));
        case "catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "participantType":
            return Optional.ofNullable(clazz.cast(participantTypeAsString()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "statuses":
            return Optional.ofNullable(clazz.cast(statusesAsStrings()));
        case "associatedResourceIdentifiers":
            return Optional.ofNullable(clazz.cast(associatedResourceIdentifiers()));
        case "handshakeTypeFilters":
            return Optional.ofNullable(clazz.cast(handshakeTypeFilters()));
        case "handshakeTypeSort":
            return Optional.ofNullable(clazz.cast(handshakeTypeSort()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("handshakeType", HANDSHAKE_TYPE_FIELD);
        map.put("catalog", CATALOG_FIELD);
        map.put("participantType", PARTICIPANT_TYPE_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("statuses", STATUSES_FIELD);
        map.put("associatedResourceIdentifiers", ASSOCIATED_RESOURCE_IDENTIFIERS_FIELD);
        map.put("handshakeTypeFilters", HANDSHAKE_TYPE_FILTERS_FIELD);
        map.put("handshakeTypeSort", HANDSHAKE_TYPE_SORT_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListChannelHandshakesRequest, T> g) {
        return obj -> g.apply((ListChannelHandshakesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PartnerCentralChannelRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListChannelHandshakesRequest> {
        /**
         * <p>
         * Filter results by handshake type.
         * </p>
         * 
         * @param handshakeType
         *        Filter results by handshake type.
         * @see HandshakeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HandshakeType
         */
        Builder handshakeType(String handshakeType);

        /**
         * <p>
         * Filter results by handshake type.
         * </p>
         * 
         * @param handshakeType
         *        Filter results by handshake type.
         * @see HandshakeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HandshakeType
         */
        Builder handshakeType(HandshakeType handshakeType);

        /**
         * <p>
         * The catalog identifier to filter handshakes.
         * </p>
         * 
         * @param catalog
         *        The catalog identifier to filter handshakes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * Filter by participant type (sender or receiver).
         * </p>
         * 
         * @param participantType
         *        Filter by participant type (sender or receiver).
         * @see ParticipantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantType
         */
        Builder participantType(String participantType);

        /**
         * <p>
         * Filter by participant type (sender or receiver).
         * </p>
         * 
         * @param participantType
         *        Filter by participant type (sender or receiver).
         * @see ParticipantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantType
         */
        Builder participantType(ParticipantType participantType);

        /**
         * <p>
         * The maximum number of results to return in a single call.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Filter results by handshake status.
         * </p>
         * 
         * @param statuses
         *        Filter results by handshake status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusesWithStrings(Collection<String> statuses);

        /**
         * <p>
         * Filter results by handshake status.
         * </p>
         * 
         * @param statuses
         *        Filter results by handshake status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusesWithStrings(String... statuses);

        /**
         * <p>
         * Filter results by handshake status.
         * </p>
         * 
         * @param statuses
         *        Filter results by handshake status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(Collection<HandshakeStatus> statuses);

        /**
         * <p>
         * Filter results by handshake status.
         * </p>
         * 
         * @param statuses
         *        Filter results by handshake status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(HandshakeStatus... statuses);

        /**
         * <p>
         * Filter by associated resource identifiers.
         * </p>
         * 
         * @param associatedResourceIdentifiers
         *        Filter by associated resource identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedResourceIdentifiers(Collection<String> associatedResourceIdentifiers);

        /**
         * <p>
         * Filter by associated resource identifiers.
         * </p>
         * 
         * @param associatedResourceIdentifiers
         *        Filter by associated resource identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedResourceIdentifiers(String... associatedResourceIdentifiers);

        /**
         * <p>
         * Type-specific filters for handshakes.
         * </p>
         * 
         * @param handshakeTypeFilters
         *        Type-specific filters for handshakes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder handshakeTypeFilters(ListChannelHandshakesTypeFilters handshakeTypeFilters);

        /**
         * <p>
         * Type-specific filters for handshakes.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListChannelHandshakesTypeFilters.Builder}
         * avoiding the need to create one manually via {@link ListChannelHandshakesTypeFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListChannelHandshakesTypeFilters.Builder#build()} is called
         * immediately and its result is passed to {@link #handshakeTypeFilters(ListChannelHandshakesTypeFilters)}.
         * 
         * @param handshakeTypeFilters
         *        a consumer that will call methods on {@link ListChannelHandshakesTypeFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #handshakeTypeFilters(ListChannelHandshakesTypeFilters)
         */
        default Builder handshakeTypeFilters(Consumer<ListChannelHandshakesTypeFilters.Builder> handshakeTypeFilters) {
            return handshakeTypeFilters(ListChannelHandshakesTypeFilters.builder().applyMutation(handshakeTypeFilters).build());
        }

        /**
         * <p>
         * Type-specific sorting options for handshakes.
         * </p>
         * 
         * @param handshakeTypeSort
         *        Type-specific sorting options for handshakes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder handshakeTypeSort(ListChannelHandshakesTypeSort handshakeTypeSort);

        /**
         * <p>
         * Type-specific sorting options for handshakes.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListChannelHandshakesTypeSort.Builder}
         * avoiding the need to create one manually via {@link ListChannelHandshakesTypeSort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListChannelHandshakesTypeSort.Builder#build()} is called
         * immediately and its result is passed to {@link #handshakeTypeSort(ListChannelHandshakesTypeSort)}.
         * 
         * @param handshakeTypeSort
         *        a consumer that will call methods on {@link ListChannelHandshakesTypeSort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #handshakeTypeSort(ListChannelHandshakesTypeSort)
         */
        default Builder handshakeTypeSort(Consumer<ListChannelHandshakesTypeSort.Builder> handshakeTypeSort) {
            return handshakeTypeSort(ListChannelHandshakesTypeSort.builder().applyMutation(handshakeTypeSort).build());
        }

        /**
         * <p>
         * Token for retrieving the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Token for retrieving the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PartnerCentralChannelRequest.BuilderImpl implements Builder {
        private String handshakeType;

        private String catalog;

        private String participantType;

        private Integer maxResults;

        private List<String> statuses = DefaultSdkAutoConstructList.getInstance();

        private List<String> associatedResourceIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private ListChannelHandshakesTypeFilters handshakeTypeFilters;

        private ListChannelHandshakesTypeSort handshakeTypeSort;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChannelHandshakesRequest model) {
            super(model);
            handshakeType(model.handshakeType);
            catalog(model.catalog);
            participantType(model.participantType);
            maxResults(model.maxResults);
            statusesWithStrings(model.statuses);
            associatedResourceIdentifiers(model.associatedResourceIdentifiers);
            handshakeTypeFilters(model.handshakeTypeFilters);
            handshakeTypeSort(model.handshakeTypeSort);
            nextToken(model.nextToken);
        }

        public final String getHandshakeType() {
            return handshakeType;
        }

        public final void setHandshakeType(String handshakeType) {
            this.handshakeType = handshakeType;
        }

        @Override
        public final Builder handshakeType(String handshakeType) {
            this.handshakeType = handshakeType;
            return this;
        }

        @Override
        public final Builder handshakeType(HandshakeType handshakeType) {
            this.handshakeType(handshakeType == null ? null : handshakeType.toString());
            return this;
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getParticipantType() {
            return participantType;
        }

        public final void setParticipantType(String participantType) {
            this.participantType = participantType;
        }

        @Override
        public final Builder participantType(String participantType) {
            this.participantType = participantType;
            return this;
        }

        @Override
        public final Builder participantType(ParticipantType participantType) {
            this.participantType(participantType == null ? null : participantType.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getStatuses() {
            if (statuses instanceof SdkAutoConstructList) {
                return null;
            }
            return statuses;
        }

        public final void setStatuses(Collection<String> statuses) {
            this.statuses = HandshakeStatusListCopier.copy(statuses);
        }

        @Override
        public final Builder statusesWithStrings(Collection<String> statuses) {
            this.statuses = HandshakeStatusListCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusesWithStrings(String... statuses) {
            statusesWithStrings(Arrays.asList(statuses));
            return this;
        }

        @Override
        public final Builder statuses(Collection<HandshakeStatus> statuses) {
            this.statuses = HandshakeStatusListCopier.copyEnumToString(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(HandshakeStatus... statuses) {
            statuses(Arrays.asList(statuses));
            return this;
        }

        public final Collection<String> getAssociatedResourceIdentifiers() {
            if (associatedResourceIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return associatedResourceIdentifiers;
        }

        public final void setAssociatedResourceIdentifiers(Collection<String> associatedResourceIdentifiers) {
            this.associatedResourceIdentifiers = AssociatedResourceIdentifierListCopier.copy(associatedResourceIdentifiers);
        }

        @Override
        public final Builder associatedResourceIdentifiers(Collection<String> associatedResourceIdentifiers) {
            this.associatedResourceIdentifiers = AssociatedResourceIdentifierListCopier.copy(associatedResourceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedResourceIdentifiers(String... associatedResourceIdentifiers) {
            associatedResourceIdentifiers(Arrays.asList(associatedResourceIdentifiers));
            return this;
        }

        public final ListChannelHandshakesTypeFilters.Builder getHandshakeTypeFilters() {
            return handshakeTypeFilters != null ? handshakeTypeFilters.toBuilder() : null;
        }

        public final void setHandshakeTypeFilters(ListChannelHandshakesTypeFilters.BuilderImpl handshakeTypeFilters) {
            this.handshakeTypeFilters = handshakeTypeFilters != null ? handshakeTypeFilters.build() : null;
        }

        @Override
        public final Builder handshakeTypeFilters(ListChannelHandshakesTypeFilters handshakeTypeFilters) {
            this.handshakeTypeFilters = handshakeTypeFilters;
            return this;
        }

        public final ListChannelHandshakesTypeSort.Builder getHandshakeTypeSort() {
            return handshakeTypeSort != null ? handshakeTypeSort.toBuilder() : null;
        }

        public final void setHandshakeTypeSort(ListChannelHandshakesTypeSort.BuilderImpl handshakeTypeSort) {
            this.handshakeTypeSort = handshakeTypeSort != null ? handshakeTypeSort.build() : null;
        }

        @Override
        public final Builder handshakeTypeSort(ListChannelHandshakesTypeSort handshakeTypeSort) {
            this.handshakeTypeSort = handshakeTypeSort;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListChannelHandshakesRequest build() {
            return new ListChannelHandshakesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
