/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralchannel.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains detailed information about different types of handshakes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HandshakeDetail implements SdkPojo, Serializable, ToCopyableBuilder<HandshakeDetail.Builder, HandshakeDetail> {
    private static final SdkField<StartServicePeriodHandshakeDetail> START_SERVICE_PERIOD_HANDSHAKE_DETAIL_FIELD = SdkField
            .<StartServicePeriodHandshakeDetail> builder(MarshallingType.SDK_POJO)
            .memberName("startServicePeriodHandshakeDetail")
            .getter(getter(HandshakeDetail::startServicePeriodHandshakeDetail))
            .setter(setter(Builder::startServicePeriodHandshakeDetail))
            .constructor(StartServicePeriodHandshakeDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startServicePeriodHandshakeDetail")
                    .build()).build();

    private static final SdkField<RevokeServicePeriodHandshakeDetail> REVOKE_SERVICE_PERIOD_HANDSHAKE_DETAIL_FIELD = SdkField
            .<RevokeServicePeriodHandshakeDetail> builder(MarshallingType.SDK_POJO)
            .memberName("revokeServicePeriodHandshakeDetail")
            .getter(getter(HandshakeDetail::revokeServicePeriodHandshakeDetail))
            .setter(setter(Builder::revokeServicePeriodHandshakeDetail))
            .constructor(RevokeServicePeriodHandshakeDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revokeServicePeriodHandshakeDetail")
                    .build()).build();

    private static final SdkField<ProgramManagementAccountHandshakeDetail> PROGRAM_MANAGEMENT_ACCOUNT_HANDSHAKE_DETAIL_FIELD = SdkField
            .<ProgramManagementAccountHandshakeDetail> builder(MarshallingType.SDK_POJO)
            .memberName("programManagementAccountHandshakeDetail")
            .getter(getter(HandshakeDetail::programManagementAccountHandshakeDetail))
            .setter(setter(Builder::programManagementAccountHandshakeDetail))
            .constructor(ProgramManagementAccountHandshakeDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("programManagementAccountHandshakeDetail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            START_SERVICE_PERIOD_HANDSHAKE_DETAIL_FIELD, REVOKE_SERVICE_PERIOD_HANDSHAKE_DETAIL_FIELD,
            PROGRAM_MANAGEMENT_ACCOUNT_HANDSHAKE_DETAIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final StartServicePeriodHandshakeDetail startServicePeriodHandshakeDetail;

    private final RevokeServicePeriodHandshakeDetail revokeServicePeriodHandshakeDetail;

    private final ProgramManagementAccountHandshakeDetail programManagementAccountHandshakeDetail;

    private final Type type;

    private HandshakeDetail(BuilderImpl builder) {
        this.startServicePeriodHandshakeDetail = builder.startServicePeriodHandshakeDetail;
        this.revokeServicePeriodHandshakeDetail = builder.revokeServicePeriodHandshakeDetail;
        this.programManagementAccountHandshakeDetail = builder.programManagementAccountHandshakeDetail;
        this.type = builder.type;
    }

    /**
     * <p>
     * Details for a start service period handshake.
     * </p>
     * 
     * @return Details for a start service period handshake.
     */
    public final StartServicePeriodHandshakeDetail startServicePeriodHandshakeDetail() {
        return startServicePeriodHandshakeDetail;
    }

    /**
     * <p>
     * Details for a revoke service period handshake.
     * </p>
     * 
     * @return Details for a revoke service period handshake.
     */
    public final RevokeServicePeriodHandshakeDetail revokeServicePeriodHandshakeDetail() {
        return revokeServicePeriodHandshakeDetail;
    }

    /**
     * <p>
     * Details for a program management account handshake.
     * </p>
     * 
     * @return Details for a program management account handshake.
     */
    public final ProgramManagementAccountHandshakeDetail programManagementAccountHandshakeDetail() {
        return programManagementAccountHandshakeDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startServicePeriodHandshakeDetail());
        hashCode = 31 * hashCode + Objects.hashCode(revokeServicePeriodHandshakeDetail());
        hashCode = 31 * hashCode + Objects.hashCode(programManagementAccountHandshakeDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HandshakeDetail)) {
            return false;
        }
        HandshakeDetail other = (HandshakeDetail) obj;
        return Objects.equals(startServicePeriodHandshakeDetail(), other.startServicePeriodHandshakeDetail())
                && Objects.equals(revokeServicePeriodHandshakeDetail(), other.revokeServicePeriodHandshakeDetail())
                && Objects.equals(programManagementAccountHandshakeDetail(), other.programManagementAccountHandshakeDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HandshakeDetail").add("StartServicePeriodHandshakeDetail", startServicePeriodHandshakeDetail())
                .add("RevokeServicePeriodHandshakeDetail", revokeServicePeriodHandshakeDetail())
                .add("ProgramManagementAccountHandshakeDetail", programManagementAccountHandshakeDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "startServicePeriodHandshakeDetail":
            return Optional.ofNullable(clazz.cast(startServicePeriodHandshakeDetail()));
        case "revokeServicePeriodHandshakeDetail":
            return Optional.ofNullable(clazz.cast(revokeServicePeriodHandshakeDetail()));
        case "programManagementAccountHandshakeDetail":
            return Optional.ofNullable(clazz.cast(programManagementAccountHandshakeDetail()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #startServicePeriodHandshakeDetail()} initialized to the given
     * value.
     *
     * <p>
     * Details for a start service period handshake.
     * </p>
     * 
     * @param startServicePeriodHandshakeDetail
     *        Details for a start service period handshake.
     */
    public static HandshakeDetail fromStartServicePeriodHandshakeDetail(
            StartServicePeriodHandshakeDetail startServicePeriodHandshakeDetail) {
        return builder().startServicePeriodHandshakeDetail(startServicePeriodHandshakeDetail).build();
    }

    /**
     * Create an instance of this class with {@link #startServicePeriodHandshakeDetail()} initialized to the given
     * value.
     *
     * <p>
     * Details for a start service period handshake.
     * </p>
     * 
     * @param startServicePeriodHandshakeDetail
     *        Details for a start service period handshake.
     */
    public static HandshakeDetail fromStartServicePeriodHandshakeDetail(
            Consumer<StartServicePeriodHandshakeDetail.Builder> startServicePeriodHandshakeDetail) {
        StartServicePeriodHandshakeDetail.Builder builder = StartServicePeriodHandshakeDetail.builder();
        startServicePeriodHandshakeDetail.accept(builder);
        return fromStartServicePeriodHandshakeDetail(builder.build());
    }

    /**
     * Create an instance of this class with {@link #revokeServicePeriodHandshakeDetail()} initialized to the given
     * value.
     *
     * <p>
     * Details for a revoke service period handshake.
     * </p>
     * 
     * @param revokeServicePeriodHandshakeDetail
     *        Details for a revoke service period handshake.
     */
    public static HandshakeDetail fromRevokeServicePeriodHandshakeDetail(
            RevokeServicePeriodHandshakeDetail revokeServicePeriodHandshakeDetail) {
        return builder().revokeServicePeriodHandshakeDetail(revokeServicePeriodHandshakeDetail).build();
    }

    /**
     * Create an instance of this class with {@link #revokeServicePeriodHandshakeDetail()} initialized to the given
     * value.
     *
     * <p>
     * Details for a revoke service period handshake.
     * </p>
     * 
     * @param revokeServicePeriodHandshakeDetail
     *        Details for a revoke service period handshake.
     */
    public static HandshakeDetail fromRevokeServicePeriodHandshakeDetail(
            Consumer<RevokeServicePeriodHandshakeDetail.Builder> revokeServicePeriodHandshakeDetail) {
        RevokeServicePeriodHandshakeDetail.Builder builder = RevokeServicePeriodHandshakeDetail.builder();
        revokeServicePeriodHandshakeDetail.accept(builder);
        return fromRevokeServicePeriodHandshakeDetail(builder.build());
    }

    /**
     * Create an instance of this class with {@link #programManagementAccountHandshakeDetail()} initialized to the given
     * value.
     *
     * <p>
     * Details for a program management account handshake.
     * </p>
     * 
     * @param programManagementAccountHandshakeDetail
     *        Details for a program management account handshake.
     */
    public static HandshakeDetail fromProgramManagementAccountHandshakeDetail(
            ProgramManagementAccountHandshakeDetail programManagementAccountHandshakeDetail) {
        return builder().programManagementAccountHandshakeDetail(programManagementAccountHandshakeDetail).build();
    }

    /**
     * Create an instance of this class with {@link #programManagementAccountHandshakeDetail()} initialized to the given
     * value.
     *
     * <p>
     * Details for a program management account handshake.
     * </p>
     * 
     * @param programManagementAccountHandshakeDetail
     *        Details for a program management account handshake.
     */
    public static HandshakeDetail fromProgramManagementAccountHandshakeDetail(
            Consumer<ProgramManagementAccountHandshakeDetail.Builder> programManagementAccountHandshakeDetail) {
        ProgramManagementAccountHandshakeDetail.Builder builder = ProgramManagementAccountHandshakeDetail.builder();
        programManagementAccountHandshakeDetail.accept(builder);
        return fromProgramManagementAccountHandshakeDetail(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("startServicePeriodHandshakeDetail", START_SERVICE_PERIOD_HANDSHAKE_DETAIL_FIELD);
        map.put("revokeServicePeriodHandshakeDetail", REVOKE_SERVICE_PERIOD_HANDSHAKE_DETAIL_FIELD);
        map.put("programManagementAccountHandshakeDetail", PROGRAM_MANAGEMENT_ACCOUNT_HANDSHAKE_DETAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HandshakeDetail, T> g) {
        return obj -> g.apply((HandshakeDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HandshakeDetail> {
        /**
         * <p>
         * Details for a start service period handshake.
         * </p>
         * 
         * @param startServicePeriodHandshakeDetail
         *        Details for a start service period handshake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startServicePeriodHandshakeDetail(StartServicePeriodHandshakeDetail startServicePeriodHandshakeDetail);

        /**
         * <p>
         * Details for a start service period handshake.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link StartServicePeriodHandshakeDetail.Builder} avoiding the need to create one manually via
         * {@link StartServicePeriodHandshakeDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StartServicePeriodHandshakeDetail.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #startServicePeriodHandshakeDetail(StartServicePeriodHandshakeDetail)}.
         * 
         * @param startServicePeriodHandshakeDetail
         *        a consumer that will call methods on {@link StartServicePeriodHandshakeDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startServicePeriodHandshakeDetail(StartServicePeriodHandshakeDetail)
         */
        default Builder startServicePeriodHandshakeDetail(
                Consumer<StartServicePeriodHandshakeDetail.Builder> startServicePeriodHandshakeDetail) {
            return startServicePeriodHandshakeDetail(StartServicePeriodHandshakeDetail.builder()
                    .applyMutation(startServicePeriodHandshakeDetail).build());
        }

        /**
         * <p>
         * Details for a revoke service period handshake.
         * </p>
         * 
         * @param revokeServicePeriodHandshakeDetail
         *        Details for a revoke service period handshake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revokeServicePeriodHandshakeDetail(RevokeServicePeriodHandshakeDetail revokeServicePeriodHandshakeDetail);

        /**
         * <p>
         * Details for a revoke service period handshake.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RevokeServicePeriodHandshakeDetail.Builder} avoiding the need to create one manually via
         * {@link RevokeServicePeriodHandshakeDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RevokeServicePeriodHandshakeDetail.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #revokeServicePeriodHandshakeDetail(RevokeServicePeriodHandshakeDetail)}.
         * 
         * @param revokeServicePeriodHandshakeDetail
         *        a consumer that will call methods on {@link RevokeServicePeriodHandshakeDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revokeServicePeriodHandshakeDetail(RevokeServicePeriodHandshakeDetail)
         */
        default Builder revokeServicePeriodHandshakeDetail(
                Consumer<RevokeServicePeriodHandshakeDetail.Builder> revokeServicePeriodHandshakeDetail) {
            return revokeServicePeriodHandshakeDetail(RevokeServicePeriodHandshakeDetail.builder()
                    .applyMutation(revokeServicePeriodHandshakeDetail).build());
        }

        /**
         * <p>
         * Details for a program management account handshake.
         * </p>
         * 
         * @param programManagementAccountHandshakeDetail
         *        Details for a program management account handshake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programManagementAccountHandshakeDetail(
                ProgramManagementAccountHandshakeDetail programManagementAccountHandshakeDetail);

        /**
         * <p>
         * Details for a program management account handshake.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ProgramManagementAccountHandshakeDetail.Builder} avoiding the need to create one manually via
         * {@link ProgramManagementAccountHandshakeDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProgramManagementAccountHandshakeDetail.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #programManagementAccountHandshakeDetail(ProgramManagementAccountHandshakeDetail)}.
         * 
         * @param programManagementAccountHandshakeDetail
         *        a consumer that will call methods on {@link ProgramManagementAccountHandshakeDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #programManagementAccountHandshakeDetail(ProgramManagementAccountHandshakeDetail)
         */
        default Builder programManagementAccountHandshakeDetail(
                Consumer<ProgramManagementAccountHandshakeDetail.Builder> programManagementAccountHandshakeDetail) {
            return programManagementAccountHandshakeDetail(ProgramManagementAccountHandshakeDetail.builder()
                    .applyMutation(programManagementAccountHandshakeDetail).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private StartServicePeriodHandshakeDetail startServicePeriodHandshakeDetail;

        private RevokeServicePeriodHandshakeDetail revokeServicePeriodHandshakeDetail;

        private ProgramManagementAccountHandshakeDetail programManagementAccountHandshakeDetail;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(HandshakeDetail model) {
            startServicePeriodHandshakeDetail(model.startServicePeriodHandshakeDetail);
            revokeServicePeriodHandshakeDetail(model.revokeServicePeriodHandshakeDetail);
            programManagementAccountHandshakeDetail(model.programManagementAccountHandshakeDetail);
        }

        public final StartServicePeriodHandshakeDetail.Builder getStartServicePeriodHandshakeDetail() {
            return startServicePeriodHandshakeDetail != null ? startServicePeriodHandshakeDetail.toBuilder() : null;
        }

        public final void setStartServicePeriodHandshakeDetail(
                StartServicePeriodHandshakeDetail.BuilderImpl startServicePeriodHandshakeDetail) {
            Object oldValue = this.startServicePeriodHandshakeDetail;
            this.startServicePeriodHandshakeDetail = startServicePeriodHandshakeDetail != null ? startServicePeriodHandshakeDetail
                    .build() : null;
            handleUnionValueChange(Type.START_SERVICE_PERIOD_HANDSHAKE_DETAIL, oldValue, this.startServicePeriodHandshakeDetail);
        }

        @Override
        public final Builder startServicePeriodHandshakeDetail(StartServicePeriodHandshakeDetail startServicePeriodHandshakeDetail) {
            Object oldValue = this.startServicePeriodHandshakeDetail;
            this.startServicePeriodHandshakeDetail = startServicePeriodHandshakeDetail;
            handleUnionValueChange(Type.START_SERVICE_PERIOD_HANDSHAKE_DETAIL, oldValue, this.startServicePeriodHandshakeDetail);
            return this;
        }

        public final RevokeServicePeriodHandshakeDetail.Builder getRevokeServicePeriodHandshakeDetail() {
            return revokeServicePeriodHandshakeDetail != null ? revokeServicePeriodHandshakeDetail.toBuilder() : null;
        }

        public final void setRevokeServicePeriodHandshakeDetail(
                RevokeServicePeriodHandshakeDetail.BuilderImpl revokeServicePeriodHandshakeDetail) {
            Object oldValue = this.revokeServicePeriodHandshakeDetail;
            this.revokeServicePeriodHandshakeDetail = revokeServicePeriodHandshakeDetail != null ? revokeServicePeriodHandshakeDetail
                    .build() : null;
            handleUnionValueChange(Type.REVOKE_SERVICE_PERIOD_HANDSHAKE_DETAIL, oldValue, this.revokeServicePeriodHandshakeDetail);
        }

        @Override
        public final Builder revokeServicePeriodHandshakeDetail(
                RevokeServicePeriodHandshakeDetail revokeServicePeriodHandshakeDetail) {
            Object oldValue = this.revokeServicePeriodHandshakeDetail;
            this.revokeServicePeriodHandshakeDetail = revokeServicePeriodHandshakeDetail;
            handleUnionValueChange(Type.REVOKE_SERVICE_PERIOD_HANDSHAKE_DETAIL, oldValue, this.revokeServicePeriodHandshakeDetail);
            return this;
        }

        public final ProgramManagementAccountHandshakeDetail.Builder getProgramManagementAccountHandshakeDetail() {
            return programManagementAccountHandshakeDetail != null ? programManagementAccountHandshakeDetail.toBuilder() : null;
        }

        public final void setProgramManagementAccountHandshakeDetail(
                ProgramManagementAccountHandshakeDetail.BuilderImpl programManagementAccountHandshakeDetail) {
            Object oldValue = this.programManagementAccountHandshakeDetail;
            this.programManagementAccountHandshakeDetail = programManagementAccountHandshakeDetail != null ? programManagementAccountHandshakeDetail
                    .build() : null;
            handleUnionValueChange(Type.PROGRAM_MANAGEMENT_ACCOUNT_HANDSHAKE_DETAIL, oldValue,
                    this.programManagementAccountHandshakeDetail);
        }

        @Override
        public final Builder programManagementAccountHandshakeDetail(
                ProgramManagementAccountHandshakeDetail programManagementAccountHandshakeDetail) {
            Object oldValue = this.programManagementAccountHandshakeDetail;
            this.programManagementAccountHandshakeDetail = programManagementAccountHandshakeDetail;
            handleUnionValueChange(Type.PROGRAM_MANAGEMENT_ACCOUNT_HANDSHAKE_DETAIL, oldValue,
                    this.programManagementAccountHandshakeDetail);
            return this;
        }

        @Override
        public HandshakeDetail build() {
            return new HandshakeDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see HandshakeDetail#type()
     */
    public enum Type {
        START_SERVICE_PERIOD_HANDSHAKE_DETAIL,

        REVOKE_SERVICE_PERIOD_HANDSHAKE_DETAIL,

        PROGRAM_MANAGEMENT_ACCOUNT_HANDSHAKE_DETAIL,

        UNKNOWN_TO_SDK_VERSION
    }
}
