/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralchannel.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the payload data for different types of channel handshakes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChannelHandshakePayload implements SdkPojo, Serializable,
        ToCopyableBuilder<ChannelHandshakePayload.Builder, ChannelHandshakePayload> {
    private static final SdkField<StartServicePeriodPayload> START_SERVICE_PERIOD_PAYLOAD_FIELD = SdkField
            .<StartServicePeriodPayload> builder(MarshallingType.SDK_POJO).memberName("startServicePeriodPayload")
            .getter(getter(ChannelHandshakePayload::startServicePeriodPayload))
            .setter(setter(Builder::startServicePeriodPayload)).constructor(StartServicePeriodPayload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startServicePeriodPayload").build())
            .build();

    private static final SdkField<RevokeServicePeriodPayload> REVOKE_SERVICE_PERIOD_PAYLOAD_FIELD = SdkField
            .<RevokeServicePeriodPayload> builder(MarshallingType.SDK_POJO)
            .memberName("revokeServicePeriodPayload")
            .getter(getter(ChannelHandshakePayload::revokeServicePeriodPayload))
            .setter(setter(Builder::revokeServicePeriodPayload))
            .constructor(RevokeServicePeriodPayload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revokeServicePeriodPayload").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            START_SERVICE_PERIOD_PAYLOAD_FIELD, REVOKE_SERVICE_PERIOD_PAYLOAD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final StartServicePeriodPayload startServicePeriodPayload;

    private final RevokeServicePeriodPayload revokeServicePeriodPayload;

    private final Type type;

    private ChannelHandshakePayload(BuilderImpl builder) {
        this.startServicePeriodPayload = builder.startServicePeriodPayload;
        this.revokeServicePeriodPayload = builder.revokeServicePeriodPayload;
        this.type = builder.type;
    }

    /**
     * <p>
     * Payload for starting a service period handshake.
     * </p>
     * 
     * @return Payload for starting a service period handshake.
     */
    public final StartServicePeriodPayload startServicePeriodPayload() {
        return startServicePeriodPayload;
    }

    /**
     * <p>
     * Payload for revoking a service period handshake.
     * </p>
     * 
     * @return Payload for revoking a service period handshake.
     */
    public final RevokeServicePeriodPayload revokeServicePeriodPayload() {
        return revokeServicePeriodPayload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startServicePeriodPayload());
        hashCode = 31 * hashCode + Objects.hashCode(revokeServicePeriodPayload());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelHandshakePayload)) {
            return false;
        }
        ChannelHandshakePayload other = (ChannelHandshakePayload) obj;
        return Objects.equals(startServicePeriodPayload(), other.startServicePeriodPayload())
                && Objects.equals(revokeServicePeriodPayload(), other.revokeServicePeriodPayload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChannelHandshakePayload").add("StartServicePeriodPayload", startServicePeriodPayload())
                .add("RevokeServicePeriodPayload", revokeServicePeriodPayload()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "startServicePeriodPayload":
            return Optional.ofNullable(clazz.cast(startServicePeriodPayload()));
        case "revokeServicePeriodPayload":
            return Optional.ofNullable(clazz.cast(revokeServicePeriodPayload()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #startServicePeriodPayload()} initialized to the given value.
     *
     * <p>
     * Payload for starting a service period handshake.
     * </p>
     * 
     * @param startServicePeriodPayload
     *        Payload for starting a service period handshake.
     */
    public static ChannelHandshakePayload fromStartServicePeriodPayload(StartServicePeriodPayload startServicePeriodPayload) {
        return builder().startServicePeriodPayload(startServicePeriodPayload).build();
    }

    /**
     * Create an instance of this class with {@link #startServicePeriodPayload()} initialized to the given value.
     *
     * <p>
     * Payload for starting a service period handshake.
     * </p>
     * 
     * @param startServicePeriodPayload
     *        Payload for starting a service period handshake.
     */
    public static ChannelHandshakePayload fromStartServicePeriodPayload(
            Consumer<StartServicePeriodPayload.Builder> startServicePeriodPayload) {
        StartServicePeriodPayload.Builder builder = StartServicePeriodPayload.builder();
        startServicePeriodPayload.accept(builder);
        return fromStartServicePeriodPayload(builder.build());
    }

    /**
     * Create an instance of this class with {@link #revokeServicePeriodPayload()} initialized to the given value.
     *
     * <p>
     * Payload for revoking a service period handshake.
     * </p>
     * 
     * @param revokeServicePeriodPayload
     *        Payload for revoking a service period handshake.
     */
    public static ChannelHandshakePayload fromRevokeServicePeriodPayload(RevokeServicePeriodPayload revokeServicePeriodPayload) {
        return builder().revokeServicePeriodPayload(revokeServicePeriodPayload).build();
    }

    /**
     * Create an instance of this class with {@link #revokeServicePeriodPayload()} initialized to the given value.
     *
     * <p>
     * Payload for revoking a service period handshake.
     * </p>
     * 
     * @param revokeServicePeriodPayload
     *        Payload for revoking a service period handshake.
     */
    public static ChannelHandshakePayload fromRevokeServicePeriodPayload(
            Consumer<RevokeServicePeriodPayload.Builder> revokeServicePeriodPayload) {
        RevokeServicePeriodPayload.Builder builder = RevokeServicePeriodPayload.builder();
        revokeServicePeriodPayload.accept(builder);
        return fromRevokeServicePeriodPayload(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("startServicePeriodPayload", START_SERVICE_PERIOD_PAYLOAD_FIELD);
        map.put("revokeServicePeriodPayload", REVOKE_SERVICE_PERIOD_PAYLOAD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChannelHandshakePayload, T> g) {
        return obj -> g.apply((ChannelHandshakePayload) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChannelHandshakePayload> {
        /**
         * <p>
         * Payload for starting a service period handshake.
         * </p>
         * 
         * @param startServicePeriodPayload
         *        Payload for starting a service period handshake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startServicePeriodPayload(StartServicePeriodPayload startServicePeriodPayload);

        /**
         * <p>
         * Payload for starting a service period handshake.
         * </p>
         * This is a convenience method that creates an instance of the {@link StartServicePeriodPayload.Builder}
         * avoiding the need to create one manually via {@link StartServicePeriodPayload#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StartServicePeriodPayload.Builder#build()} is called immediately
         * and its result is passed to {@link #startServicePeriodPayload(StartServicePeriodPayload)}.
         * 
         * @param startServicePeriodPayload
         *        a consumer that will call methods on {@link StartServicePeriodPayload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startServicePeriodPayload(StartServicePeriodPayload)
         */
        default Builder startServicePeriodPayload(Consumer<StartServicePeriodPayload.Builder> startServicePeriodPayload) {
            return startServicePeriodPayload(StartServicePeriodPayload.builder().applyMutation(startServicePeriodPayload).build());
        }

        /**
         * <p>
         * Payload for revoking a service period handshake.
         * </p>
         * 
         * @param revokeServicePeriodPayload
         *        Payload for revoking a service period handshake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revokeServicePeriodPayload(RevokeServicePeriodPayload revokeServicePeriodPayload);

        /**
         * <p>
         * Payload for revoking a service period handshake.
         * </p>
         * This is a convenience method that creates an instance of the {@link RevokeServicePeriodPayload.Builder}
         * avoiding the need to create one manually via {@link RevokeServicePeriodPayload#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RevokeServicePeriodPayload.Builder#build()} is called immediately
         * and its result is passed to {@link #revokeServicePeriodPayload(RevokeServicePeriodPayload)}.
         * 
         * @param revokeServicePeriodPayload
         *        a consumer that will call methods on {@link RevokeServicePeriodPayload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revokeServicePeriodPayload(RevokeServicePeriodPayload)
         */
        default Builder revokeServicePeriodPayload(Consumer<RevokeServicePeriodPayload.Builder> revokeServicePeriodPayload) {
            return revokeServicePeriodPayload(RevokeServicePeriodPayload.builder().applyMutation(revokeServicePeriodPayload)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private StartServicePeriodPayload startServicePeriodPayload;

        private RevokeServicePeriodPayload revokeServicePeriodPayload;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelHandshakePayload model) {
            startServicePeriodPayload(model.startServicePeriodPayload);
            revokeServicePeriodPayload(model.revokeServicePeriodPayload);
        }

        public final StartServicePeriodPayload.Builder getStartServicePeriodPayload() {
            return startServicePeriodPayload != null ? startServicePeriodPayload.toBuilder() : null;
        }

        public final void setStartServicePeriodPayload(StartServicePeriodPayload.BuilderImpl startServicePeriodPayload) {
            Object oldValue = this.startServicePeriodPayload;
            this.startServicePeriodPayload = startServicePeriodPayload != null ? startServicePeriodPayload.build() : null;
            handleUnionValueChange(Type.START_SERVICE_PERIOD_PAYLOAD, oldValue, this.startServicePeriodPayload);
        }

        @Override
        public final Builder startServicePeriodPayload(StartServicePeriodPayload startServicePeriodPayload) {
            Object oldValue = this.startServicePeriodPayload;
            this.startServicePeriodPayload = startServicePeriodPayload;
            handleUnionValueChange(Type.START_SERVICE_PERIOD_PAYLOAD, oldValue, this.startServicePeriodPayload);
            return this;
        }

        public final RevokeServicePeriodPayload.Builder getRevokeServicePeriodPayload() {
            return revokeServicePeriodPayload != null ? revokeServicePeriodPayload.toBuilder() : null;
        }

        public final void setRevokeServicePeriodPayload(RevokeServicePeriodPayload.BuilderImpl revokeServicePeriodPayload) {
            Object oldValue = this.revokeServicePeriodPayload;
            this.revokeServicePeriodPayload = revokeServicePeriodPayload != null ? revokeServicePeriodPayload.build() : null;
            handleUnionValueChange(Type.REVOKE_SERVICE_PERIOD_PAYLOAD, oldValue, this.revokeServicePeriodPayload);
        }

        @Override
        public final Builder revokeServicePeriodPayload(RevokeServicePeriodPayload revokeServicePeriodPayload) {
            Object oldValue = this.revokeServicePeriodPayload;
            this.revokeServicePeriodPayload = revokeServicePeriodPayload;
            handleUnionValueChange(Type.REVOKE_SERVICE_PERIOD_PAYLOAD, oldValue, this.revokeServicePeriodPayload);
            return this;
        }

        @Override
        public ChannelHandshakePayload build() {
            return new ChannelHandshakePayload(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ChannelHandshakePayload#type()
     */
    public enum Type {
        START_SERVICE_PERIOD_PAYLOAD,

        REVOKE_SERVICE_PERIOD_PAYLOAD,

        UNKNOWN_TO_SDK_VERSION
    }
}
