/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralchannel.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralchannel.PartnerCentralChannelClient;
import software.amazon.awssdk.services.partnercentralchannel.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralchannel.model.ListProgramManagementAccountsRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.ListProgramManagementAccountsResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.ProgramManagementAccountSummary;

public class ListProgramManagementAccountsIterable
implements SdkIterable<ListProgramManagementAccountsResponse> {
    private final PartnerCentralChannelClient client;
    private final ListProgramManagementAccountsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProgramManagementAccountsIterable(PartnerCentralChannelClient client, ListProgramManagementAccountsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListProgramManagementAccountsResponseFetcher();
    }

    public Iterator<ListProgramManagementAccountsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProgramManagementAccountSummary> items() {
        Function<ListProgramManagementAccountsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListProgramManagementAccountsResponseFetcher
    implements SyncPageFetcher<ListProgramManagementAccountsResponse> {
        private ListProgramManagementAccountsResponseFetcher() {
        }

        public boolean hasNextPage(ListProgramManagementAccountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProgramManagementAccountsResponse nextPage(ListProgramManagementAccountsResponse previousPage) {
            if (previousPage == null) {
                return ListProgramManagementAccountsIterable.this.client.listProgramManagementAccounts(ListProgramManagementAccountsIterable.this.firstRequest);
            }
            return ListProgramManagementAccountsIterable.this.client.listProgramManagementAccounts((ListProgramManagementAccountsRequest)((Object)ListProgramManagementAccountsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

