/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralchannel.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralchannel.model.Coverage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResoldEnterprise
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResoldEnterprise> {
    private static final SdkField<String> COVERAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("coverage").getter(ResoldEnterprise.getter(ResoldEnterprise::coverageAsString)).setter(ResoldEnterprise.setter(Builder::coverage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("coverage").build()}).build();
    private static final SdkField<String> TAM_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tamLocation").getter(ResoldEnterprise.getter(ResoldEnterprise::tamLocation)).setter(ResoldEnterprise.setter(Builder::tamLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tamLocation").build()}).build();
    private static final SdkField<String> CHARGE_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("chargeAccountId").getter(ResoldEnterprise.getter(ResoldEnterprise::chargeAccountId)).setter(ResoldEnterprise.setter(Builder::chargeAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chargeAccountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COVERAGE_FIELD, TAM_LOCATION_FIELD, CHARGE_ACCOUNT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResoldEnterprise.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String coverage;
    private final String tamLocation;
    private final String chargeAccountId;

    private ResoldEnterprise(BuilderImpl builder) {
        this.coverage = builder.coverage;
        this.tamLocation = builder.tamLocation;
        this.chargeAccountId = builder.chargeAccountId;
    }

    public final Coverage coverage() {
        return Coverage.fromValue(this.coverage);
    }

    public final String coverageAsString() {
        return this.coverage;
    }

    public final String tamLocation() {
        return this.tamLocation;
    }

    public final String chargeAccountId() {
        return this.chargeAccountId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.coverageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tamLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.chargeAccountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResoldEnterprise)) {
            return false;
        }
        ResoldEnterprise other = (ResoldEnterprise)obj;
        return Objects.equals(this.coverageAsString(), other.coverageAsString()) && Objects.equals(this.tamLocation(), other.tamLocation()) && Objects.equals(this.chargeAccountId(), other.chargeAccountId());
    }

    public final String toString() {
        return ToString.builder((String)"ResoldEnterprise").add("Coverage", (Object)this.coverageAsString()).add("TamLocation", (Object)this.tamLocation()).add("ChargeAccountId", (Object)this.chargeAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "coverage": {
                return Optional.ofNullable(clazz.cast(this.coverageAsString()));
            }
            case "tamLocation": {
                return Optional.ofNullable(clazz.cast(this.tamLocation()));
            }
            case "chargeAccountId": {
                return Optional.ofNullable(clazz.cast(this.chargeAccountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("coverage", COVERAGE_FIELD);
        map.put("tamLocation", TAM_LOCATION_FIELD);
        map.put("chargeAccountId", CHARGE_ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResoldEnterprise, T> g) {
        return obj -> g.apply((ResoldEnterprise)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String coverage;
        private String tamLocation;
        private String chargeAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResoldEnterprise model) {
            this.coverage(model.coverage);
            this.tamLocation(model.tamLocation);
            this.chargeAccountId(model.chargeAccountId);
        }

        public final String getCoverage() {
            return this.coverage;
        }

        public final void setCoverage(String coverage) {
            this.coverage = coverage;
        }

        @Override
        public final Builder coverage(String coverage) {
            this.coverage = coverage;
            return this;
        }

        @Override
        public final Builder coverage(Coverage coverage) {
            this.coverage(coverage == null ? null : coverage.toString());
            return this;
        }

        public final String getTamLocation() {
            return this.tamLocation;
        }

        public final void setTamLocation(String tamLocation) {
            this.tamLocation = tamLocation;
        }

        @Override
        public final Builder tamLocation(String tamLocation) {
            this.tamLocation = tamLocation;
            return this;
        }

        public final String getChargeAccountId() {
            return this.chargeAccountId;
        }

        public final void setChargeAccountId(String chargeAccountId) {
            this.chargeAccountId = chargeAccountId;
        }

        @Override
        public final Builder chargeAccountId(String chargeAccountId) {
            this.chargeAccountId = chargeAccountId;
            return this;
        }

        public ResoldEnterprise build() {
            return new ResoldEnterprise(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResoldEnterprise> {
        public Builder coverage(String var1);

        public Builder coverage(Coverage var1);

        public Builder tamLocation(String var1);

        public Builder chargeAccountId(String var1);
    }
}

