/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralchannel.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralchannel.model.AssociatedResourceIdentifierListCopier;
import software.amazon.awssdk.services.partnercentralchannel.model.HandshakeStatus;
import software.amazon.awssdk.services.partnercentralchannel.model.HandshakeStatusListCopier;
import software.amazon.awssdk.services.partnercentralchannel.model.HandshakeType;
import software.amazon.awssdk.services.partnercentralchannel.model.ListChannelHandshakesTypeFilters;
import software.amazon.awssdk.services.partnercentralchannel.model.ListChannelHandshakesTypeSort;
import software.amazon.awssdk.services.partnercentralchannel.model.ParticipantType;
import software.amazon.awssdk.services.partnercentralchannel.model.PartnerCentralChannelRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListChannelHandshakesRequest
extends PartnerCentralChannelRequest
implements ToCopyableBuilder<Builder, ListChannelHandshakesRequest> {
    private static final SdkField<String> HANDSHAKE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("handshakeType").getter(ListChannelHandshakesRequest.getter(ListChannelHandshakesRequest::handshakeTypeAsString)).setter(ListChannelHandshakesRequest.setter(Builder::handshakeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("handshakeType").build()}).build();
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("catalog").getter(ListChannelHandshakesRequest.getter(ListChannelHandshakesRequest::catalog)).setter(ListChannelHandshakesRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalog").build()}).build();
    private static final SdkField<String> PARTICIPANT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("participantType").getter(ListChannelHandshakesRequest.getter(ListChannelHandshakesRequest::participantTypeAsString)).setter(ListChannelHandshakesRequest.setter(Builder::participantType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participantType").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListChannelHandshakesRequest.getter(ListChannelHandshakesRequest::maxResults)).setter(ListChannelHandshakesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<List<String>> STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("statuses").getter(ListChannelHandshakesRequest.getter(ListChannelHandshakesRequest::statusesAsStrings)).setter(ListChannelHandshakesRequest.setter(Builder::statusesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ASSOCIATED_RESOURCE_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("associatedResourceIdentifiers").getter(ListChannelHandshakesRequest.getter(ListChannelHandshakesRequest::associatedResourceIdentifiers)).setter(ListChannelHandshakesRequest.setter(Builder::associatedResourceIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedResourceIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ListChannelHandshakesTypeFilters> HANDSHAKE_TYPE_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("handshakeTypeFilters").getter(ListChannelHandshakesRequest.getter(ListChannelHandshakesRequest::handshakeTypeFilters)).setter(ListChannelHandshakesRequest.setter(Builder::handshakeTypeFilters)).constructor(ListChannelHandshakesTypeFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("handshakeTypeFilters").build()}).build();
    private static final SdkField<ListChannelHandshakesTypeSort> HANDSHAKE_TYPE_SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("handshakeTypeSort").getter(ListChannelHandshakesRequest.getter(ListChannelHandshakesRequest::handshakeTypeSort)).setter(ListChannelHandshakesRequest.setter(Builder::handshakeTypeSort)).constructor(ListChannelHandshakesTypeSort::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("handshakeTypeSort").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListChannelHandshakesRequest.getter(ListChannelHandshakesRequest::nextToken)).setter(ListChannelHandshakesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HANDSHAKE_TYPE_FIELD, CATALOG_FIELD, PARTICIPANT_TYPE_FIELD, MAX_RESULTS_FIELD, STATUSES_FIELD, ASSOCIATED_RESOURCE_IDENTIFIERS_FIELD, HANDSHAKE_TYPE_FILTERS_FIELD, HANDSHAKE_TYPE_SORT_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListChannelHandshakesRequest.memberNameToFieldInitializer();
    private final String handshakeType;
    private final String catalog;
    private final String participantType;
    private final Integer maxResults;
    private final List<String> statuses;
    private final List<String> associatedResourceIdentifiers;
    private final ListChannelHandshakesTypeFilters handshakeTypeFilters;
    private final ListChannelHandshakesTypeSort handshakeTypeSort;
    private final String nextToken;

    private ListChannelHandshakesRequest(BuilderImpl builder) {
        super(builder);
        this.handshakeType = builder.handshakeType;
        this.catalog = builder.catalog;
        this.participantType = builder.participantType;
        this.maxResults = builder.maxResults;
        this.statuses = builder.statuses;
        this.associatedResourceIdentifiers = builder.associatedResourceIdentifiers;
        this.handshakeTypeFilters = builder.handshakeTypeFilters;
        this.handshakeTypeSort = builder.handshakeTypeSort;
        this.nextToken = builder.nextToken;
    }

    public final HandshakeType handshakeType() {
        return HandshakeType.fromValue(this.handshakeType);
    }

    public final String handshakeTypeAsString() {
        return this.handshakeType;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final ParticipantType participantType() {
        return ParticipantType.fromValue(this.participantType);
    }

    public final String participantTypeAsString() {
        return this.participantType;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final List<HandshakeStatus> statuses() {
        return HandshakeStatusListCopier.copyStringToEnum(this.statuses);
    }

    public final boolean hasStatuses() {
        return this.statuses != null && !(this.statuses instanceof SdkAutoConstructList);
    }

    public final List<String> statusesAsStrings() {
        return this.statuses;
    }

    public final boolean hasAssociatedResourceIdentifiers() {
        return this.associatedResourceIdentifiers != null && !(this.associatedResourceIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> associatedResourceIdentifiers() {
        return this.associatedResourceIdentifiers;
    }

    public final ListChannelHandshakesTypeFilters handshakeTypeFilters() {
        return this.handshakeTypeFilters;
    }

    public final ListChannelHandshakesTypeSort handshakeTypeSort() {
        return this.handshakeTypeSort;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.handshakeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatuses() ? this.statusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedResourceIdentifiers() ? this.associatedResourceIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.handshakeTypeFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.handshakeTypeSort());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChannelHandshakesRequest)) {
            return false;
        }
        ListChannelHandshakesRequest other = (ListChannelHandshakesRequest)((Object)obj);
        return Objects.equals(this.handshakeTypeAsString(), other.handshakeTypeAsString()) && Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.participantTypeAsString(), other.participantTypeAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasStatuses() == other.hasStatuses() && Objects.equals(this.statusesAsStrings(), other.statusesAsStrings()) && this.hasAssociatedResourceIdentifiers() == other.hasAssociatedResourceIdentifiers() && Objects.equals(this.associatedResourceIdentifiers(), other.associatedResourceIdentifiers()) && Objects.equals(this.handshakeTypeFilters(), other.handshakeTypeFilters()) && Objects.equals(this.handshakeTypeSort(), other.handshakeTypeSort()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListChannelHandshakesRequest").add("HandshakeType", (Object)this.handshakeTypeAsString()).add("Catalog", (Object)this.catalog()).add("ParticipantType", (Object)this.participantTypeAsString()).add("MaxResults", (Object)this.maxResults()).add("Statuses", this.hasStatuses() ? this.statusesAsStrings() : null).add("AssociatedResourceIdentifiers", this.hasAssociatedResourceIdentifiers() ? this.associatedResourceIdentifiers() : null).add("HandshakeTypeFilters", (Object)this.handshakeTypeFilters()).add("HandshakeTypeSort", (Object)this.handshakeTypeSort()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "handshakeType": {
                return Optional.ofNullable(clazz.cast(this.handshakeTypeAsString()));
            }
            case "catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "participantType": {
                return Optional.ofNullable(clazz.cast(this.participantTypeAsString()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "statuses": {
                return Optional.ofNullable(clazz.cast(this.statusesAsStrings()));
            }
            case "associatedResourceIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.associatedResourceIdentifiers()));
            }
            case "handshakeTypeFilters": {
                return Optional.ofNullable(clazz.cast(this.handshakeTypeFilters()));
            }
            case "handshakeTypeSort": {
                return Optional.ofNullable(clazz.cast(this.handshakeTypeSort()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("handshakeType", HANDSHAKE_TYPE_FIELD);
        map.put("catalog", CATALOG_FIELD);
        map.put("participantType", PARTICIPANT_TYPE_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("statuses", STATUSES_FIELD);
        map.put("associatedResourceIdentifiers", ASSOCIATED_RESOURCE_IDENTIFIERS_FIELD);
        map.put("handshakeTypeFilters", HANDSHAKE_TYPE_FILTERS_FIELD);
        map.put("handshakeTypeSort", HANDSHAKE_TYPE_SORT_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListChannelHandshakesRequest, T> g) {
        return obj -> g.apply((ListChannelHandshakesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralChannelRequest.BuilderImpl
    implements Builder {
        private String handshakeType;
        private String catalog;
        private String participantType;
        private Integer maxResults;
        private List<String> statuses = DefaultSdkAutoConstructList.getInstance();
        private List<String> associatedResourceIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private ListChannelHandshakesTypeFilters handshakeTypeFilters;
        private ListChannelHandshakesTypeSort handshakeTypeSort;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChannelHandshakesRequest model) {
            super(model);
            this.handshakeType(model.handshakeType);
            this.catalog(model.catalog);
            this.participantType(model.participantType);
            this.maxResults(model.maxResults);
            this.statusesWithStrings(model.statuses);
            this.associatedResourceIdentifiers(model.associatedResourceIdentifiers);
            this.handshakeTypeFilters(model.handshakeTypeFilters);
            this.handshakeTypeSort(model.handshakeTypeSort);
            this.nextToken(model.nextToken);
        }

        public final String getHandshakeType() {
            return this.handshakeType;
        }

        public final void setHandshakeType(String handshakeType) {
            this.handshakeType = handshakeType;
        }

        @Override
        public final Builder handshakeType(String handshakeType) {
            this.handshakeType = handshakeType;
            return this;
        }

        @Override
        public final Builder handshakeType(HandshakeType handshakeType) {
            this.handshakeType(handshakeType == null ? null : handshakeType.toString());
            return this;
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getParticipantType() {
            return this.participantType;
        }

        public final void setParticipantType(String participantType) {
            this.participantType = participantType;
        }

        @Override
        public final Builder participantType(String participantType) {
            this.participantType = participantType;
            return this;
        }

        @Override
        public final Builder participantType(ParticipantType participantType) {
            this.participantType(participantType == null ? null : participantType.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getStatuses() {
            if (this.statuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statuses;
        }

        public final void setStatuses(Collection<String> statuses) {
            this.statuses = HandshakeStatusListCopier.copy(statuses);
        }

        @Override
        public final Builder statusesWithStrings(Collection<String> statuses) {
            this.statuses = HandshakeStatusListCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusesWithStrings(String ... statuses) {
            this.statusesWithStrings(Arrays.asList(statuses));
            return this;
        }

        @Override
        public final Builder statuses(Collection<HandshakeStatus> statuses) {
            this.statuses = HandshakeStatusListCopier.copyEnumToString(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(HandshakeStatus ... statuses) {
            this.statuses(Arrays.asList(statuses));
            return this;
        }

        public final Collection<String> getAssociatedResourceIdentifiers() {
            if (this.associatedResourceIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedResourceIdentifiers;
        }

        public final void setAssociatedResourceIdentifiers(Collection<String> associatedResourceIdentifiers) {
            this.associatedResourceIdentifiers = AssociatedResourceIdentifierListCopier.copy(associatedResourceIdentifiers);
        }

        @Override
        public final Builder associatedResourceIdentifiers(Collection<String> associatedResourceIdentifiers) {
            this.associatedResourceIdentifiers = AssociatedResourceIdentifierListCopier.copy(associatedResourceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedResourceIdentifiers(String ... associatedResourceIdentifiers) {
            this.associatedResourceIdentifiers(Arrays.asList(associatedResourceIdentifiers));
            return this;
        }

        public final ListChannelHandshakesTypeFilters.Builder getHandshakeTypeFilters() {
            return this.handshakeTypeFilters != null ? this.handshakeTypeFilters.toBuilder() : null;
        }

        public final void setHandshakeTypeFilters(ListChannelHandshakesTypeFilters.BuilderImpl handshakeTypeFilters) {
            this.handshakeTypeFilters = handshakeTypeFilters != null ? handshakeTypeFilters.build() : null;
        }

        @Override
        public final Builder handshakeTypeFilters(ListChannelHandshakesTypeFilters handshakeTypeFilters) {
            this.handshakeTypeFilters = handshakeTypeFilters;
            return this;
        }

        public final ListChannelHandshakesTypeSort.Builder getHandshakeTypeSort() {
            return this.handshakeTypeSort != null ? this.handshakeTypeSort.toBuilder() : null;
        }

        public final void setHandshakeTypeSort(ListChannelHandshakesTypeSort.BuilderImpl handshakeTypeSort) {
            this.handshakeTypeSort = handshakeTypeSort != null ? handshakeTypeSort.build() : null;
        }

        @Override
        public final Builder handshakeTypeSort(ListChannelHandshakesTypeSort handshakeTypeSort) {
            this.handshakeTypeSort = handshakeTypeSort;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListChannelHandshakesRequest build() {
            return new ListChannelHandshakesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralChannelRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListChannelHandshakesRequest> {
        public Builder handshakeType(String var1);

        public Builder handshakeType(HandshakeType var1);

        public Builder catalog(String var1);

        public Builder participantType(String var1);

        public Builder participantType(ParticipantType var1);

        public Builder maxResults(Integer var1);

        public Builder statusesWithStrings(Collection<String> var1);

        public Builder statusesWithStrings(String ... var1);

        public Builder statuses(Collection<HandshakeStatus> var1);

        public Builder statuses(HandshakeStatus ... var1);

        public Builder associatedResourceIdentifiers(Collection<String> var1);

        public Builder associatedResourceIdentifiers(String ... var1);

        public Builder handshakeTypeFilters(ListChannelHandshakesTypeFilters var1);

        default public Builder handshakeTypeFilters(Consumer<ListChannelHandshakesTypeFilters.Builder> handshakeTypeFilters) {
            return this.handshakeTypeFilters((ListChannelHandshakesTypeFilters)((ListChannelHandshakesTypeFilters.Builder)ListChannelHandshakesTypeFilters.builder().applyMutation(handshakeTypeFilters)).build());
        }

        public Builder handshakeTypeSort(ListChannelHandshakesTypeSort var1);

        default public Builder handshakeTypeSort(Consumer<ListChannelHandshakesTypeSort.Builder> handshakeTypeSort) {
            return this.handshakeTypeSort((ListChannelHandshakesTypeSort)((ListChannelHandshakesTypeSort.Builder)ListChannelHandshakesTypeSort.builder().applyMutation(handshakeTypeSort)).build());
        }

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

