/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralchannel.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralchannel.PartnerCentralChannelAsyncClient;
import software.amazon.awssdk.services.partnercentralchannel.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralchannel.model.ChannelHandshakeSummary;
import software.amazon.awssdk.services.partnercentralchannel.model.ListChannelHandshakesRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.ListChannelHandshakesResponse;

public class ListChannelHandshakesPublisher
implements SdkPublisher<ListChannelHandshakesResponse> {
    private final PartnerCentralChannelAsyncClient client;
    private final ListChannelHandshakesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListChannelHandshakesPublisher(PartnerCentralChannelAsyncClient client, ListChannelHandshakesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListChannelHandshakesPublisher(PartnerCentralChannelAsyncClient client, ListChannelHandshakesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListChannelHandshakesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListChannelHandshakesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ChannelHandshakeSummary> items() {
        Function<ListChannelHandshakesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListChannelHandshakesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListChannelHandshakesResponseFetcher
    implements AsyncPageFetcher<ListChannelHandshakesResponse> {
        private ListChannelHandshakesResponseFetcher() {
        }

        public boolean hasNextPage(ListChannelHandshakesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListChannelHandshakesResponse> nextPage(ListChannelHandshakesResponse previousPage) {
            if (previousPage == null) {
                return ListChannelHandshakesPublisher.this.client.listChannelHandshakes(ListChannelHandshakesPublisher.this.firstRequest);
            }
            return ListChannelHandshakesPublisher.this.client.listChannelHandshakes((ListChannelHandshakesRequest)((Object)ListChannelHandshakesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

