/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralchannel.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralchannel.model.HandshakeDetail;
import software.amazon.awssdk.services.partnercentralchannel.model.HandshakeStatus;
import software.amazon.awssdk.services.partnercentralchannel.model.HandshakeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChannelHandshakeSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChannelHandshakeSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ChannelHandshakeSummary.getter(ChannelHandshakeSummary::id)).setter(ChannelHandshakeSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ChannelHandshakeSummary.getter(ChannelHandshakeSummary::arn)).setter(ChannelHandshakeSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("catalog").getter(ChannelHandshakeSummary.getter(ChannelHandshakeSummary::catalog)).setter(ChannelHandshakeSummary.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalog").build()}).build();
    private static final SdkField<String> HANDSHAKE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("handshakeType").getter(ChannelHandshakeSummary.getter(ChannelHandshakeSummary::handshakeTypeAsString)).setter(ChannelHandshakeSummary.setter(Builder::handshakeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("handshakeType").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ownerAccountId").getter(ChannelHandshakeSummary.getter(ChannelHandshakeSummary::ownerAccountId)).setter(ChannelHandshakeSummary.setter(Builder::ownerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccountId").build()}).build();
    private static final SdkField<String> SENDER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("senderAccountId").getter(ChannelHandshakeSummary.getter(ChannelHandshakeSummary::senderAccountId)).setter(ChannelHandshakeSummary.setter(Builder::senderAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("senderAccountId").build()}).build();
    private static final SdkField<String> SENDER_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("senderDisplayName").getter(ChannelHandshakeSummary.getter(ChannelHandshakeSummary::senderDisplayName)).setter(ChannelHandshakeSummary.setter(Builder::senderDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("senderDisplayName").build()}).build();
    private static final SdkField<String> RECEIVER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("receiverAccountId").getter(ChannelHandshakeSummary.getter(ChannelHandshakeSummary::receiverAccountId)).setter(ChannelHandshakeSummary.setter(Builder::receiverAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("receiverAccountId").build()}).build();
    private static final SdkField<String> ASSOCIATED_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associatedResourceId").getter(ChannelHandshakeSummary.getter(ChannelHandshakeSummary::associatedResourceId)).setter(ChannelHandshakeSummary.setter(Builder::associatedResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedResourceId").build()}).build();
    private static final SdkField<HandshakeDetail> DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("detail").getter(ChannelHandshakeSummary.getter(ChannelHandshakeSummary::detail)).setter(ChannelHandshakeSummary.setter(Builder::detail)).constructor(HandshakeDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detail").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ChannelHandshakeSummary.getter(ChannelHandshakeSummary::createdAt)).setter(ChannelHandshakeSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(ChannelHandshakeSummary.getter(ChannelHandshakeSummary::updatedAt)).setter(ChannelHandshakeSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ChannelHandshakeSummary.getter(ChannelHandshakeSummary::statusAsString)).setter(ChannelHandshakeSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, CATALOG_FIELD, HANDSHAKE_TYPE_FIELD, OWNER_ACCOUNT_ID_FIELD, SENDER_ACCOUNT_ID_FIELD, SENDER_DISPLAY_NAME_FIELD, RECEIVER_ACCOUNT_ID_FIELD, ASSOCIATED_RESOURCE_ID_FIELD, DETAIL_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ChannelHandshakeSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String catalog;
    private final String handshakeType;
    private final String ownerAccountId;
    private final String senderAccountId;
    private final String senderDisplayName;
    private final String receiverAccountId;
    private final String associatedResourceId;
    private final HandshakeDetail detail;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String status;

    private ChannelHandshakeSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.catalog = builder.catalog;
        this.handshakeType = builder.handshakeType;
        this.ownerAccountId = builder.ownerAccountId;
        this.senderAccountId = builder.senderAccountId;
        this.senderDisplayName = builder.senderDisplayName;
        this.receiverAccountId = builder.receiverAccountId;
        this.associatedResourceId = builder.associatedResourceId;
        this.detail = builder.detail;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.status = builder.status;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final HandshakeType handshakeType() {
        return HandshakeType.fromValue(this.handshakeType);
    }

    public final String handshakeTypeAsString() {
        return this.handshakeType;
    }

    public final String ownerAccountId() {
        return this.ownerAccountId;
    }

    public final String senderAccountId() {
        return this.senderAccountId;
    }

    public final String senderDisplayName() {
        return this.senderDisplayName;
    }

    public final String receiverAccountId() {
        return this.receiverAccountId;
    }

    public final String associatedResourceId() {
        return this.associatedResourceId;
    }

    public final HandshakeDetail detail() {
        return this.detail;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final HandshakeStatus status() {
        return HandshakeStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.handshakeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.senderAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.senderDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.receiverAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.detail());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelHandshakeSummary)) {
            return false;
        }
        ChannelHandshakeSummary other = (ChannelHandshakeSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.handshakeTypeAsString(), other.handshakeTypeAsString()) && Objects.equals(this.ownerAccountId(), other.ownerAccountId()) && Objects.equals(this.senderAccountId(), other.senderAccountId()) && Objects.equals(this.senderDisplayName(), other.senderDisplayName()) && Objects.equals(this.receiverAccountId(), other.receiverAccountId()) && Objects.equals(this.associatedResourceId(), other.associatedResourceId()) && Objects.equals(this.detail(), other.detail()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ChannelHandshakeSummary").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Catalog", (Object)this.catalog()).add("HandshakeType", (Object)this.handshakeTypeAsString()).add("OwnerAccountId", (Object)this.ownerAccountId()).add("SenderAccountId", (Object)this.senderAccountId()).add("SenderDisplayName", (Object)this.senderDisplayName()).add("ReceiverAccountId", (Object)this.receiverAccountId()).add("AssociatedResourceId", (Object)this.associatedResourceId()).add("Detail", (Object)this.detail()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "handshakeType": {
                return Optional.ofNullable(clazz.cast(this.handshakeTypeAsString()));
            }
            case "ownerAccountId": {
                return Optional.ofNullable(clazz.cast(this.ownerAccountId()));
            }
            case "senderAccountId": {
                return Optional.ofNullable(clazz.cast(this.senderAccountId()));
            }
            case "senderDisplayName": {
                return Optional.ofNullable(clazz.cast(this.senderDisplayName()));
            }
            case "receiverAccountId": {
                return Optional.ofNullable(clazz.cast(this.receiverAccountId()));
            }
            case "associatedResourceId": {
                return Optional.ofNullable(clazz.cast(this.associatedResourceId()));
            }
            case "detail": {
                return Optional.ofNullable(clazz.cast(this.detail()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("catalog", CATALOG_FIELD);
        map.put("handshakeType", HANDSHAKE_TYPE_FIELD);
        map.put("ownerAccountId", OWNER_ACCOUNT_ID_FIELD);
        map.put("senderAccountId", SENDER_ACCOUNT_ID_FIELD);
        map.put("senderDisplayName", SENDER_DISPLAY_NAME_FIELD);
        map.put("receiverAccountId", RECEIVER_ACCOUNT_ID_FIELD);
        map.put("associatedResourceId", ASSOCIATED_RESOURCE_ID_FIELD);
        map.put("detail", DETAIL_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChannelHandshakeSummary, T> g) {
        return obj -> g.apply((ChannelHandshakeSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String catalog;
        private String handshakeType;
        private String ownerAccountId;
        private String senderAccountId;
        private String senderDisplayName;
        private String receiverAccountId;
        private String associatedResourceId;
        private HandshakeDetail detail;
        private Instant createdAt;
        private Instant updatedAt;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelHandshakeSummary model) {
            this.id(model.id);
            this.arn(model.arn);
            this.catalog(model.catalog);
            this.handshakeType(model.handshakeType);
            this.ownerAccountId(model.ownerAccountId);
            this.senderAccountId(model.senderAccountId);
            this.senderDisplayName(model.senderDisplayName);
            this.receiverAccountId(model.receiverAccountId);
            this.associatedResourceId(model.associatedResourceId);
            this.detail(model.detail);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.status(model.status);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getHandshakeType() {
            return this.handshakeType;
        }

        public final void setHandshakeType(String handshakeType) {
            this.handshakeType = handshakeType;
        }

        @Override
        public final Builder handshakeType(String handshakeType) {
            this.handshakeType = handshakeType;
            return this;
        }

        @Override
        public final Builder handshakeType(HandshakeType handshakeType) {
            this.handshakeType(handshakeType == null ? null : handshakeType.toString());
            return this;
        }

        public final String getOwnerAccountId() {
            return this.ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getSenderAccountId() {
            return this.senderAccountId;
        }

        public final void setSenderAccountId(String senderAccountId) {
            this.senderAccountId = senderAccountId;
        }

        @Override
        public final Builder senderAccountId(String senderAccountId) {
            this.senderAccountId = senderAccountId;
            return this;
        }

        public final String getSenderDisplayName() {
            return this.senderDisplayName;
        }

        public final void setSenderDisplayName(String senderDisplayName) {
            this.senderDisplayName = senderDisplayName;
        }

        @Override
        public final Builder senderDisplayName(String senderDisplayName) {
            this.senderDisplayName = senderDisplayName;
            return this;
        }

        public final String getReceiverAccountId() {
            return this.receiverAccountId;
        }

        public final void setReceiverAccountId(String receiverAccountId) {
            this.receiverAccountId = receiverAccountId;
        }

        @Override
        public final Builder receiverAccountId(String receiverAccountId) {
            this.receiverAccountId = receiverAccountId;
            return this;
        }

        public final String getAssociatedResourceId() {
            return this.associatedResourceId;
        }

        public final void setAssociatedResourceId(String associatedResourceId) {
            this.associatedResourceId = associatedResourceId;
        }

        @Override
        public final Builder associatedResourceId(String associatedResourceId) {
            this.associatedResourceId = associatedResourceId;
            return this;
        }

        public final HandshakeDetail.Builder getDetail() {
            return this.detail != null ? this.detail.toBuilder() : null;
        }

        public final void setDetail(HandshakeDetail.BuilderImpl detail) {
            this.detail = detail != null ? detail.build() : null;
        }

        @Override
        public final Builder detail(HandshakeDetail detail) {
            this.detail = detail;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(HandshakeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public ChannelHandshakeSummary build() {
            return new ChannelHandshakeSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChannelHandshakeSummary> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder catalog(String var1);

        public Builder handshakeType(String var1);

        public Builder handshakeType(HandshakeType var1);

        public Builder ownerAccountId(String var1);

        public Builder senderAccountId(String var1);

        public Builder senderDisplayName(String var1);

        public Builder receiverAccountId(String var1);

        public Builder associatedResourceId(String var1);

        public Builder detail(HandshakeDetail var1);

        default public Builder detail(Consumer<HandshakeDetail.Builder> detail) {
            return this.detail((HandshakeDetail)((HandshakeDetail.Builder)HandshakeDetail.builder().applyMutation(detail)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder status(String var1);

        public Builder status(HandshakeStatus var1);
    }
}

