/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralbenefits.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralbenefits.PartnerCentralBenefitsAsyncClient;
import software.amazon.awssdk.services.partnercentralbenefits.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralbenefits.model.BenefitAllocationSummary;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsResponse;

public class ListBenefitAllocationsPublisher
implements SdkPublisher<ListBenefitAllocationsResponse> {
    private final PartnerCentralBenefitsAsyncClient client;
    private final ListBenefitAllocationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBenefitAllocationsPublisher(PartnerCentralBenefitsAsyncClient client, ListBenefitAllocationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBenefitAllocationsPublisher(PartnerCentralBenefitsAsyncClient client, ListBenefitAllocationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBenefitAllocationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBenefitAllocationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BenefitAllocationSummary> benefitAllocationSummaries() {
        Function<ListBenefitAllocationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.benefitAllocationSummaries() != null) {
                return response.benefitAllocationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBenefitAllocationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBenefitAllocationsResponseFetcher
    implements AsyncPageFetcher<ListBenefitAllocationsResponse> {
        private ListBenefitAllocationsResponseFetcher() {
        }

        public boolean hasNextPage(ListBenefitAllocationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBenefitAllocationsResponse> nextPage(ListBenefitAllocationsResponse previousPage) {
            if (previousPage == null) {
                return ListBenefitAllocationsPublisher.this.client.listBenefitAllocations(ListBenefitAllocationsPublisher.this.firstRequest);
            }
            return ListBenefitAllocationsPublisher.this.client.listBenefitAllocations((ListBenefitAllocationsRequest)((Object)ListBenefitAllocationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

