/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralbenefits.model.BenefitApplicationStatus;
import software.amazon.awssdk.services.partnercentralbenefits.model.Contact;
import software.amazon.awssdk.services.partnercentralbenefits.model.ContactsCopier;
import software.amazon.awssdk.services.partnercentralbenefits.model.FileDetail;
import software.amazon.awssdk.services.partnercentralbenefits.model.FulfillmentType;
import software.amazon.awssdk.services.partnercentralbenefits.model.FulfillmentTypesCopier;
import software.amazon.awssdk.services.partnercentralbenefits.model.GetBenefitApplicationOutputAssociatedResourcesListCopier;
import software.amazon.awssdk.services.partnercentralbenefits.model.GetBenefitApplicationOutputFileDetailsListCopier;
import software.amazon.awssdk.services.partnercentralbenefits.model.PartnerCentralBenefitsResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.ProgramsCopier;
import software.amazon.awssdk.services.partnercentralbenefits.model.StatusReasonCodesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBenefitApplicationResponse
extends PartnerCentralBenefitsResponse
implements ToCopyableBuilder<Builder, GetBenefitApplicationResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(GetBenefitApplicationResponse.getter(GetBenefitApplicationResponse::id)).setter(GetBenefitApplicationResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetBenefitApplicationResponse.getter(GetBenefitApplicationResponse::arn)).setter(GetBenefitApplicationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(GetBenefitApplicationResponse.getter(GetBenefitApplicationResponse::catalog)).setter(GetBenefitApplicationResponse.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<String> BENEFIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BenefitId").getter(GetBenefitApplicationResponse.getter(GetBenefitApplicationResponse::benefitId)).setter(GetBenefitApplicationResponse.setter(Builder::benefitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BenefitId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetBenefitApplicationResponse.getter(GetBenefitApplicationResponse::name)).setter(GetBenefitApplicationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetBenefitApplicationResponse.getter(GetBenefitApplicationResponse::description)).setter(GetBenefitApplicationResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<String>> FULFILLMENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FulfillmentTypes").getter(GetBenefitApplicationResponse.getter(GetBenefitApplicationResponse::fulfillmentTypesAsStrings)).setter(GetBenefitApplicationResponse.setter(Builder::fulfillmentTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FulfillmentTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Document> BENEFIT_APPLICATION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("BenefitApplicationDetails").getter(GetBenefitApplicationResponse.getter(GetBenefitApplicationResponse::benefitApplicationDetails)).setter(GetBenefitApplicationResponse.setter(Builder::benefitApplicationDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BenefitApplicationDetails").build()}).build();
    private static final SdkField<List<String>> PROGRAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Programs").getter(GetBenefitApplicationResponse.getter(GetBenefitApplicationResponse::programs)).setter(GetBenefitApplicationResponse.setter(Builder::programs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Programs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetBenefitApplicationResponse.getter(GetBenefitApplicationResponse::statusAsString)).setter(GetBenefitApplicationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Stage").getter(GetBenefitApplicationResponse.getter(GetBenefitApplicationResponse::stage)).setter(GetBenefitApplicationResponse.setter(Builder::stage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stage").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(GetBenefitApplicationResponse.getter(GetBenefitApplicationResponse::statusReason)).setter(GetBenefitApplicationResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<String> STATUS_REASON_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReasonCode").getter(GetBenefitApplicationResponse.getter(GetBenefitApplicationResponse::statusReasonCode)).setter(GetBenefitApplicationResponse.setter(Builder::statusReasonCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReasonCode").build()}).build();
    private static final SdkField<List<String>> STATUS_REASON_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StatusReasonCodes").getter(GetBenefitApplicationResponse.getter(GetBenefitApplicationResponse::statusReasonCodes)).setter(GetBenefitApplicationResponse.setter(Builder::statusReasonCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReasonCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetBenefitApplicationResponse.getter(GetBenefitApplicationResponse::createdAt)).setter(GetBenefitApplicationResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(GetBenefitApplicationResponse.getter(GetBenefitApplicationResponse::updatedAt)).setter(GetBenefitApplicationResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Revision").getter(GetBenefitApplicationResponse.getter(GetBenefitApplicationResponse::revision)).setter(GetBenefitApplicationResponse.setter(Builder::revision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Revision").build()}).build();
    private static final SdkField<List<String>> ASSOCIATED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociatedResources").getter(GetBenefitApplicationResponse.getter(GetBenefitApplicationResponse::associatedResources)).setter(GetBenefitApplicationResponse.setter(Builder::associatedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Contact>> PARTNER_CONTACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PartnerContacts").getter(GetBenefitApplicationResponse.getter(GetBenefitApplicationResponse::partnerContacts)).setter(GetBenefitApplicationResponse.setter(Builder::partnerContacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerContacts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Contact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FileDetail>> FILE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FileDetails").getter(GetBenefitApplicationResponse.getter(GetBenefitApplicationResponse::fileDetails)).setter(GetBenefitApplicationResponse.setter(Builder::fileDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FileDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, CATALOG_FIELD, BENEFIT_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, FULFILLMENT_TYPES_FIELD, BENEFIT_APPLICATION_DETAILS_FIELD, PROGRAMS_FIELD, STATUS_FIELD, STAGE_FIELD, STATUS_REASON_FIELD, STATUS_REASON_CODE_FIELD, STATUS_REASON_CODES_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, REVISION_FIELD, ASSOCIATED_RESOURCES_FIELD, PARTNER_CONTACTS_FIELD, FILE_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetBenefitApplicationResponse.memberNameToFieldInitializer();
    private final String id;
    private final String arn;
    private final String catalog;
    private final String benefitId;
    private final String name;
    private final String description;
    private final List<String> fulfillmentTypes;
    private final Document benefitApplicationDetails;
    private final List<String> programs;
    private final String status;
    private final String stage;
    private final String statusReason;
    private final String statusReasonCode;
    private final List<String> statusReasonCodes;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String revision;
    private final List<String> associatedResources;
    private final List<Contact> partnerContacts;
    private final List<FileDetail> fileDetails;

    private GetBenefitApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.catalog = builder.catalog;
        this.benefitId = builder.benefitId;
        this.name = builder.name;
        this.description = builder.description;
        this.fulfillmentTypes = builder.fulfillmentTypes;
        this.benefitApplicationDetails = builder.benefitApplicationDetails;
        this.programs = builder.programs;
        this.status = builder.status;
        this.stage = builder.stage;
        this.statusReason = builder.statusReason;
        this.statusReasonCode = builder.statusReasonCode;
        this.statusReasonCodes = builder.statusReasonCodes;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.revision = builder.revision;
        this.associatedResources = builder.associatedResources;
        this.partnerContacts = builder.partnerContacts;
        this.fileDetails = builder.fileDetails;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final String benefitId() {
        return this.benefitId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final List<FulfillmentType> fulfillmentTypes() {
        return FulfillmentTypesCopier.copyStringToEnum(this.fulfillmentTypes);
    }

    public final boolean hasFulfillmentTypes() {
        return this.fulfillmentTypes != null && !(this.fulfillmentTypes instanceof SdkAutoConstructList);
    }

    public final List<String> fulfillmentTypesAsStrings() {
        return this.fulfillmentTypes;
    }

    public final Document benefitApplicationDetails() {
        return this.benefitApplicationDetails;
    }

    public final boolean hasPrograms() {
        return this.programs != null && !(this.programs instanceof SdkAutoConstructList);
    }

    public final List<String> programs() {
        return this.programs;
    }

    public final BenefitApplicationStatus status() {
        return BenefitApplicationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String stage() {
        return this.stage;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    @Deprecated
    public final String statusReasonCode() {
        return this.statusReasonCode;
    }

    public final boolean hasStatusReasonCodes() {
        return this.statusReasonCodes != null && !(this.statusReasonCodes instanceof SdkAutoConstructList);
    }

    public final List<String> statusReasonCodes() {
        return this.statusReasonCodes;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String revision() {
        return this.revision;
    }

    public final boolean hasAssociatedResources() {
        return this.associatedResources != null && !(this.associatedResources instanceof SdkAutoConstructList);
    }

    public final List<String> associatedResources() {
        return this.associatedResources;
    }

    public final boolean hasPartnerContacts() {
        return this.partnerContacts != null && !(this.partnerContacts instanceof SdkAutoConstructList);
    }

    public final List<Contact> partnerContacts() {
        return this.partnerContacts;
    }

    public final boolean hasFileDetails() {
        return this.fileDetails != null && !(this.fileDetails instanceof SdkAutoConstructList);
    }

    public final List<FileDetail> fileDetails() {
        return this.fileDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.benefitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFulfillmentTypes() ? this.fulfillmentTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.benefitApplicationDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrograms() ? this.programs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stage());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReasonCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatusReasonCodes() ? this.statusReasonCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedResources() ? this.associatedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartnerContacts() ? this.partnerContacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFileDetails() ? this.fileDetails() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBenefitApplicationResponse)) {
            return false;
        }
        GetBenefitApplicationResponse other = (GetBenefitApplicationResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.benefitId(), other.benefitId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasFulfillmentTypes() == other.hasFulfillmentTypes() && Objects.equals(this.fulfillmentTypesAsStrings(), other.fulfillmentTypesAsStrings()) && Objects.equals(this.benefitApplicationDetails(), other.benefitApplicationDetails()) && this.hasPrograms() == other.hasPrograms() && Objects.equals(this.programs(), other.programs()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.stage(), other.stage()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.statusReasonCode(), other.statusReasonCode()) && this.hasStatusReasonCodes() == other.hasStatusReasonCodes() && Objects.equals(this.statusReasonCodes(), other.statusReasonCodes()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.revision(), other.revision()) && this.hasAssociatedResources() == other.hasAssociatedResources() && Objects.equals(this.associatedResources(), other.associatedResources()) && this.hasPartnerContacts() == other.hasPartnerContacts() && Objects.equals(this.partnerContacts(), other.partnerContacts()) && this.hasFileDetails() == other.hasFileDetails() && Objects.equals(this.fileDetails(), other.fileDetails());
    }

    public final String toString() {
        return ToString.builder((String)"GetBenefitApplicationResponse").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Catalog", (Object)this.catalog()).add("BenefitId", (Object)this.benefitId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("FulfillmentTypes", this.hasFulfillmentTypes() ? this.fulfillmentTypesAsStrings() : null).add("BenefitApplicationDetails", (Object)this.benefitApplicationDetails()).add("Programs", this.hasPrograms() ? this.programs() : null).add("Status", (Object)this.statusAsString()).add("Stage", (Object)this.stage()).add("StatusReason", (Object)this.statusReason()).add("StatusReasonCode", (Object)this.statusReasonCode()).add("StatusReasonCodes", this.hasStatusReasonCodes() ? this.statusReasonCodes() : null).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("Revision", (Object)this.revision()).add("AssociatedResources", this.hasAssociatedResources() ? this.associatedResources() : null).add("PartnerContacts", this.hasPartnerContacts() ? this.partnerContacts() : null).add("FileDetails", this.hasFileDetails() ? this.fileDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "BenefitId": {
                return Optional.ofNullable(clazz.cast(this.benefitId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "FulfillmentTypes": {
                return Optional.ofNullable(clazz.cast(this.fulfillmentTypesAsStrings()));
            }
            case "BenefitApplicationDetails": {
                return Optional.ofNullable(clazz.cast(this.benefitApplicationDetails()));
            }
            case "Programs": {
                return Optional.ofNullable(clazz.cast(this.programs()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Stage": {
                return Optional.ofNullable(clazz.cast(this.stage()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "StatusReasonCode": {
                return Optional.ofNullable(clazz.cast(this.statusReasonCode()));
            }
            case "StatusReasonCodes": {
                return Optional.ofNullable(clazz.cast(this.statusReasonCodes()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "Revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
            case "AssociatedResources": {
                return Optional.ofNullable(clazz.cast(this.associatedResources()));
            }
            case "PartnerContacts": {
                return Optional.ofNullable(clazz.cast(this.partnerContacts()));
            }
            case "FileDetails": {
                return Optional.ofNullable(clazz.cast(this.fileDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Catalog", CATALOG_FIELD);
        map.put("BenefitId", BENEFIT_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("FulfillmentTypes", FULFILLMENT_TYPES_FIELD);
        map.put("BenefitApplicationDetails", BENEFIT_APPLICATION_DETAILS_FIELD);
        map.put("Programs", PROGRAMS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Stage", STAGE_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("StatusReasonCode", STATUS_REASON_CODE_FIELD);
        map.put("StatusReasonCodes", STATUS_REASON_CODES_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("Revision", REVISION_FIELD);
        map.put("AssociatedResources", ASSOCIATED_RESOURCES_FIELD);
        map.put("PartnerContacts", PARTNER_CONTACTS_FIELD);
        map.put("FileDetails", FILE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBenefitApplicationResponse, T> g) {
        return obj -> g.apply((GetBenefitApplicationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralBenefitsResponse.BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String catalog;
        private String benefitId;
        private String name;
        private String description;
        private List<String> fulfillmentTypes = DefaultSdkAutoConstructList.getInstance();
        private Document benefitApplicationDetails;
        private List<String> programs = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String stage;
        private String statusReason;
        private String statusReasonCode;
        private List<String> statusReasonCodes = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private Instant updatedAt;
        private String revision;
        private List<String> associatedResources = DefaultSdkAutoConstructList.getInstance();
        private List<Contact> partnerContacts = DefaultSdkAutoConstructList.getInstance();
        private List<FileDetail> fileDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetBenefitApplicationResponse model) {
            super(model);
            this.id(model.id);
            this.arn(model.arn);
            this.catalog(model.catalog);
            this.benefitId(model.benefitId);
            this.name(model.name);
            this.description(model.description);
            this.fulfillmentTypesWithStrings(model.fulfillmentTypes);
            this.benefitApplicationDetails(model.benefitApplicationDetails);
            this.programs(model.programs);
            this.status(model.status);
            this.stage(model.stage);
            this.statusReason(model.statusReason);
            this.statusReasonCode(model.statusReasonCode);
            this.statusReasonCodes(model.statusReasonCodes);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.revision(model.revision);
            this.associatedResources(model.associatedResources);
            this.partnerContacts(model.partnerContacts);
            this.fileDetails(model.fileDetails);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getBenefitId() {
            return this.benefitId;
        }

        public final void setBenefitId(String benefitId) {
            this.benefitId = benefitId;
        }

        @Override
        public final Builder benefitId(String benefitId) {
            this.benefitId = benefitId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getFulfillmentTypes() {
            if (this.fulfillmentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fulfillmentTypes;
        }

        public final void setFulfillmentTypes(Collection<String> fulfillmentTypes) {
            this.fulfillmentTypes = FulfillmentTypesCopier.copy(fulfillmentTypes);
        }

        @Override
        public final Builder fulfillmentTypesWithStrings(Collection<String> fulfillmentTypes) {
            this.fulfillmentTypes = FulfillmentTypesCopier.copy(fulfillmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fulfillmentTypesWithStrings(String ... fulfillmentTypes) {
            this.fulfillmentTypesWithStrings(Arrays.asList(fulfillmentTypes));
            return this;
        }

        @Override
        public final Builder fulfillmentTypes(Collection<FulfillmentType> fulfillmentTypes) {
            this.fulfillmentTypes = FulfillmentTypesCopier.copyEnumToString(fulfillmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fulfillmentTypes(FulfillmentType ... fulfillmentTypes) {
            this.fulfillmentTypes(Arrays.asList(fulfillmentTypes));
            return this;
        }

        public final Document getBenefitApplicationDetails() {
            return this.benefitApplicationDetails;
        }

        public final void setBenefitApplicationDetails(Document benefitApplicationDetails) {
            this.benefitApplicationDetails = benefitApplicationDetails;
        }

        @Override
        public final Builder benefitApplicationDetails(Document benefitApplicationDetails) {
            this.benefitApplicationDetails = benefitApplicationDetails;
            return this;
        }

        public final Collection<String> getPrograms() {
            if (this.programs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.programs;
        }

        public final void setPrograms(Collection<String> programs) {
            this.programs = ProgramsCopier.copy(programs);
        }

        @Override
        public final Builder programs(Collection<String> programs) {
            this.programs = ProgramsCopier.copy(programs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder programs(String ... programs) {
            this.programs(Arrays.asList(programs));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BenefitApplicationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStage() {
            return this.stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Deprecated
        public final String getStatusReasonCode() {
            return this.statusReasonCode;
        }

        @Deprecated
        public final void setStatusReasonCode(String statusReasonCode) {
            this.statusReasonCode = statusReasonCode;
        }

        @Override
        @Deprecated
        public final Builder statusReasonCode(String statusReasonCode) {
            this.statusReasonCode = statusReasonCode;
            return this;
        }

        public final Collection<String> getStatusReasonCodes() {
            if (this.statusReasonCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statusReasonCodes;
        }

        public final void setStatusReasonCodes(Collection<String> statusReasonCodes) {
            this.statusReasonCodes = StatusReasonCodesCopier.copy(statusReasonCodes);
        }

        @Override
        public final Builder statusReasonCodes(Collection<String> statusReasonCodes) {
            this.statusReasonCodes = StatusReasonCodesCopier.copy(statusReasonCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusReasonCodes(String ... statusReasonCodes) {
            this.statusReasonCodes(Arrays.asList(statusReasonCodes));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getRevision() {
            return this.revision;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public final Collection<String> getAssociatedResources() {
            if (this.associatedResources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedResources;
        }

        public final void setAssociatedResources(Collection<String> associatedResources) {
            this.associatedResources = GetBenefitApplicationOutputAssociatedResourcesListCopier.copy(associatedResources);
        }

        @Override
        public final Builder associatedResources(Collection<String> associatedResources) {
            this.associatedResources = GetBenefitApplicationOutputAssociatedResourcesListCopier.copy(associatedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedResources(String ... associatedResources) {
            this.associatedResources(Arrays.asList(associatedResources));
            return this;
        }

        public final List<Contact.Builder> getPartnerContacts() {
            List<Contact.Builder> result = ContactsCopier.copyToBuilder(this.partnerContacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPartnerContacts(Collection<Contact.BuilderImpl> partnerContacts) {
            this.partnerContacts = ContactsCopier.copyFromBuilder(partnerContacts);
        }

        @Override
        public final Builder partnerContacts(Collection<Contact> partnerContacts) {
            this.partnerContacts = ContactsCopier.copy(partnerContacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partnerContacts(Contact ... partnerContacts) {
            this.partnerContacts(Arrays.asList(partnerContacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partnerContacts(Consumer<Contact.Builder> ... partnerContacts) {
            this.partnerContacts(Stream.of(partnerContacts).map(c -> (Contact)((Contact.Builder)Contact.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FileDetail.Builder> getFileDetails() {
            List<FileDetail.Builder> result = GetBenefitApplicationOutputFileDetailsListCopier.copyToBuilder(this.fileDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileDetails(Collection<FileDetail.BuilderImpl> fileDetails) {
            this.fileDetails = GetBenefitApplicationOutputFileDetailsListCopier.copyFromBuilder(fileDetails);
        }

        @Override
        public final Builder fileDetails(Collection<FileDetail> fileDetails) {
            this.fileDetails = GetBenefitApplicationOutputFileDetailsListCopier.copy(fileDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileDetails(FileDetail ... fileDetails) {
            this.fileDetails(Arrays.asList(fileDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileDetails(Consumer<FileDetail.Builder> ... fileDetails) {
            this.fileDetails(Stream.of(fileDetails).map(c -> (FileDetail)((FileDetail.Builder)FileDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetBenefitApplicationResponse build() {
            return new GetBenefitApplicationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralBenefitsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBenefitApplicationResponse> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder catalog(String var1);

        public Builder benefitId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder fulfillmentTypesWithStrings(Collection<String> var1);

        public Builder fulfillmentTypesWithStrings(String ... var1);

        public Builder fulfillmentTypes(Collection<FulfillmentType> var1);

        public Builder fulfillmentTypes(FulfillmentType ... var1);

        public Builder benefitApplicationDetails(Document var1);

        public Builder programs(Collection<String> var1);

        public Builder programs(String ... var1);

        public Builder status(String var1);

        public Builder status(BenefitApplicationStatus var1);

        public Builder stage(String var1);

        public Builder statusReason(String var1);

        @Deprecated
        public Builder statusReasonCode(String var1);

        public Builder statusReasonCodes(Collection<String> var1);

        public Builder statusReasonCodes(String ... var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder revision(String var1);

        public Builder associatedResources(Collection<String> var1);

        public Builder associatedResources(String ... var1);

        public Builder partnerContacts(Collection<Contact> var1);

        public Builder partnerContacts(Contact ... var1);

        public Builder partnerContacts(Consumer<Contact.Builder> ... var1);

        public Builder fileDetails(Collection<FileDetail> var1);

        public Builder fileDetails(FileDetail ... var1);

        public Builder fileDetails(Consumer<FileDetail.Builder> ... var1);
    }
}

