/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralbenefits.model.BenefitAllocationStatus;
import software.amazon.awssdk.services.partnercentralbenefits.model.BenefitIdentifiersCopier;
import software.amazon.awssdk.services.partnercentralbenefits.model.FulfillmentDetails;
import software.amazon.awssdk.services.partnercentralbenefits.model.FulfillmentType;
import software.amazon.awssdk.services.partnercentralbenefits.model.PartnerCentralBenefitsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBenefitAllocationResponse
extends PartnerCentralBenefitsResponse
implements ToCopyableBuilder<Builder, GetBenefitAllocationResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(GetBenefitAllocationResponse.getter(GetBenefitAllocationResponse::id)).setter(GetBenefitAllocationResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(GetBenefitAllocationResponse.getter(GetBenefitAllocationResponse::catalog)).setter(GetBenefitAllocationResponse.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetBenefitAllocationResponse.getter(GetBenefitAllocationResponse::arn)).setter(GetBenefitAllocationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetBenefitAllocationResponse.getter(GetBenefitAllocationResponse::name)).setter(GetBenefitAllocationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetBenefitAllocationResponse.getter(GetBenefitAllocationResponse::description)).setter(GetBenefitAllocationResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetBenefitAllocationResponse.getter(GetBenefitAllocationResponse::statusAsString)).setter(GetBenefitAllocationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(GetBenefitAllocationResponse.getter(GetBenefitAllocationResponse::statusReason)).setter(GetBenefitAllocationResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<String> BENEFIT_APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BenefitApplicationId").getter(GetBenefitAllocationResponse.getter(GetBenefitAllocationResponse::benefitApplicationId)).setter(GetBenefitAllocationResponse.setter(Builder::benefitApplicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BenefitApplicationId").build()}).build();
    private static final SdkField<String> BENEFIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BenefitId").getter(GetBenefitAllocationResponse.getter(GetBenefitAllocationResponse::benefitId)).setter(GetBenefitAllocationResponse.setter(Builder::benefitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BenefitId").build()}).build();
    private static final SdkField<String> FULFILLMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FulfillmentType").getter(GetBenefitAllocationResponse.getter(GetBenefitAllocationResponse::fulfillmentTypeAsString)).setter(GetBenefitAllocationResponse.setter(Builder::fulfillmentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FulfillmentType").build()}).build();
    private static final SdkField<List<String>> APPLICABLE_BENEFIT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ApplicableBenefitIds").getter(GetBenefitAllocationResponse.getter(GetBenefitAllocationResponse::applicableBenefitIds)).setter(GetBenefitAllocationResponse.setter(Builder::applicableBenefitIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicableBenefitIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<FulfillmentDetails> FULFILLMENT_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FulfillmentDetail").getter(GetBenefitAllocationResponse.getter(GetBenefitAllocationResponse::fulfillmentDetail)).setter(GetBenefitAllocationResponse.setter(Builder::fulfillmentDetail)).constructor(FulfillmentDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FulfillmentDetail").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetBenefitAllocationResponse.getter(GetBenefitAllocationResponse::createdAt)).setter(GetBenefitAllocationResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(GetBenefitAllocationResponse.getter(GetBenefitAllocationResponse::updatedAt)).setter(GetBenefitAllocationResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> STARTS_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartsAt").getter(GetBenefitAllocationResponse.getter(GetBenefitAllocationResponse::startsAt)).setter(GetBenefitAllocationResponse.setter(Builder::startsAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartsAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpiresAt").getter(GetBenefitAllocationResponse.getter(GetBenefitAllocationResponse::expiresAt)).setter(GetBenefitAllocationResponse.setter(Builder::expiresAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiresAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, CATALOG_FIELD, ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, BENEFIT_APPLICATION_ID_FIELD, BENEFIT_ID_FIELD, FULFILLMENT_TYPE_FIELD, APPLICABLE_BENEFIT_IDS_FIELD, FULFILLMENT_DETAIL_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, STARTS_AT_FIELD, EXPIRES_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetBenefitAllocationResponse.memberNameToFieldInitializer();
    private final String id;
    private final String catalog;
    private final String arn;
    private final String name;
    private final String description;
    private final String status;
    private final String statusReason;
    private final String benefitApplicationId;
    private final String benefitId;
    private final String fulfillmentType;
    private final List<String> applicableBenefitIds;
    private final FulfillmentDetails fulfillmentDetail;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final Instant startsAt;
    private final Instant expiresAt;

    private GetBenefitAllocationResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.catalog = builder.catalog;
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.benefitApplicationId = builder.benefitApplicationId;
        this.benefitId = builder.benefitId;
        this.fulfillmentType = builder.fulfillmentType;
        this.applicableBenefitIds = builder.applicableBenefitIds;
        this.fulfillmentDetail = builder.fulfillmentDetail;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.startsAt = builder.startsAt;
        this.expiresAt = builder.expiresAt;
    }

    public final String id() {
        return this.id;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final BenefitAllocationStatus status() {
        return BenefitAllocationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final String benefitApplicationId() {
        return this.benefitApplicationId;
    }

    public final String benefitId() {
        return this.benefitId;
    }

    public final FulfillmentType fulfillmentType() {
        return FulfillmentType.fromValue(this.fulfillmentType);
    }

    public final String fulfillmentTypeAsString() {
        return this.fulfillmentType;
    }

    public final boolean hasApplicableBenefitIds() {
        return this.applicableBenefitIds != null && !(this.applicableBenefitIds instanceof SdkAutoConstructList);
    }

    public final List<String> applicableBenefitIds() {
        return this.applicableBenefitIds;
    }

    public final FulfillmentDetails fulfillmentDetail() {
        return this.fulfillmentDetail;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final Instant startsAt() {
        return this.startsAt;
    }

    public final Instant expiresAt() {
        return this.expiresAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.benefitApplicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.benefitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fulfillmentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicableBenefitIds() ? this.applicableBenefitIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.fulfillmentDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.startsAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBenefitAllocationResponse)) {
            return false;
        }
        GetBenefitAllocationResponse other = (GetBenefitAllocationResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.benefitApplicationId(), other.benefitApplicationId()) && Objects.equals(this.benefitId(), other.benefitId()) && Objects.equals(this.fulfillmentTypeAsString(), other.fulfillmentTypeAsString()) && this.hasApplicableBenefitIds() == other.hasApplicableBenefitIds() && Objects.equals(this.applicableBenefitIds(), other.applicableBenefitIds()) && Objects.equals(this.fulfillmentDetail(), other.fulfillmentDetail()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.startsAt(), other.startsAt()) && Objects.equals(this.expiresAt(), other.expiresAt());
    }

    public final String toString() {
        return ToString.builder((String)"GetBenefitAllocationResponse").add("Id", (Object)this.id()).add("Catalog", (Object)this.catalog()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("BenefitApplicationId", (Object)this.benefitApplicationId()).add("BenefitId", (Object)this.benefitId()).add("FulfillmentType", (Object)this.fulfillmentTypeAsString()).add("ApplicableBenefitIds", this.hasApplicableBenefitIds() ? this.applicableBenefitIds() : null).add("FulfillmentDetail", (Object)this.fulfillmentDetail()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("StartsAt", (Object)this.startsAt()).add("ExpiresAt", (Object)this.expiresAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "BenefitApplicationId": {
                return Optional.ofNullable(clazz.cast(this.benefitApplicationId()));
            }
            case "BenefitId": {
                return Optional.ofNullable(clazz.cast(this.benefitId()));
            }
            case "FulfillmentType": {
                return Optional.ofNullable(clazz.cast(this.fulfillmentTypeAsString()));
            }
            case "ApplicableBenefitIds": {
                return Optional.ofNullable(clazz.cast(this.applicableBenefitIds()));
            }
            case "FulfillmentDetail": {
                return Optional.ofNullable(clazz.cast(this.fulfillmentDetail()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "StartsAt": {
                return Optional.ofNullable(clazz.cast(this.startsAt()));
            }
            case "ExpiresAt": {
                return Optional.ofNullable(clazz.cast(this.expiresAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Catalog", CATALOG_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("BenefitApplicationId", BENEFIT_APPLICATION_ID_FIELD);
        map.put("BenefitId", BENEFIT_ID_FIELD);
        map.put("FulfillmentType", FULFILLMENT_TYPE_FIELD);
        map.put("ApplicableBenefitIds", APPLICABLE_BENEFIT_IDS_FIELD);
        map.put("FulfillmentDetail", FULFILLMENT_DETAIL_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("StartsAt", STARTS_AT_FIELD);
        map.put("ExpiresAt", EXPIRES_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBenefitAllocationResponse, T> g) {
        return obj -> g.apply((GetBenefitAllocationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralBenefitsResponse.BuilderImpl
    implements Builder {
        private String id;
        private String catalog;
        private String arn;
        private String name;
        private String description;
        private String status;
        private String statusReason;
        private String benefitApplicationId;
        private String benefitId;
        private String fulfillmentType;
        private List<String> applicableBenefitIds = DefaultSdkAutoConstructList.getInstance();
        private FulfillmentDetails fulfillmentDetail;
        private Instant createdAt;
        private Instant updatedAt;
        private Instant startsAt;
        private Instant expiresAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBenefitAllocationResponse model) {
            super(model);
            this.id(model.id);
            this.catalog(model.catalog);
            this.arn(model.arn);
            this.name(model.name);
            this.description(model.description);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.benefitApplicationId(model.benefitApplicationId);
            this.benefitId(model.benefitId);
            this.fulfillmentType(model.fulfillmentType);
            this.applicableBenefitIds(model.applicableBenefitIds);
            this.fulfillmentDetail(model.fulfillmentDetail);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.startsAt(model.startsAt);
            this.expiresAt(model.expiresAt);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BenefitAllocationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getBenefitApplicationId() {
            return this.benefitApplicationId;
        }

        public final void setBenefitApplicationId(String benefitApplicationId) {
            this.benefitApplicationId = benefitApplicationId;
        }

        @Override
        public final Builder benefitApplicationId(String benefitApplicationId) {
            this.benefitApplicationId = benefitApplicationId;
            return this;
        }

        public final String getBenefitId() {
            return this.benefitId;
        }

        public final void setBenefitId(String benefitId) {
            this.benefitId = benefitId;
        }

        @Override
        public final Builder benefitId(String benefitId) {
            this.benefitId = benefitId;
            return this;
        }

        public final String getFulfillmentType() {
            return this.fulfillmentType;
        }

        public final void setFulfillmentType(String fulfillmentType) {
            this.fulfillmentType = fulfillmentType;
        }

        @Override
        public final Builder fulfillmentType(String fulfillmentType) {
            this.fulfillmentType = fulfillmentType;
            return this;
        }

        @Override
        public final Builder fulfillmentType(FulfillmentType fulfillmentType) {
            this.fulfillmentType(fulfillmentType == null ? null : fulfillmentType.toString());
            return this;
        }

        public final Collection<String> getApplicableBenefitIds() {
            if (this.applicableBenefitIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.applicableBenefitIds;
        }

        public final void setApplicableBenefitIds(Collection<String> applicableBenefitIds) {
            this.applicableBenefitIds = BenefitIdentifiersCopier.copy(applicableBenefitIds);
        }

        @Override
        public final Builder applicableBenefitIds(Collection<String> applicableBenefitIds) {
            this.applicableBenefitIds = BenefitIdentifiersCopier.copy(applicableBenefitIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicableBenefitIds(String ... applicableBenefitIds) {
            this.applicableBenefitIds(Arrays.asList(applicableBenefitIds));
            return this;
        }

        public final FulfillmentDetails.Builder getFulfillmentDetail() {
            return this.fulfillmentDetail != null ? this.fulfillmentDetail.toBuilder() : null;
        }

        public final void setFulfillmentDetail(FulfillmentDetails.BuilderImpl fulfillmentDetail) {
            this.fulfillmentDetail = fulfillmentDetail != null ? fulfillmentDetail.build() : null;
        }

        @Override
        public final Builder fulfillmentDetail(FulfillmentDetails fulfillmentDetail) {
            this.fulfillmentDetail = fulfillmentDetail;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Instant getStartsAt() {
            return this.startsAt;
        }

        public final void setStartsAt(Instant startsAt) {
            this.startsAt = startsAt;
        }

        @Override
        public final Builder startsAt(Instant startsAt) {
            this.startsAt = startsAt;
            return this;
        }

        public final Instant getExpiresAt() {
            return this.expiresAt;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        @Override
        public GetBenefitAllocationResponse build() {
            return new GetBenefitAllocationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralBenefitsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBenefitAllocationResponse> {
        public Builder id(String var1);

        public Builder catalog(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(BenefitAllocationStatus var1);

        public Builder statusReason(String var1);

        public Builder benefitApplicationId(String var1);

        public Builder benefitId(String var1);

        public Builder fulfillmentType(String var1);

        public Builder fulfillmentType(FulfillmentType var1);

        public Builder applicableBenefitIds(Collection<String> var1);

        public Builder applicableBenefitIds(String ... var1);

        public Builder fulfillmentDetail(FulfillmentDetails var1);

        default public Builder fulfillmentDetail(Consumer<FulfillmentDetails.Builder> fulfillmentDetail) {
            return this.fulfillmentDetail((FulfillmentDetails)((FulfillmentDetails.Builder)FulfillmentDetails.builder().applyMutation(fulfillmentDetail)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder startsAt(Instant var1);

        public Builder expiresAt(Instant var1);
    }
}

