/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.partnercentralbenefits.model.AccessDetails;
import software.amazon.awssdk.services.partnercentralbenefits.model.ConsumableDetails;
import software.amazon.awssdk.services.partnercentralbenefits.model.CreditDetails;
import software.amazon.awssdk.services.partnercentralbenefits.model.DisbursementDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FulfillmentDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FulfillmentDetails> {
    private static final SdkField<DisbursementDetails> DISBURSEMENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DisbursementDetails").getter(FulfillmentDetails.getter(FulfillmentDetails::disbursementDetails)).setter(FulfillmentDetails.setter(Builder::disbursementDetails)).constructor(DisbursementDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisbursementDetails").build()}).build();
    private static final SdkField<ConsumableDetails> CONSUMABLE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConsumableDetails").getter(FulfillmentDetails.getter(FulfillmentDetails::consumableDetails)).setter(FulfillmentDetails.setter(Builder::consumableDetails)).constructor(ConsumableDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumableDetails").build()}).build();
    private static final SdkField<CreditDetails> CREDIT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreditDetails").getter(FulfillmentDetails.getter(FulfillmentDetails::creditDetails)).setter(FulfillmentDetails.setter(Builder::creditDetails)).constructor(CreditDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreditDetails").build()}).build();
    private static final SdkField<AccessDetails> ACCESS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccessDetails").getter(FulfillmentDetails.getter(FulfillmentDetails::accessDetails)).setter(FulfillmentDetails.setter(Builder::accessDetails)).constructor(AccessDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISBURSEMENT_DETAILS_FIELD, CONSUMABLE_DETAILS_FIELD, CREDIT_DETAILS_FIELD, ACCESS_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FulfillmentDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DisbursementDetails disbursementDetails;
    private final ConsumableDetails consumableDetails;
    private final CreditDetails creditDetails;
    private final AccessDetails accessDetails;
    private final Type type;

    private FulfillmentDetails(BuilderImpl builder) {
        this.disbursementDetails = builder.disbursementDetails;
        this.consumableDetails = builder.consumableDetails;
        this.creditDetails = builder.creditDetails;
        this.accessDetails = builder.accessDetails;
        this.type = builder.type;
    }

    public final DisbursementDetails disbursementDetails() {
        return this.disbursementDetails;
    }

    public final ConsumableDetails consumableDetails() {
        return this.consumableDetails;
    }

    public final CreditDetails creditDetails() {
        return this.creditDetails;
    }

    public final AccessDetails accessDetails() {
        return this.accessDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.disbursementDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumableDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.creditDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FulfillmentDetails)) {
            return false;
        }
        FulfillmentDetails other = (FulfillmentDetails)obj;
        return Objects.equals(this.disbursementDetails(), other.disbursementDetails()) && Objects.equals(this.consumableDetails(), other.consumableDetails()) && Objects.equals(this.creditDetails(), other.creditDetails()) && Objects.equals(this.accessDetails(), other.accessDetails());
    }

    public final String toString() {
        return ToString.builder((String)"FulfillmentDetails").add("DisbursementDetails", (Object)this.disbursementDetails()).add("ConsumableDetails", (Object)this.consumableDetails()).add("CreditDetails", (Object)this.creditDetails()).add("AccessDetails", (Object)this.accessDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DisbursementDetails": {
                return Optional.ofNullable(clazz.cast(this.disbursementDetails()));
            }
            case "ConsumableDetails": {
                return Optional.ofNullable(clazz.cast(this.consumableDetails()));
            }
            case "CreditDetails": {
                return Optional.ofNullable(clazz.cast(this.creditDetails()));
            }
            case "AccessDetails": {
                return Optional.ofNullable(clazz.cast(this.accessDetails()));
            }
        }
        return Optional.empty();
    }

    public static FulfillmentDetails fromDisbursementDetails(DisbursementDetails disbursementDetails) {
        return (FulfillmentDetails)FulfillmentDetails.builder().disbursementDetails(disbursementDetails).build();
    }

    public static FulfillmentDetails fromDisbursementDetails(Consumer<DisbursementDetails.Builder> disbursementDetails) {
        DisbursementDetails.Builder builder = DisbursementDetails.builder();
        disbursementDetails.accept(builder);
        return FulfillmentDetails.fromDisbursementDetails((DisbursementDetails)builder.build());
    }

    public static FulfillmentDetails fromConsumableDetails(ConsumableDetails consumableDetails) {
        return (FulfillmentDetails)FulfillmentDetails.builder().consumableDetails(consumableDetails).build();
    }

    public static FulfillmentDetails fromConsumableDetails(Consumer<ConsumableDetails.Builder> consumableDetails) {
        ConsumableDetails.Builder builder = ConsumableDetails.builder();
        consumableDetails.accept(builder);
        return FulfillmentDetails.fromConsumableDetails((ConsumableDetails)builder.build());
    }

    public static FulfillmentDetails fromCreditDetails(CreditDetails creditDetails) {
        return (FulfillmentDetails)FulfillmentDetails.builder().creditDetails(creditDetails).build();
    }

    public static FulfillmentDetails fromCreditDetails(Consumer<CreditDetails.Builder> creditDetails) {
        CreditDetails.Builder builder = CreditDetails.builder();
        creditDetails.accept(builder);
        return FulfillmentDetails.fromCreditDetails((CreditDetails)builder.build());
    }

    public static FulfillmentDetails fromAccessDetails(AccessDetails accessDetails) {
        return (FulfillmentDetails)FulfillmentDetails.builder().accessDetails(accessDetails).build();
    }

    public static FulfillmentDetails fromAccessDetails(Consumer<AccessDetails.Builder> accessDetails) {
        AccessDetails.Builder builder = AccessDetails.builder();
        accessDetails.accept(builder);
        return FulfillmentDetails.fromAccessDetails((AccessDetails)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DisbursementDetails", DISBURSEMENT_DETAILS_FIELD);
        map.put("ConsumableDetails", CONSUMABLE_DETAILS_FIELD);
        map.put("CreditDetails", CREDIT_DETAILS_FIELD);
        map.put("AccessDetails", ACCESS_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FulfillmentDetails, T> g) {
        return obj -> g.apply((FulfillmentDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        DISBURSEMENT_DETAILS,
        CONSUMABLE_DETAILS,
        CREDIT_DETAILS,
        ACCESS_DETAILS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private DisbursementDetails disbursementDetails;
        private ConsumableDetails consumableDetails;
        private CreditDetails creditDetails;
        private AccessDetails accessDetails;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FulfillmentDetails model) {
            this.disbursementDetails(model.disbursementDetails);
            this.consumableDetails(model.consumableDetails);
            this.creditDetails(model.creditDetails);
            this.accessDetails(model.accessDetails);
        }

        public final DisbursementDetails.Builder getDisbursementDetails() {
            return this.disbursementDetails != null ? this.disbursementDetails.toBuilder() : null;
        }

        public final void setDisbursementDetails(DisbursementDetails.BuilderImpl disbursementDetails) {
            DisbursementDetails oldValue = this.disbursementDetails;
            this.disbursementDetails = disbursementDetails != null ? disbursementDetails.build() : null;
            this.handleUnionValueChange(Type.DISBURSEMENT_DETAILS, oldValue, this.disbursementDetails);
        }

        @Override
        public final Builder disbursementDetails(DisbursementDetails disbursementDetails) {
            DisbursementDetails oldValue = this.disbursementDetails;
            this.disbursementDetails = disbursementDetails;
            this.handleUnionValueChange(Type.DISBURSEMENT_DETAILS, oldValue, this.disbursementDetails);
            return this;
        }

        public final ConsumableDetails.Builder getConsumableDetails() {
            return this.consumableDetails != null ? this.consumableDetails.toBuilder() : null;
        }

        public final void setConsumableDetails(ConsumableDetails.BuilderImpl consumableDetails) {
            ConsumableDetails oldValue = this.consumableDetails;
            this.consumableDetails = consumableDetails != null ? consumableDetails.build() : null;
            this.handleUnionValueChange(Type.CONSUMABLE_DETAILS, oldValue, this.consumableDetails);
        }

        @Override
        public final Builder consumableDetails(ConsumableDetails consumableDetails) {
            ConsumableDetails oldValue = this.consumableDetails;
            this.consumableDetails = consumableDetails;
            this.handleUnionValueChange(Type.CONSUMABLE_DETAILS, oldValue, this.consumableDetails);
            return this;
        }

        public final CreditDetails.Builder getCreditDetails() {
            return this.creditDetails != null ? this.creditDetails.toBuilder() : null;
        }

        public final void setCreditDetails(CreditDetails.BuilderImpl creditDetails) {
            CreditDetails oldValue = this.creditDetails;
            this.creditDetails = creditDetails != null ? creditDetails.build() : null;
            this.handleUnionValueChange(Type.CREDIT_DETAILS, oldValue, this.creditDetails);
        }

        @Override
        public final Builder creditDetails(CreditDetails creditDetails) {
            CreditDetails oldValue = this.creditDetails;
            this.creditDetails = creditDetails;
            this.handleUnionValueChange(Type.CREDIT_DETAILS, oldValue, this.creditDetails);
            return this;
        }

        public final AccessDetails.Builder getAccessDetails() {
            return this.accessDetails != null ? this.accessDetails.toBuilder() : null;
        }

        public final void setAccessDetails(AccessDetails.BuilderImpl accessDetails) {
            AccessDetails oldValue = this.accessDetails;
            this.accessDetails = accessDetails != null ? accessDetails.build() : null;
            this.handleUnionValueChange(Type.ACCESS_DETAILS, oldValue, this.accessDetails);
        }

        @Override
        public final Builder accessDetails(AccessDetails accessDetails) {
            AccessDetails oldValue = this.accessDetails;
            this.accessDetails = accessDetails;
            this.handleUnionValueChange(Type.ACCESS_DETAILS, oldValue, this.accessDetails);
            return this;
        }

        public FulfillmentDetails build() {
            return new FulfillmentDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FulfillmentDetails> {
        public Builder disbursementDetails(DisbursementDetails var1);

        default public Builder disbursementDetails(Consumer<DisbursementDetails.Builder> disbursementDetails) {
            return this.disbursementDetails((DisbursementDetails)((DisbursementDetails.Builder)DisbursementDetails.builder().applyMutation(disbursementDetails)).build());
        }

        public Builder consumableDetails(ConsumableDetails var1);

        default public Builder consumableDetails(Consumer<ConsumableDetails.Builder> consumableDetails) {
            return this.consumableDetails((ConsumableDetails)((ConsumableDetails.Builder)ConsumableDetails.builder().applyMutation(consumableDetails)).build());
        }

        public Builder creditDetails(CreditDetails var1);

        default public Builder creditDetails(Consumer<CreditDetails.Builder> creditDetails) {
            return this.creditDetails((CreditDetails)((CreditDetails.Builder)CreditDetails.builder().applyMutation(creditDetails)).build());
        }

        public Builder accessDetails(AccessDetails var1);

        default public Builder accessDetails(Consumer<AccessDetails.Builder> accessDetails) {
            return this.accessDetails((AccessDetails)((AccessDetails.Builder)AccessDetails.builder().applyMutation(accessDetails)).build());
        }
    }
}

