/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CurrencyCode {
    AED("AED"),
    AMD("AMD"),
    ARS("ARS"),
    AUD("AUD"),
    AWG("AWG"),
    AZN("AZN"),
    BBD("BBD"),
    BDT("BDT"),
    BGN("BGN"),
    BMD("BMD"),
    BND("BND"),
    BOB("BOB"),
    BRL("BRL"),
    BSD("BSD"),
    BYR("BYR"),
    BZD("BZD"),
    CAD("CAD"),
    CHF("CHF"),
    CLP("CLP"),
    CNY("CNY"),
    COP("COP"),
    CRC("CRC"),
    CZK("CZK"),
    DKK("DKK"),
    DOP("DOP"),
    EEK("EEK"),
    EGP("EGP"),
    EUR("EUR"),
    GBP("GBP"),
    GEL("GEL"),
    GHS("GHS"),
    GTQ("GTQ"),
    GYD("GYD"),
    HKD("HKD"),
    HNL("HNL"),
    HRK("HRK"),
    HTG("HTG"),
    HUF("HUF"),
    IDR("IDR"),
    ILS("ILS"),
    INR("INR"),
    ISK("ISK"),
    JMD("JMD"),
    JPY("JPY"),
    KES("KES"),
    KHR("KHR"),
    KRW("KRW"),
    KYD("KYD"),
    KZT("KZT"),
    LBP("LBP"),
    LKR("LKR"),
    LTL("LTL"),
    LVL("LVL"),
    MAD("MAD"),
    MNT("MNT"),
    MOP("MOP"),
    MUR("MUR"),
    MVR("MVR"),
    MXN("MXN"),
    MYR("MYR"),
    NAD("NAD"),
    NGN("NGN"),
    NIO("NIO"),
    NOK("NOK"),
    NZD("NZD"),
    PAB("PAB"),
    PEN("PEN"),
    PHP("PHP"),
    PKR("PKR"),
    PLN("PLN"),
    PYG("PYG"),
    QAR("QAR"),
    RON("RON"),
    RUB("RUB"),
    SAR("SAR"),
    SEK("SEK"),
    SGD("SGD"),
    SIT("SIT"),
    SKK("SKK"),
    THB("THB"),
    TND("TND"),
    TRY("TRY"),
    TTD("TTD"),
    TWD("TWD"),
    TZS("TZS"),
    UAH("UAH"),
    USD("USD"),
    UYU("UYU"),
    UZS("UZS"),
    VND("VND"),
    XAF("XAF"),
    XCD("XCD"),
    XOF("XOF"),
    XPF("XPF"),
    ZAR("ZAR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CurrencyCode> VALUE_MAP;
    private final String value;

    private CurrencyCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CurrencyCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CurrencyCode> knownValues() {
        EnumSet<CurrencyCode> knownValues = EnumSet.allOf(CurrencyCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CurrencyCode.class, CurrencyCode::toString);
    }
}

