/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralbenefits.model.BenefitAllocationStatus;
import software.amazon.awssdk.services.partnercentralbenefits.model.FulfillmentType;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsInputBenefitApplicationIdentifiersListCopier;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsInputBenefitIdentifiersListCopier;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsInputFulfillmentTypesListCopier;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsInputStatusListCopier;
import software.amazon.awssdk.services.partnercentralbenefits.model.PartnerCentralBenefitsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBenefitAllocationsRequest
extends PartnerCentralBenefitsRequest
implements ToCopyableBuilder<Builder, ListBenefitAllocationsRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(ListBenefitAllocationsRequest.getter(ListBenefitAllocationsRequest::catalog)).setter(ListBenefitAllocationsRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<List<String>> FULFILLMENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FulfillmentTypes").getter(ListBenefitAllocationsRequest.getter(ListBenefitAllocationsRequest::fulfillmentTypesAsStrings)).setter(ListBenefitAllocationsRequest.setter(Builder::fulfillmentTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FulfillmentTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> BENEFIT_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BenefitIdentifiers").getter(ListBenefitAllocationsRequest.getter(ListBenefitAllocationsRequest::benefitIdentifiers)).setter(ListBenefitAllocationsRequest.setter(Builder::benefitIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BenefitIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> BENEFIT_APPLICATION_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BenefitApplicationIdentifiers").getter(ListBenefitAllocationsRequest.getter(ListBenefitAllocationsRequest::benefitApplicationIdentifiers)).setter(ListBenefitAllocationsRequest.setter(Builder::benefitApplicationIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BenefitApplicationIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Status").getter(ListBenefitAllocationsRequest.getter(ListBenefitAllocationsRequest::statusAsStrings)).setter(ListBenefitAllocationsRequest.setter(Builder::statusWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListBenefitAllocationsRequest.getter(ListBenefitAllocationsRequest::maxResults)).setter(ListBenefitAllocationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListBenefitAllocationsRequest.getter(ListBenefitAllocationsRequest::nextToken)).setter(ListBenefitAllocationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, FULFILLMENT_TYPES_FIELD, BENEFIT_IDENTIFIERS_FIELD, BENEFIT_APPLICATION_IDENTIFIERS_FIELD, STATUS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListBenefitAllocationsRequest.memberNameToFieldInitializer();
    private final String catalog;
    private final List<String> fulfillmentTypes;
    private final List<String> benefitIdentifiers;
    private final List<String> benefitApplicationIdentifiers;
    private final List<String> status;
    private final Integer maxResults;
    private final String nextToken;

    private ListBenefitAllocationsRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.fulfillmentTypes = builder.fulfillmentTypes;
        this.benefitIdentifiers = builder.benefitIdentifiers;
        this.benefitApplicationIdentifiers = builder.benefitApplicationIdentifiers;
        this.status = builder.status;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final List<FulfillmentType> fulfillmentTypes() {
        return ListBenefitAllocationsInputFulfillmentTypesListCopier.copyStringToEnum(this.fulfillmentTypes);
    }

    public final boolean hasFulfillmentTypes() {
        return this.fulfillmentTypes != null && !(this.fulfillmentTypes instanceof SdkAutoConstructList);
    }

    public final List<String> fulfillmentTypesAsStrings() {
        return this.fulfillmentTypes;
    }

    public final boolean hasBenefitIdentifiers() {
        return this.benefitIdentifiers != null && !(this.benefitIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> benefitIdentifiers() {
        return this.benefitIdentifiers;
    }

    public final boolean hasBenefitApplicationIdentifiers() {
        return this.benefitApplicationIdentifiers != null && !(this.benefitApplicationIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> benefitApplicationIdentifiers() {
        return this.benefitApplicationIdentifiers;
    }

    public final List<BenefitAllocationStatus> status() {
        return ListBenefitAllocationsInputStatusListCopier.copyStringToEnum(this.status);
    }

    public final boolean hasStatus() {
        return this.status != null && !(this.status instanceof SdkAutoConstructList);
    }

    public final List<String> statusAsStrings() {
        return this.status;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFulfillmentTypes() ? this.fulfillmentTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBenefitIdentifiers() ? this.benefitIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBenefitApplicationIdentifiers() ? this.benefitApplicationIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatus() ? this.statusAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBenefitAllocationsRequest)) {
            return false;
        }
        ListBenefitAllocationsRequest other = (ListBenefitAllocationsRequest)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && this.hasFulfillmentTypes() == other.hasFulfillmentTypes() && Objects.equals(this.fulfillmentTypesAsStrings(), other.fulfillmentTypesAsStrings()) && this.hasBenefitIdentifiers() == other.hasBenefitIdentifiers() && Objects.equals(this.benefitIdentifiers(), other.benefitIdentifiers()) && this.hasBenefitApplicationIdentifiers() == other.hasBenefitApplicationIdentifiers() && Objects.equals(this.benefitApplicationIdentifiers(), other.benefitApplicationIdentifiers()) && this.hasStatus() == other.hasStatus() && Objects.equals(this.statusAsStrings(), other.statusAsStrings()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBenefitAllocationsRequest").add("Catalog", (Object)this.catalog()).add("FulfillmentTypes", this.hasFulfillmentTypes() ? this.fulfillmentTypesAsStrings() : null).add("BenefitIdentifiers", this.hasBenefitIdentifiers() ? this.benefitIdentifiers() : null).add("BenefitApplicationIdentifiers", this.hasBenefitApplicationIdentifiers() ? this.benefitApplicationIdentifiers() : null).add("Status", this.hasStatus() ? this.statusAsStrings() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "FulfillmentTypes": {
                return Optional.ofNullable(clazz.cast(this.fulfillmentTypesAsStrings()));
            }
            case "BenefitIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.benefitIdentifiers()));
            }
            case "BenefitApplicationIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.benefitApplicationIdentifiers()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsStrings()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("FulfillmentTypes", FULFILLMENT_TYPES_FIELD);
        map.put("BenefitIdentifiers", BENEFIT_IDENTIFIERS_FIELD);
        map.put("BenefitApplicationIdentifiers", BENEFIT_APPLICATION_IDENTIFIERS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBenefitAllocationsRequest, T> g) {
        return obj -> g.apply((ListBenefitAllocationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralBenefitsRequest.BuilderImpl
    implements Builder {
        private String catalog;
        private List<String> fulfillmentTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> benefitIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private List<String> benefitApplicationIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private List<String> status = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBenefitAllocationsRequest model) {
            super(model);
            this.catalog(model.catalog);
            this.fulfillmentTypesWithStrings(model.fulfillmentTypes);
            this.benefitIdentifiers(model.benefitIdentifiers);
            this.benefitApplicationIdentifiers(model.benefitApplicationIdentifiers);
            this.statusWithStrings(model.status);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final Collection<String> getFulfillmentTypes() {
            if (this.fulfillmentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fulfillmentTypes;
        }

        public final void setFulfillmentTypes(Collection<String> fulfillmentTypes) {
            this.fulfillmentTypes = ListBenefitAllocationsInputFulfillmentTypesListCopier.copy(fulfillmentTypes);
        }

        @Override
        public final Builder fulfillmentTypesWithStrings(Collection<String> fulfillmentTypes) {
            this.fulfillmentTypes = ListBenefitAllocationsInputFulfillmentTypesListCopier.copy(fulfillmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fulfillmentTypesWithStrings(String ... fulfillmentTypes) {
            this.fulfillmentTypesWithStrings(Arrays.asList(fulfillmentTypes));
            return this;
        }

        @Override
        public final Builder fulfillmentTypes(Collection<FulfillmentType> fulfillmentTypes) {
            this.fulfillmentTypes = ListBenefitAllocationsInputFulfillmentTypesListCopier.copyEnumToString(fulfillmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fulfillmentTypes(FulfillmentType ... fulfillmentTypes) {
            this.fulfillmentTypes(Arrays.asList(fulfillmentTypes));
            return this;
        }

        public final Collection<String> getBenefitIdentifiers() {
            if (this.benefitIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.benefitIdentifiers;
        }

        public final void setBenefitIdentifiers(Collection<String> benefitIdentifiers) {
            this.benefitIdentifiers = ListBenefitAllocationsInputBenefitIdentifiersListCopier.copy(benefitIdentifiers);
        }

        @Override
        public final Builder benefitIdentifiers(Collection<String> benefitIdentifiers) {
            this.benefitIdentifiers = ListBenefitAllocationsInputBenefitIdentifiersListCopier.copy(benefitIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder benefitIdentifiers(String ... benefitIdentifiers) {
            this.benefitIdentifiers(Arrays.asList(benefitIdentifiers));
            return this;
        }

        public final Collection<String> getBenefitApplicationIdentifiers() {
            if (this.benefitApplicationIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.benefitApplicationIdentifiers;
        }

        public final void setBenefitApplicationIdentifiers(Collection<String> benefitApplicationIdentifiers) {
            this.benefitApplicationIdentifiers = ListBenefitAllocationsInputBenefitApplicationIdentifiersListCopier.copy(benefitApplicationIdentifiers);
        }

        @Override
        public final Builder benefitApplicationIdentifiers(Collection<String> benefitApplicationIdentifiers) {
            this.benefitApplicationIdentifiers = ListBenefitAllocationsInputBenefitApplicationIdentifiersListCopier.copy(benefitApplicationIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder benefitApplicationIdentifiers(String ... benefitApplicationIdentifiers) {
            this.benefitApplicationIdentifiers(Arrays.asList(benefitApplicationIdentifiers));
            return this;
        }

        public final Collection<String> getStatus() {
            if (this.status instanceof SdkAutoConstructList) {
                return null;
            }
            return this.status;
        }

        public final void setStatus(Collection<String> status) {
            this.status = ListBenefitAllocationsInputStatusListCopier.copy(status);
        }

        @Override
        public final Builder statusWithStrings(Collection<String> status) {
            this.status = ListBenefitAllocationsInputStatusListCopier.copy(status);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusWithStrings(String ... status) {
            this.statusWithStrings(Arrays.asList(status));
            return this;
        }

        @Override
        public final Builder status(Collection<BenefitAllocationStatus> status) {
            this.status = ListBenefitAllocationsInputStatusListCopier.copyEnumToString(status);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder status(BenefitAllocationStatus ... status) {
            this.status(Arrays.asList(status));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBenefitAllocationsRequest build() {
            return new ListBenefitAllocationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralBenefitsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBenefitAllocationsRequest> {
        public Builder catalog(String var1);

        public Builder fulfillmentTypesWithStrings(Collection<String> var1);

        public Builder fulfillmentTypesWithStrings(String ... var1);

        public Builder fulfillmentTypes(Collection<FulfillmentType> var1);

        public Builder fulfillmentTypes(FulfillmentType ... var1);

        public Builder benefitIdentifiers(Collection<String> var1);

        public Builder benefitIdentifiers(String ... var1);

        public Builder benefitApplicationIdentifiers(Collection<String> var1);

        public Builder benefitApplicationIdentifiers(String ... var1);

        public Builder statusWithStrings(Collection<String> var1);

        public Builder statusWithStrings(String ... var1);

        public Builder status(Collection<BenefitAllocationStatus> var1);

        public Builder status(BenefitAllocationStatus ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

