/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a field-specific validation error with detailed information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidationExceptionField implements SdkPojo, Serializable,
        ToCopyableBuilder<ValidationExceptionField.Builder, ValidationExceptionField> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ValidationExceptionField::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(ValidationExceptionField::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Code")
            .getter(getter(ValidationExceptionField::codeAsString)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MESSAGE_FIELD,
            CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String message;

    private final String code;

    private ValidationExceptionField(BuilderImpl builder) {
        this.name = builder.name;
        this.message = builder.message;
        this.code = builder.code;
    }

    /**
     * <p>
     * The name of the field that failed validation.
     * </p>
     * 
     * @return The name of the field that failed validation.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A detailed message explaining why the field validation failed.
     * </p>
     * 
     * @return A detailed message explaining why the field validation failed.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * An error code explaining why the field validation failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link ValidationExceptionErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #codeAsString}.
     * </p>
     * 
     * @return An error code explaining why the field validation failed.
     * @see ValidationExceptionErrorCode
     */
    public final ValidationExceptionErrorCode code() {
        return ValidationExceptionErrorCode.fromValue(code);
    }

    /**
     * <p>
     * An error code explaining why the field validation failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link ValidationExceptionErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #codeAsString}.
     * </p>
     * 
     * @return An error code explaining why the field validation failed.
     * @see ValidationExceptionErrorCode
     */
    public final String codeAsString() {
        return code;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(codeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationExceptionField)) {
            return false;
        }
        ValidationExceptionField other = (ValidationExceptionField) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(message(), other.message())
                && Objects.equals(codeAsString(), other.codeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValidationExceptionField").add("Name", name()).add("Message", message())
                .add("Code", codeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "Code":
            return Optional.ofNullable(clazz.cast(codeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("Code", CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidationExceptionField, T> g) {
        return obj -> g.apply((ValidationExceptionField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValidationExceptionField> {
        /**
         * <p>
         * The name of the field that failed validation.
         * </p>
         * 
         * @param name
         *        The name of the field that failed validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A detailed message explaining why the field validation failed.
         * </p>
         * 
         * @param message
         *        A detailed message explaining why the field validation failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * An error code explaining why the field validation failed.
         * </p>
         * 
         * @param code
         *        An error code explaining why the field validation failed.
         * @see ValidationExceptionErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationExceptionErrorCode
         */
        Builder code(String code);

        /**
         * <p>
         * An error code explaining why the field validation failed.
         * </p>
         * 
         * @param code
         *        An error code explaining why the field validation failed.
         * @see ValidationExceptionErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationExceptionErrorCode
         */
        Builder code(ValidationExceptionErrorCode code);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String message;

        private String code;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationExceptionField model) {
            name(model.name);
            message(model.message);
            code(model.code);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(ValidationExceptionErrorCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        @Override
        public ValidationExceptionField build() {
            return new ValidationExceptionField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
