/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBenefitApplicationRequest extends PartnerCentralBenefitsRequest implements
        ToCopyableBuilder<UpdateBenefitApplicationRequest.Builder, UpdateBenefitApplicationRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(UpdateBenefitApplicationRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(UpdateBenefitApplicationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateBenefitApplicationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateBenefitApplicationRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(UpdateBenefitApplicationRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<String> REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Revision").getter(getter(UpdateBenefitApplicationRequest::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Revision").build()).build();

    private static final SdkField<Document> BENEFIT_APPLICATION_DETAILS_FIELD = SdkField
            .<Document> builder(MarshallingType.DOCUMENT).memberName("BenefitApplicationDetails")
            .getter(getter(UpdateBenefitApplicationRequest::benefitApplicationDetails))
            .setter(setter(Builder::benefitApplicationDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BenefitApplicationDetails").build())
            .build();

    private static final SdkField<List<Contact>> PARTNER_CONTACTS_FIELD = SdkField
            .<List<Contact>> builder(MarshallingType.LIST)
            .memberName("PartnerContacts")
            .getter(getter(UpdateBenefitApplicationRequest::partnerContacts))
            .setter(setter(Builder::partnerContacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerContacts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Contact> builder(MarshallingType.SDK_POJO)
                                            .constructor(Contact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FileInput>> FILE_DETAILS_FIELD = SdkField
            .<List<FileInput>> builder(MarshallingType.LIST)
            .memberName("FileDetails")
            .getter(getter(UpdateBenefitApplicationRequest::fileDetails))
            .setter(setter(Builder::fileDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FileInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(FileInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD,
            CLIENT_TOKEN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, IDENTIFIER_FIELD, REVISION_FIELD,
            BENEFIT_APPLICATION_DETAILS_FIELD, PARTNER_CONTACTS_FIELD, FILE_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final String clientToken;

    private final String name;

    private final String description;

    private final String identifier;

    private final String revision;

    private final Document benefitApplicationDetails;

    private final List<Contact> partnerContacts;

    private final List<FileInput> fileDetails;

    private UpdateBenefitApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.clientToken = builder.clientToken;
        this.name = builder.name;
        this.description = builder.description;
        this.identifier = builder.identifier;
        this.revision = builder.revision;
        this.benefitApplicationDetails = builder.benefitApplicationDetails;
        this.partnerContacts = builder.partnerContacts;
        this.fileDetails = builder.fileDetails;
    }

    /**
     * <p>
     * The catalog identifier that specifies which benefit catalog the application belongs to.
     * </p>
     * 
     * @return The catalog identifier that specifies which benefit catalog the application belongs to.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure idempotent processing of the update request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure idempotent processing of the update request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The updated human-readable name for the benefit application.
     * </p>
     * 
     * @return The updated human-readable name for the benefit application.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The updated detailed description of the benefit application.
     * </p>
     * 
     * @return The updated detailed description of the benefit application.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The unique identifier of the benefit application to update.
     * </p>
     * 
     * @return The unique identifier of the benefit application to update.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The current revision number of the benefit application to ensure optimistic concurrency control.
     * </p>
     * 
     * @return The current revision number of the benefit application to ensure optimistic concurrency control.
     */
    public final String revision() {
        return revision;
    }

    /**
     * <p>
     * Updated detailed information and requirements specific to the benefit being requested.
     * </p>
     * 
     * @return Updated detailed information and requirements specific to the benefit being requested.
     */
    public final Document benefitApplicationDetails() {
        return benefitApplicationDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the PartnerContacts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPartnerContacts() {
        return partnerContacts != null && !(partnerContacts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Updated contact information for partner representatives responsible for this benefit application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPartnerContacts} method.
     * </p>
     * 
     * @return Updated contact information for partner representatives responsible for this benefit application.
     */
    public final List<Contact> partnerContacts() {
        return partnerContacts;
    }

    /**
     * For responses, this returns true if the service returned a value for the FileDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFileDetails() {
        return fileDetails != null && !(fileDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Updated supporting documents and files attached to the benefit application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFileDetails} method.
     * </p>
     * 
     * @return Updated supporting documents and files attached to the benefit application.
     */
    public final List<FileInput> fileDetails() {
        return fileDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        hashCode = 31 * hashCode + Objects.hashCode(benefitApplicationDetails());
        hashCode = 31 * hashCode + Objects.hashCode(hasPartnerContacts() ? partnerContacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFileDetails() ? fileDetails() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBenefitApplicationRequest)) {
            return false;
        }
        UpdateBenefitApplicationRequest other = (UpdateBenefitApplicationRequest) obj;
        return Objects.equals(catalog(), other.catalog()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(identifier(), other.identifier()) && Objects.equals(revision(), other.revision())
                && Objects.equals(benefitApplicationDetails(), other.benefitApplicationDetails())
                && hasPartnerContacts() == other.hasPartnerContacts()
                && Objects.equals(partnerContacts(), other.partnerContacts()) && hasFileDetails() == other.hasFileDetails()
                && Objects.equals(fileDetails(), other.fileDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBenefitApplicationRequest").add("Catalog", catalog()).add("ClientToken", clientToken())
                .add("Name", name()).add("Description", description()).add("Identifier", identifier())
                .add("Revision", revision()).add("BenefitApplicationDetails", benefitApplicationDetails())
                .add("PartnerContacts", hasPartnerContacts() ? partnerContacts() : null)
                .add("FileDetails", hasFileDetails() ? fileDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "Revision":
            return Optional.ofNullable(clazz.cast(revision()));
        case "BenefitApplicationDetails":
            return Optional.ofNullable(clazz.cast(benefitApplicationDetails()));
        case "PartnerContacts":
            return Optional.ofNullable(clazz.cast(partnerContacts()));
        case "FileDetails":
            return Optional.ofNullable(clazz.cast(fileDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("Revision", REVISION_FIELD);
        map.put("BenefitApplicationDetails", BENEFIT_APPLICATION_DETAILS_FIELD);
        map.put("PartnerContacts", PARTNER_CONTACTS_FIELD);
        map.put("FileDetails", FILE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateBenefitApplicationRequest, T> g) {
        return obj -> g.apply((UpdateBenefitApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PartnerCentralBenefitsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateBenefitApplicationRequest> {
        /**
         * <p>
         * The catalog identifier that specifies which benefit catalog the application belongs to.
         * </p>
         * 
         * @param catalog
         *        The catalog identifier that specifies which benefit catalog the application belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure idempotent processing of the update request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier to ensure idempotent processing of the update request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The updated human-readable name for the benefit application.
         * </p>
         * 
         * @param name
         *        The updated human-readable name for the benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The updated detailed description of the benefit application.
         * </p>
         * 
         * @param description
         *        The updated detailed description of the benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The unique identifier of the benefit application to update.
         * </p>
         * 
         * @param identifier
         *        The unique identifier of the benefit application to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The current revision number of the benefit application to ensure optimistic concurrency control.
         * </p>
         * 
         * @param revision
         *        The current revision number of the benefit application to ensure optimistic concurrency control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(String revision);

        /**
         * <p>
         * Updated detailed information and requirements specific to the benefit being requested.
         * </p>
         * 
         * @param benefitApplicationDetails
         *        Updated detailed information and requirements specific to the benefit being requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder benefitApplicationDetails(Document benefitApplicationDetails);

        /**
         * <p>
         * Updated contact information for partner representatives responsible for this benefit application.
         * </p>
         * 
         * @param partnerContacts
         *        Updated contact information for partner representatives responsible for this benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partnerContacts(Collection<Contact> partnerContacts);

        /**
         * <p>
         * Updated contact information for partner representatives responsible for this benefit application.
         * </p>
         * 
         * @param partnerContacts
         *        Updated contact information for partner representatives responsible for this benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partnerContacts(Contact... partnerContacts);

        /**
         * <p>
         * Updated contact information for partner representatives responsible for this benefit application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralbenefits.model.Contact.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.partnercentralbenefits.model.Contact#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralbenefits.model.Contact.Builder#build()} is called
         * immediately and its result is passed to {@link #partnerContacts(List<Contact>)}.
         * 
         * @param partnerContacts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.Contact.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partnerContacts(java.util.Collection<Contact>)
         */
        Builder partnerContacts(Consumer<Contact.Builder>... partnerContacts);

        /**
         * <p>
         * Updated supporting documents and files attached to the benefit application.
         * </p>
         * 
         * @param fileDetails
         *        Updated supporting documents and files attached to the benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileDetails(Collection<FileInput> fileDetails);

        /**
         * <p>
         * Updated supporting documents and files attached to the benefit application.
         * </p>
         * 
         * @param fileDetails
         *        Updated supporting documents and files attached to the benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileDetails(FileInput... fileDetails);

        /**
         * <p>
         * Updated supporting documents and files attached to the benefit application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralbenefits.model.FileInput.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.partnercentralbenefits.model.FileInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralbenefits.model.FileInput.Builder#build()} is called
         * immediately and its result is passed to {@link #fileDetails(List<FileInput>)}.
         * 
         * @param fileDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.FileInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileDetails(java.util.Collection<FileInput>)
         */
        Builder fileDetails(Consumer<FileInput.Builder>... fileDetails);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PartnerCentralBenefitsRequest.BuilderImpl implements Builder {
        private String catalog;

        private String clientToken;

        private String name;

        private String description;

        private String identifier;

        private String revision;

        private Document benefitApplicationDetails;

        private List<Contact> partnerContacts = DefaultSdkAutoConstructList.getInstance();

        private List<FileInput> fileDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBenefitApplicationRequest model) {
            super(model);
            catalog(model.catalog);
            clientToken(model.clientToken);
            name(model.name);
            description(model.description);
            identifier(model.identifier);
            revision(model.revision);
            benefitApplicationDetails(model.benefitApplicationDetails);
            partnerContacts(model.partnerContacts);
            fileDetails(model.fileDetails);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getRevision() {
            return revision;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public final Document getBenefitApplicationDetails() {
            return benefitApplicationDetails;
        }

        public final void setBenefitApplicationDetails(Document benefitApplicationDetails) {
            this.benefitApplicationDetails = benefitApplicationDetails;
        }

        @Override
        public final Builder benefitApplicationDetails(Document benefitApplicationDetails) {
            this.benefitApplicationDetails = benefitApplicationDetails;
            return this;
        }

        public final List<Contact.Builder> getPartnerContacts() {
            List<Contact.Builder> result = UpdateBenefitApplicationInputPartnerContactsListCopier
                    .copyToBuilder(this.partnerContacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPartnerContacts(Collection<Contact.BuilderImpl> partnerContacts) {
            this.partnerContacts = UpdateBenefitApplicationInputPartnerContactsListCopier.copyFromBuilder(partnerContacts);
        }

        @Override
        public final Builder partnerContacts(Collection<Contact> partnerContacts) {
            this.partnerContacts = UpdateBenefitApplicationInputPartnerContactsListCopier.copy(partnerContacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partnerContacts(Contact... partnerContacts) {
            partnerContacts(Arrays.asList(partnerContacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partnerContacts(Consumer<Contact.Builder>... partnerContacts) {
            partnerContacts(Stream.of(partnerContacts).map(c -> Contact.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<FileInput.Builder> getFileDetails() {
            List<FileInput.Builder> result = UpdateBenefitApplicationInputFileDetailsListCopier.copyToBuilder(this.fileDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileDetails(Collection<FileInput.BuilderImpl> fileDetails) {
            this.fileDetails = UpdateBenefitApplicationInputFileDetailsListCopier.copyFromBuilder(fileDetails);
        }

        @Override
        public final Builder fileDetails(Collection<FileInput> fileDetails) {
            this.fileDetails = UpdateBenefitApplicationInputFileDetailsListCopier.copy(fileDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileDetails(FileInput... fileDetails) {
            fileDetails(Arrays.asList(fileDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileDetails(Consumer<FileInput.Builder>... fileDetails) {
            fileDetails(Stream.of(fileDetails).map(c -> FileInput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBenefitApplicationRequest build() {
            return new UpdateBenefitApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
