/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBenefitApplicationsRequest extends PartnerCentralBenefitsRequest implements
        ToCopyableBuilder<ListBenefitApplicationsRequest.Builder, ListBenefitApplicationsRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(ListBenefitApplicationsRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<List<String>> PROGRAMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Programs")
            .getter(getter(ListBenefitApplicationsRequest::programs))
            .setter(setter(Builder::programs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Programs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> FULFILLMENT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FulfillmentTypes")
            .getter(getter(ListBenefitApplicationsRequest::fulfillmentTypesAsStrings))
            .setter(setter(Builder::fulfillmentTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FulfillmentTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> BENEFIT_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("BenefitIdentifiers")
            .getter(getter(ListBenefitApplicationsRequest::benefitIdentifiers))
            .setter(setter(Builder::benefitIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BenefitIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STATUS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Status")
            .getter(getter(ListBenefitApplicationsRequest::statusAsStrings))
            .setter(setter(Builder::statusWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STAGES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Stages")
            .getter(getter(ListBenefitApplicationsRequest::stages))
            .setter(setter(Builder::stages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssociatedResource>> ASSOCIATED_RESOURCES_FIELD = SdkField
            .<List<AssociatedResource>> builder(MarshallingType.LIST)
            .memberName("AssociatedResources")
            .getter(getter(ListBenefitApplicationsRequest::associatedResources))
            .setter(setter(Builder::associatedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssociatedResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssociatedResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ASSOCIATED_RESOURCE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AssociatedResourceArns")
            .getter(getter(ListBenefitApplicationsRequest::associatedResourceArns))
            .setter(setter(Builder::associatedResourceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResourceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListBenefitApplicationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListBenefitApplicationsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, PROGRAMS_FIELD,
            FULFILLMENT_TYPES_FIELD, BENEFIT_IDENTIFIERS_FIELD, STATUS_FIELD, STAGES_FIELD, ASSOCIATED_RESOURCES_FIELD,
            ASSOCIATED_RESOURCE_ARNS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final List<String> programs;

    private final List<String> fulfillmentTypes;

    private final List<String> benefitIdentifiers;

    private final List<String> status;

    private final List<String> stages;

    private final List<AssociatedResource> associatedResources;

    private final List<String> associatedResourceArns;

    private final Integer maxResults;

    private final String nextToken;

    private ListBenefitApplicationsRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.programs = builder.programs;
        this.fulfillmentTypes = builder.fulfillmentTypes;
        this.benefitIdentifiers = builder.benefitIdentifiers;
        this.status = builder.status;
        this.stages = builder.stages;
        this.associatedResources = builder.associatedResources;
        this.associatedResourceArns = builder.associatedResourceArns;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The catalog identifier to filter benefit applications by catalog.
     * </p>
     * 
     * @return The catalog identifier to filter benefit applications by catalog.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * For responses, this returns true if the service returned a value for the Programs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPrograms() {
        return programs != null && !(programs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter benefit applications by specific AWS partner programs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrograms} method.
     * </p>
     * 
     * @return Filter benefit applications by specific AWS partner programs.
     */
    public final List<String> programs() {
        return programs;
    }

    /**
     * <p>
     * Filter benefit applications by specific fulfillment types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFulfillmentTypes} method.
     * </p>
     * 
     * @return Filter benefit applications by specific fulfillment types.
     */
    public final List<FulfillmentType> fulfillmentTypes() {
        return ListBenefitApplicationsInputFulfillmentTypesListCopier.copyStringToEnum(fulfillmentTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the FulfillmentTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFulfillmentTypes() {
        return fulfillmentTypes != null && !(fulfillmentTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter benefit applications by specific fulfillment types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFulfillmentTypes} method.
     * </p>
     * 
     * @return Filter benefit applications by specific fulfillment types.
     */
    public final List<String> fulfillmentTypesAsStrings() {
        return fulfillmentTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the BenefitIdentifiers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBenefitIdentifiers() {
        return benefitIdentifiers != null && !(benefitIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter benefit applications by specific benefit identifiers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBenefitIdentifiers} method.
     * </p>
     * 
     * @return Filter benefit applications by specific benefit identifiers.
     */
    public final List<String> benefitIdentifiers() {
        return benefitIdentifiers;
    }

    /**
     * <p>
     * Filter benefit applications by their current processing status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatus} method.
     * </p>
     * 
     * @return Filter benefit applications by their current processing status.
     */
    public final List<BenefitApplicationStatus> status() {
        return ListBenefitApplicationsInputStatusListCopier.copyStringToEnum(status);
    }

    /**
     * For responses, this returns true if the service returned a value for the Status property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatus() {
        return status != null && !(status instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter benefit applications by their current processing status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatus} method.
     * </p>
     * 
     * @return Filter benefit applications by their current processing status.
     */
    public final List<String> statusAsStrings() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Stages property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStages() {
        return stages != null && !(stages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter benefit applications by their current processing stage.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStages} method.
     * </p>
     * 
     * @return Filter benefit applications by their current processing stage.
     */
    public final List<String> stages() {
        return stages;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedResources property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     *
     * @deprecated This field is no longer used.
     */
    @Deprecated
    public final boolean hasAssociatedResources() {
        return associatedResources != null && !(associatedResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter benefit applications by associated AWS resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedResources} method.
     * </p>
     * 
     * @return Filter benefit applications by associated AWS resources.
     * @deprecated This field is no longer used.
     */
    @Deprecated
    public final List<AssociatedResource> associatedResources() {
        return associatedResources;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedResourceArns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssociatedResourceArns() {
        return associatedResourceArns != null && !(associatedResourceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter benefit applications by specific AWS resource ARNs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedResourceArns} method.
     * </p>
     * 
     * @return Filter benefit applications by specific AWS resource ARNs.
     */
    public final List<String> associatedResourceArns() {
        return associatedResourceArns;
    }

    /**
     * <p>
     * The maximum number of benefit applications to return in a single response.
     * </p>
     * 
     * @return The maximum number of benefit applications to return in a single response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A pagination token to retrieve the next set of results from a previous request.
     * </p>
     * 
     * @return A pagination token to retrieve the next set of results from a previous request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrograms() ? programs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFulfillmentTypes() ? fulfillmentTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBenefitIdentifiers() ? benefitIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStatus() ? statusAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStages() ? stages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedResources() ? associatedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedResourceArns() ? associatedResourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBenefitApplicationsRequest)) {
            return false;
        }
        ListBenefitApplicationsRequest other = (ListBenefitApplicationsRequest) obj;
        return Objects.equals(catalog(), other.catalog()) && hasPrograms() == other.hasPrograms()
                && Objects.equals(programs(), other.programs()) && hasFulfillmentTypes() == other.hasFulfillmentTypes()
                && Objects.equals(fulfillmentTypesAsStrings(), other.fulfillmentTypesAsStrings())
                && hasBenefitIdentifiers() == other.hasBenefitIdentifiers()
                && Objects.equals(benefitIdentifiers(), other.benefitIdentifiers()) && hasStatus() == other.hasStatus()
                && Objects.equals(statusAsStrings(), other.statusAsStrings()) && hasStages() == other.hasStages()
                && Objects.equals(stages(), other.stages()) && hasAssociatedResources() == other.hasAssociatedResources()
                && Objects.equals(associatedResources(), other.associatedResources())
                && hasAssociatedResourceArns() == other.hasAssociatedResourceArns()
                && Objects.equals(associatedResourceArns(), other.associatedResourceArns())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBenefitApplicationsRequest").add("Catalog", catalog())
                .add("Programs", hasPrograms() ? programs() : null)
                .add("FulfillmentTypes", hasFulfillmentTypes() ? fulfillmentTypesAsStrings() : null)
                .add("BenefitIdentifiers", hasBenefitIdentifiers() ? benefitIdentifiers() : null)
                .add("Status", hasStatus() ? statusAsStrings() : null).add("Stages", hasStages() ? stages() : null)
                .add("AssociatedResources", hasAssociatedResources() ? associatedResources() : null)
                .add("AssociatedResourceArns", hasAssociatedResourceArns() ? associatedResourceArns() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "Programs":
            return Optional.ofNullable(clazz.cast(programs()));
        case "FulfillmentTypes":
            return Optional.ofNullable(clazz.cast(fulfillmentTypesAsStrings()));
        case "BenefitIdentifiers":
            return Optional.ofNullable(clazz.cast(benefitIdentifiers()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsStrings()));
        case "Stages":
            return Optional.ofNullable(clazz.cast(stages()));
        case "AssociatedResources":
            return Optional.ofNullable(clazz.cast(associatedResources()));
        case "AssociatedResourceArns":
            return Optional.ofNullable(clazz.cast(associatedResourceArns()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("Programs", PROGRAMS_FIELD);
        map.put("FulfillmentTypes", FULFILLMENT_TYPES_FIELD);
        map.put("BenefitIdentifiers", BENEFIT_IDENTIFIERS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Stages", STAGES_FIELD);
        map.put("AssociatedResources", ASSOCIATED_RESOURCES_FIELD);
        map.put("AssociatedResourceArns", ASSOCIATED_RESOURCE_ARNS_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBenefitApplicationsRequest, T> g) {
        return obj -> g.apply((ListBenefitApplicationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PartnerCentralBenefitsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListBenefitApplicationsRequest> {
        /**
         * <p>
         * The catalog identifier to filter benefit applications by catalog.
         * </p>
         * 
         * @param catalog
         *        The catalog identifier to filter benefit applications by catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * Filter benefit applications by specific AWS partner programs.
         * </p>
         * 
         * @param programs
         *        Filter benefit applications by specific AWS partner programs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programs(Collection<String> programs);

        /**
         * <p>
         * Filter benefit applications by specific AWS partner programs.
         * </p>
         * 
         * @param programs
         *        Filter benefit applications by specific AWS partner programs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programs(String... programs);

        /**
         * <p>
         * Filter benefit applications by specific fulfillment types.
         * </p>
         * 
         * @param fulfillmentTypes
         *        Filter benefit applications by specific fulfillment types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfillmentTypesWithStrings(Collection<String> fulfillmentTypes);

        /**
         * <p>
         * Filter benefit applications by specific fulfillment types.
         * </p>
         * 
         * @param fulfillmentTypes
         *        Filter benefit applications by specific fulfillment types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfillmentTypesWithStrings(String... fulfillmentTypes);

        /**
         * <p>
         * Filter benefit applications by specific fulfillment types.
         * </p>
         * 
         * @param fulfillmentTypes
         *        Filter benefit applications by specific fulfillment types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfillmentTypes(Collection<FulfillmentType> fulfillmentTypes);

        /**
         * <p>
         * Filter benefit applications by specific fulfillment types.
         * </p>
         * 
         * @param fulfillmentTypes
         *        Filter benefit applications by specific fulfillment types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfillmentTypes(FulfillmentType... fulfillmentTypes);

        /**
         * <p>
         * Filter benefit applications by specific benefit identifiers.
         * </p>
         * 
         * @param benefitIdentifiers
         *        Filter benefit applications by specific benefit identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder benefitIdentifiers(Collection<String> benefitIdentifiers);

        /**
         * <p>
         * Filter benefit applications by specific benefit identifiers.
         * </p>
         * 
         * @param benefitIdentifiers
         *        Filter benefit applications by specific benefit identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder benefitIdentifiers(String... benefitIdentifiers);

        /**
         * <p>
         * Filter benefit applications by their current processing status.
         * </p>
         * 
         * @param status
         *        Filter benefit applications by their current processing status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusWithStrings(Collection<String> status);

        /**
         * <p>
         * Filter benefit applications by their current processing status.
         * </p>
         * 
         * @param status
         *        Filter benefit applications by their current processing status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusWithStrings(String... status);

        /**
         * <p>
         * Filter benefit applications by their current processing status.
         * </p>
         * 
         * @param status
         *        Filter benefit applications by their current processing status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Collection<BenefitApplicationStatus> status);

        /**
         * <p>
         * Filter benefit applications by their current processing status.
         * </p>
         * 
         * @param status
         *        Filter benefit applications by their current processing status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(BenefitApplicationStatus... status);

        /**
         * <p>
         * Filter benefit applications by their current processing stage.
         * </p>
         * 
         * @param stages
         *        Filter benefit applications by their current processing stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stages(Collection<String> stages);

        /**
         * <p>
         * Filter benefit applications by their current processing stage.
         * </p>
         * 
         * @param stages
         *        Filter benefit applications by their current processing stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stages(String... stages);

        /**
         * <p>
         * Filter benefit applications by associated AWS resources.
         * </p>
         * 
         * @param associatedResources
         *        Filter benefit applications by associated AWS resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This field is no longer used.
         */
        @Deprecated
        Builder associatedResources(Collection<AssociatedResource> associatedResources);

        /**
         * <p>
         * Filter benefit applications by associated AWS resources.
         * </p>
         * 
         * @param associatedResources
         *        Filter benefit applications by associated AWS resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This field is no longer used.
         */
        @Deprecated
        Builder associatedResources(AssociatedResource... associatedResources);

        /**
         * <p>
         * Filter benefit applications by associated AWS resources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralbenefits.model.AssociatedResource.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.partnercentralbenefits.model.AssociatedResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralbenefits.model.AssociatedResource.Builder#build()} is
         * called immediately and its result is passed to {@link #associatedResources(List<AssociatedResource>)}.
         * 
         * @param associatedResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.AssociatedResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associatedResources(java.util.Collection<AssociatedResource>)
         * @deprecated This field is no longer used.
         */
        @Deprecated
        Builder associatedResources(Consumer<AssociatedResource.Builder>... associatedResources);

        /**
         * <p>
         * Filter benefit applications by specific AWS resource ARNs.
         * </p>
         * 
         * @param associatedResourceArns
         *        Filter benefit applications by specific AWS resource ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedResourceArns(Collection<String> associatedResourceArns);

        /**
         * <p>
         * Filter benefit applications by specific AWS resource ARNs.
         * </p>
         * 
         * @param associatedResourceArns
         *        Filter benefit applications by specific AWS resource ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedResourceArns(String... associatedResourceArns);

        /**
         * <p>
         * The maximum number of benefit applications to return in a single response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of benefit applications to return in a single response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A pagination token to retrieve the next set of results from a previous request.
         * </p>
         * 
         * @param nextToken
         *        A pagination token to retrieve the next set of results from a previous request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PartnerCentralBenefitsRequest.BuilderImpl implements Builder {
        private String catalog;

        private List<String> programs = DefaultSdkAutoConstructList.getInstance();

        private List<String> fulfillmentTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> benefitIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private List<String> status = DefaultSdkAutoConstructList.getInstance();

        private List<String> stages = DefaultSdkAutoConstructList.getInstance();

        private List<AssociatedResource> associatedResources = DefaultSdkAutoConstructList.getInstance();

        private List<String> associatedResourceArns = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBenefitApplicationsRequest model) {
            super(model);
            catalog(model.catalog);
            programs(model.programs);
            fulfillmentTypesWithStrings(model.fulfillmentTypes);
            benefitIdentifiers(model.benefitIdentifiers);
            statusWithStrings(model.status);
            stages(model.stages);
            associatedResources(model.associatedResources);
            associatedResourceArns(model.associatedResourceArns);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final Collection<String> getPrograms() {
            if (programs instanceof SdkAutoConstructList) {
                return null;
            }
            return programs;
        }

        public final void setPrograms(Collection<String> programs) {
            this.programs = ListBenefitApplicationsInputProgramsListCopier.copy(programs);
        }

        @Override
        public final Builder programs(Collection<String> programs) {
            this.programs = ListBenefitApplicationsInputProgramsListCopier.copy(programs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder programs(String... programs) {
            programs(Arrays.asList(programs));
            return this;
        }

        public final Collection<String> getFulfillmentTypes() {
            if (fulfillmentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return fulfillmentTypes;
        }

        public final void setFulfillmentTypes(Collection<String> fulfillmentTypes) {
            this.fulfillmentTypes = ListBenefitApplicationsInputFulfillmentTypesListCopier.copy(fulfillmentTypes);
        }

        @Override
        public final Builder fulfillmentTypesWithStrings(Collection<String> fulfillmentTypes) {
            this.fulfillmentTypes = ListBenefitApplicationsInputFulfillmentTypesListCopier.copy(fulfillmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fulfillmentTypesWithStrings(String... fulfillmentTypes) {
            fulfillmentTypesWithStrings(Arrays.asList(fulfillmentTypes));
            return this;
        }

        @Override
        public final Builder fulfillmentTypes(Collection<FulfillmentType> fulfillmentTypes) {
            this.fulfillmentTypes = ListBenefitApplicationsInputFulfillmentTypesListCopier.copyEnumToString(fulfillmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fulfillmentTypes(FulfillmentType... fulfillmentTypes) {
            fulfillmentTypes(Arrays.asList(fulfillmentTypes));
            return this;
        }

        public final Collection<String> getBenefitIdentifiers() {
            if (benefitIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return benefitIdentifiers;
        }

        public final void setBenefitIdentifiers(Collection<String> benefitIdentifiers) {
            this.benefitIdentifiers = ListBenefitApplicationsInputBenefitIdentifiersListCopier.copy(benefitIdentifiers);
        }

        @Override
        public final Builder benefitIdentifiers(Collection<String> benefitIdentifiers) {
            this.benefitIdentifiers = ListBenefitApplicationsInputBenefitIdentifiersListCopier.copy(benefitIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder benefitIdentifiers(String... benefitIdentifiers) {
            benefitIdentifiers(Arrays.asList(benefitIdentifiers));
            return this;
        }

        public final Collection<String> getStatus() {
            if (status instanceof SdkAutoConstructList) {
                return null;
            }
            return status;
        }

        public final void setStatus(Collection<String> status) {
            this.status = ListBenefitApplicationsInputStatusListCopier.copy(status);
        }

        @Override
        public final Builder statusWithStrings(Collection<String> status) {
            this.status = ListBenefitApplicationsInputStatusListCopier.copy(status);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusWithStrings(String... status) {
            statusWithStrings(Arrays.asList(status));
            return this;
        }

        @Override
        public final Builder status(Collection<BenefitApplicationStatus> status) {
            this.status = ListBenefitApplicationsInputStatusListCopier.copyEnumToString(status);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder status(BenefitApplicationStatus... status) {
            status(Arrays.asList(status));
            return this;
        }

        public final Collection<String> getStages() {
            if (stages instanceof SdkAutoConstructList) {
                return null;
            }
            return stages;
        }

        public final void setStages(Collection<String> stages) {
            this.stages = ListBenefitApplicationsInputStagesListCopier.copy(stages);
        }

        @Override
        public final Builder stages(Collection<String> stages) {
            this.stages = ListBenefitApplicationsInputStagesListCopier.copy(stages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stages(String... stages) {
            stages(Arrays.asList(stages));
            return this;
        }

        @Deprecated
        public final List<AssociatedResource.Builder> getAssociatedResources() {
            List<AssociatedResource.Builder> result = AssociatedResourcesCopier.copyToBuilder(this.associatedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Deprecated
        public final void setAssociatedResources(Collection<AssociatedResource.BuilderImpl> associatedResources) {
            this.associatedResources = AssociatedResourcesCopier.copyFromBuilder(associatedResources);
        }

        @Override
        @Deprecated
        public final Builder associatedResources(Collection<AssociatedResource> associatedResources) {
            this.associatedResources = AssociatedResourcesCopier.copy(associatedResources);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder associatedResources(AssociatedResource... associatedResources) {
            associatedResources(Arrays.asList(associatedResources));
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder associatedResources(Consumer<AssociatedResource.Builder>... associatedResources) {
            associatedResources(Stream.of(associatedResources).map(c -> AssociatedResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAssociatedResourceArns() {
            if (associatedResourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return associatedResourceArns;
        }

        public final void setAssociatedResourceArns(Collection<String> associatedResourceArns) {
            this.associatedResourceArns = ArnsCopier.copy(associatedResourceArns);
        }

        @Override
        public final Builder associatedResourceArns(Collection<String> associatedResourceArns) {
            this.associatedResourceArns = ArnsCopier.copy(associatedResourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedResourceArns(String... associatedResourceArns) {
            associatedResourceArns(Arrays.asList(associatedResourceArns));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBenefitApplicationsRequest build() {
            return new ListBenefitApplicationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
