/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBenefitApplicationResponse extends PartnerCentralBenefitsResponse implements
        ToCopyableBuilder<GetBenefitApplicationResponse.Builder, GetBenefitApplicationResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(GetBenefitApplicationResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetBenefitApplicationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(GetBenefitApplicationResponse::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<String> BENEFIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BenefitId").getter(getter(GetBenefitApplicationResponse::benefitId)).setter(setter(Builder::benefitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BenefitId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetBenefitApplicationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetBenefitApplicationResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<String>> FULFILLMENT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FulfillmentTypes")
            .getter(getter(GetBenefitApplicationResponse::fulfillmentTypesAsStrings))
            .setter(setter(Builder::fulfillmentTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FulfillmentTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Document> BENEFIT_APPLICATION_DETAILS_FIELD = SdkField
            .<Document> builder(MarshallingType.DOCUMENT).memberName("BenefitApplicationDetails")
            .getter(getter(GetBenefitApplicationResponse::benefitApplicationDetails))
            .setter(setter(Builder::benefitApplicationDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BenefitApplicationDetails").build())
            .build();

    private static final SdkField<List<String>> PROGRAMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Programs")
            .getter(getter(GetBenefitApplicationResponse::programs))
            .setter(setter(Builder::programs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Programs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetBenefitApplicationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Stage")
            .getter(getter(GetBenefitApplicationResponse::stage)).setter(setter(Builder::stage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stage").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(GetBenefitApplicationResponse::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<String> STATUS_REASON_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReasonCode").getter(getter(GetBenefitApplicationResponse::statusReasonCode))
            .setter(setter(Builder::statusReasonCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReasonCode").build()).build();

    private static final SdkField<List<String>> STATUS_REASON_CODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StatusReasonCodes")
            .getter(getter(GetBenefitApplicationResponse::statusReasonCodes))
            .setter(setter(Builder::statusReasonCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReasonCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(GetBenefitApplicationResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt")
            .getter(getter(GetBenefitApplicationResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Revision").getter(getter(GetBenefitApplicationResponse::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Revision").build()).build();

    private static final SdkField<List<String>> ASSOCIATED_RESOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AssociatedResources")
            .getter(getter(GetBenefitApplicationResponse::associatedResources))
            .setter(setter(Builder::associatedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Contact>> PARTNER_CONTACTS_FIELD = SdkField
            .<List<Contact>> builder(MarshallingType.LIST)
            .memberName("PartnerContacts")
            .getter(getter(GetBenefitApplicationResponse::partnerContacts))
            .setter(setter(Builder::partnerContacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerContacts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Contact> builder(MarshallingType.SDK_POJO)
                                            .constructor(Contact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FileDetail>> FILE_DETAILS_FIELD = SdkField
            .<List<FileDetail>> builder(MarshallingType.LIST)
            .memberName("FileDetails")
            .getter(getter(GetBenefitApplicationResponse::fileDetails))
            .setter(setter(Builder::fileDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FileDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(FileDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            CATALOG_FIELD, BENEFIT_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, FULFILLMENT_TYPES_FIELD,
            BENEFIT_APPLICATION_DETAILS_FIELD, PROGRAMS_FIELD, STATUS_FIELD, STAGE_FIELD, STATUS_REASON_FIELD,
            STATUS_REASON_CODE_FIELD, STATUS_REASON_CODES_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, REVISION_FIELD,
            ASSOCIATED_RESOURCES_FIELD, PARTNER_CONTACTS_FIELD, FILE_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String arn;

    private final String catalog;

    private final String benefitId;

    private final String name;

    private final String description;

    private final List<String> fulfillmentTypes;

    private final Document benefitApplicationDetails;

    private final List<String> programs;

    private final String status;

    private final String stage;

    private final String statusReason;

    private final String statusReasonCode;

    private final List<String> statusReasonCodes;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String revision;

    private final List<String> associatedResources;

    private final List<Contact> partnerContacts;

    private final List<FileDetail> fileDetails;

    private GetBenefitApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.catalog = builder.catalog;
        this.benefitId = builder.benefitId;
        this.name = builder.name;
        this.description = builder.description;
        this.fulfillmentTypes = builder.fulfillmentTypes;
        this.benefitApplicationDetails = builder.benefitApplicationDetails;
        this.programs = builder.programs;
        this.status = builder.status;
        this.stage = builder.stage;
        this.statusReason = builder.statusReason;
        this.statusReasonCode = builder.statusReasonCode;
        this.statusReasonCodes = builder.statusReasonCodes;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.revision = builder.revision;
        this.associatedResources = builder.associatedResources;
        this.partnerContacts = builder.partnerContacts;
        this.fileDetails = builder.fileDetails;
    }

    /**
     * <p>
     * The unique identifier of the benefit application.
     * </p>
     * 
     * @return The unique identifier of the benefit application.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the benefit application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the benefit application.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The catalog identifier that the benefit application belongs to.
     * </p>
     * 
     * @return The catalog identifier that the benefit application belongs to.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * The identifier of the benefit being requested in this application.
     * </p>
     * 
     * @return The identifier of the benefit being requested in this application.
     */
    public final String benefitId() {
        return benefitId;
    }

    /**
     * <p>
     * The human-readable name of the benefit application.
     * </p>
     * 
     * @return The human-readable name of the benefit application.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A detailed description of the benefit application.
     * </p>
     * 
     * @return A detailed description of the benefit application.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The fulfillment types requested for this benefit application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFulfillmentTypes} method.
     * </p>
     * 
     * @return The fulfillment types requested for this benefit application.
     */
    public final List<FulfillmentType> fulfillmentTypes() {
        return FulfillmentTypesCopier.copyStringToEnum(fulfillmentTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the FulfillmentTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFulfillmentTypes() {
        return fulfillmentTypes != null && !(fulfillmentTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The fulfillment types requested for this benefit application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFulfillmentTypes} method.
     * </p>
     * 
     * @return The fulfillment types requested for this benefit application.
     */
    public final List<String> fulfillmentTypesAsStrings() {
        return fulfillmentTypes;
    }

    /**
     * <p>
     * Detailed information and requirements specific to the benefit being requested.
     * </p>
     * 
     * @return Detailed information and requirements specific to the benefit being requested.
     */
    public final Document benefitApplicationDetails() {
        return benefitApplicationDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the Programs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPrograms() {
        return programs != null && !(programs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The AWS partner programs associated with this benefit application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrograms} method.
     * </p>
     * 
     * @return The AWS partner programs associated with this benefit application.
     */
    public final List<String> programs() {
        return programs;
    }

    /**
     * <p>
     * The current processing status of the benefit application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BenefitApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current processing status of the benefit application.
     * @see BenefitApplicationStatus
     */
    public final BenefitApplicationStatus status() {
        return BenefitApplicationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current processing status of the benefit application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BenefitApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current processing status of the benefit application.
     * @see BenefitApplicationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The current stage in the benefit application processing workflow.
     * </p>
     * 
     * @return The current stage in the benefit application processing workflow.
     */
    public final String stage() {
        return stage;
    }

    /**
     * <p>
     * Additional information explaining the current status of the benefit application.
     * </p>
     * 
     * @return Additional information explaining the current status of the benefit application.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * A standardized code representing the reason for the current status.
     * </p>
     * 
     * @return A standardized code representing the reason for the current status.
     * @deprecated This field is no longer used
     */
    @Deprecated
    public final String statusReasonCode() {
        return statusReasonCode;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatusReasonCodes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStatusReasonCodes() {
        return statusReasonCodes != null && !(statusReasonCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of standardized codes representing the reason for the current status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatusReasonCodes} method.
     * </p>
     * 
     * @return The list of standardized codes representing the reason for the current status.
     */
    public final List<String> statusReasonCodes() {
        return statusReasonCodes;
    }

    /**
     * <p>
     * The timestamp when the benefit application was created.
     * </p>
     * 
     * @return The timestamp when the benefit application was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the benefit application was last updated.
     * </p>
     * 
     * @return The timestamp when the benefit application was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The current revision number of the benefit application.
     * </p>
     * 
     * @return The current revision number of the benefit application.
     */
    public final String revision() {
        return revision;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedResources property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociatedResources() {
        return associatedResources != null && !(associatedResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * AWS resources that are associated with this benefit application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedResources} method.
     * </p>
     * 
     * @return AWS resources that are associated with this benefit application.
     */
    public final List<String> associatedResources() {
        return associatedResources;
    }

    /**
     * For responses, this returns true if the service returned a value for the PartnerContacts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPartnerContacts() {
        return partnerContacts != null && !(partnerContacts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contact information for partner representatives responsible for this benefit application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPartnerContacts} method.
     * </p>
     * 
     * @return Contact information for partner representatives responsible for this benefit application.
     */
    public final List<Contact> partnerContacts() {
        return partnerContacts;
    }

    /**
     * For responses, this returns true if the service returned a value for the FileDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFileDetails() {
        return fileDetails != null && !(fileDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Supporting documents and files attached to the benefit application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFileDetails} method.
     * </p>
     * 
     * @return Supporting documents and files attached to the benefit application.
     */
    public final List<FileDetail> fileDetails() {
        return fileDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(benefitId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasFulfillmentTypes() ? fulfillmentTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(benefitApplicationDetails());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrograms() ? programs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stage());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(statusReasonCode());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatusReasonCodes() ? statusReasonCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedResources() ? associatedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPartnerContacts() ? partnerContacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFileDetails() ? fileDetails() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBenefitApplicationResponse)) {
            return false;
        }
        GetBenefitApplicationResponse other = (GetBenefitApplicationResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(catalog(), other.catalog()) && Objects.equals(benefitId(), other.benefitId())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && hasFulfillmentTypes() == other.hasFulfillmentTypes()
                && Objects.equals(fulfillmentTypesAsStrings(), other.fulfillmentTypesAsStrings())
                && Objects.equals(benefitApplicationDetails(), other.benefitApplicationDetails())
                && hasPrograms() == other.hasPrograms() && Objects.equals(programs(), other.programs())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(stage(), other.stage())
                && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(statusReasonCode(), other.statusReasonCode())
                && hasStatusReasonCodes() == other.hasStatusReasonCodes()
                && Objects.equals(statusReasonCodes(), other.statusReasonCodes())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(revision(), other.revision()) && hasAssociatedResources() == other.hasAssociatedResources()
                && Objects.equals(associatedResources(), other.associatedResources())
                && hasPartnerContacts() == other.hasPartnerContacts()
                && Objects.equals(partnerContacts(), other.partnerContacts()) && hasFileDetails() == other.hasFileDetails()
                && Objects.equals(fileDetails(), other.fileDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBenefitApplicationResponse").add("Id", id()).add("Arn", arn()).add("Catalog", catalog())
                .add("BenefitId", benefitId()).add("Name", name()).add("Description", description())
                .add("FulfillmentTypes", hasFulfillmentTypes() ? fulfillmentTypesAsStrings() : null)
                .add("BenefitApplicationDetails", benefitApplicationDetails()).add("Programs", hasPrograms() ? programs() : null)
                .add("Status", statusAsString()).add("Stage", stage()).add("StatusReason", statusReason())
                .add("StatusReasonCode", statusReasonCode())
                .add("StatusReasonCodes", hasStatusReasonCodes() ? statusReasonCodes() : null).add("CreatedAt", createdAt())
                .add("UpdatedAt", updatedAt()).add("Revision", revision())
                .add("AssociatedResources", hasAssociatedResources() ? associatedResources() : null)
                .add("PartnerContacts", hasPartnerContacts() ? partnerContacts() : null)
                .add("FileDetails", hasFileDetails() ? fileDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "BenefitId":
            return Optional.ofNullable(clazz.cast(benefitId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "FulfillmentTypes":
            return Optional.ofNullable(clazz.cast(fulfillmentTypesAsStrings()));
        case "BenefitApplicationDetails":
            return Optional.ofNullable(clazz.cast(benefitApplicationDetails()));
        case "Programs":
            return Optional.ofNullable(clazz.cast(programs()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Stage":
            return Optional.ofNullable(clazz.cast(stage()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "StatusReasonCode":
            return Optional.ofNullable(clazz.cast(statusReasonCode()));
        case "StatusReasonCodes":
            return Optional.ofNullable(clazz.cast(statusReasonCodes()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "Revision":
            return Optional.ofNullable(clazz.cast(revision()));
        case "AssociatedResources":
            return Optional.ofNullable(clazz.cast(associatedResources()));
        case "PartnerContacts":
            return Optional.ofNullable(clazz.cast(partnerContacts()));
        case "FileDetails":
            return Optional.ofNullable(clazz.cast(fileDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Catalog", CATALOG_FIELD);
        map.put("BenefitId", BENEFIT_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("FulfillmentTypes", FULFILLMENT_TYPES_FIELD);
        map.put("BenefitApplicationDetails", BENEFIT_APPLICATION_DETAILS_FIELD);
        map.put("Programs", PROGRAMS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Stage", STAGE_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("StatusReasonCode", STATUS_REASON_CODE_FIELD);
        map.put("StatusReasonCodes", STATUS_REASON_CODES_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("Revision", REVISION_FIELD);
        map.put("AssociatedResources", ASSOCIATED_RESOURCES_FIELD);
        map.put("PartnerContacts", PARTNER_CONTACTS_FIELD);
        map.put("FileDetails", FILE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBenefitApplicationResponse, T> g) {
        return obj -> g.apply((GetBenefitApplicationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PartnerCentralBenefitsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetBenefitApplicationResponse> {
        /**
         * <p>
         * The unique identifier of the benefit application.
         * </p>
         * 
         * @param id
         *        The unique identifier of the benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the benefit application.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The catalog identifier that the benefit application belongs to.
         * </p>
         * 
         * @param catalog
         *        The catalog identifier that the benefit application belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * The identifier of the benefit being requested in this application.
         * </p>
         * 
         * @param benefitId
         *        The identifier of the benefit being requested in this application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder benefitId(String benefitId);

        /**
         * <p>
         * The human-readable name of the benefit application.
         * </p>
         * 
         * @param name
         *        The human-readable name of the benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A detailed description of the benefit application.
         * </p>
         * 
         * @param description
         *        A detailed description of the benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The fulfillment types requested for this benefit application.
         * </p>
         * 
         * @param fulfillmentTypes
         *        The fulfillment types requested for this benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfillmentTypesWithStrings(Collection<String> fulfillmentTypes);

        /**
         * <p>
         * The fulfillment types requested for this benefit application.
         * </p>
         * 
         * @param fulfillmentTypes
         *        The fulfillment types requested for this benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfillmentTypesWithStrings(String... fulfillmentTypes);

        /**
         * <p>
         * The fulfillment types requested for this benefit application.
         * </p>
         * 
         * @param fulfillmentTypes
         *        The fulfillment types requested for this benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfillmentTypes(Collection<FulfillmentType> fulfillmentTypes);

        /**
         * <p>
         * The fulfillment types requested for this benefit application.
         * </p>
         * 
         * @param fulfillmentTypes
         *        The fulfillment types requested for this benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfillmentTypes(FulfillmentType... fulfillmentTypes);

        /**
         * <p>
         * Detailed information and requirements specific to the benefit being requested.
         * </p>
         * 
         * @param benefitApplicationDetails
         *        Detailed information and requirements specific to the benefit being requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder benefitApplicationDetails(Document benefitApplicationDetails);

        /**
         * <p>
         * The AWS partner programs associated with this benefit application.
         * </p>
         * 
         * @param programs
         *        The AWS partner programs associated with this benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programs(Collection<String> programs);

        /**
         * <p>
         * The AWS partner programs associated with this benefit application.
         * </p>
         * 
         * @param programs
         *        The AWS partner programs associated with this benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programs(String... programs);

        /**
         * <p>
         * The current processing status of the benefit application.
         * </p>
         * 
         * @param status
         *        The current processing status of the benefit application.
         * @see BenefitApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BenefitApplicationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current processing status of the benefit application.
         * </p>
         * 
         * @param status
         *        The current processing status of the benefit application.
         * @see BenefitApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BenefitApplicationStatus
         */
        Builder status(BenefitApplicationStatus status);

        /**
         * <p>
         * The current stage in the benefit application processing workflow.
         * </p>
         * 
         * @param stage
         *        The current stage in the benefit application processing workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stage(String stage);

        /**
         * <p>
         * Additional information explaining the current status of the benefit application.
         * </p>
         * 
         * @param statusReason
         *        Additional information explaining the current status of the benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * A standardized code representing the reason for the current status.
         * </p>
         * 
         * @param statusReasonCode
         *        A standardized code representing the reason for the current status.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This field is no longer used
         */
        @Deprecated
        Builder statusReasonCode(String statusReasonCode);

        /**
         * <p>
         * The list of standardized codes representing the reason for the current status.
         * </p>
         * 
         * @param statusReasonCodes
         *        The list of standardized codes representing the reason for the current status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReasonCodes(Collection<String> statusReasonCodes);

        /**
         * <p>
         * The list of standardized codes representing the reason for the current status.
         * </p>
         * 
         * @param statusReasonCodes
         *        The list of standardized codes representing the reason for the current status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReasonCodes(String... statusReasonCodes);

        /**
         * <p>
         * The timestamp when the benefit application was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the benefit application was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the benefit application was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the benefit application was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The current revision number of the benefit application.
         * </p>
         * 
         * @param revision
         *        The current revision number of the benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(String revision);

        /**
         * <p>
         * AWS resources that are associated with this benefit application.
         * </p>
         * 
         * @param associatedResources
         *        AWS resources that are associated with this benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedResources(Collection<String> associatedResources);

        /**
         * <p>
         * AWS resources that are associated with this benefit application.
         * </p>
         * 
         * @param associatedResources
         *        AWS resources that are associated with this benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedResources(String... associatedResources);

        /**
         * <p>
         * Contact information for partner representatives responsible for this benefit application.
         * </p>
         * 
         * @param partnerContacts
         *        Contact information for partner representatives responsible for this benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partnerContacts(Collection<Contact> partnerContacts);

        /**
         * <p>
         * Contact information for partner representatives responsible for this benefit application.
         * </p>
         * 
         * @param partnerContacts
         *        Contact information for partner representatives responsible for this benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partnerContacts(Contact... partnerContacts);

        /**
         * <p>
         * Contact information for partner representatives responsible for this benefit application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralbenefits.model.Contact.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.partnercentralbenefits.model.Contact#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralbenefits.model.Contact.Builder#build()} is called
         * immediately and its result is passed to {@link #partnerContacts(List<Contact>)}.
         * 
         * @param partnerContacts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.Contact.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partnerContacts(java.util.Collection<Contact>)
         */
        Builder partnerContacts(Consumer<Contact.Builder>... partnerContacts);

        /**
         * <p>
         * Supporting documents and files attached to the benefit application.
         * </p>
         * 
         * @param fileDetails
         *        Supporting documents and files attached to the benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileDetails(Collection<FileDetail> fileDetails);

        /**
         * <p>
         * Supporting documents and files attached to the benefit application.
         * </p>
         * 
         * @param fileDetails
         *        Supporting documents and files attached to the benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileDetails(FileDetail... fileDetails);

        /**
         * <p>
         * Supporting documents and files attached to the benefit application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralbenefits.model.FileDetail.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.partnercentralbenefits.model.FileDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralbenefits.model.FileDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #fileDetails(List<FileDetail>)}.
         * 
         * @param fileDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.FileDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileDetails(java.util.Collection<FileDetail>)
         */
        Builder fileDetails(Consumer<FileDetail.Builder>... fileDetails);
    }

    static final class BuilderImpl extends PartnerCentralBenefitsResponse.BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String catalog;

        private String benefitId;

        private String name;

        private String description;

        private List<String> fulfillmentTypes = DefaultSdkAutoConstructList.getInstance();

        private Document benefitApplicationDetails;

        private List<String> programs = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private String stage;

        private String statusReason;

        private String statusReasonCode;

        private List<String> statusReasonCodes = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private Instant updatedAt;

        private String revision;

        private List<String> associatedResources = DefaultSdkAutoConstructList.getInstance();

        private List<Contact> partnerContacts = DefaultSdkAutoConstructList.getInstance();

        private List<FileDetail> fileDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetBenefitApplicationResponse model) {
            super(model);
            id(model.id);
            arn(model.arn);
            catalog(model.catalog);
            benefitId(model.benefitId);
            name(model.name);
            description(model.description);
            fulfillmentTypesWithStrings(model.fulfillmentTypes);
            benefitApplicationDetails(model.benefitApplicationDetails);
            programs(model.programs);
            status(model.status);
            stage(model.stage);
            statusReason(model.statusReason);
            statusReasonCode(model.statusReasonCode);
            statusReasonCodes(model.statusReasonCodes);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            revision(model.revision);
            associatedResources(model.associatedResources);
            partnerContacts(model.partnerContacts);
            fileDetails(model.fileDetails);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getBenefitId() {
            return benefitId;
        }

        public final void setBenefitId(String benefitId) {
            this.benefitId = benefitId;
        }

        @Override
        public final Builder benefitId(String benefitId) {
            this.benefitId = benefitId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getFulfillmentTypes() {
            if (fulfillmentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return fulfillmentTypes;
        }

        public final void setFulfillmentTypes(Collection<String> fulfillmentTypes) {
            this.fulfillmentTypes = FulfillmentTypesCopier.copy(fulfillmentTypes);
        }

        @Override
        public final Builder fulfillmentTypesWithStrings(Collection<String> fulfillmentTypes) {
            this.fulfillmentTypes = FulfillmentTypesCopier.copy(fulfillmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fulfillmentTypesWithStrings(String... fulfillmentTypes) {
            fulfillmentTypesWithStrings(Arrays.asList(fulfillmentTypes));
            return this;
        }

        @Override
        public final Builder fulfillmentTypes(Collection<FulfillmentType> fulfillmentTypes) {
            this.fulfillmentTypes = FulfillmentTypesCopier.copyEnumToString(fulfillmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fulfillmentTypes(FulfillmentType... fulfillmentTypes) {
            fulfillmentTypes(Arrays.asList(fulfillmentTypes));
            return this;
        }

        public final Document getBenefitApplicationDetails() {
            return benefitApplicationDetails;
        }

        public final void setBenefitApplicationDetails(Document benefitApplicationDetails) {
            this.benefitApplicationDetails = benefitApplicationDetails;
        }

        @Override
        public final Builder benefitApplicationDetails(Document benefitApplicationDetails) {
            this.benefitApplicationDetails = benefitApplicationDetails;
            return this;
        }

        public final Collection<String> getPrograms() {
            if (programs instanceof SdkAutoConstructList) {
                return null;
            }
            return programs;
        }

        public final void setPrograms(Collection<String> programs) {
            this.programs = ProgramsCopier.copy(programs);
        }

        @Override
        public final Builder programs(Collection<String> programs) {
            this.programs = ProgramsCopier.copy(programs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder programs(String... programs) {
            programs(Arrays.asList(programs));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BenefitApplicationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStage() {
            return stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Deprecated
        public final String getStatusReasonCode() {
            return statusReasonCode;
        }

        @Deprecated
        public final void setStatusReasonCode(String statusReasonCode) {
            this.statusReasonCode = statusReasonCode;
        }

        @Override
        @Deprecated
        public final Builder statusReasonCode(String statusReasonCode) {
            this.statusReasonCode = statusReasonCode;
            return this;
        }

        public final Collection<String> getStatusReasonCodes() {
            if (statusReasonCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return statusReasonCodes;
        }

        public final void setStatusReasonCodes(Collection<String> statusReasonCodes) {
            this.statusReasonCodes = StatusReasonCodesCopier.copy(statusReasonCodes);
        }

        @Override
        public final Builder statusReasonCodes(Collection<String> statusReasonCodes) {
            this.statusReasonCodes = StatusReasonCodesCopier.copy(statusReasonCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusReasonCodes(String... statusReasonCodes) {
            statusReasonCodes(Arrays.asList(statusReasonCodes));
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getRevision() {
            return revision;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public final Collection<String> getAssociatedResources() {
            if (associatedResources instanceof SdkAutoConstructList) {
                return null;
            }
            return associatedResources;
        }

        public final void setAssociatedResources(Collection<String> associatedResources) {
            this.associatedResources = GetBenefitApplicationOutputAssociatedResourcesListCopier.copy(associatedResources);
        }

        @Override
        public final Builder associatedResources(Collection<String> associatedResources) {
            this.associatedResources = GetBenefitApplicationOutputAssociatedResourcesListCopier.copy(associatedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedResources(String... associatedResources) {
            associatedResources(Arrays.asList(associatedResources));
            return this;
        }

        public final List<Contact.Builder> getPartnerContacts() {
            List<Contact.Builder> result = ContactsCopier.copyToBuilder(this.partnerContacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPartnerContacts(Collection<Contact.BuilderImpl> partnerContacts) {
            this.partnerContacts = ContactsCopier.copyFromBuilder(partnerContacts);
        }

        @Override
        public final Builder partnerContacts(Collection<Contact> partnerContacts) {
            this.partnerContacts = ContactsCopier.copy(partnerContacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partnerContacts(Contact... partnerContacts) {
            partnerContacts(Arrays.asList(partnerContacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partnerContacts(Consumer<Contact.Builder>... partnerContacts) {
            partnerContacts(Stream.of(partnerContacts).map(c -> Contact.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<FileDetail.Builder> getFileDetails() {
            List<FileDetail.Builder> result = GetBenefitApplicationOutputFileDetailsListCopier.copyToBuilder(this.fileDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileDetails(Collection<FileDetail.BuilderImpl> fileDetails) {
            this.fileDetails = GetBenefitApplicationOutputFileDetailsListCopier.copyFromBuilder(fileDetails);
        }

        @Override
        public final Builder fileDetails(Collection<FileDetail> fileDetails) {
            this.fileDetails = GetBenefitApplicationOutputFileDetailsListCopier.copy(fileDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileDetails(FileDetail... fileDetails) {
            fileDetails(Arrays.asList(fileDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileDetails(Consumer<FileDetail.Builder>... fileDetails) {
            fileDetails(Stream.of(fileDetails).map(c -> FileDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetBenefitApplicationResponse build() {
            return new GetBenefitApplicationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
