/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBenefitAllocationResponse extends PartnerCentralBenefitsResponse implements
        ToCopyableBuilder<GetBenefitAllocationResponse.Builder, GetBenefitAllocationResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(GetBenefitAllocationResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(GetBenefitAllocationResponse::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetBenefitAllocationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetBenefitAllocationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetBenefitAllocationResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetBenefitAllocationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(GetBenefitAllocationResponse::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<String> BENEFIT_APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BenefitApplicationId").getter(getter(GetBenefitAllocationResponse::benefitApplicationId))
            .setter(setter(Builder::benefitApplicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BenefitApplicationId").build())
            .build();

    private static final SdkField<String> BENEFIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BenefitId").getter(getter(GetBenefitAllocationResponse::benefitId)).setter(setter(Builder::benefitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BenefitId").build()).build();

    private static final SdkField<String> FULFILLMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FulfillmentType").getter(getter(GetBenefitAllocationResponse::fulfillmentTypeAsString))
            .setter(setter(Builder::fulfillmentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FulfillmentType").build()).build();

    private static final SdkField<List<String>> APPLICABLE_BENEFIT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ApplicableBenefitIds")
            .getter(getter(GetBenefitAllocationResponse::applicableBenefitIds))
            .setter(setter(Builder::applicableBenefitIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicableBenefitIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<FulfillmentDetails> FULFILLMENT_DETAIL_FIELD = SdkField
            .<FulfillmentDetails> builder(MarshallingType.SDK_POJO).memberName("FulfillmentDetail")
            .getter(getter(GetBenefitAllocationResponse::fulfillmentDetail)).setter(setter(Builder::fulfillmentDetail))
            .constructor(FulfillmentDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FulfillmentDetail").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(GetBenefitAllocationResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt")
            .getter(getter(GetBenefitAllocationResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> STARTS_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartsAt")
            .getter(getter(GetBenefitAllocationResponse::startsAt))
            .setter(setter(Builder::startsAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartsAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpiresAt")
            .getter(getter(GetBenefitAllocationResponse::expiresAt))
            .setter(setter(Builder::expiresAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiresAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, CATALOG_FIELD,
            ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, BENEFIT_APPLICATION_ID_FIELD,
            BENEFIT_ID_FIELD, FULFILLMENT_TYPE_FIELD, APPLICABLE_BENEFIT_IDS_FIELD, FULFILLMENT_DETAIL_FIELD, CREATED_AT_FIELD,
            UPDATED_AT_FIELD, STARTS_AT_FIELD, EXPIRES_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String catalog;

    private final String arn;

    private final String name;

    private final String description;

    private final String status;

    private final String statusReason;

    private final String benefitApplicationId;

    private final String benefitId;

    private final String fulfillmentType;

    private final List<String> applicableBenefitIds;

    private final FulfillmentDetails fulfillmentDetail;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final Instant startsAt;

    private final Instant expiresAt;

    private GetBenefitAllocationResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.catalog = builder.catalog;
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.benefitApplicationId = builder.benefitApplicationId;
        this.benefitId = builder.benefitId;
        this.fulfillmentType = builder.fulfillmentType;
        this.applicableBenefitIds = builder.applicableBenefitIds;
        this.fulfillmentDetail = builder.fulfillmentDetail;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.startsAt = builder.startsAt;
        this.expiresAt = builder.expiresAt;
    }

    /**
     * <p>
     * The unique identifier of the benefit allocation.
     * </p>
     * 
     * @return The unique identifier of the benefit allocation.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The catalog identifier that the benefit allocation belongs to.
     * </p>
     * 
     * @return The catalog identifier that the benefit allocation belongs to.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the benefit allocation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the benefit allocation.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The human-readable name of the benefit allocation.
     * </p>
     * 
     * @return The human-readable name of the benefit allocation.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A detailed description of the benefit allocation.
     * </p>
     * 
     * @return A detailed description of the benefit allocation.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The current status of the benefit allocation (e.g., active, expired, consumed).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BenefitAllocationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the benefit allocation (e.g., active, expired, consumed).
     * @see BenefitAllocationStatus
     */
    public final BenefitAllocationStatus status() {
        return BenefitAllocationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the benefit allocation (e.g., active, expired, consumed).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BenefitAllocationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the benefit allocation (e.g., active, expired, consumed).
     * @see BenefitAllocationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Additional information explaining the current status of the benefit allocation.
     * </p>
     * 
     * @return Additional information explaining the current status of the benefit allocation.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The identifier of the benefit application that resulted in this allocation.
     * </p>
     * 
     * @return The identifier of the benefit application that resulted in this allocation.
     */
    public final String benefitApplicationId() {
        return benefitApplicationId;
    }

    /**
     * <p>
     * The identifier of the benefit that this allocation is based on.
     * </p>
     * 
     * @return The identifier of the benefit that this allocation is based on.
     */
    public final String benefitId() {
        return benefitId;
    }

    /**
     * <p>
     * The fulfillment type used for this benefit allocation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fulfillmentType}
     * will return {@link FulfillmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fulfillmentTypeAsString}.
     * </p>
     * 
     * @return The fulfillment type used for this benefit allocation.
     * @see FulfillmentType
     */
    public final FulfillmentType fulfillmentType() {
        return FulfillmentType.fromValue(fulfillmentType);
    }

    /**
     * <p>
     * The fulfillment type used for this benefit allocation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fulfillmentType}
     * will return {@link FulfillmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fulfillmentTypeAsString}.
     * </p>
     * 
     * @return The fulfillment type used for this benefit allocation.
     * @see FulfillmentType
     */
    public final String fulfillmentTypeAsString() {
        return fulfillmentType;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApplicableBenefitIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasApplicableBenefitIds() {
        return applicableBenefitIds != null && !(applicableBenefitIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of benefit identifiers that this allocation can be applied to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplicableBenefitIds} method.
     * </p>
     * 
     * @return A list of benefit identifiers that this allocation can be applied to.
     */
    public final List<String> applicableBenefitIds() {
        return applicableBenefitIds;
    }

    /**
     * <p>
     * Detailed information about how the benefit allocation is fulfilled.
     * </p>
     * 
     * @return Detailed information about how the benefit allocation is fulfilled.
     */
    public final FulfillmentDetails fulfillmentDetail() {
        return fulfillmentDetail;
    }

    /**
     * <p>
     * The timestamp when the benefit allocation was created.
     * </p>
     * 
     * @return The timestamp when the benefit allocation was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the benefit allocation was last updated.
     * </p>
     * 
     * @return The timestamp when the benefit allocation was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The timestamp when the benefit allocation becomes active and usable.
     * </p>
     * 
     * @return The timestamp when the benefit allocation becomes active and usable.
     */
    public final Instant startsAt() {
        return startsAt;
    }

    /**
     * <p>
     * The timestamp when the benefit allocation expires and is no longer usable.
     * </p>
     * 
     * @return The timestamp when the benefit allocation expires and is no longer usable.
     */
    public final Instant expiresAt() {
        return expiresAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(benefitApplicationId());
        hashCode = 31 * hashCode + Objects.hashCode(benefitId());
        hashCode = 31 * hashCode + Objects.hashCode(fulfillmentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasApplicableBenefitIds() ? applicableBenefitIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(fulfillmentDetail());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(startsAt());
        hashCode = 31 * hashCode + Objects.hashCode(expiresAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBenefitAllocationResponse)) {
            return false;
        }
        GetBenefitAllocationResponse other = (GetBenefitAllocationResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(catalog(), other.catalog())
                && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(benefitApplicationId(), other.benefitApplicationId())
                && Objects.equals(benefitId(), other.benefitId())
                && Objects.equals(fulfillmentTypeAsString(), other.fulfillmentTypeAsString())
                && hasApplicableBenefitIds() == other.hasApplicableBenefitIds()
                && Objects.equals(applicableBenefitIds(), other.applicableBenefitIds())
                && Objects.equals(fulfillmentDetail(), other.fulfillmentDetail())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(startsAt(), other.startsAt()) && Objects.equals(expiresAt(), other.expiresAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBenefitAllocationResponse").add("Id", id()).add("Catalog", catalog()).add("Arn", arn())
                .add("Name", name()).add("Description", description()).add("Status", statusAsString())
                .add("StatusReason", statusReason()).add("BenefitApplicationId", benefitApplicationId())
                .add("BenefitId", benefitId()).add("FulfillmentType", fulfillmentTypeAsString())
                .add("ApplicableBenefitIds", hasApplicableBenefitIds() ? applicableBenefitIds() : null)
                .add("FulfillmentDetail", fulfillmentDetail()).add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt())
                .add("StartsAt", startsAt()).add("ExpiresAt", expiresAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "BenefitApplicationId":
            return Optional.ofNullable(clazz.cast(benefitApplicationId()));
        case "BenefitId":
            return Optional.ofNullable(clazz.cast(benefitId()));
        case "FulfillmentType":
            return Optional.ofNullable(clazz.cast(fulfillmentTypeAsString()));
        case "ApplicableBenefitIds":
            return Optional.ofNullable(clazz.cast(applicableBenefitIds()));
        case "FulfillmentDetail":
            return Optional.ofNullable(clazz.cast(fulfillmentDetail()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "StartsAt":
            return Optional.ofNullable(clazz.cast(startsAt()));
        case "ExpiresAt":
            return Optional.ofNullable(clazz.cast(expiresAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Catalog", CATALOG_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("BenefitApplicationId", BENEFIT_APPLICATION_ID_FIELD);
        map.put("BenefitId", BENEFIT_ID_FIELD);
        map.put("FulfillmentType", FULFILLMENT_TYPE_FIELD);
        map.put("ApplicableBenefitIds", APPLICABLE_BENEFIT_IDS_FIELD);
        map.put("FulfillmentDetail", FULFILLMENT_DETAIL_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("StartsAt", STARTS_AT_FIELD);
        map.put("ExpiresAt", EXPIRES_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBenefitAllocationResponse, T> g) {
        return obj -> g.apply((GetBenefitAllocationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PartnerCentralBenefitsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetBenefitAllocationResponse> {
        /**
         * <p>
         * The unique identifier of the benefit allocation.
         * </p>
         * 
         * @param id
         *        The unique identifier of the benefit allocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The catalog identifier that the benefit allocation belongs to.
         * </p>
         * 
         * @param catalog
         *        The catalog identifier that the benefit allocation belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the benefit allocation.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the benefit allocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The human-readable name of the benefit allocation.
         * </p>
         * 
         * @param name
         *        The human-readable name of the benefit allocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A detailed description of the benefit allocation.
         * </p>
         * 
         * @param description
         *        A detailed description of the benefit allocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The current status of the benefit allocation (e.g., active, expired, consumed).
         * </p>
         * 
         * @param status
         *        The current status of the benefit allocation (e.g., active, expired, consumed).
         * @see BenefitAllocationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BenefitAllocationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the benefit allocation (e.g., active, expired, consumed).
         * </p>
         * 
         * @param status
         *        The current status of the benefit allocation (e.g., active, expired, consumed).
         * @see BenefitAllocationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BenefitAllocationStatus
         */
        Builder status(BenefitAllocationStatus status);

        /**
         * <p>
         * Additional information explaining the current status of the benefit allocation.
         * </p>
         * 
         * @param statusReason
         *        Additional information explaining the current status of the benefit allocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The identifier of the benefit application that resulted in this allocation.
         * </p>
         * 
         * @param benefitApplicationId
         *        The identifier of the benefit application that resulted in this allocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder benefitApplicationId(String benefitApplicationId);

        /**
         * <p>
         * The identifier of the benefit that this allocation is based on.
         * </p>
         * 
         * @param benefitId
         *        The identifier of the benefit that this allocation is based on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder benefitId(String benefitId);

        /**
         * <p>
         * The fulfillment type used for this benefit allocation.
         * </p>
         * 
         * @param fulfillmentType
         *        The fulfillment type used for this benefit allocation.
         * @see FulfillmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FulfillmentType
         */
        Builder fulfillmentType(String fulfillmentType);

        /**
         * <p>
         * The fulfillment type used for this benefit allocation.
         * </p>
         * 
         * @param fulfillmentType
         *        The fulfillment type used for this benefit allocation.
         * @see FulfillmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FulfillmentType
         */
        Builder fulfillmentType(FulfillmentType fulfillmentType);

        /**
         * <p>
         * A list of benefit identifiers that this allocation can be applied to.
         * </p>
         * 
         * @param applicableBenefitIds
         *        A list of benefit identifiers that this allocation can be applied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicableBenefitIds(Collection<String> applicableBenefitIds);

        /**
         * <p>
         * A list of benefit identifiers that this allocation can be applied to.
         * </p>
         * 
         * @param applicableBenefitIds
         *        A list of benefit identifiers that this allocation can be applied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicableBenefitIds(String... applicableBenefitIds);

        /**
         * <p>
         * Detailed information about how the benefit allocation is fulfilled.
         * </p>
         * 
         * @param fulfillmentDetail
         *        Detailed information about how the benefit allocation is fulfilled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfillmentDetail(FulfillmentDetails fulfillmentDetail);

        /**
         * <p>
         * Detailed information about how the benefit allocation is fulfilled.
         * </p>
         * This is a convenience method that creates an instance of the {@link FulfillmentDetails.Builder} avoiding the
         * need to create one manually via {@link FulfillmentDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FulfillmentDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #fulfillmentDetail(FulfillmentDetails)}.
         * 
         * @param fulfillmentDetail
         *        a consumer that will call methods on {@link FulfillmentDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fulfillmentDetail(FulfillmentDetails)
         */
        default Builder fulfillmentDetail(Consumer<FulfillmentDetails.Builder> fulfillmentDetail) {
            return fulfillmentDetail(FulfillmentDetails.builder().applyMutation(fulfillmentDetail).build());
        }

        /**
         * <p>
         * The timestamp when the benefit allocation was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the benefit allocation was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the benefit allocation was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the benefit allocation was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The timestamp when the benefit allocation becomes active and usable.
         * </p>
         * 
         * @param startsAt
         *        The timestamp when the benefit allocation becomes active and usable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startsAt(Instant startsAt);

        /**
         * <p>
         * The timestamp when the benefit allocation expires and is no longer usable.
         * </p>
         * 
         * @param expiresAt
         *        The timestamp when the benefit allocation expires and is no longer usable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresAt(Instant expiresAt);
    }

    static final class BuilderImpl extends PartnerCentralBenefitsResponse.BuilderImpl implements Builder {
        private String id;

        private String catalog;

        private String arn;

        private String name;

        private String description;

        private String status;

        private String statusReason;

        private String benefitApplicationId;

        private String benefitId;

        private String fulfillmentType;

        private List<String> applicableBenefitIds = DefaultSdkAutoConstructList.getInstance();

        private FulfillmentDetails fulfillmentDetail;

        private Instant createdAt;

        private Instant updatedAt;

        private Instant startsAt;

        private Instant expiresAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBenefitAllocationResponse model) {
            super(model);
            id(model.id);
            catalog(model.catalog);
            arn(model.arn);
            name(model.name);
            description(model.description);
            status(model.status);
            statusReason(model.statusReason);
            benefitApplicationId(model.benefitApplicationId);
            benefitId(model.benefitId);
            fulfillmentType(model.fulfillmentType);
            applicableBenefitIds(model.applicableBenefitIds);
            fulfillmentDetail(model.fulfillmentDetail);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            startsAt(model.startsAt);
            expiresAt(model.expiresAt);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BenefitAllocationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getBenefitApplicationId() {
            return benefitApplicationId;
        }

        public final void setBenefitApplicationId(String benefitApplicationId) {
            this.benefitApplicationId = benefitApplicationId;
        }

        @Override
        public final Builder benefitApplicationId(String benefitApplicationId) {
            this.benefitApplicationId = benefitApplicationId;
            return this;
        }

        public final String getBenefitId() {
            return benefitId;
        }

        public final void setBenefitId(String benefitId) {
            this.benefitId = benefitId;
        }

        @Override
        public final Builder benefitId(String benefitId) {
            this.benefitId = benefitId;
            return this;
        }

        public final String getFulfillmentType() {
            return fulfillmentType;
        }

        public final void setFulfillmentType(String fulfillmentType) {
            this.fulfillmentType = fulfillmentType;
        }

        @Override
        public final Builder fulfillmentType(String fulfillmentType) {
            this.fulfillmentType = fulfillmentType;
            return this;
        }

        @Override
        public final Builder fulfillmentType(FulfillmentType fulfillmentType) {
            this.fulfillmentType(fulfillmentType == null ? null : fulfillmentType.toString());
            return this;
        }

        public final Collection<String> getApplicableBenefitIds() {
            if (applicableBenefitIds instanceof SdkAutoConstructList) {
                return null;
            }
            return applicableBenefitIds;
        }

        public final void setApplicableBenefitIds(Collection<String> applicableBenefitIds) {
            this.applicableBenefitIds = BenefitIdentifiersCopier.copy(applicableBenefitIds);
        }

        @Override
        public final Builder applicableBenefitIds(Collection<String> applicableBenefitIds) {
            this.applicableBenefitIds = BenefitIdentifiersCopier.copy(applicableBenefitIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicableBenefitIds(String... applicableBenefitIds) {
            applicableBenefitIds(Arrays.asList(applicableBenefitIds));
            return this;
        }

        public final FulfillmentDetails.Builder getFulfillmentDetail() {
            return fulfillmentDetail != null ? fulfillmentDetail.toBuilder() : null;
        }

        public final void setFulfillmentDetail(FulfillmentDetails.BuilderImpl fulfillmentDetail) {
            this.fulfillmentDetail = fulfillmentDetail != null ? fulfillmentDetail.build() : null;
        }

        @Override
        public final Builder fulfillmentDetail(FulfillmentDetails fulfillmentDetail) {
            this.fulfillmentDetail = fulfillmentDetail;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Instant getStartsAt() {
            return startsAt;
        }

        public final void setStartsAt(Instant startsAt) {
            this.startsAt = startsAt;
        }

        @Override
        public final Builder startsAt(Instant startsAt) {
            this.startsAt = startsAt;
            return this;
        }

        public final Instant getExpiresAt() {
            return expiresAt;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        @Override
        public GetBenefitAllocationResponse build() {
            return new GetBenefitAllocationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
