/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents input information for uploading a file to a benefit application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileInput implements SdkPojo, Serializable, ToCopyableBuilder<FileInput.Builder, FileInput> {
    private static final SdkField<String> FILE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileURI").getter(getter(FileInput::fileURI)).setter(setter(Builder::fileURI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileURI").build()).build();

    private static final SdkField<String> BUSINESS_USE_CASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BusinessUseCase").getter(getter(FileInput::businessUseCase)).setter(setter(Builder::businessUseCase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessUseCase").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_URI_FIELD,
            BUSINESS_USE_CASE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fileURI;

    private final String businessUseCase;

    private FileInput(BuilderImpl builder) {
        this.fileURI = builder.fileURI;
        this.businessUseCase = builder.businessUseCase;
    }

    /**
     * <p>
     * The URI or location where the file should be stored or has been uploaded.
     * </p>
     * 
     * @return The URI or location where the file should be stored or has been uploaded.
     */
    public final String fileURI() {
        return fileURI;
    }

    /**
     * <p>
     * The business purpose or use case that this file supports in the benefit application.
     * </p>
     * 
     * @return The business purpose or use case that this file supports in the benefit application.
     */
    public final String businessUseCase() {
        return businessUseCase;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileURI());
        hashCode = 31 * hashCode + Objects.hashCode(businessUseCase());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileInput)) {
            return false;
        }
        FileInput other = (FileInput) obj;
        return Objects.equals(fileURI(), other.fileURI()) && Objects.equals(businessUseCase(), other.businessUseCase());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FileInput").add("FileURI", fileURI()).add("BusinessUseCase", businessUseCase()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileURI":
            return Optional.ofNullable(clazz.cast(fileURI()));
        case "BusinessUseCase":
            return Optional.ofNullable(clazz.cast(businessUseCase()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FileURI", FILE_URI_FIELD);
        map.put("BusinessUseCase", BUSINESS_USE_CASE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FileInput, T> g) {
        return obj -> g.apply((FileInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FileInput> {
        /**
         * <p>
         * The URI or location where the file should be stored or has been uploaded.
         * </p>
         * 
         * @param fileURI
         *        The URI or location where the file should be stored or has been uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileURI(String fileURI);

        /**
         * <p>
         * The business purpose or use case that this file supports in the benefit application.
         * </p>
         * 
         * @param businessUseCase
         *        The business purpose or use case that this file supports in the benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessUseCase(String businessUseCase);
    }

    static final class BuilderImpl implements Builder {
        private String fileURI;

        private String businessUseCase;

        private BuilderImpl() {
        }

        private BuilderImpl(FileInput model) {
            fileURI(model.fileURI);
            businessUseCase(model.businessUseCase);
        }

        public final String getFileURI() {
            return fileURI;
        }

        public final void setFileURI(String fileURI) {
            this.fileURI = fileURI;
        }

        @Override
        public final Builder fileURI(String fileURI) {
            this.fileURI = fileURI;
            return this;
        }

        public final String getBusinessUseCase() {
            return businessUseCase;
        }

        public final void setBusinessUseCase(String businessUseCase) {
            this.businessUseCase = businessUseCase;
        }

        @Override
        public final Builder businessUseCase(String businessUseCase) {
            this.businessUseCase = businessUseCase;
            return this;
        }

        @Override
        public FileInput build() {
            return new FileInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
