/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents detailed information about a file attached to a benefit application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileDetail implements SdkPojo, Serializable, ToCopyableBuilder<FileDetail.Builder, FileDetail> {
    private static final SdkField<String> FILE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileURI").getter(getter(FileDetail::fileURI)).setter(setter(Builder::fileURI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileURI").build()).build();

    private static final SdkField<String> BUSINESS_USE_CASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BusinessUseCase").getter(getter(FileDetail::businessUseCase)).setter(setter(Builder::businessUseCase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessUseCase").build()).build();

    private static final SdkField<String> FILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileName").getter(getter(FileDetail::fileName)).setter(setter(Builder::fileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileName").build()).build();

    private static final SdkField<String> FILE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileStatus").getter(getter(FileDetail::fileStatus)).setter(setter(Builder::fileStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileStatus").build()).build();

    private static final SdkField<String> FILE_STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileStatusReason").getter(getter(FileDetail::fileStatusReason))
            .setter(setter(Builder::fileStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileStatusReason").build()).build();

    private static final SdkField<String> FILE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileType").getter(getter(FileDetail::fileTypeAsString)).setter(setter(Builder::fileType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileType").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedBy").getter(getter(FileDetail::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(FileDetail::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_URI_FIELD,
            BUSINESS_USE_CASE_FIELD, FILE_NAME_FIELD, FILE_STATUS_FIELD, FILE_STATUS_REASON_FIELD, FILE_TYPE_FIELD,
            CREATED_BY_FIELD, CREATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fileURI;

    private final String businessUseCase;

    private final String fileName;

    private final String fileStatus;

    private final String fileStatusReason;

    private final String fileType;

    private final String createdBy;

    private final Instant createdAt;

    private FileDetail(BuilderImpl builder) {
        this.fileURI = builder.fileURI;
        this.businessUseCase = builder.businessUseCase;
        this.fileName = builder.fileName;
        this.fileStatus = builder.fileStatus;
        this.fileStatusReason = builder.fileStatusReason;
        this.fileType = builder.fileType;
        this.createdBy = builder.createdBy;
        this.createdAt = builder.createdAt;
    }

    /**
     * <p>
     * The URI or location where the file is stored.
     * </p>
     * 
     * @return The URI or location where the file is stored.
     */
    public final String fileURI() {
        return fileURI;
    }

    /**
     * <p>
     * The business purpose or use case that this file supports in the benefit application.
     * </p>
     * 
     * @return The business purpose or use case that this file supports in the benefit application.
     */
    public final String businessUseCase() {
        return businessUseCase;
    }

    /**
     * <p>
     * The original name of the uploaded file.
     * </p>
     * 
     * @return The original name of the uploaded file.
     */
    public final String fileName() {
        return fileName;
    }

    /**
     * <p>
     * The current processing status of the file (e.g., uploaded, processing, approved, rejected).
     * </p>
     * 
     * @return The current processing status of the file (e.g., uploaded, processing, approved, rejected).
     */
    public final String fileStatus() {
        return fileStatus;
    }

    /**
     * <p>
     * The reason for that particulat file status.
     * </p>
     * 
     * @return The reason for that particulat file status.
     */
    public final String fileStatusReason() {
        return fileStatusReason;
    }

    /**
     * <p>
     * The type or category of the file (e.g., document, image, spreadsheet).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileType} will
     * return {@link FileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileTypeAsString}.
     * </p>
     * 
     * @return The type or category of the file (e.g., document, image, spreadsheet).
     * @see FileType
     */
    public final FileType fileType() {
        return FileType.fromValue(fileType);
    }

    /**
     * <p>
     * The type or category of the file (e.g., document, image, spreadsheet).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileType} will
     * return {@link FileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileTypeAsString}.
     * </p>
     * 
     * @return The type or category of the file (e.g., document, image, spreadsheet).
     * @see FileType
     */
    public final String fileTypeAsString() {
        return fileType;
    }

    /**
     * <p>
     * The identifier of the user who uploaded the file.
     * </p>
     * 
     * @return The identifier of the user who uploaded the file.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The timestamp when the file was uploaded.
     * </p>
     * 
     * @return The timestamp when the file was uploaded.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileURI());
        hashCode = 31 * hashCode + Objects.hashCode(businessUseCase());
        hashCode = 31 * hashCode + Objects.hashCode(fileName());
        hashCode = 31 * hashCode + Objects.hashCode(fileStatus());
        hashCode = 31 * hashCode + Objects.hashCode(fileStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(fileTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileDetail)) {
            return false;
        }
        FileDetail other = (FileDetail) obj;
        return Objects.equals(fileURI(), other.fileURI()) && Objects.equals(businessUseCase(), other.businessUseCase())
                && Objects.equals(fileName(), other.fileName()) && Objects.equals(fileStatus(), other.fileStatus())
                && Objects.equals(fileStatusReason(), other.fileStatusReason())
                && Objects.equals(fileTypeAsString(), other.fileTypeAsString()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(createdAt(), other.createdAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FileDetail").add("FileURI", fileURI()).add("BusinessUseCase", businessUseCase())
                .add("FileName", fileName()).add("FileStatus", fileStatus()).add("FileStatusReason", fileStatusReason())
                .add("FileType", fileTypeAsString()).add("CreatedBy", createdBy()).add("CreatedAt", createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileURI":
            return Optional.ofNullable(clazz.cast(fileURI()));
        case "BusinessUseCase":
            return Optional.ofNullable(clazz.cast(businessUseCase()));
        case "FileName":
            return Optional.ofNullable(clazz.cast(fileName()));
        case "FileStatus":
            return Optional.ofNullable(clazz.cast(fileStatus()));
        case "FileStatusReason":
            return Optional.ofNullable(clazz.cast(fileStatusReason()));
        case "FileType":
            return Optional.ofNullable(clazz.cast(fileTypeAsString()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FileURI", FILE_URI_FIELD);
        map.put("BusinessUseCase", BUSINESS_USE_CASE_FIELD);
        map.put("FileName", FILE_NAME_FIELD);
        map.put("FileStatus", FILE_STATUS_FIELD);
        map.put("FileStatusReason", FILE_STATUS_REASON_FIELD);
        map.put("FileType", FILE_TYPE_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FileDetail, T> g) {
        return obj -> g.apply((FileDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FileDetail> {
        /**
         * <p>
         * The URI or location where the file is stored.
         * </p>
         * 
         * @param fileURI
         *        The URI or location where the file is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileURI(String fileURI);

        /**
         * <p>
         * The business purpose or use case that this file supports in the benefit application.
         * </p>
         * 
         * @param businessUseCase
         *        The business purpose or use case that this file supports in the benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessUseCase(String businessUseCase);

        /**
         * <p>
         * The original name of the uploaded file.
         * </p>
         * 
         * @param fileName
         *        The original name of the uploaded file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileName(String fileName);

        /**
         * <p>
         * The current processing status of the file (e.g., uploaded, processing, approved, rejected).
         * </p>
         * 
         * @param fileStatus
         *        The current processing status of the file (e.g., uploaded, processing, approved, rejected).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileStatus(String fileStatus);

        /**
         * <p>
         * The reason for that particulat file status.
         * </p>
         * 
         * @param fileStatusReason
         *        The reason for that particulat file status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileStatusReason(String fileStatusReason);

        /**
         * <p>
         * The type or category of the file (e.g., document, image, spreadsheet).
         * </p>
         * 
         * @param fileType
         *        The type or category of the file (e.g., document, image, spreadsheet).
         * @see FileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileType
         */
        Builder fileType(String fileType);

        /**
         * <p>
         * The type or category of the file (e.g., document, image, spreadsheet).
         * </p>
         * 
         * @param fileType
         *        The type or category of the file (e.g., document, image, spreadsheet).
         * @see FileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileType
         */
        Builder fileType(FileType fileType);

        /**
         * <p>
         * The identifier of the user who uploaded the file.
         * </p>
         * 
         * @param createdBy
         *        The identifier of the user who uploaded the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The timestamp when the file was uploaded.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the file was uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);
    }

    static final class BuilderImpl implements Builder {
        private String fileURI;

        private String businessUseCase;

        private String fileName;

        private String fileStatus;

        private String fileStatusReason;

        private String fileType;

        private String createdBy;

        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(FileDetail model) {
            fileURI(model.fileURI);
            businessUseCase(model.businessUseCase);
            fileName(model.fileName);
            fileStatus(model.fileStatus);
            fileStatusReason(model.fileStatusReason);
            fileType(model.fileType);
            createdBy(model.createdBy);
            createdAt(model.createdAt);
        }

        public final String getFileURI() {
            return fileURI;
        }

        public final void setFileURI(String fileURI) {
            this.fileURI = fileURI;
        }

        @Override
        public final Builder fileURI(String fileURI) {
            this.fileURI = fileURI;
            return this;
        }

        public final String getBusinessUseCase() {
            return businessUseCase;
        }

        public final void setBusinessUseCase(String businessUseCase) {
            this.businessUseCase = businessUseCase;
        }

        @Override
        public final Builder businessUseCase(String businessUseCase) {
            this.businessUseCase = businessUseCase;
            return this;
        }

        public final String getFileName() {
            return fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final String getFileStatus() {
            return fileStatus;
        }

        public final void setFileStatus(String fileStatus) {
            this.fileStatus = fileStatus;
        }

        @Override
        public final Builder fileStatus(String fileStatus) {
            this.fileStatus = fileStatus;
            return this;
        }

        public final String getFileStatusReason() {
            return fileStatusReason;
        }

        public final void setFileStatusReason(String fileStatusReason) {
            this.fileStatusReason = fileStatusReason;
        }

        @Override
        public final Builder fileStatusReason(String fileStatusReason) {
            this.fileStatusReason = fileStatusReason;
            return this;
        }

        public final String getFileType() {
            return fileType;
        }

        public final void setFileType(String fileType) {
            this.fileType = fileType;
        }

        @Override
        public final Builder fileType(String fileType) {
            this.fileType = fileType;
            return this;
        }

        @Override
        public final Builder fileType(FileType fileType) {
            this.fileType(fileType == null ? null : fileType.toString());
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public FileDetail build() {
            return new FileDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
