/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum CurrencyCode {
    AED("AED"),

    AMD("AMD"),

    ARS("ARS"),

    AUD("AUD"),

    AWG("AWG"),

    AZN("AZN"),

    BBD("BBD"),

    BDT("BDT"),

    BGN("BGN"),

    BMD("BMD"),

    BND("BND"),

    BOB("BOB"),

    BRL("BRL"),

    BSD("BSD"),

    BYR("BYR"),

    BZD("BZD"),

    CAD("CAD"),

    CHF("CHF"),

    CLP("CLP"),

    CNY("CNY"),

    COP("COP"),

    CRC("CRC"),

    CZK("CZK"),

    DKK("DKK"),

    DOP("DOP"),

    EEK("EEK"),

    EGP("EGP"),

    EUR("EUR"),

    GBP("GBP"),

    GEL("GEL"),

    GHS("GHS"),

    GTQ("GTQ"),

    GYD("GYD"),

    HKD("HKD"),

    HNL("HNL"),

    HRK("HRK"),

    HTG("HTG"),

    HUF("HUF"),

    IDR("IDR"),

    ILS("ILS"),

    INR("INR"),

    ISK("ISK"),

    JMD("JMD"),

    JPY("JPY"),

    KES("KES"),

    KHR("KHR"),

    KRW("KRW"),

    KYD("KYD"),

    KZT("KZT"),

    LBP("LBP"),

    LKR("LKR"),

    LTL("LTL"),

    LVL("LVL"),

    MAD("MAD"),

    MNT("MNT"),

    MOP("MOP"),

    MUR("MUR"),

    MVR("MVR"),

    MXN("MXN"),

    MYR("MYR"),

    NAD("NAD"),

    NGN("NGN"),

    NIO("NIO"),

    NOK("NOK"),

    NZD("NZD"),

    PAB("PAB"),

    PEN("PEN"),

    PHP("PHP"),

    PKR("PKR"),

    PLN("PLN"),

    PYG("PYG"),

    QAR("QAR"),

    RON("RON"),

    RUB("RUB"),

    SAR("SAR"),

    SEK("SEK"),

    SGD("SGD"),

    SIT("SIT"),

    SKK("SKK"),

    THB("THB"),

    TND("TND"),

    TRY("TRY"),

    TTD("TTD"),

    TWD("TWD"),

    TZS("TZS"),

    UAH("UAH"),

    USD("USD"),

    UYU("UYU"),

    UZS("UZS"),

    VND("VND"),

    XAF("XAF"),

    XCD("XCD"),

    XOF("XOF"),

    XPF("XPF"),

    ZAR("ZAR"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CurrencyCode> VALUE_MAP = EnumUtils.uniqueIndex(CurrencyCode.class, CurrencyCode::toString);

    private final String value;

    private CurrencyCode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return CurrencyCode corresponding to the value
     */
    public static CurrencyCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link CurrencyCode}s
     */
    public static Set<CurrencyCode> knownValues() {
        Set<CurrencyCode> knownValues = EnumSet.allOf(CurrencyCode.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
