/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about credit-based benefit fulfillment, including AWS promotional credits.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreditDetails implements SdkPojo, Serializable, ToCopyableBuilder<CreditDetails.Builder, CreditDetails> {
    private static final SdkField<MonetaryValue> ALLOCATED_AMOUNT_FIELD = SdkField
            .<MonetaryValue> builder(MarshallingType.SDK_POJO).memberName("AllocatedAmount")
            .getter(getter(CreditDetails::allocatedAmount)).setter(setter(Builder::allocatedAmount))
            .constructor(MonetaryValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedAmount").build()).build();

    private static final SdkField<MonetaryValue> ISSUED_AMOUNT_FIELD = SdkField.<MonetaryValue> builder(MarshallingType.SDK_POJO)
            .memberName("IssuedAmount").getter(getter(CreditDetails::issuedAmount)).setter(setter(Builder::issuedAmount))
            .constructor(MonetaryValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssuedAmount").build()).build();

    private static final SdkField<List<CreditCode>> CODES_FIELD = SdkField
            .<List<CreditCode>> builder(MarshallingType.LIST)
            .memberName("Codes")
            .getter(getter(CreditDetails::codes))
            .setter(setter(Builder::codes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Codes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CreditCode> builder(MarshallingType.SDK_POJO)
                                            .constructor(CreditCode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATED_AMOUNT_FIELD,
            ISSUED_AMOUNT_FIELD, CODES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MonetaryValue allocatedAmount;

    private final MonetaryValue issuedAmount;

    private final List<CreditCode> codes;

    private CreditDetails(BuilderImpl builder) {
        this.allocatedAmount = builder.allocatedAmount;
        this.issuedAmount = builder.issuedAmount;
        this.codes = builder.codes;
    }

    /**
     * <p>
     * The total amount of credits that have been allocated for this benefit.
     * </p>
     * 
     * @return The total amount of credits that have been allocated for this benefit.
     */
    public final MonetaryValue allocatedAmount() {
        return allocatedAmount;
    }

    /**
     * <p>
     * The amount of credits that have actually been issued and are available for use.
     * </p>
     * 
     * @return The amount of credits that have actually been issued and are available for use.
     */
    public final MonetaryValue issuedAmount() {
        return issuedAmount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Codes property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasCodes() {
        return codes != null && !(codes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of credit codes that have been generated for this benefit allocation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCodes} method.
     * </p>
     * 
     * @return A list of credit codes that have been generated for this benefit allocation.
     */
    public final List<CreditCode> codes() {
        return codes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allocatedAmount());
        hashCode = 31 * hashCode + Objects.hashCode(issuedAmount());
        hashCode = 31 * hashCode + Objects.hashCode(hasCodes() ? codes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreditDetails)) {
            return false;
        }
        CreditDetails other = (CreditDetails) obj;
        return Objects.equals(allocatedAmount(), other.allocatedAmount()) && Objects.equals(issuedAmount(), other.issuedAmount())
                && hasCodes() == other.hasCodes() && Objects.equals(codes(), other.codes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreditDetails").add("AllocatedAmount", allocatedAmount()).add("IssuedAmount", issuedAmount())
                .add("Codes", hasCodes() ? codes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllocatedAmount":
            return Optional.ofNullable(clazz.cast(allocatedAmount()));
        case "IssuedAmount":
            return Optional.ofNullable(clazz.cast(issuedAmount()));
        case "Codes":
            return Optional.ofNullable(clazz.cast(codes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AllocatedAmount", ALLOCATED_AMOUNT_FIELD);
        map.put("IssuedAmount", ISSUED_AMOUNT_FIELD);
        map.put("Codes", CODES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreditDetails, T> g) {
        return obj -> g.apply((CreditDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreditDetails> {
        /**
         * <p>
         * The total amount of credits that have been allocated for this benefit.
         * </p>
         * 
         * @param allocatedAmount
         *        The total amount of credits that have been allocated for this benefit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedAmount(MonetaryValue allocatedAmount);

        /**
         * <p>
         * The total amount of credits that have been allocated for this benefit.
         * </p>
         * This is a convenience method that creates an instance of the {@link MonetaryValue.Builder} avoiding the need
         * to create one manually via {@link MonetaryValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonetaryValue.Builder#build()} is called immediately and its
         * result is passed to {@link #allocatedAmount(MonetaryValue)}.
         * 
         * @param allocatedAmount
         *        a consumer that will call methods on {@link MonetaryValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allocatedAmount(MonetaryValue)
         */
        default Builder allocatedAmount(Consumer<MonetaryValue.Builder> allocatedAmount) {
            return allocatedAmount(MonetaryValue.builder().applyMutation(allocatedAmount).build());
        }

        /**
         * <p>
         * The amount of credits that have actually been issued and are available for use.
         * </p>
         * 
         * @param issuedAmount
         *        The amount of credits that have actually been issued and are available for use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuedAmount(MonetaryValue issuedAmount);

        /**
         * <p>
         * The amount of credits that have actually been issued and are available for use.
         * </p>
         * This is a convenience method that creates an instance of the {@link MonetaryValue.Builder} avoiding the need
         * to create one manually via {@link MonetaryValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonetaryValue.Builder#build()} is called immediately and its
         * result is passed to {@link #issuedAmount(MonetaryValue)}.
         * 
         * @param issuedAmount
         *        a consumer that will call methods on {@link MonetaryValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #issuedAmount(MonetaryValue)
         */
        default Builder issuedAmount(Consumer<MonetaryValue.Builder> issuedAmount) {
            return issuedAmount(MonetaryValue.builder().applyMutation(issuedAmount).build());
        }

        /**
         * <p>
         * A list of credit codes that have been generated for this benefit allocation.
         * </p>
         * 
         * @param codes
         *        A list of credit codes that have been generated for this benefit allocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codes(Collection<CreditCode> codes);

        /**
         * <p>
         * A list of credit codes that have been generated for this benefit allocation.
         * </p>
         * 
         * @param codes
         *        A list of credit codes that have been generated for this benefit allocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codes(CreditCode... codes);

        /**
         * <p>
         * A list of credit codes that have been generated for this benefit allocation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralbenefits.model.CreditCode.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.partnercentralbenefits.model.CreditCode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralbenefits.model.CreditCode.Builder#build()} is called
         * immediately and its result is passed to {@link #codes(List<CreditCode>)}.
         * 
         * @param codes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.CreditCode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codes(java.util.Collection<CreditCode>)
         */
        Builder codes(Consumer<CreditCode.Builder>... codes);
    }

    static final class BuilderImpl implements Builder {
        private MonetaryValue allocatedAmount;

        private MonetaryValue issuedAmount;

        private List<CreditCode> codes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreditDetails model) {
            allocatedAmount(model.allocatedAmount);
            issuedAmount(model.issuedAmount);
            codes(model.codes);
        }

        public final MonetaryValue.Builder getAllocatedAmount() {
            return allocatedAmount != null ? allocatedAmount.toBuilder() : null;
        }

        public final void setAllocatedAmount(MonetaryValue.BuilderImpl allocatedAmount) {
            this.allocatedAmount = allocatedAmount != null ? allocatedAmount.build() : null;
        }

        @Override
        public final Builder allocatedAmount(MonetaryValue allocatedAmount) {
            this.allocatedAmount = allocatedAmount;
            return this;
        }

        public final MonetaryValue.Builder getIssuedAmount() {
            return issuedAmount != null ? issuedAmount.toBuilder() : null;
        }

        public final void setIssuedAmount(MonetaryValue.BuilderImpl issuedAmount) {
            this.issuedAmount = issuedAmount != null ? issuedAmount.build() : null;
        }

        @Override
        public final Builder issuedAmount(MonetaryValue issuedAmount) {
            this.issuedAmount = issuedAmount;
            return this;
        }

        public final List<CreditCode.Builder> getCodes() {
            List<CreditCode.Builder> result = CreditCodesCopier.copyToBuilder(this.codes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCodes(Collection<CreditCode.BuilderImpl> codes) {
            this.codes = CreditCodesCopier.copyFromBuilder(codes);
        }

        @Override
        public final Builder codes(Collection<CreditCode> codes) {
            this.codes = CreditCodesCopier.copy(codes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codes(CreditCode... codes) {
            codes(Arrays.asList(codes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codes(Consumer<CreditCode.Builder>... codes) {
            codes(Stream.of(codes).map(c -> CreditCode.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreditDetails build() {
            return new CreditDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
