/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an AWS credit code that can be applied to an AWS account for billing purposes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreditCode implements SdkPojo, Serializable, ToCopyableBuilder<CreditCode.Builder, CreditCode> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(CreditCode::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build()).build();

    private static final SdkField<MonetaryValue> VALUE_FIELD = SdkField.<MonetaryValue> builder(MarshallingType.SDK_POJO)
            .memberName("Value").getter(getter(CreditCode::value)).setter(setter(Builder::value))
            .constructor(MonetaryValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> AWS_CREDIT_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsCreditCode").getter(getter(CreditCode::awsCreditCode)).setter(setter(Builder::awsCreditCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsCreditCode").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(CreditCode::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> ISSUED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("IssuedAt")
            .getter(getter(CreditCode::issuedAt))
            .setter(setter(Builder::issuedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssuedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpiresAt")
            .getter(getter(CreditCode::expiresAt))
            .setter(setter(Builder::expiresAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiresAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            VALUE_FIELD, AWS_CREDIT_CODE_FIELD, STATUS_FIELD, ISSUED_AT_FIELD, EXPIRES_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String awsAccountId;

    private final MonetaryValue value;

    private final String awsCreditCode;

    private final String status;

    private final Instant issuedAt;

    private final Instant expiresAt;

    private CreditCode(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.value = builder.value;
        this.awsCreditCode = builder.awsCreditCode;
        this.status = builder.status;
        this.issuedAt = builder.issuedAt;
        this.expiresAt = builder.expiresAt;
    }

    /**
     * <p>
     * The AWS account ID that the credit code is associated with or can be applied to.
     * </p>
     * 
     * @return The AWS account ID that the credit code is associated with or can be applied to.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The monetary value of the credit code.
     * </p>
     * 
     * @return The monetary value of the credit code.
     */
    public final MonetaryValue value() {
        return value;
    }

    /**
     * <p>
     * The actual credit code string that can be redeemed in the AWS billing console.
     * </p>
     * 
     * @return The actual credit code string that can be redeemed in the AWS billing console.
     */
    public final String awsCreditCode() {
        return awsCreditCode;
    }

    /**
     * <p>
     * The current status of the credit code (e.g., active, redeemed, expired).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BenefitAllocationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the credit code (e.g., active, redeemed, expired).
     * @see BenefitAllocationStatus
     */
    public final BenefitAllocationStatus status() {
        return BenefitAllocationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the credit code (e.g., active, redeemed, expired).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BenefitAllocationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the credit code (e.g., active, redeemed, expired).
     * @see BenefitAllocationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp when the credit code was issued.
     * </p>
     * 
     * @return The timestamp when the credit code was issued.
     */
    public final Instant issuedAt() {
        return issuedAt;
    }

    /**
     * <p>
     * The timestamp when the credit code expires and can no longer be redeemed.
     * </p>
     * 
     * @return The timestamp when the credit code expires and can no longer be redeemed.
     */
    public final Instant expiresAt() {
        return expiresAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(awsCreditCode());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(issuedAt());
        hashCode = 31 * hashCode + Objects.hashCode(expiresAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreditCode)) {
            return false;
        }
        CreditCode other = (CreditCode) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(value(), other.value())
                && Objects.equals(awsCreditCode(), other.awsCreditCode())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(issuedAt(), other.issuedAt())
                && Objects.equals(expiresAt(), other.expiresAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreditCode").add("AwsAccountId", awsAccountId()).add("Value", value())
                .add("AwsCreditCode", awsCreditCode()).add("Status", statusAsString()).add("IssuedAt", issuedAt())
                .add("ExpiresAt", expiresAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "AwsCreditCode":
            return Optional.ofNullable(clazz.cast(awsCreditCode()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "IssuedAt":
            return Optional.ofNullable(clazz.cast(issuedAt()));
        case "ExpiresAt":
            return Optional.ofNullable(clazz.cast(expiresAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("AwsCreditCode", AWS_CREDIT_CODE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("IssuedAt", ISSUED_AT_FIELD);
        map.put("ExpiresAt", EXPIRES_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreditCode, T> g) {
        return obj -> g.apply((CreditCode) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreditCode> {
        /**
         * <p>
         * The AWS account ID that the credit code is associated with or can be applied to.
         * </p>
         * 
         * @param awsAccountId
         *        The AWS account ID that the credit code is associated with or can be applied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The monetary value of the credit code.
         * </p>
         * 
         * @param value
         *        The monetary value of the credit code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(MonetaryValue value);

        /**
         * <p>
         * The monetary value of the credit code.
         * </p>
         * This is a convenience method that creates an instance of the {@link MonetaryValue.Builder} avoiding the need
         * to create one manually via {@link MonetaryValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonetaryValue.Builder#build()} is called immediately and its
         * result is passed to {@link #value(MonetaryValue)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link MonetaryValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(MonetaryValue)
         */
        default Builder value(Consumer<MonetaryValue.Builder> value) {
            return value(MonetaryValue.builder().applyMutation(value).build());
        }

        /**
         * <p>
         * The actual credit code string that can be redeemed in the AWS billing console.
         * </p>
         * 
         * @param awsCreditCode
         *        The actual credit code string that can be redeemed in the AWS billing console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsCreditCode(String awsCreditCode);

        /**
         * <p>
         * The current status of the credit code (e.g., active, redeemed, expired).
         * </p>
         * 
         * @param status
         *        The current status of the credit code (e.g., active, redeemed, expired).
         * @see BenefitAllocationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BenefitAllocationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the credit code (e.g., active, redeemed, expired).
         * </p>
         * 
         * @param status
         *        The current status of the credit code (e.g., active, redeemed, expired).
         * @see BenefitAllocationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BenefitAllocationStatus
         */
        Builder status(BenefitAllocationStatus status);

        /**
         * <p>
         * The timestamp when the credit code was issued.
         * </p>
         * 
         * @param issuedAt
         *        The timestamp when the credit code was issued.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuedAt(Instant issuedAt);

        /**
         * <p>
         * The timestamp when the credit code expires and can no longer be redeemed.
         * </p>
         * 
         * @param expiresAt
         *        The timestamp when the credit code expires and can no longer be redeemed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresAt(Instant expiresAt);
    }

    static final class BuilderImpl implements Builder {
        private String awsAccountId;

        private MonetaryValue value;

        private String awsCreditCode;

        private String status;

        private Instant issuedAt;

        private Instant expiresAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CreditCode model) {
            awsAccountId(model.awsAccountId);
            value(model.value);
            awsCreditCode(model.awsCreditCode);
            status(model.status);
            issuedAt(model.issuedAt);
            expiresAt(model.expiresAt);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final MonetaryValue.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(MonetaryValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(MonetaryValue value) {
            this.value = value;
            return this;
        }

        public final String getAwsCreditCode() {
            return awsCreditCode;
        }

        public final void setAwsCreditCode(String awsCreditCode) {
            this.awsCreditCode = awsCreditCode;
        }

        @Override
        public final Builder awsCreditCode(String awsCreditCode) {
            this.awsCreditCode = awsCreditCode;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BenefitAllocationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getIssuedAt() {
            return issuedAt;
        }

        public final void setIssuedAt(Instant issuedAt) {
            this.issuedAt = issuedAt;
        }

        @Override
        public final Builder issuedAt(Instant issuedAt) {
            this.issuedAt = issuedAt;
            return this;
        }

        public final Instant getExpiresAt() {
            return expiresAt;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        @Override
        public CreditCode build() {
            return new CreditCode(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
