/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBenefitApplicationRequest extends PartnerCentralBenefitsRequest implements
        ToCopyableBuilder<CreateBenefitApplicationRequest.Builder, CreateBenefitApplicationRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(CreateBenefitApplicationRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(CreateBenefitApplicationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateBenefitApplicationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateBenefitApplicationRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> BENEFIT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BenefitIdentifier").getter(getter(CreateBenefitApplicationRequest::benefitIdentifier))
            .setter(setter(Builder::benefitIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BenefitIdentifier").build()).build();

    private static final SdkField<List<String>> FULFILLMENT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FulfillmentTypes")
            .getter(getter(CreateBenefitApplicationRequest::fulfillmentTypesAsStrings))
            .setter(setter(Builder::fulfillmentTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FulfillmentTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Document> BENEFIT_APPLICATION_DETAILS_FIELD = SdkField
            .<Document> builder(MarshallingType.DOCUMENT).memberName("BenefitApplicationDetails")
            .getter(getter(CreateBenefitApplicationRequest::benefitApplicationDetails))
            .setter(setter(Builder::benefitApplicationDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BenefitApplicationDetails").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateBenefitApplicationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ASSOCIATED_RESOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AssociatedResources")
            .getter(getter(CreateBenefitApplicationRequest::associatedResources))
            .setter(setter(Builder::associatedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Contact>> PARTNER_CONTACTS_FIELD = SdkField
            .<List<Contact>> builder(MarshallingType.LIST)
            .memberName("PartnerContacts")
            .getter(getter(CreateBenefitApplicationRequest::partnerContacts))
            .setter(setter(Builder::partnerContacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerContacts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Contact> builder(MarshallingType.SDK_POJO)
                                            .constructor(Contact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FileInput>> FILE_DETAILS_FIELD = SdkField
            .<List<FileInput>> builder(MarshallingType.LIST)
            .memberName("FileDetails")
            .getter(getter(CreateBenefitApplicationRequest::fileDetails))
            .setter(setter(Builder::fileDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FileInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(FileInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CATALOG_FIELD, CLIENT_TOKEN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, BENEFIT_IDENTIFIER_FIELD,
                    FULFILLMENT_TYPES_FIELD, BENEFIT_APPLICATION_DETAILS_FIELD, TAGS_FIELD, ASSOCIATED_RESOURCES_FIELD,
                    PARTNER_CONTACTS_FIELD, FILE_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final String clientToken;

    private final String name;

    private final String description;

    private final String benefitIdentifier;

    private final List<String> fulfillmentTypes;

    private final Document benefitApplicationDetails;

    private final List<Tag> tags;

    private final List<String> associatedResources;

    private final List<Contact> partnerContacts;

    private final List<FileInput> fileDetails;

    private CreateBenefitApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.clientToken = builder.clientToken;
        this.name = builder.name;
        this.description = builder.description;
        this.benefitIdentifier = builder.benefitIdentifier;
        this.fulfillmentTypes = builder.fulfillmentTypes;
        this.benefitApplicationDetails = builder.benefitApplicationDetails;
        this.tags = builder.tags;
        this.associatedResources = builder.associatedResources;
        this.partnerContacts = builder.partnerContacts;
        this.fileDetails = builder.fileDetails;
    }

    /**
     * <p>
     * The catalog identifier that specifies which benefit catalog to create the application in.
     * </p>
     * 
     * @return The catalog identifier that specifies which benefit catalog to create the application in.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure idempotent processing of the creation request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure idempotent processing of the creation request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A human-readable name for the benefit application.
     * </p>
     * 
     * @return A human-readable name for the benefit application.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A detailed description of the benefit application and its intended use.
     * </p>
     * 
     * @return A detailed description of the benefit application and its intended use.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The unique identifier of the benefit being requested in this application.
     * </p>
     * 
     * @return The unique identifier of the benefit being requested in this application.
     */
    public final String benefitIdentifier() {
        return benefitIdentifier;
    }

    /**
     * <p>
     * The types of fulfillment requested for this benefit application (e.g., credits, access, disbursement).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFulfillmentTypes} method.
     * </p>
     * 
     * @return The types of fulfillment requested for this benefit application (e.g., credits, access, disbursement).
     */
    public final List<FulfillmentType> fulfillmentTypes() {
        return FulfillmentTypesCopier.copyStringToEnum(fulfillmentTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the FulfillmentTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFulfillmentTypes() {
        return fulfillmentTypes != null && !(fulfillmentTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The types of fulfillment requested for this benefit application (e.g., credits, access, disbursement).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFulfillmentTypes} method.
     * </p>
     * 
     * @return The types of fulfillment requested for this benefit application (e.g., credits, access, disbursement).
     */
    public final List<String> fulfillmentTypesAsStrings() {
        return fulfillmentTypes;
    }

    /**
     * <p>
     * Detailed information and requirements specific to the benefit being requested.
     * </p>
     * 
     * @return Detailed information and requirements specific to the benefit being requested.
     */
    public final Document benefitApplicationDetails() {
        return benefitApplicationDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Key-value pairs to categorize and organize the benefit application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Key-value pairs to categorize and organize the benefit application.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedResources property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociatedResources() {
        return associatedResources != null && !(associatedResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * AWS resources that are associated with this benefit application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedResources} method.
     * </p>
     * 
     * @return AWS resources that are associated with this benefit application.
     */
    public final List<String> associatedResources() {
        return associatedResources;
    }

    /**
     * For responses, this returns true if the service returned a value for the PartnerContacts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPartnerContacts() {
        return partnerContacts != null && !(partnerContacts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contact information for partner representatives responsible for this benefit application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPartnerContacts} method.
     * </p>
     * 
     * @return Contact information for partner representatives responsible for this benefit application.
     */
    public final List<Contact> partnerContacts() {
        return partnerContacts;
    }

    /**
     * For responses, this returns true if the service returned a value for the FileDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFileDetails() {
        return fileDetails != null && !(fileDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Supporting documents and files attached to the benefit application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFileDetails} method.
     * </p>
     * 
     * @return Supporting documents and files attached to the benefit application.
     */
    public final List<FileInput> fileDetails() {
        return fileDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(benefitIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasFulfillmentTypes() ? fulfillmentTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(benefitApplicationDetails());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedResources() ? associatedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPartnerContacts() ? partnerContacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFileDetails() ? fileDetails() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBenefitApplicationRequest)) {
            return false;
        }
        CreateBenefitApplicationRequest other = (CreateBenefitApplicationRequest) obj;
        return Objects.equals(catalog(), other.catalog()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(benefitIdentifier(), other.benefitIdentifier())
                && hasFulfillmentTypes() == other.hasFulfillmentTypes()
                && Objects.equals(fulfillmentTypesAsStrings(), other.fulfillmentTypesAsStrings())
                && Objects.equals(benefitApplicationDetails(), other.benefitApplicationDetails()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasAssociatedResources() == other.hasAssociatedResources()
                && Objects.equals(associatedResources(), other.associatedResources())
                && hasPartnerContacts() == other.hasPartnerContacts()
                && Objects.equals(partnerContacts(), other.partnerContacts()) && hasFileDetails() == other.hasFileDetails()
                && Objects.equals(fileDetails(), other.fileDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBenefitApplicationRequest").add("Catalog", catalog()).add("ClientToken", clientToken())
                .add("Name", name()).add("Description", description()).add("BenefitIdentifier", benefitIdentifier())
                .add("FulfillmentTypes", hasFulfillmentTypes() ? fulfillmentTypesAsStrings() : null)
                .add("BenefitApplicationDetails", benefitApplicationDetails()).add("Tags", hasTags() ? tags() : null)
                .add("AssociatedResources", hasAssociatedResources() ? associatedResources() : null)
                .add("PartnerContacts", hasPartnerContacts() ? partnerContacts() : null)
                .add("FileDetails", hasFileDetails() ? fileDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "BenefitIdentifier":
            return Optional.ofNullable(clazz.cast(benefitIdentifier()));
        case "FulfillmentTypes":
            return Optional.ofNullable(clazz.cast(fulfillmentTypesAsStrings()));
        case "BenefitApplicationDetails":
            return Optional.ofNullable(clazz.cast(benefitApplicationDetails()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "AssociatedResources":
            return Optional.ofNullable(clazz.cast(associatedResources()));
        case "PartnerContacts":
            return Optional.ofNullable(clazz.cast(partnerContacts()));
        case "FileDetails":
            return Optional.ofNullable(clazz.cast(fileDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("BenefitIdentifier", BENEFIT_IDENTIFIER_FIELD);
        map.put("FulfillmentTypes", FULFILLMENT_TYPES_FIELD);
        map.put("BenefitApplicationDetails", BENEFIT_APPLICATION_DETAILS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("AssociatedResources", ASSOCIATED_RESOURCES_FIELD);
        map.put("PartnerContacts", PARTNER_CONTACTS_FIELD);
        map.put("FileDetails", FILE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateBenefitApplicationRequest, T> g) {
        return obj -> g.apply((CreateBenefitApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PartnerCentralBenefitsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateBenefitApplicationRequest> {
        /**
         * <p>
         * The catalog identifier that specifies which benefit catalog to create the application in.
         * </p>
         * 
         * @param catalog
         *        The catalog identifier that specifies which benefit catalog to create the application in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure idempotent processing of the creation request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier to ensure idempotent processing of the creation request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A human-readable name for the benefit application.
         * </p>
         * 
         * @param name
         *        A human-readable name for the benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A detailed description of the benefit application and its intended use.
         * </p>
         * 
         * @param description
         *        A detailed description of the benefit application and its intended use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The unique identifier of the benefit being requested in this application.
         * </p>
         * 
         * @param benefitIdentifier
         *        The unique identifier of the benefit being requested in this application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder benefitIdentifier(String benefitIdentifier);

        /**
         * <p>
         * The types of fulfillment requested for this benefit application (e.g., credits, access, disbursement).
         * </p>
         * 
         * @param fulfillmentTypes
         *        The types of fulfillment requested for this benefit application (e.g., credits, access, disbursement).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfillmentTypesWithStrings(Collection<String> fulfillmentTypes);

        /**
         * <p>
         * The types of fulfillment requested for this benefit application (e.g., credits, access, disbursement).
         * </p>
         * 
         * @param fulfillmentTypes
         *        The types of fulfillment requested for this benefit application (e.g., credits, access, disbursement).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfillmentTypesWithStrings(String... fulfillmentTypes);

        /**
         * <p>
         * The types of fulfillment requested for this benefit application (e.g., credits, access, disbursement).
         * </p>
         * 
         * @param fulfillmentTypes
         *        The types of fulfillment requested for this benefit application (e.g., credits, access, disbursement).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfillmentTypes(Collection<FulfillmentType> fulfillmentTypes);

        /**
         * <p>
         * The types of fulfillment requested for this benefit application (e.g., credits, access, disbursement).
         * </p>
         * 
         * @param fulfillmentTypes
         *        The types of fulfillment requested for this benefit application (e.g., credits, access, disbursement).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfillmentTypes(FulfillmentType... fulfillmentTypes);

        /**
         * <p>
         * Detailed information and requirements specific to the benefit being requested.
         * </p>
         * 
         * @param benefitApplicationDetails
         *        Detailed information and requirements specific to the benefit being requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder benefitApplicationDetails(Document benefitApplicationDetails);

        /**
         * <p>
         * Key-value pairs to categorize and organize the benefit application.
         * </p>
         * 
         * @param tags
         *        Key-value pairs to categorize and organize the benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Key-value pairs to categorize and organize the benefit application.
         * </p>
         * 
         * @param tags
         *        Key-value pairs to categorize and organize the benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Key-value pairs to categorize and organize the benefit application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralbenefits.model.Tag.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.partnercentralbenefits.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralbenefits.model.Tag.Builder#build()} is called
         * immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * AWS resources that are associated with this benefit application.
         * </p>
         * 
         * @param associatedResources
         *        AWS resources that are associated with this benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedResources(Collection<String> associatedResources);

        /**
         * <p>
         * AWS resources that are associated with this benefit application.
         * </p>
         * 
         * @param associatedResources
         *        AWS resources that are associated with this benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedResources(String... associatedResources);

        /**
         * <p>
         * Contact information for partner representatives responsible for this benefit application.
         * </p>
         * 
         * @param partnerContacts
         *        Contact information for partner representatives responsible for this benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partnerContacts(Collection<Contact> partnerContacts);

        /**
         * <p>
         * Contact information for partner representatives responsible for this benefit application.
         * </p>
         * 
         * @param partnerContacts
         *        Contact information for partner representatives responsible for this benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partnerContacts(Contact... partnerContacts);

        /**
         * <p>
         * Contact information for partner representatives responsible for this benefit application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralbenefits.model.Contact.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.partnercentralbenefits.model.Contact#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralbenefits.model.Contact.Builder#build()} is called
         * immediately and its result is passed to {@link #partnerContacts(List<Contact>)}.
         * 
         * @param partnerContacts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.Contact.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partnerContacts(java.util.Collection<Contact>)
         */
        Builder partnerContacts(Consumer<Contact.Builder>... partnerContacts);

        /**
         * <p>
         * Supporting documents and files attached to the benefit application.
         * </p>
         * 
         * @param fileDetails
         *        Supporting documents and files attached to the benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileDetails(Collection<FileInput> fileDetails);

        /**
         * <p>
         * Supporting documents and files attached to the benefit application.
         * </p>
         * 
         * @param fileDetails
         *        Supporting documents and files attached to the benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileDetails(FileInput... fileDetails);

        /**
         * <p>
         * Supporting documents and files attached to the benefit application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralbenefits.model.FileInput.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.partnercentralbenefits.model.FileInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralbenefits.model.FileInput.Builder#build()} is called
         * immediately and its result is passed to {@link #fileDetails(List<FileInput>)}.
         * 
         * @param fileDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.FileInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileDetails(java.util.Collection<FileInput>)
         */
        Builder fileDetails(Consumer<FileInput.Builder>... fileDetails);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PartnerCentralBenefitsRequest.BuilderImpl implements Builder {
        private String catalog;

        private String clientToken;

        private String name;

        private String description;

        private String benefitIdentifier;

        private List<String> fulfillmentTypes = DefaultSdkAutoConstructList.getInstance();

        private Document benefitApplicationDetails;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<String> associatedResources = DefaultSdkAutoConstructList.getInstance();

        private List<Contact> partnerContacts = DefaultSdkAutoConstructList.getInstance();

        private List<FileInput> fileDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBenefitApplicationRequest model) {
            super(model);
            catalog(model.catalog);
            clientToken(model.clientToken);
            name(model.name);
            description(model.description);
            benefitIdentifier(model.benefitIdentifier);
            fulfillmentTypesWithStrings(model.fulfillmentTypes);
            benefitApplicationDetails(model.benefitApplicationDetails);
            tags(model.tags);
            associatedResources(model.associatedResources);
            partnerContacts(model.partnerContacts);
            fileDetails(model.fileDetails);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getBenefitIdentifier() {
            return benefitIdentifier;
        }

        public final void setBenefitIdentifier(String benefitIdentifier) {
            this.benefitIdentifier = benefitIdentifier;
        }

        @Override
        public final Builder benefitIdentifier(String benefitIdentifier) {
            this.benefitIdentifier = benefitIdentifier;
            return this;
        }

        public final Collection<String> getFulfillmentTypes() {
            if (fulfillmentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return fulfillmentTypes;
        }

        public final void setFulfillmentTypes(Collection<String> fulfillmentTypes) {
            this.fulfillmentTypes = FulfillmentTypesCopier.copy(fulfillmentTypes);
        }

        @Override
        public final Builder fulfillmentTypesWithStrings(Collection<String> fulfillmentTypes) {
            this.fulfillmentTypes = FulfillmentTypesCopier.copy(fulfillmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fulfillmentTypesWithStrings(String... fulfillmentTypes) {
            fulfillmentTypesWithStrings(Arrays.asList(fulfillmentTypes));
            return this;
        }

        @Override
        public final Builder fulfillmentTypes(Collection<FulfillmentType> fulfillmentTypes) {
            this.fulfillmentTypes = FulfillmentTypesCopier.copyEnumToString(fulfillmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fulfillmentTypes(FulfillmentType... fulfillmentTypes) {
            fulfillmentTypes(Arrays.asList(fulfillmentTypes));
            return this;
        }

        public final Document getBenefitApplicationDetails() {
            return benefitApplicationDetails;
        }

        public final void setBenefitApplicationDetails(Document benefitApplicationDetails) {
            this.benefitApplicationDetails = benefitApplicationDetails;
        }

        @Override
        public final Builder benefitApplicationDetails(Document benefitApplicationDetails) {
            this.benefitApplicationDetails = benefitApplicationDetails;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = CreateBenefitApplicationInputTagsListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = CreateBenefitApplicationInputTagsListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = CreateBenefitApplicationInputTagsListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAssociatedResources() {
            if (associatedResources instanceof SdkAutoConstructList) {
                return null;
            }
            return associatedResources;
        }

        public final void setAssociatedResources(Collection<String> associatedResources) {
            this.associatedResources = CreateBenefitApplicationInputAssociatedResourcesListCopier.copy(associatedResources);
        }

        @Override
        public final Builder associatedResources(Collection<String> associatedResources) {
            this.associatedResources = CreateBenefitApplicationInputAssociatedResourcesListCopier.copy(associatedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedResources(String... associatedResources) {
            associatedResources(Arrays.asList(associatedResources));
            return this;
        }

        public final List<Contact.Builder> getPartnerContacts() {
            List<Contact.Builder> result = CreateBenefitApplicationInputPartnerContactsListCopier
                    .copyToBuilder(this.partnerContacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPartnerContacts(Collection<Contact.BuilderImpl> partnerContacts) {
            this.partnerContacts = CreateBenefitApplicationInputPartnerContactsListCopier.copyFromBuilder(partnerContacts);
        }

        @Override
        public final Builder partnerContacts(Collection<Contact> partnerContacts) {
            this.partnerContacts = CreateBenefitApplicationInputPartnerContactsListCopier.copy(partnerContacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partnerContacts(Contact... partnerContacts) {
            partnerContacts(Arrays.asList(partnerContacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partnerContacts(Consumer<Contact.Builder>... partnerContacts) {
            partnerContacts(Stream.of(partnerContacts).map(c -> Contact.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<FileInput.Builder> getFileDetails() {
            List<FileInput.Builder> result = CreateBenefitApplicationInputFileDetailsListCopier.copyToBuilder(this.fileDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileDetails(Collection<FileInput.BuilderImpl> fileDetails) {
            this.fileDetails = CreateBenefitApplicationInputFileDetailsListCopier.copyFromBuilder(fileDetails);
        }

        @Override
        public final Builder fileDetails(Collection<FileInput> fileDetails) {
            this.fileDetails = CreateBenefitApplicationInputFileDetailsListCopier.copy(fileDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileDetails(FileInput... fileDetails) {
            fileDetails(Arrays.asList(fileDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileDetails(Consumer<FileInput.Builder>... fileDetails) {
            fileDetails(Stream.of(fileDetails).map(c -> FileInput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBenefitApplicationRequest build() {
            return new CreateBenefitApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
