/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about consumable benefit fulfillment, such as usage quotas or service limits.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConsumableDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ConsumableDetails.Builder, ConsumableDetails> {
    private static final SdkField<MonetaryValue> ALLOCATED_AMOUNT_FIELD = SdkField
            .<MonetaryValue> builder(MarshallingType.SDK_POJO).memberName("AllocatedAmount")
            .getter(getter(ConsumableDetails::allocatedAmount)).setter(setter(Builder::allocatedAmount))
            .constructor(MonetaryValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedAmount").build()).build();

    private static final SdkField<MonetaryValue> REMAINING_AMOUNT_FIELD = SdkField
            .<MonetaryValue> builder(MarshallingType.SDK_POJO).memberName("RemainingAmount")
            .getter(getter(ConsumableDetails::remainingAmount)).setter(setter(Builder::remainingAmount))
            .constructor(MonetaryValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemainingAmount").build()).build();

    private static final SdkField<MonetaryValue> UTILIZED_AMOUNT_FIELD = SdkField
            .<MonetaryValue> builder(MarshallingType.SDK_POJO).memberName("UtilizedAmount")
            .getter(getter(ConsumableDetails::utilizedAmount)).setter(setter(Builder::utilizedAmount))
            .constructor(MonetaryValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UtilizedAmount").build()).build();

    private static final SdkField<IssuanceDetail> ISSUANCE_DETAILS_FIELD = SdkField
            .<IssuanceDetail> builder(MarshallingType.SDK_POJO).memberName("IssuanceDetails")
            .getter(getter(ConsumableDetails::issuanceDetails)).setter(setter(Builder::issuanceDetails))
            .constructor(IssuanceDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssuanceDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATED_AMOUNT_FIELD,
            REMAINING_AMOUNT_FIELD, UTILIZED_AMOUNT_FIELD, ISSUANCE_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MonetaryValue allocatedAmount;

    private final MonetaryValue remainingAmount;

    private final MonetaryValue utilizedAmount;

    private final IssuanceDetail issuanceDetails;

    private ConsumableDetails(BuilderImpl builder) {
        this.allocatedAmount = builder.allocatedAmount;
        this.remainingAmount = builder.remainingAmount;
        this.utilizedAmount = builder.utilizedAmount;
        this.issuanceDetails = builder.issuanceDetails;
    }

    /**
     * <p>
     * The total amount of the consumable benefit that has been allocated.
     * </p>
     * 
     * @return The total amount of the consumable benefit that has been allocated.
     */
    public final MonetaryValue allocatedAmount() {
        return allocatedAmount;
    }

    /**
     * <p>
     * The remaining amount of the consumable benefit that is still available for use.
     * </p>
     * 
     * @return The remaining amount of the consumable benefit that is still available for use.
     */
    public final MonetaryValue remainingAmount() {
        return remainingAmount;
    }

    /**
     * <p>
     * The amount of the consumable benefit that has already been used.
     * </p>
     * 
     * @return The amount of the consumable benefit that has already been used.
     */
    public final MonetaryValue utilizedAmount() {
        return utilizedAmount;
    }

    /**
     * <p>
     * Detailed information about how the consumable benefit was issued and distributed.
     * </p>
     * 
     * @return Detailed information about how the consumable benefit was issued and distributed.
     */
    public final IssuanceDetail issuanceDetails() {
        return issuanceDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allocatedAmount());
        hashCode = 31 * hashCode + Objects.hashCode(remainingAmount());
        hashCode = 31 * hashCode + Objects.hashCode(utilizedAmount());
        hashCode = 31 * hashCode + Objects.hashCode(issuanceDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConsumableDetails)) {
            return false;
        }
        ConsumableDetails other = (ConsumableDetails) obj;
        return Objects.equals(allocatedAmount(), other.allocatedAmount())
                && Objects.equals(remainingAmount(), other.remainingAmount())
                && Objects.equals(utilizedAmount(), other.utilizedAmount())
                && Objects.equals(issuanceDetails(), other.issuanceDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConsumableDetails").add("AllocatedAmount", allocatedAmount())
                .add("RemainingAmount", remainingAmount()).add("UtilizedAmount", utilizedAmount())
                .add("IssuanceDetails", issuanceDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllocatedAmount":
            return Optional.ofNullable(clazz.cast(allocatedAmount()));
        case "RemainingAmount":
            return Optional.ofNullable(clazz.cast(remainingAmount()));
        case "UtilizedAmount":
            return Optional.ofNullable(clazz.cast(utilizedAmount()));
        case "IssuanceDetails":
            return Optional.ofNullable(clazz.cast(issuanceDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AllocatedAmount", ALLOCATED_AMOUNT_FIELD);
        map.put("RemainingAmount", REMAINING_AMOUNT_FIELD);
        map.put("UtilizedAmount", UTILIZED_AMOUNT_FIELD);
        map.put("IssuanceDetails", ISSUANCE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConsumableDetails, T> g) {
        return obj -> g.apply((ConsumableDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConsumableDetails> {
        /**
         * <p>
         * The total amount of the consumable benefit that has been allocated.
         * </p>
         * 
         * @param allocatedAmount
         *        The total amount of the consumable benefit that has been allocated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedAmount(MonetaryValue allocatedAmount);

        /**
         * <p>
         * The total amount of the consumable benefit that has been allocated.
         * </p>
         * This is a convenience method that creates an instance of the {@link MonetaryValue.Builder} avoiding the need
         * to create one manually via {@link MonetaryValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonetaryValue.Builder#build()} is called immediately and its
         * result is passed to {@link #allocatedAmount(MonetaryValue)}.
         * 
         * @param allocatedAmount
         *        a consumer that will call methods on {@link MonetaryValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allocatedAmount(MonetaryValue)
         */
        default Builder allocatedAmount(Consumer<MonetaryValue.Builder> allocatedAmount) {
            return allocatedAmount(MonetaryValue.builder().applyMutation(allocatedAmount).build());
        }

        /**
         * <p>
         * The remaining amount of the consumable benefit that is still available for use.
         * </p>
         * 
         * @param remainingAmount
         *        The remaining amount of the consumable benefit that is still available for use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remainingAmount(MonetaryValue remainingAmount);

        /**
         * <p>
         * The remaining amount of the consumable benefit that is still available for use.
         * </p>
         * This is a convenience method that creates an instance of the {@link MonetaryValue.Builder} avoiding the need
         * to create one manually via {@link MonetaryValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonetaryValue.Builder#build()} is called immediately and its
         * result is passed to {@link #remainingAmount(MonetaryValue)}.
         * 
         * @param remainingAmount
         *        a consumer that will call methods on {@link MonetaryValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remainingAmount(MonetaryValue)
         */
        default Builder remainingAmount(Consumer<MonetaryValue.Builder> remainingAmount) {
            return remainingAmount(MonetaryValue.builder().applyMutation(remainingAmount).build());
        }

        /**
         * <p>
         * The amount of the consumable benefit that has already been used.
         * </p>
         * 
         * @param utilizedAmount
         *        The amount of the consumable benefit that has already been used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utilizedAmount(MonetaryValue utilizedAmount);

        /**
         * <p>
         * The amount of the consumable benefit that has already been used.
         * </p>
         * This is a convenience method that creates an instance of the {@link MonetaryValue.Builder} avoiding the need
         * to create one manually via {@link MonetaryValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonetaryValue.Builder#build()} is called immediately and its
         * result is passed to {@link #utilizedAmount(MonetaryValue)}.
         * 
         * @param utilizedAmount
         *        a consumer that will call methods on {@link MonetaryValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #utilizedAmount(MonetaryValue)
         */
        default Builder utilizedAmount(Consumer<MonetaryValue.Builder> utilizedAmount) {
            return utilizedAmount(MonetaryValue.builder().applyMutation(utilizedAmount).build());
        }

        /**
         * <p>
         * Detailed information about how the consumable benefit was issued and distributed.
         * </p>
         * 
         * @param issuanceDetails
         *        Detailed information about how the consumable benefit was issued and distributed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuanceDetails(IssuanceDetail issuanceDetails);

        /**
         * <p>
         * Detailed information about how the consumable benefit was issued and distributed.
         * </p>
         * This is a convenience method that creates an instance of the {@link IssuanceDetail.Builder} avoiding the need
         * to create one manually via {@link IssuanceDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IssuanceDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #issuanceDetails(IssuanceDetail)}.
         * 
         * @param issuanceDetails
         *        a consumer that will call methods on {@link IssuanceDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #issuanceDetails(IssuanceDetail)
         */
        default Builder issuanceDetails(Consumer<IssuanceDetail.Builder> issuanceDetails) {
            return issuanceDetails(IssuanceDetail.builder().applyMutation(issuanceDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MonetaryValue allocatedAmount;

        private MonetaryValue remainingAmount;

        private MonetaryValue utilizedAmount;

        private IssuanceDetail issuanceDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ConsumableDetails model) {
            allocatedAmount(model.allocatedAmount);
            remainingAmount(model.remainingAmount);
            utilizedAmount(model.utilizedAmount);
            issuanceDetails(model.issuanceDetails);
        }

        public final MonetaryValue.Builder getAllocatedAmount() {
            return allocatedAmount != null ? allocatedAmount.toBuilder() : null;
        }

        public final void setAllocatedAmount(MonetaryValue.BuilderImpl allocatedAmount) {
            this.allocatedAmount = allocatedAmount != null ? allocatedAmount.build() : null;
        }

        @Override
        public final Builder allocatedAmount(MonetaryValue allocatedAmount) {
            this.allocatedAmount = allocatedAmount;
            return this;
        }

        public final MonetaryValue.Builder getRemainingAmount() {
            return remainingAmount != null ? remainingAmount.toBuilder() : null;
        }

        public final void setRemainingAmount(MonetaryValue.BuilderImpl remainingAmount) {
            this.remainingAmount = remainingAmount != null ? remainingAmount.build() : null;
        }

        @Override
        public final Builder remainingAmount(MonetaryValue remainingAmount) {
            this.remainingAmount = remainingAmount;
            return this;
        }

        public final MonetaryValue.Builder getUtilizedAmount() {
            return utilizedAmount != null ? utilizedAmount.toBuilder() : null;
        }

        public final void setUtilizedAmount(MonetaryValue.BuilderImpl utilizedAmount) {
            this.utilizedAmount = utilizedAmount != null ? utilizedAmount.build() : null;
        }

        @Override
        public final Builder utilizedAmount(MonetaryValue utilizedAmount) {
            this.utilizedAmount = utilizedAmount;
            return this;
        }

        public final IssuanceDetail.Builder getIssuanceDetails() {
            return issuanceDetails != null ? issuanceDetails.toBuilder() : null;
        }

        public final void setIssuanceDetails(IssuanceDetail.BuilderImpl issuanceDetails) {
            this.issuanceDetails = issuanceDetails != null ? issuanceDetails.build() : null;
        }

        @Override
        public final Builder issuanceDetails(IssuanceDetail issuanceDetails) {
            this.issuanceDetails = issuanceDetails;
            return this;
        }

        @Override
        public ConsumableDetails build() {
            return new ConsumableDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
