/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateBenefitApplicationResourceRequest extends PartnerCentralBenefitsRequest implements
        ToCopyableBuilder<AssociateBenefitApplicationResourceRequest.Builder, AssociateBenefitApplicationResourceRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(AssociateBenefitApplicationResourceRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<String> BENEFIT_APPLICATION_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BenefitApplicationIdentifier")
            .getter(getter(AssociateBenefitApplicationResourceRequest::benefitApplicationIdentifier))
            .setter(setter(Builder::benefitApplicationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BenefitApplicationIdentifier")
                    .build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(AssociateBenefitApplicationResourceRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD,
            BENEFIT_APPLICATION_IDENTIFIER_FIELD, RESOURCE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final String benefitApplicationIdentifier;

    private final String resourceArn;

    private AssociateBenefitApplicationResourceRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.benefitApplicationIdentifier = builder.benefitApplicationIdentifier;
        this.resourceArn = builder.resourceArn;
    }

    /**
     * <p>
     * The catalog identifier that specifies which benefit catalog the application belongs to.
     * </p>
     * 
     * @return The catalog identifier that specifies which benefit catalog the application belongs to.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * The unique identifier of the benefit application to associate the resource with.
     * </p>
     * 
     * @return The unique identifier of the benefit application to associate the resource with.
     */
    public final String benefitApplicationIdentifier() {
        return benefitApplicationIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS resource to associate with the benefit application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS resource to associate with the benefit application.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(benefitApplicationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateBenefitApplicationResourceRequest)) {
            return false;
        }
        AssociateBenefitApplicationResourceRequest other = (AssociateBenefitApplicationResourceRequest) obj;
        return Objects.equals(catalog(), other.catalog())
                && Objects.equals(benefitApplicationIdentifier(), other.benefitApplicationIdentifier())
                && Objects.equals(resourceArn(), other.resourceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateBenefitApplicationResourceRequest").add("Catalog", catalog())
                .add("BenefitApplicationIdentifier", benefitApplicationIdentifier()).add("ResourceArn", resourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "BenefitApplicationIdentifier":
            return Optional.ofNullable(clazz.cast(benefitApplicationIdentifier()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("BenefitApplicationIdentifier", BENEFIT_APPLICATION_IDENTIFIER_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateBenefitApplicationResourceRequest, T> g) {
        return obj -> g.apply((AssociateBenefitApplicationResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PartnerCentralBenefitsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateBenefitApplicationResourceRequest> {
        /**
         * <p>
         * The catalog identifier that specifies which benefit catalog the application belongs to.
         * </p>
         * 
         * @param catalog
         *        The catalog identifier that specifies which benefit catalog the application belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * The unique identifier of the benefit application to associate the resource with.
         * </p>
         * 
         * @param benefitApplicationIdentifier
         *        The unique identifier of the benefit application to associate the resource with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder benefitApplicationIdentifier(String benefitApplicationIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS resource to associate with the benefit application.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the AWS resource to associate with the benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PartnerCentralBenefitsRequest.BuilderImpl implements Builder {
        private String catalog;

        private String benefitApplicationIdentifier;

        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateBenefitApplicationResourceRequest model) {
            super(model);
            catalog(model.catalog);
            benefitApplicationIdentifier(model.benefitApplicationIdentifier);
            resourceArn(model.resourceArn);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getBenefitApplicationIdentifier() {
            return benefitApplicationIdentifier;
        }

        public final void setBenefitApplicationIdentifier(String benefitApplicationIdentifier) {
            this.benefitApplicationIdentifier = benefitApplicationIdentifier;
        }

        @Override
        public final Builder benefitApplicationIdentifier(String benefitApplicationIdentifier) {
            this.benefitApplicationIdentifier = benefitApplicationIdentifier;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateBenefitApplicationResourceRequest build() {
            return new AssociateBenefitApplicationResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
